<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS ENUM Module Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_module_require_class('fs', 'application');
class Fs_enum_module_class extends Fs_module_class
{
    public function __construct($fs_app)
    {
        parent::__construct($fs_app, "enum");
    }
    public function configure()
    {
        // Set the module description
        $this->set_description("ENUM");
        // Create the config object
        $cfg = new Fs_enum_config_class($this->node() , $this->object_name() , $this->name());
        // Synch with DB
        $cfg->configure();
        $cfg->synch();
        // Attach config to module
        $this->set_config($cfg);
        return parent::configure();
    }
    /**
     * Decides whether the module is enabled or disabled
     * @see Fs_module_class::is_enabled()
     */
    public function is_enabled($mod_name = "")
    {
        $cfg = $this->config()->get_data_values(false);
        if (!empty($cfg)) {
            if ($cfg['default-root'] != "") return true;
            else return false;
        } else return false;
    }
    public function generate_config(&$config_manager)
    {
        // Get our configuration data (unresolved)
        $cfg = $this->config()->get_data_values(false);
        // Create xml document
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        $xml_writer->startDocument('1.0', 'UTF-8');
        $xml_writer->startElement('configuration');
        $xml_writer->writeAttribute('name', 'enum.conf');
        $xml_writer->writeAttribute('description', 'ENUM Module');
        $xml_writer->startElement('settings');
        foreach ($cfg as $k => $v) {
            switch ($k) {
            case 'use-server':
                if ($v != "") {
                    $xml_writer->startElement('param');
                    $xml_writer->writeAttribute('name', $k);
                    $xml_writer->writeAttribute('value', $v);
                    $xml_writer->endElement();
                }
                break;

            default:
                $xml_writer->startElement('param');
                $xml_writer->writeAttribute('name', $k);
                $xml_writer->writeAttribute('value', $v);
                $xml_writer->endElement();
                break;
            }
        }
        $xml_writer->fullEndElement();
        //routes
        $xml_writer->startElement('routes');
        $xml_writer->startElement('X-PRE-PROCESS');
        $xml_writer->writeAttribute('cmd', 'include');
        $xml_writer->writeAttribute('data', '../enum/user_routes.xml');
        $xml_writer->endElement();
        $xml_writer->fullEndElement();
        $xml_writer->fullEndElement();
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = 'autoload_configs/enum.conf.xml';
        $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        return parent::generate_config($config_manager);
    }
}
class Fs_enum_config_class extends Safe_configurable_object_class
{
    public function __construct($node, $parent_name)
    {
        parent::__construct($parent_name, "configuration");
    }
    public function configure()
    {
        $this->add_field('default-root', 'Default Root Domain', 'string', 'e164.org', 60);
        $this->set_field_rules('default-root', 'required');
        $this->set_field_help('default-root', 'Default domain root for plain telephone numbers.');
        $this->add_field('default-isn-root', 'Default ISN Root Domain', 'string', 'freenum.org', 60);
        $this->set_field_rules('default-isn-root', 'required');
        $this->set_field_help('default-isn-root', 'Default root domain for ISN numbers');
        $this->add_field('use-server', 'Custom DNS Server', 'string', '', 60);
        $this->set_field_rules('use-server', 'valid_ip');
        $this->set_field_help('use-server', 'Custom DNS server that will be used for enum. This is an optional field. If left blank, will use the system configured DNS Server. Must be a valid IPv4 address');
        $this->add_field('query-timeout', 'DNS Query Timeout', 'string', 5, 20);
        $this->set_field_rules('query-timeout', 'required|greater_than[0]');
        $this->set_field_help('query-timeout', 'Number of seconds to wait before timing out a DNS query');
        return parent::configure();
    }
    public function description()
    {
        // Get the data values (not enum resolved)
        $cfg = $this->get_data_values(false);
        if ('""' != $cfg['default-root']) return "Enable";
        else return 'Disable';
    }
}
?>
