<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SNG SSH Linux service wrapper
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
safe_require_class('service');
class Sng_watchdog_config_class extends Safe_configurable_object_class
{
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        $this->add_field('max-load-1', 'Max (1 min)', 'text', '0',10);
        $this->set_field_help('max-load-1', 'Port number that snmpd listens on.');
        $this->set_field_rules('max-load-1', 'integer|greater_than[2]|less_than[100]');

        $this->add_field('max-load-5', 'Max (5 min)', 'text', '0',10);
        $this->set_field_help('max-load-5', 'Port number that snmpd listens on.');
        $this->set_field_rules('max-load-5', 'integer|greater_than[2]|less_than[100]');

        $this->add_field('max-load-15', 'Max (15 min)', 'text', '0',10);
        $this->set_field_help('max-load-15', 'Port number that snmpd listens on.');
        $this->set_field_rules('max-load-15', 'integer|greater_than[2]|less_than[100]');
        $this->set_field_category('max-load-1', 'Load Average');

        $this->add_field('min-memory', 'Min Free', 'text', '0',10);
        $this->set_field_help('min-memory', 'Port number that snmpd listens on.');
        $this->set_field_rules('min-memory', 'integer|greater_than[2]|less_than[100]');
        $this->set_field_category('min-memory', 'Memory');

        $this->add_field('max-temperature', 'Max', 'text', '0',10);
        $this->set_field_help('max-temperature', 'Port number that snmpd listens on.');
        $this->set_field_rules('max-temperature', 'integer|greater_than[2]|less_than[100]');
        $this->set_field_category('max-temperature', 'Temperature');

        return parent::configure();
    }

}

class Sng_watchdog_service_class extends Safe_service_class
{
    public function __construct($software)
    {
        parent::__construct($software, 'watchdog');
    }
    /**
     * @brief
     *
     * @return
     */
    public function configure()
    {
        // Set the module description
        $this->set_description("Watchdog");
    
        // Create the config object
        $cfg = new Sng_watchdog_config_class($this->node(), parent::path(),$this->name());
        // Synch with DB
        $cfg->configure();
        $cfg->synch();
        // Attach config to module
        $this->set_config($cfg);

        return parent::configure();
    }

    public function can_restore($info, &$reason)
    {
        // Prevent calling parent as service status will be checked
        return true;
    }
    public function allow_user_ctl()
    {
        return 'hide';
    }
    /**
     * @brief Generate sshd configuration
     *
     * @param[in out] $config_manager
     *
     * @return true on success
     */
    public function generate_config(&$config_manager)
    {
        //Generates service configuration files
        if (!$this->_generate_service_config($config_manager)) return false;
        // Invoke parent generate
        return parent::generate_config($config_manager);
    }
    public function _generate_service_config(&$config_manager)
    {
        return true;
    }
    /**
     * @brief Invoked after a successfull write_config
     *
     * @return
     */
    public function post_write_config($obj_type=null)
    {
        // restart service
        if($this->status() == Safe_service_class::STATUS_RUNNING){
            $this->restart();
        }
        return parent::post_write_config($obj_type);
    }
    public function support_reload(&$need_reload = null) {
        parent::support_reload($need_reload);
        return true;
    }
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        return $this->generate_config($config_manager);
    }
    public function reload_clear_modified($obj_type=null)
    {
        return $this->clear_configuration_modified();
    }
}
/* End of file sng_sshd_service_class.php */
