/**
 * @file /SAFe/js/safe.js
 */

/**
 * @function safe_disabled
 * @param g (group name)
 * @param v (enable_disable_enum value)
 * @desc allows to disable all fields starting with the end of a field name
 */
function safe_disabled(g, v) {
  if (typeof group[g]['fields'] !== 'undefined') {
    var fields = group[g]['fields'];
    for(var i=0;i<fields.length;i++) {
       if (v == group[g]['default']['value'] ) {
        if(group[g]['default']['status']=='disable'){
        	$("[name='"+fields[i]+"']").attr('disabled','disabled');
            $("[name='"+fields[i]+"']").addClass('field_disabled');
        }else{
        	$("[name='"+fields[i]+"']").removeAttr('disabled');
            $("[name='"+fields[i]+"']").removeClass('field_disabled');
        }
      } else {
        if(group[g]['default']['status']=='disable'){
        	$("[name='"+fields[i]+"']").removeAttr('disabled');
            $("[name='"+fields[i]+"']").removeClass('field_disabled');
        }else{
        	$("[name='"+fields[i]+"']").attr('disabled','disabled');
            $("[name='"+fields[i]+"']").addClass('field_disabled');
        }
      }
       var field_span = $("[name='"+fields[i]+"']").closest( "span" );
       if(group[g]['default']['display']=='yes'){
       	var hide_class_name = field_span.attr("class");
	        if(hide_class_name == 'field'){
	        	field_span.show();
	        }
       }
       if(group[g]['default']['display']=='no'){
       	var hide_class_name = field_span.attr("class");
	        if(hide_class_name == 'field'){
	        	field_span.hide();
	        }
       }
    }
    if (typeof group[g]['condition'] !== 'undefined') {
  	  var condition = group[g]['condition'];
    	  if(typeof condition[v] !== 'undefined'){
    		  var condition_fileds = condition[v];
    		  for(var k=0;k<condition_fileds.length;k++){
    			  if(condition_fileds[k]['status'] == 'disable'){
	    			  $("[name='"+condition_fileds[k]['field_name']+"']").attr('disabled','disabled');
	    		        $("[name='"+condition_fileds[k]['field_name']+"']").addClass('field_disabled');
	    		  }else{
	    			  $("[name='"+condition_fileds[k]['field_name']+"']").removeAttr('disabled');
	    		        $("[name='"+condition_fileds[k]['field_name']+"']").removeClass('field_disabled');
	    		  }
    			  var field_span = $("[name='"+condition_fileds[k]['field_name']+"']").closest( "span" );
    			  if(condition_fileds[k]['display']=='yes'){
    		        	var hide_class_name = field_span.attr("class");
    			        if(hide_class_name == 'field'){
    			        	field_span.show();
    			        }
    		        }
    			  if(condition_fileds[k]['display']=='no'){
    		        	var hide_class_name = field_span.attr("class");
    			        if(hide_class_name == 'field'){
    			        	field_span.hide();
    			        }
    		        }
    		  }
    		  
    	  }
     }
    for(var i=0;i<fields.length;i++) {
    	var field = $("[name='"+fields[i]+"']");
    	if(field.length != 0 && typeof field.attr('onchange') !== 'undefined' && field.prop('tagName').toLowerCase() =='select'){
    		if(field.is(":visible") && !field.is(":disabled")){
    			field.trigger('change');
    		}else{
    			if(field.is(":disabled")){
    				safe_disabled(fields[i], 'none');
    			}
    		}
    	}
    }
  }
}
function safe_hide(g, v) {
	  if (typeof group[g]['fields']!== 'undefined') {
	    var fields = group[g]['fields'];
	    for(var i=0;i<fields.length;i++) {
	      if (v == 'false') {
	        $("[name='"+fields[i]+"']").attr('disabled','disabled');
	        $("[name='"+fields[i]+"']").addClass('field_disabled');
	        var field_tr = $("[name='"+fields[i]+"']").closest( "tr" );
	        field_tr.hide();
	        var hide_class_name = field_tr.attr("class");
	        if(hide_class_name != ''){
	        	field_tr.attr('class', '');
		        field_tr.attr('tmpclass', hide_class_name);
	        }
	      } else {
	    	$("[name='"+fields[i]+"']").removeAttr('disabled');
  	        $("[name='"+fields[i]+"']").removeClass('field_disabled');
    		var field_tr = $("[name='"+fields[i]+"']").closest( "tr" );
    		field_tr.show();  
    		var hide_class_name = field_tr.attr("tmpclass");
	        field_tr.attr('class', hide_class_name);
	      }
	    }
	    for(var i=0;i<fields.length;i++) {
	    	var field = $("[name='"+fields[i]+"']");
	    	if(typeof field.attr('onchange') !== 'undefined' && field.prop('tagName').toLowerCase() =='select'){
	    		if(field.is(":visible") && !field.is(":disabled")){
	    			field.trigger('change');
	    		}
	    		
	    	}
	    }
	  }
	}
function set_group(group , action ){
	if(action == 'disable'){
		safe_hide(group, 'false');
	}else{
		safe_hide(group, 'true');
	}
}
function safe_condition_disabled(g, v) {
	  if (typeof group_condition[g]!=='undefined') {
		  var condition = group_condition[g];
		  if(typeof condition['default'] !== 'undefined'){
			  for(var i=0;i<condition['groups'].length;i++) {
				  set_group(condition['groups'][i] , condition['default']);
			  }
		  }
		  if(typeof condition['condition'][v] !== 'undefined'){
			  $.each(condition['condition'][v], function(index, value) {
				  set_group(index , value);
			  });
		  }
	  }
	}
/**
 * @function safe_disabled_field_init
 * @param
 * @desc find all fields elements that need to be disabled
 */
function safe_disabled_field_init() {
  $('form').find('input,select,textarea').each(function(){
      if(this.tagName.toLowerCase() == 'select') {
	      if(typeof $(this).attr('onchange') !== 'undefined'){
	    	  $(this).trigger('change');
	      }
      }
  });
}

/**
 * @function safe_handle_field_help
 * @param
 * @desc handle contextual help for a form element
 */
function safe_handle_field_help() {
	// if there is at least one help content, build the process to handle it
  if ($('.field_info').size() > 0) {
	$('.field_info').on('click', function(){
	    var content = $(this).find('.tooltip-inner').html();
	    // Field info UI Dialog
	    return $("<div>" + content + "</div>").dialog({
			autoOpen: true,
			position: "center",
			modal: true,
			height: 'auto',
			width: 'auto',
			maxHeight: 600,
			maxWidth: 600,
			minWidth: 400,
			draggable: true,
			resizable: false,
			dialogClass: 'msgbox',
			title:$(this).parent().prev().text(),
			close: function() {
				//destory the dialog
				$(this).dialog("destroy").remove();
			},
			buttons: {
			    "Ok": function() {
			    	$(this).dialog("close");
			        return false;
			     }
			}
	    });
	 });
  
	$('.field_info').tooltip({
	    content : function(){ 
	    	return $(this).find('.tooltip-inner').html();
	    },
	    position: {
		    my: "center top",
		    at: "center bottom+15",
		    using: function( position, feedback ) {
		      $( this ).css( position );
		      $( "<div>" )
		        .addClass( "arrow" )
		        .addClass( feedback.vertical )
		        .addClass( feedback.horizontal )
		        .appendTo( this );
		    }
		  }
	    });
	    $('.field_info').tooltip({
			hide: {
				delay: 250
			}
		});
  }
}

function safe_enable_datepicker(){
  $('.safe_datetime').datetimepicker( {
    dateFormat:'yy-mm-dd'
  });
  $('.safe_date').datepicker({
    dateFormat:'yy-mm-dd'
  });


}

function safe_toggle_fields(header_id, fields_class, setting){
  if(typeof setting !== 'undefined'){
	  setting = 0; 
  }else{
	  setting = 'slow';
  }
  if($('#'+header_id).hasClass('header_collapse')){
    $('#'+header_id).removeClass('header_collapse');
    $('#'+header_id).addClass('header_expand');
  }else if($('#'+header_id).hasClass('header_expand')){
    $('#'+header_id).removeClass('header_expand');
    $('#'+header_id).addClass('header_collapse');
  }
  $('.'+fields_class).each(function(){
    $(this).fadeToggle(setting);
  });
};


/**
 * @function safe_handle_create_button
 * @param button_obj (button object) 
 * @desc send ajax request pop up a creation dialog
 */
function safe_handle_create_button(button_obj){
	//send a ajax request to generate a creation dialog
	cancel_refresh();
	ui_ajax_running = $.ajax({
		  type: 'POST',
		  url: button_obj.parentNode.action,
		  dataType: 'json',
		  async:false,
		  success:function(rs){
			  try{
				  if (rs.result == true ){
					  var ok_name ='Create';
					  if(typeof rs.buttons !== 'undefined'){
						  ok_name = rs.buttons[0].value;
					  }
					  var ok_data = new Object();//{ "delete": "delete"};
					  //get submit button data from confime page
					  if(typeof rs.action_url !== 'undefined'){
						  if (safe_create_box(rs.page_title,rs.content,rs.action_url,'',rs.action_method,'',ok_data,null ,ok_name)){
						  }else{
							  throw {'title':rs.page_title, 'content':'Open confirm dialog failed.', 'type':'alert'};
						  }
					  }else{
						  if (typeof rs.redirect_url !== 'undefined'){
							  //if redirect url returned no need show confirm dialog
        					  window.location = rs.redirect_url;
        				  }else{
        					  throw {'title':rs.page_title, 'content':'action_url error!', 'type':'alert'};
        				  }
					  }  
				   }else{
					  var tmp_reason = '';
 					  if(typeof rs.reason !== 'undefined' && rs.reason !== null){
 						  if (rs.reason instanceof Array){
 							  tmp_reason = rs.reason.join('<br>');
 						  }else{
 							  tmp_reason = rs.reason;
 						  }
 					  }
 					  if (tmp_reason != ''){
 						  rs.message = rs.message + '<br>' + tmp_reason;
 					  }
					 throw {'title':rs.page_title, 'content':rs.message, 'type': rs.message_type};
				   };
			  }catch(err){
				  safe_message_box(err.title,safe_message_style(err.content,err.type));
			  }
			  
		  },
		  error:function(xhr){
			  if(xhr.status == '200'){
				  location.reload(true);
			  }else{
				  safe_message_box('An error occurred:', safe_message_style(xhr.status + " " + xhr.statusText,'alert'));
			  }
		  }
		});
}

/**
 * @function safe_handle_confirm_button
 * @param button_obj (button object) 
 * @desc handle button with an ajax confirm requst first
 */
function safe_handle_confirm_button(button_obj){
	//send a confirm request
	cancel_refresh();
	ui_ajax_running = $.ajax({
		  type: 'POST',
		  url: button_obj.parentNode.action,
		  //data : { "confirm": "YES"},
		  dataType: 'json',
		  async:false,
		  success:function(rs){
			  try{
				  if (rs.result == true ){
					  var ok_data = new Object();//{ "delete": "delete"};
					  //get submit button data from confime page
					  if(typeof rs.action_url !== 'undefined'){
						  var ok_name ='Ok';
      					  if(typeof rs.buttons !== 'undefined'){
      						  ok_name = rs.buttons[0].value;
      					  }
      					  if(typeof rs.setting !== 'undefined'){
      						  setting = rs.setting;
    					  }else{
    						  setting = false;
    					  }
						  if (safe_confirmation_box(rs.page_title,safe_message_style(rs.message,rs.message_type),rs.action_url,'','POST','',ok_data,null,ok_name,setting)){
						  }else{
							  throw {'title':rs.page_title, 'content':'Open confirm dialog failed.', 'type':'alert'};
						  }
					  }else{
						  throw {'title':rs.page_title, 'content':'action_url error!', 'type':'alert'};
					  }  
				   }else{
					   var tmp_reason = '';
	 					  if(typeof rs.reason !== 'undefined' && rs.reason !== null){
	 						  if (rs.reason instanceof Array){
	 							  tmp_reason = rs.reason.join('<br>');
	 						  }else{
	 							  tmp_reason = rs.reason;
	 						  }
	 					  }
	 					  if (tmp_reason != ''){
	 						  rs.message = rs.message + '<br>' + tmp_reason;
	 					  }
					   throw {'title':rs.page_title, 'content':rs.message, 'type': rs.message_type};
				   };
			  }catch(err){
				  safe_message_box(err.title,safe_message_style(err.content,err.type));
			  }
			  
		  },
		  error:function(xhr){
			  if(xhr.status == '200'){
				  location.reload(true);
			  }else{
				  safe_message_box('An error occurred:', safe_message_style(xhr.status + " " + xhr.statusText,'alert'));
			  }
		  }
		});
}
/**
 * @function defaultvalue
 * @param arg (argument)
 * @param val (default value)
 * @desc set arg default value
 */
function defaultvalue(arg, val) { 
	return typeof arg !== 'undefined' ? arg : val; 
}

/**
 * @function safe_confirmation_box
 * @param title	(confirm box title)
 * @param content (confirm box content, can use html code)
 * @param url_ok (click ok button url)
 * @param url_cancel (click cancel button url)
 * @param ok_method	(click ok send http requst method)
 * @param cancel_method (click cancel send http requst method)
 * @param ok_data (click ok send http requst with this ok_data)
 * @param cancel_data (click cancel send http requst with this cancel_data)
 * @desc show a confirm dialog box with ok or cancel button
 */
function safe_confirmation_box(title, content, url_ok, url_cancel, ok_method, cancel_method, ok_data, cancel_data, ok_name,setting) {
	
	title 		= defaultvalue(title, '');
	content 	= defaultvalue(content, '');
	url_ok 		= defaultvalue(url_ok, '');
	url_cancel 	= defaultvalue(url_cancel, '');
	ok_method 	= ok_method != 'GET' ? 'POST' : 'GET';
	cancel_method 	= cancel_method != 'POST' ? 'GET' : 'POST';
	ok_data		= defaultvalue(ok_data, null);
	cancel_data = defaultvalue(cancel_data, null);
	ok_name		= defaultvalue(ok_name, 'Ok');
	setting		= defaultvalue(setting, '');
	
	if (title != '' && content != '' && url_ok != '' ){
		return $("<div>" + content + "</div>").dialog({
			//autoOpen: false,
			position: "center",
			modal: true,
			width: 'auto',
			maxHeight: 600,
			maxWidth: 600,
			minWidth: 400,
			draggable: true,
			resizable: false,
			dialogClass: 'msgbox',
			title: title,
			buttons:[ 
				{
					text : ok_name,
					click:function() {
						//show process bar
						if(setting){
							p_title = defaultvalue(setting['title'], title);
							p_sec = defaultvalue(setting['sec'], 30);
							p_msg = defaultvalue(setting['msg'], 'Timeout ...');
							p_lable = defaultvalue(setting['lable'], 'Ok');
							p_url = defaultvalue(setting['url'], '');
							processing_ui = safe_wait(p_title,'spinning_wheel',p_sec,p_msg,p_lable,p_url);
						}
						
						$(this).dialog("close");
						cancel_refresh();
						var timeout = window.setTimeout(function() {
							ui_ajax_running = $.ajax({
			            		  type: ok_method,
			            		  url: url_ok,
			            		  data : ok_data,
			            		  dataType: 'json',
			            		  async:true,
			            		  success:function(rs){
			            			//handle result
			            			  if(processing_ui) {
			            				  processing_ui.dialog("close");
			            			  }
			            			  if (rs.result == true ){
			            				  //return a url and redirect url
			            				  if (typeof rs.redirect_url !== 'undefined'){
			            					  window.location = rs.redirect_url;
			            				  }else{
			            					  safe_message_box('An error occurred:', safe_message_style("Redirect url undefined.",'alert'));
			            				  }
			            			  }else{
			            				  safe_message_box(rs.page_title,safe_message_style(rs.message,rs.message_type));
			            			  }
			            		  },
			            		  error:function(xhr){
			            			  processing_ui.dialog("close");
			            			  safe_message_box('An error occurred:', safe_message_style(xhr.status + " " + xhr.statusText,'alert'));
			            		  }
			            		});
						}, 200);
		                return false;
		            }
				},
				{
					text : 'Cancel',
					click:function() {
						if (url_cancel != ''){
							//do some thing
						}
						$(this).dialog("close");
		                return false;
		            }
				}
			]
		});
	}else{
		safe_message_box('An error occurred:', safe_message_style("Parameter missing, Open the confirmation box failed",'alert'));
		return false;
	}
}
/**
 * @function safe_security_timer
 * @param sec (Value in second defining maximum time to wait for page to complete - Default is 10sec - 0 disable mechanism)
 * @param msg (Message to display when timeout reached)
 * @param lable (Button label for redirection )
 * @param url ( URL to redirect user to after timeout expired when user press the redirect button - default is proper $_SERVER array entry containing base url + port ) 
 * @desc When the timeout fires we must add in the waiting dialog a custom message and a redirect button 
 */
function safe_security_timer(sec,msg,lable,url){
	sec 	= defaultvalue(sec, 0);
	if(sec > 0){
		return setTimeout(function(){ timeout_dialog = safe_message_box('Timeout', msg,null,lable,function() {if(url!='') window.location = url;});}, sec*1000);
	}
	return false;
}

/**
 * @function safe_wait
 * @param content (message show in the dialog)
 * @param type (spinning_wheel, or processing_bar ) 
 * @desc show a please wait dialog and block the ui 
 */
function safe_wait(content,type,sec,msg,lable,url){
	content 	= defaultvalue(content, 'Please wait...');
	type 	= defaultvalue(type, 'spinning_wheel');
	sec 	= defaultvalue(sec, 0);
	msg 	= defaultvalue(msg, 'Timeout...');
	lable 	= defaultvalue(lable, 'Ok');
	url 	= defaultvalue(url, '');
	if(type == 'spinning_wheel'){
		var security_timer = safe_security_timer(sec,msg,lable,url);
		return $('<div><center><br><img src="/templates/base/images/icons/16x16/icon-loading.gif" style="vertical-align:middle;"> &nbsp;Please wait... <br><br><div id="content">' + content + "</div></center></div>").dialog({
			autoOpen: true,
			position: "center",
			modal: true,
			width: 'auto',
			maxHeight: 600,
			maxWidth: 600,
			minWidth: 400,
			draggable: false,
			resizable: false,
			dialogClass: 'msgbox',
			open: function( event, ui ) {
				$(this).closest(".ui-dialog").find(".ui-dialog-titlebar:first").hide();
				$(this).closest(".ui-dialog").find(".ui-dialog-content:first").css('overflow', 'hidden'); 
			},
			close: function() {
				//destory the dialog
				if(security_timer) clearTimeout (security_timer);
				$(this).dialog("destroy").remove();
			}
		});
	}else if(type == 'processing_bar'){
		return $('<div><center><br><img src="/templates/base/images/icons/16x16/icon-loading.gif" style="vertical-align:middle;"> &nbsp;Please wait... <br><br><div id="safe_progress_bar"><span id="percent" style="width: 100%;"></span></div><br><div id="content">' + content + "</div></center></div>").dialog({
			autoOpen: true,
			position: "center",
			modal: true,
			width: 'auto',
			maxHeight: 600,
			maxWidth: 600,
			minWidth: 400,
			draggable: false,
			resizable: false,
			dialogClass: 'msgbox',
			open: function(event, ui) {
				$(this).closest(".ui-dialog").find(".ui-dialog-titlebar:first").hide();
				$(this).closest(".ui-dialog").find(".ui-dialog-content:first").css('overflow', 'hidden'); 
				$("#safe_progress_bar").progressbar({value:false});//init
				safe_progressbar_update($("#safe_progress_bar"),false);
			},
			close: function() {
				if(security_timer) clearTimeout (security_timer);
				//destory the dialog
				$(this).dialog("destroy").remove();
			}
		});
	}else{
		return false;
	}
}
function safe_progressbar_update(bar,value){
	value 	= defaultvalue(value, false);
	bar.progressbar({value:value});
	if(value == false){
		bar.find(".ui-progressbar-value").css('display','block');
		bar.find(".ui-progressbar-value").css('width','100%');
		bar.find(".ui-progressbar-value").css('background-image','url("/SAFe/images/animated-overlay.gif")');
		bar.find(".ui-progressbar-value").css('height','100%');
		bar.find(".ui-progressbar-value").css('opacity','0.25');
	}else{
		bar.find(".ui-progressbar-value").css('display','block');
		bar.find(".ui-progressbar-value").css('width',value +'%');
		bar.find(".ui-progressbar-value").css('background-image','');
		bar.find(".ui-progressbar-value").css('opacity','');
	}
}
function obj_loop(object){
    var collection= '', next, item;
    for(item in object){
        if(object.hasOwnProperty(item)){
            next= object[item];
            if(typeof next == 'object' && next != null){
                collection = collection +   obj_loop(next) ;
            }else{
            	collection = collection + '<li style="list-style-type:none;">'+String(next) + '</li>';
            }
        }
    }
    if(collection != ''){
    	collection = '<ul style="list-style-type:none;  padding-left: 10px; margin: 0px;" >' +  collection + '</ul>';
    }
    return collection;
}
/**
 * @function safe_create_box
 * @param title	(confirm box title)
 * @param content (confirm box content, can use html code)
 * @param url_ok (click ok button url)
 * @param url_cancel (click cancel button url)
 * @param ok_method	(click ok send http requst method)
 * @param cancel_method (click cancel send http requst method)
 * @param ok_data (click ok send http requst with this ok_data)
 * @param cancel_data (click cancel send http requst with this cancel_data)
 * @param ok_name (ok button name)
 * @desc show a confirm dialog box with ok or cancel button
 */
function safe_create_box(title, content, url_ok, url_cancel, ok_method, cancel_method, ok_data, cancel_data,ok_name) {
	
	title 		= defaultvalue(title, '');
	content 	= defaultvalue(content, '');
	url_ok 		= defaultvalue(url_ok, '');
	url_cancel 	= defaultvalue(url_cancel, '');
	ok_method 	= ok_method != 'GET' ? 'POST' : 'GET';
	cancel_method 	= cancel_method != 'POST' ? 'GET' : 'POST';
	ok_data		= defaultvalue(ok_data, null);
	cancel_data = defaultvalue(cancel_data, null);
	ok_name		= defaultvalue(ok_name, 'Create');
		
	if (title != '' && content != '' && url_ok != '' ){
		return $("<div>" + content + "</div>").dialog({
			//autoOpen: false,
	    	//position: {my: "center", at: "center", of: window, collision:"fit"},
			position:'center',
			modal: true,
			width: 'auto',
			maxHeight: 600,
			maxWidth: 600,
			minWidth: 400,
			draggable: true,
			resizable: false,
			dialogClass: 'msgbox',
			title: title,
			open: function( event, ui ) {
				var forms = $(this).find('form');
				if (forms.length>0){
					//default enter key submit form
					//set submit event to click ok button
					$(forms[0]).submit(function() {
							$(this).parents('.ui-dialog').first().find('.ui-button').first().click();
						  return false;
						});
				}
			},
			buttons:[ {
				text : ok_name,
				click:function() {
					var form_type ='';
					//to do url_ok, data 
					var forms = $(this).find('form');
					if (forms.length>0){
						ok_data = $(forms[0]).serialize();
						//check if have a file upload Field
						var files = $(forms[0]).find(':file');
						if (files.length>0){
							form_type='upload_file';
						}
					}else{
						throw {'title':title, 'content':'Form data not found!', 'type':'alert'};
					}
					var old_dialog = $(this);
					
					//ajax submit the form and get the result
					if(form_type=='upload_file'){
						var options = { 
								url:       url_ok,         // override for form's 'action' attribute
								beforeSend: function() {
									old_dialog.dialog("close");//hide the old dialog box
	            					  var close_method = {
	            				            "dialogbeforeclose": function() {
	            				            	old_dialog.dialog("open");//show the old dialog box when close the error message box
	            				             }
	            					  	};
									upload_processing_ui = safe_wait(title,'processing_bar');
									p = 0;
							        //$("#safe_progress_bar .ui-progressbar-value").animate({width: p+"%"},50);
							        //$("#safe_progress_bar").find("#percent").html('0%')
							    },
							    uploadProgress: function(event, position, total, percentComplete) {
							    	if(p == 0){
							    		$("#safe_progress_bar").progressbar({value:0.01});//init
							    		safe_progressbar_update($("#safe_progress_bar"),percentComplete);
							    		p = 1;
							    	}
							    	$("#safe_progress_bar .ui-progressbar-value").animate({width: percentComplete+"%"},50);
							        $("#safe_progress_bar").find("#percent").html(percentComplete + '%')
							        if(percentComplete >= 100){
							        	upload_processing_ui.find("#content").html('File Uploaded successfully! System processing...');
							        }
							    },
						        success:       function(rs){
			            			//handle result
			            			  if (rs.result == true ){
			            				  //add successful and return a redirect url
			            				  if (typeof rs.redirect_url !== 'undefined'){
			            					  if(rs.redirect_method=='POST'){
			            						  redirect_by_post(rs.redirect_url,rs.post_data);  
			            					  }else{
			            						  window.location = rs.redirect_url;
			            					  }
			            				  }else{
			            					  safe_message_box('An error occurred:', safe_message_style("Redirect url undefined.",'alert'));
			            				  }
			            			  }else{
			            				  //add fail
			            				  if(rs.reload==true){
			            					  //uer input data run_validation fail
			            					  //show the form again with validation error
				            				  ok_data = null;//clear ok_data
				          					  if(typeof rs.action_url !== 'undefined'){
				          						  var ok_name ='Create';
					          					  if(typeof rs.buttons !== 'undefined'){
					          						  ok_name = rs.buttons[0].value;
					          					  }
				          						  if (safe_create_box(rs.page_title,rs.content,rs.action_url,'',rs.action_method,'',ok_data, null,ok_name)){
				          							  old_dialog.dialog("close");//close the old dialog
				          							  old_dialog.dialog( "destroy" ).remove();//distory the old add dialog
				          						  }else{
				          							  throw {'title':rs.page_title, 'content':'Open confirm dialog failed.', 'type':'alert'};
				          						  }
				          					  }else{
				          						  throw {'title':rs.page_title, 'content':'action_url error!', 'type':'alert'};
				          					  }  
			            				  }else{
			            					  
			            					  old_dialog.dialog("close");//hide the old dialog box
			            					  var close_method = {
			            				            "dialogbeforeclose": function() {
			            				            	old_dialog.dialog("open");//show the old dialog box when close the error message box
			            				             }
			            					  	};
			            					  //show other error dialog in a new message box
			            					  var tmp_reason = '';
			            					  if(typeof rs.reason !== 'undefined' && rs.reason !== null){
			            						  if(typeof rs.reason === 'object'){
			            							  tmp_reason = obj_loop(rs.reason);
			            						  }else if(typeof rs.reason === 'string'){
			            							  tmp_reason = rs.reason;
			            						  }
			            					  }
			            					  if (tmp_reason != ''){
			            						  rs.message = rs.message + '<br>' + tmp_reason;
			            					  }
			            					  safe_message_box(rs.page_title,safe_message_style(rs.message,rs.message_type),close_method);
			            					 
			            				  }
			            			  }
			            		},  // post-submit callback
			            		error:function(xhr){
			            			if(xhr.status == '200'){
			          				  	location.reload(true);
			          			  	}else{
			          			  		safe_message_box('An error occurred:', safe_message_style(xhr.status + " " + xhr.statusText,'alert'));
			          			  	}
			              		},
			              		complete: function(xhr) {
			              				//status.html(xhr.responseText);
			              				//$("#safe_progress_bar .ui-progressbar-value").animate({width: 100+"%"},100);
			              				upload_processing_ui.dialog("close");
			              		},
						        
						        //async:true,
						        // other available options: 
						         
						        //type:      type        // 'get' or 'post', override for form's 'method' attribute 
						        dataType:  'json'        // 'xml', 'script', or 'json' (expected server response type) 
						        //clearForm: true        // clear all form fields after successful submit 
						        //resetForm: true        // reset the form after successful submit 
						 
						        // $.ajax options can be used here too, for example: 
						        //timeout:   3000 
						    };
						cancel_refresh();
						$(forms[0]).unbind('submit');
						$(forms[0]).submit(function() { 
							ui_ajax_running = $(this).ajaxSubmit(options); 
					        return false; 
					    }); 
						$(forms[0]).submit();
					}else{
						cancel_refresh();
						ui_ajax_running = $.ajax({
		            		  type: ok_method,
		            		  url: url_ok,
		            		  data : ok_data,
		            		  dataType: 'json',
		            		  async:false,
		            		  success:function(rs){
		            			//handle result
		            			  if (rs.result == true ){
		            				  //add successful and return a redirect url
		            				  if (typeof rs.redirect_url !== 'undefined'){
		            					  if(rs.redirect_method=='POST'){
		            						  redirect_by_post(rs.redirect_url,rs.post_data);  
		            					  }else{
		            						  window.location = rs.redirect_url;
		            					  }
		            				  }else{
		            					  safe_message_box('An error occurred:', safe_message_style("Redirect url undefined.",'alert'));
		            				  }
		            			  }else{
		            				  //add fail
		            				  if(rs.reload==true){
		            					  //uer input data run_validation fail
		            					  //show the form again with validation error
			            				  ok_data = null;//clear ok_data
			          					  if(typeof rs.action_url !== 'undefined'){
			          						  var ok_name ='Create';
				          					  if(typeof rs.buttons !== 'undefined'){
				          						  ok_name = rs.buttons[0].value;
				          					  }
			          						  if (safe_create_box(rs.page_title,rs.content,rs.action_url,'',rs.action_method,'',ok_data,null,ok_name)){
			          							  old_dialog.dialog("close");//close the old dialog
			          							  old_dialog.dialog( "destroy" ).remove();//distory the old add dialog
			          						  }else{
			          							  throw {'title':rs.page_title, 'content':'Open confirm dialog failed.', 'type':'alert'};
			          						  }
			          					  }else{
			          						  throw {'title':rs.page_title, 'content':'action_url error!', 'type':'alert'};
			          					  }  
		            				  }else{
		            					  
		            					  old_dialog.dialog("close");//hide the old dialog box
		            					  var close_method = {
		            				            "dialogbeforeclose": function() {
		            				            	old_dialog.dialog("open");//show the old dialog box when close the error message box
		            				             }
		            					  	};
		            					  //show other error dialog in a new message box
		            					  var tmp_reason = '';
		            					  if(typeof rs.reason !== 'undefined' && rs.reason !== null){
		            						  if (rs.reason instanceof Array){
		            							  tmp_reason = rs.reason.join('<br>');
		            						  }else{
		            							  tmp_reason = rs.reason;
		            						  }
		            					  }
		            					  if (tmp_reason != ''){
		            						  rs.message = rs.message + '<br>' + tmp_reason;
		            					  }
		            					  //show other error dialog in a new message box
		            					  safe_message_box(rs.page_title,safe_message_style(rs.message,rs.message_type),close_method);
		            				  }
		            			  }
		            		  },
		            		  error:function(xhr){
		            			  if(xhr.status == '200'){
		            				  location.reload(true);
		            			  }else{
		            				  safe_message_box('An error occurred:', safe_message_style(xhr.status + " " + xhr.statusText,'alert'));
		            			  }
		            		  }
		            		});
					}
	                return false;
	            }
			},{
	            	text : "Cancel",
	            	click: function() {
						if (url_cancel != ''){
							//do some thing
						}
						$(this).dialog("close");
		                return false;
		            }
	            }
	          ]
		});
	}else{
		safe_message_box('An error occurred:', safe_message_style("Parameter missing, Open the confirmation box failed.",'alert'));
		return false;
	}
}

/**
 * @function safe_message_style
 * @param content (message content)
 * @param type	(style type normal info message or alert message )
 * @desc add style to dialog content
 */
function safe_message_style(content,type){
	content 	= defaultvalue(content, '');
	type 		= defaultvalue(type, 'info');//alert
	var tmp_string ='';
	if(type == 'alert'){
		tmp_string ='<div style="margin-top: 10px; margin-bottom: 10px;"><div style="float: left; margin: 0 2px 2px 0;"><span class="ui-icon ui-icon-alert">-</span></div><div style="margin-left: 20px;">'+content+'</div></div>';
	}else if(type == 'notice'){
		tmp_string ='<div style="margin-top: 10px; margin-bottom: 10px;"><div style="float: left; margin: 0 2px 2px 0;"><span class="ui-icon ui-icon-notice">-</span></div><div style="margin-left: 20px;">'+content+'</div></div>';
	}else{
		tmp_string ='<div style="margin-top: 10px; margin-bottom: 10px;"><div style="float: left; margin: 0 2px 2px 0;"><span class="ui-icon ui-icon-info">-</span></div><div style="margin-left: 20px;">'+content+'</div></div>';
	}
	return tmp_string;
}

/**
 * @function safe_message_box
 * @param title	(message  title)
 * @param content (message content)
 * @param buttons (special buttons)
 * @desc show a message box
 */
function safe_message_box(title, content,close_method,btn_name,btn_method){
	title 		= defaultvalue(title, '');
	content 	= defaultvalue(content, '');
	close_method	= defaultvalue(close_method, null);
	btn_name		= defaultvalue(btn_name, 'Ok');
	btn_method	= defaultvalue(btn_method, 
		function() {
			$(this).dialog("close");
			return false;
		}
	);
	return $("<div>" + content + "</div>").dialog({
		//autoOpen: false,
		position: "center",
		modal: true,
		height: 'auto',
		width: 'auto',
		maxHeight: 600,
		maxWidth: 600,
		minWidth: 400,
		draggable: true,
		resizable: false,
		dialogClass: 'msgbox',
		title: title,
		open: function(){
			//Bind an event listener to the dialogbeforeclose event 
			if(close_method!=null){
				$(this).on( close_method )
			}
		},
		close: function() {
			//destory the dialog
			$(this).dialog("destroy").remove();
		},
		buttons:[ {
			text  : btn_name,
			click : btn_method
		}]
	});
}
(function($){
	if(typeof $.ui.dialog.prototype.oldOpen === 'undefined'){
		var dialogExtensions ={
		        oldOpen: $.ui.dialog.prototype.open,
		        oldClose: $.ui.dialog.prototype.close,
		        open: function(event){
		        	dialog_open = true;
		        	if(this.options.position !== false && this.options.position=='center'){
		        		var window_width = this.window.innerWidth();
		        		var window_height = this.window.innerHeight();
		    			var dialog_width = this.widget().width();
		    			var dialog_height = this.widget().height();
		    			var this_top 	=  this.widget().offset().top;
		    			var this_left 	=  this.widget().offset().left;
		    			if(this_left<(window_width/2-dialog_width/2)) this_left =  window_width/2-dialog_width/2;
		    			//if(this_top<(window_height/2-dialog_height/2)) this_top =  window_height/2-dialog_height/2;
		    			this.widget().offset({ top: this_top, left: this_left});
		        	}
		        	this.oldOpen(event);
		        	//dialog showed in browser
		        	// fix the max and min width value doe not set when dialog open
		        	if(this.options.minWidth !== false && this.widget().width()<this.options.minWidth) this.widget().width(this.options.minWidth);
		        	if(this.options.maxWidth !== false && this.widget().width()>this.options.maxWidth) this.widget().width(this.options.maxWidth);
		        	if(this.options.maxHeight !== false && this.widget().height()>this.options.maxHeight) {
		        		this.widget().height(this.options.maxHeight);
		        		$(this.widget()).find('.ui-dialog-content').first().height(this.options.maxHeight-85);//title and foot bar 85
		        	}
		        },
			close:function(event){
				this.oldClose(event);
				//value sett too fast
				setTimeout(function(){dialog_open = false;},500);
			} 
		};
		$.extend($.ui.dialog.prototype, dialogExtensions);
	}
})(jQuery);

/**
 * @function safe_get_system_status
 * @desc handle get system status
 */
function safe_get_system_status(id){
	return $.ajax({
		  type: 'GET',
		  url: '/SAFe/sng_control_panel/get_system_status',
		  dataType: 'json',
		  async:true,
		  success:function(rs){
			  try{
				  if(typeof window.parent !== 'undefined'){
					  if (rs.status == 'ok' ){
						  if(system_status_flag != 'green'){
							  window.parent.$('#system_status').html('<img src="/SAFe/images/silk/accept.png" style="vertical-align:middle;"> <a href="'+rs.url+'">'+ rs.description + '</a>');
							  window.parent.$('#system_status').css('color','green');
							  window.parent.$('#system_status').css('display','block'); 
							  system_status_flag = 'green';
						  }
					   }else{
						   if(system_status_flag != 'red'){
							   window.parent.$('#system_status').html('<img src="/SAFe/images/silk/stop.png" style="vertical-align:middle;"> <a href="'+rs.url+'" style="color:red;">'+ rs.description + '</a>');
							   window.parent.$('#system_status').css('color','red');
							   window.parent.$('#system_status').css('display','block');
							   system_status_flag = 'red';
						  }
					   }; 
				  }
			  }catch(err){
			  }
			  system_status_fresh(false,id);
		  },
		  error:function(xhr){
			  system_status_fresh(false,id);
		  }
		});
}
/**
 * @function safe_get_configuration_status
 * @desc handle get configuration status
 */
function safe_get_configuration_status(id){
	return $.ajax({
		  type: 'GET',
		  url: '/SAFe/sng_control_panel/get_configuration_status',
		  dataType: 'json',
		  async:true,
		  success:function(rs){
			  try{
				  if(typeof window.parent !== 'undefined'){
					  if (rs.status == 'ok' ){
						  if(config_status_flag != 'green'){
							  window.parent.$('#config_status').html('<img src="/SAFe/images/silk/accept.png" style="vertical-align:middle;"> <a href="'+rs.url+'">'+ rs.description + '</a>');
							  window.parent.$('#config_status').css('color','green');
							  window.parent.$('#config_status').css('display','block');
							  config_status_flag = 'green';
						  }
					   }else{
						   if(config_status_flag != 'red'){
							  window.parent.$('#config_status').html('<img src="/SAFe/images/silk/stop.png" style="vertical-align:middle;"> <a href="'+rs.url+'" style="color:red;">'+ rs.description + '</a>');
							  window.parent.$('#config_status').css('color','red');
							  window.parent.$('#config_status').css('display','block');
							  config_status_flag = 'red';
						  }
					   };  
				  }
			  }catch(err){
			  }
			  system_status_fresh(false,id);
		  },
		  error:function(xhr){
			  system_status_fresh(false,id);
		  }
		});
}
/**
 * @function safe_get_warning_notification
 * @desc handle get warning notification 
 */
function safe_get_warning_notification(id){
	return $.ajax({
		  type: 'GET',
		  url: '/SAFe/sng_control_panel/get_notifications',
		  dataType: 'json',
		  async:true,
		  success:function(rs){
			  try{
				  if(typeof window.parent !== 'undefined'){
					  if (rs.number > 0 ){
						  if(warning_status_flag != rs.number){
							  window.parent.$('#safe_notification_number').html(rs.number);
							  window.parent.$('#safe_notification_list').html(safe_display_natification(rs.data));
							  window.parent.$('#safe_badge_icon').css('display','block');  
							  warning_status_flag = rs.number;
						  }
					   }else{
						  if(warning_status_flag != ''){
							  window.parent.$('#safe_notification_number').html('');
							  window.parent.$('#safe_notification_list').html('');
							  window.parent.$('#safe_badge_icon').css('display','none');  
							  warning_status_flag = '';
						  }
					   };  
				  }
			  }catch(err){
			  }
			  system_status_fresh(false,id);
		  },
		  error:function(xhr){
			  system_status_fresh(false,id);
		  }
		});
}
function safe_display_natification(data){
	var len = data.length;
	if (len > 0){
		var icon = new Array();
		icon["error"] = "/SAFe/images/silk/error.png";
		icon["warning"] = "/SAFe/images/silk/lightning.png";
		icon["other"] = "/SAFe/images/silk/note_error.png";
		icon["link"] = "/SAFe/images/silk/link_go.png";
		var notification_content = '';
        var tr_class = '';
		for (var i = 0; i < len; i++) {
			  data_item = data[i];
			  if(typeof icon[data_item.notification_type] != 'undefined'){
                  show_icon='<img src="'+icon[data_item.notification_type] + '">';
              }else{
                  show_icon='<img src="'+icon["other"] + '">';
              }
              link_icon = '';
              if(data_item.url != ''){
            	  data_item.description = "<a href='"+data_item.url + "' style='color:#cd0a0a'>" + data_item.description + "</a>";
                  link_icon = "<a href='"+data_item.url + "' style='color:#cd0a0a'><img src='" + icon["link"] + "' ></a>";
              }
              notification_content = notification_content + 
              	  "<tr " + tr_class + " title='" + data_item.notification_type + "id=" + data_item.id + " " + data_item.add_time +"'>" +
              	  	"<td>" + show_icon +"</td>" +
              	  	"<td>" + data_item.description + "</td>" +
              	  	"<td>" + link_icon + "</td>" +
                  "</tr>";
              tr_class = (tr_class == '') ? 'style="background-color:#FFFFFF"' : '' ;
		}
        notification ='<table border="0" cellspacing="0" cellpadding="3" width="100%" >' + notification_content + '</table>';
        return notification;
	}else{
		return '';
	}
}
/**
 * @function safe_warn_tooltip
 * @param
 * @desc system warnning messages
 */
function safe_warn_tooltip() {
  if ($('#safe_badge_icon').size() > 0) {
	$('#safe_badge_icon').tooltip({
	    content : function(){ 
	    	return $(this).find('#safe_notification_list').html();
	    },
	    position: {
		    my: "center top",
		    at: "center bottom+10",
		    using: function( position, feedback ) {
		    	$( this ).css( position );
		      $( "<div>" )
		        .addClass( "arrow_red" )
		        .addClass( feedback.vertical )
		        .addClass( feedback.horizontal )
		        .appendTo( this );
		      $(this).css( 'border', '1px solid #800000' );
		      $(this).css( 'background-color', '#FFEEEE' );//D4E6F4
		      $(this).css( 'color', '#cd0a0a' );
		    }
		  }
	    });
	    $('#safe_badge_icon').tooltip({
			hide: {
				delay: 250
			}
		});
  }
}

if(typeof ajax_running_id === 'undefined'){
	var ajax_running_id = 0;
	var ajax_running = null;
	var ui_ajax_running = null;
	var request_queue = new Array();
	var timeout_obj;
	var system_status_timer = null;
}
/**
 * @function cancel_refresh
 * @param
 * @desc stop get system status when ui ajax request
 */
function cancel_refresh(){
	clearTimeout(timeout_obj);
	request_queue.length = 0;
	if(ajax_running != null){
		ajax_running.abort();
		ajax_running = null;
	}
}
/**
 * @function system_status_fresh
 * @param
 * @desc send reques one by one in the queue
 */
function system_status_fresh(init,id){
	init = defaultvalue(init, false);
	id = defaultvalue(id, 0);
	if(init == true){
		request_queue.length = 0;
		clearTimeout(timeout_obj);
		request_queue.push('safe_get_system_status('+ajax_running_id+')');
		request_queue.push('safe_get_configuration_status('+ajax_running_id+')');
		request_queue.push('safe_get_warning_notification('+ajax_running_id+')');
	}
	if((id >= ajax_running_id) && (tmp_function_name = request_queue.shift())){
		timeout_obj=setTimeout(function(){ajax_running = eval(tmp_function_name);},5000);
	}
}

/**
 * @function redirect_by_post
 * @param
 * @desc redirect url by post with some post data
 */
function redirect_by_post(url,data){
	if(typeof url !== 'undefined' && url != ''){
		var form = document.createElement("form");
	    form.setAttribute("method", "post");
	    form.setAttribute("action", url);
	    if(typeof data !== 'undefined'){
	    	for(var key in data) 
	        { 
	    		if (data[key].constructor === Array){
	    			for(var subkey in data[key])
	    			{
	    				var hiddenField = document.createElement("input");
			            hiddenField.setAttribute("name", key+'[]');
			            hiddenField.setAttribute("value",data[key][subkey] );
			            hiddenField.setAttribute("type", "checkbox");
			            hiddenField.setAttribute("checked", 'checked');
			            form.appendChild(hiddenField);
	    			}
	    		}else{
	    			var hiddenField = document.createElement("input");
		            hiddenField.setAttribute("name", key);
		            hiddenField.setAttribute("value",data[key] );
		            hiddenField.setAttribute("type", "hidden");
		            form.appendChild(hiddenField);
	    		}
	        	
	            
	        }
	    }
	    document.body.appendChild(form);
	    form.submit();
	}
}

var p = 0;
var upload_processing_ui = null;
var processing_ui = null;

(function($){
	if(system_status_timer === null){
		safe_warn_tooltip();
		//system_status_fresh(true,ajax_running_id);
		//system_status_timer = setInterval(function(){ajax_running_id = ajax_running_id+1;system_status_fresh(true,ajax_running_id);}, 5000);//5s
		//if mouse on the tooltip will not hide
	    $( "[title]" ).bind( "mouseleave", function( event ) {
			event.stopImmediatePropagation();
			var fixed = setTimeout('$("[title]").tooltip().tooltip("close")', 250);
			$(".ui-tooltip").hover(
			    function(){
			    	clearTimeout (fixed);
			    	},
			    function(){
			    		$("[title]").tooltip().tooltip("close");
			    	}
			);
		}).tooltip();
	}
})(jQuery);
var dialog_open = false;
$(document).ready(function() {
    $('form:first *:input[type!=hidden]:first').focus();
});
$(document).ready(function() {
	if(typeof _category !== 'undefined'){
		for(var i=0;i<_category.length;i++) {
			safe_toggle_fields('safe_category_header_'+_category[i],'safe_category_'+_category[i], '0');
		}
	}
});
