<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SNG Firewall Linux service wrapper
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
safe_require_class('service');
class Sng_firewall_config_class extends Safe_configurable_object_class
{
    /**
     * @brief Constructor
     *           
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    /**
     * @brief Configure the config class object
     *         
     * @return
     */
    public function configure()
    {
        // Synch with memory not DB
        $this->_set_sync_strategy( Safe_serializable_object_class::SYNC_MEM);
        // Grab adapters
        $adapters = $this->_node->hardware()->adapters();
        $adapter_list = '';
        foreach($adapters as $adapter){
            $adapter_list .= $adapter->name().' ';
        }

        // General settings
        $this->add_field('extif', 'External Interface List', 'text', $adapter_list, 70);

        return parent::configure();
    }
}


class Sng_firewall_service_class extends Safe_service_class
{
    public function __construct($software, $name, $process_name = null)
    {
        parent::__construct($software, $name, $process_name);
    }
    public function configure()
    {
        // Create the config object
        $cfg = new Sng_firewall_config_class($this->node(), parent::path(),$this->name());
        // Synch with DB
        $cfg->configure();
        $cfg->synch();
        // Attach config to module
        $this->set_config($cfg);

        return parent::configure();
    }
    public function can_restore($info, &$reason)
    {
        // Prevent calling parent as service status will be checked
        return true;
    }
    // Overloaded service status to check for running file created by
    // firewall.hooks
    public function status(&$stats = null)
    {
        if (!isset($stats)) $stats = array();
        $name = strtolower($this->node()->software()->application()->name());
        $stat_file = $this->node()->os()->stat_file('/var/run/' . $name . '.firewall.running');
        if ($stat_file) $status = Safe_service_class::STATUS_RUNNING;
        else $status = Safe_service_class::STATUS_STOPPED;
        if (isset($stats)) {
            $stats['process'] = 'N/A';
            if (isset($stat_file[9])) {
                $uptime = time() - $stat_file[9];
                $days = '';
                if ($uptime > 24 * 60 * 60) {
                    $days = (int)($uptime / (24 * 60 * 60));
                    $days = ((string)$days) . '-';
                    $uptime = $uptime - ($days * (24 * 60 * 60));
                }
                $uptime = date('H:i:s', $uptime);
                $stats['cputime'] = $days . $uptime;
            } else $stats['cputime'] = 'N/A';
            $stats['%cpu'] = 'N/A';
            $stats['%mem'] = 'N/A';
        }
        return $status;
    }
    /**
     * @brief Generate sshd configuration
     *
     * @param[in out] $config_manager
     *
     * @return true on success
     */
    public function generate_config(&$config_manager)
    {
        //Generates service configuration files
        if (!$this->_generate_service_config($config_manager)) return false;
        // Invoke parent generate
        return parent::generate_config($config_manager);
    }
    public function _generate_service_config(&$config_manager)
    {
        $data= $this->config()->get_data_values(false);
        // Get our configuration data (unresolved)
        $firewall_conf_file  = '/etc/firewall';
        $firewall_extif = 'EXTIF="'.$data['extif'].'"';

        $config_manager->add_config(new Safe_configuration_class($firewall_conf_file, 'webconfig', Safe_configuration_class::CFG_UPDATE,Safe_configuration_class::CFG_CHOWN));
        $sed_data[] = "s/^\s*EXTIF=.*/".$firewall_extif.'/';
        $config_manager->add_config(new Safe_configuration_class($firewall_conf_file, $sed_data, Safe_configuration_class::CFG_UPDATE,Safe_configuration_class::CFG_SED));
        $config_manager->add_config(new Safe_configuration_class($firewall_conf_file, 'root', Safe_configuration_class::CFG_UPDATE,Safe_configuration_class::CFG_CHOWN));

        return true;
    }
    /**
     * @brief Invoked after a successfull write_config
     *
     * @return
     */
    public function post_write_config($obj_type=null)
    {
        // restart service
        if($this->status() == Safe_service_class::STATUS_RUNNING){
            $this->restart();
        }
        return parent::post_write_config($obj_type);
    }
    public function support_reload(&$need_reload = null) {
        parent::support_reload($need_reload);
        return true;
    }
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        return $this->generate_config($config_manager);
    }
    public function reload_clear_modified($obj_type=null)
    {
        return $this->clear_configuration_modified();
    }
}
/* End of file sng_firewall_service_class.php */
