<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * Node class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_object_class');
safe_require_class('safe_config_class');
safe_require_class('safe_os_class');
safe_require_class('safe_software_class');
safe_require_class('safe_hardware_class');
class Safe_node extends Safe_object_class
{
    private $_product = null;
    public $_os = null;
    private $_software = null;
    private $_hardware = null;
    private $_config_mgr = null;
    public function __construct($product, $name)
    {
        parent::__construct($product->object_name() , $name);
        $this->_product = $product;
    }
    public function configure($product_def = array())
    {
        // Create configuration manager
        $this->_config_mgr = new Safe_configuration_manager_class($this, $product_def['product']);
        // Latch configuration
        unset($this->_config);
        $this->_config = $product_def['product'];
        // OS
        // Configure software
        $this->_software = $this->_product->create_software_class($this);
        $this->_software->configure();
        // Configure hardware
        $this->_hardware = $this->_product->create_hardware_class($this);
        $this->_hardware->configure();
        return true;
    }
    public function execute($cmd, &$result = null)
    {
        // Delegate to os
        return $this->_os->execute($cmd, $result);
    }
    public function service_ctl($service_name, $action, &$result = null, $process_name = null)
    {
        // Delegate to os
        return $this->_os->service_ctl($service_name, $action, &$result, $process_name);
    }
    public function set_service_startup($service_name, $is_auto, $process_name = null)
    {
        // Delegate to os
        return $this->_os->set_service_startup($service_name, $is_auto, $process_name);
    }
    public function is_service_auto($service_name, $process_name = null)
    {
        // Delegate to os
        return $this->_os->is_service_auto($service_name, $process_name);
    }
    public function kill($service_name, $signal, $process_name = null)
    {
        // Delegate to os
        return $this->_os->kill($service_name, $signal, $process_name);
    }
    public function &software()
    {
        return $this->_software;
    }
    public function &hardware()
    {
        return $this->_hardware;
    }
    public function &os()
    {
        return $this->_os;
    }
    public function &configuration_manager()
    {
        return $this->_config_mgr;
    }
    public function is_configuration_modified($include_childs = true)
    {
        return ($this->software()->is_configuration_modified($include_childs) || $this->hardware()->is_configuration_modified($include_childs));
    }
    public function is_configuration_generated()
    {
        return $this->configuration_manager()->generate_count();
    }
    public function checklist(&$list, $check_generate=true){
        $this->software()->checklist($list, $check_generate);
        $this->hardware()->checklist($list, $check_generate);
        $this->configuration_manager()->checklist($list, $check_generate);
        return count($list);
    }
    public function check_object_usage($src_module_name, $obj_type, $obj_name, $sub_typ=null, $sub_name=null)
    {
        return $this->software()->application()->check_object_usage($src_module_name, $obj_type, $obj_name, $sub_typ, $sub_name);
    }

    public function generate_config()
    {
        // clean up errors
        $this->_config_mgr->reset_errors();
        $this->_config_mgr->reset_progress();
        // Ask software and hardware to generate their configuration
        if ($this->_software->generate_config($this->_config_mgr) && $this->_hardware->generate_config($this->_config_mgr) && !$this->_config_mgr->errors()) {
            // Write config cannot forget errors
            $this->_config_mgr->forget_error(false);
            if ($this->_config_mgr->write_config($this)) {
                // All good, clear modified flags
                Safe_object_serializer_class::get_serializer()->clear_modified($this->object_name() , true);
                return true;
            }
        }
        return false;
    }
    public function mkdir($pathname , $chown_recursive  = true)
    {
        // Default is to delegate to OS
        return $this->_os->mkdir($pathname , $chown_recursive);
    }
    // OS wrapper
    public function write_file($file_name, $buffer, $mode = 'w')
    {
        // Default is to delegate to OS
        return $this->_os->write_file($file_name, $buffer, $mode);
    }
    // OS wrapper
    public function read_file($file_name, &$buffer, $mode = 'r', $as_array = false)
    {
        // Default is to delegate to OS
        return $this->_os->read_file($file_name, &$buffer, $mode, $as_array);
    }
    public function symlink_file($original, $target)
    {
        // Default is to delegate to OS
        return $this->_os->symlink_file($original, $target);
    }
    public function unlink_file($file)
    {
        // Default is to delegate to OS
        return $this->_os->unlink_file($file);
    }
    public function rehash_folder($dir)
    {
        return $this->_os->rehash_folder($dir);
    }
    public function delete_file($file_name)
    {
        // Default is to delegate to OS
        return $this->_os->delete_file($file_name);
    }
    public function rmdir($pathname)
    {
        // Default is to delegate to OS
        return $this->_os->rmdir($pathname);
    }
    public function chmod_file($pathname, $mod)
    {
        // Default is to delegate to OS
        return $this->_os->chmod_file($pathname, $mod);
    }
    public function chown_file($pathname, $own)
    {
        // Default is to delegate to OS
        return $this->_os->chown_file($pathname, $own);
    }
    public function sed_file($pathname, $data)
    {
        // Default is to delegate to OS
        return $this->_os->sed_file($pathname, $data);
    }
    public function get_audit_points(&$audit_points){
        $this->os()->get_audit_points($audit_points);
        $this->software()->get_audit_points($audit_points);
        $this->hardware()->get_audit_points($audit_points);
        // re-index audit_points array using point name
        $tmp = array();
        foreach($audit_points as $point){
            $tmp[$point->name()] = $point;
        }
        $audit_points = $tmp;
    }
    public function hostname()
    {
        // Default is to delegate to OS
        return $this->_os->hostname();
    }
    public function modules()
    {
        $modules = array();
        $sw = $this->software()->services();
        foreach($sw as $k => $v){
            $modules[$k] = $v;
            $modules = array_merge($modules, $v->modules());
        }
        return $modules;
    }
    public function find_module_by_name($name){
        return $this->software()->application()->find_module_by_name($name);
    }
    public function can_install_data($info, &$reason)
    {
        //software module
        if(true != $this->software()->can_install_data($info, $reason)) return false;
        //hardware module
        if(true != $this->hardware()->can_install_data($info, $reason)) return false;
        //check os architecture
        if(true != $this->os()->can_install_data($info, $reason)) return false;
        return true;
    }
}
class Safe_local_node extends Safe_node
{
    public function __construct($product)
    {
        parent::__construct($product, "local");
    }
    public function configure($product_def = array())
    {
        // Figure out which OS we're running on
        // TODO(wadam) - CentOS as it is only running on appliance ;)
        $this->_os = new Safe_centos_wrapper();
        if (false === parent::configure($product_def)) return false;
        return true;
    }
}
/* End of file safe_node_class.php */
