<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * 0
 *
 * @author Michel Buczynski
 * @version
 */
class Safe_crud_class
{
    /*
     * $filename="/var/webconfig/SAFe/modules/crud_test/etc/crudtest-config.xml"
     * @var string
    */
    public $filename;
    public $load_file = true;
    /*
     * $config_section=array('jsr309', 'media', 'codec','audio'); @var array of
     * string
    */
    public $config_section;
    /**
     * Default data value in JSON or structured array
     *
     * @var array string
     */
    public $conf_data_default = array();
    /*
     * $config_table = array ( array ('path' => '/', 				'field' => 'codec',
     * 'label' => 'Codec',	 'type' => 'string' , 'primary_key' => true), array
     * ('path' => 'payload_type',	'field' => 'payload_type', 'label'=> 'PayLoad
     * Type', 'type' => 'int'), array ('path' => 'payload_size',	'field' =>
     * 'payload_size', 	'label'=> 'PayLoad size', 'type' => 'int'), array
     * ('path' => 'sampling_rate', 	'field' => 'sampling_rate', 'label'=>
     * 'Sampling rate', 'type' => 'int'), array ('path' => 'bit_rate', 		'field'
     * => 'bit_rate', 		'label'=> 'bit rate', 'type' => 'int') ); @var array of
     * array of string
    */
    public $config_table;
    var $line_button = array();
    var $footer_button = array();
    /*
     * $config_form= array( //array ('field' => 'codec', 			'label' => 'Codec',
     * 'type'=> 'hidden'), array ('field' => 'sampling_rate', 	'label'=>
     * 'Sampling rate', 	'type' => 'text', 'size'=>'14', 'rules'=>'numeric'),
     * array ('field' => 'payload_type', 	'label'=> 'PayLoad Type', 	'type' =>
     * 'text', 'size'=>'14', 'rules'=>'numeric'), array ('field' =>
     * 'payload_size', 	'label'=> 'PayLoad size', 	'type' => 'text',
     * 'size'=>'14', 'rules'=>'numeric'), array ('field' => 'bit_rate',
     * 'label'=> 'bit rate', 		'type' => 'text', 'size'=>'14',
     * 'rules'=>'numeric') ); @var array of array of string
    */
    public $config_form;
    /*
     * $config_form= array( array ('field' => 'pk', 			'label' => 'Codec',
     * 'type'=> 'text', rules='required'), ); @var array of array of string
    */
    public $config_form_add;
    /**
     * data array from safe_config_class
     *
     * @var array of mixed
     */
    public $conf_data = array();
    /**
     *
     * @var Safe_config_class
     */
    public $conf;
    /**
     *
     * @var Safe_table_class
     */
    public $table;
    public $data_loaded = 0;
    public function __construct()
    {
        $this->init();
    }
    private function init()
    {
        if (empty($this->conf)) {
            $this->conf = load_class('safe_config_class', 'libraries', '');
        }
        if (!empty($this->filename) && empty($this->conf->filename)) $this->conf->filename = $this->filename;
        if (empty($this->table)) $this->table = load_class("safe_table_class", 'libraries', '');
        if (!empty($this->config_table) && empty($this->table->config)) $this->table->config = $this->config_table;
    }
    function load_data($load_file = true)
    {
        $this->init();
        if (!$this->conf->load_data($load_file)) {
            $this->conf->save_new_data($this->conf_data_default);
        }
        $this->conf_data = & $this->conf->get_data($this->config_section);
        $this->data_loaded++;
    }
    protected function set_table_buttons($add_url = null)
    {
        $table = $this->table;
        $this->_set_table_buttons_data($this->line_button, $add_url);
        $this->_set_table_buttons_data($this->footer_button, $add_url);
        $table->line_button = $this->line_button;
        $table->footer_button = $this->footer_button;
    }
    protected function _set_table_buttons_data(&$buttons, $add_url = null)
    {
        if (count($buttons) > 0) {
            foreach ($buttons as $k => $v) if (empty($v['name'])) error_log("WRONG button definition");
            else if (empty($v['url'])) {
                $buttons[$k]['url'] = current_url() . '/';
                $buttons[$k]['url'].= strtolower($v['name']);
                $buttons[$k]['url'].= (!empty($add_url) ? '/' . urlencode($add_url) : '');
            }
        }
    }
    function show_table()
    {
        if ($this->data_loaded == 0) $this->load_data();
        $table = & $this->table;
        $this->set_table_buttons();
        $table->convert_data($this->conf_data);
        return $table->generate();
    }
    function show_form(&$view_data, $pk, $force = false, $add = False)
    {
        $CI = & get_instance();
        $first_time = false;
        if ($add) $this->config_form = array_merge($this->config_form_add, $this->config_form);
        if ($this->data_loaded == 0) $this->load_data();
        if (empty($_POST)) {
            if (!$add) {
                $_POST = & $this->table->get_line($this->conf_data, $pk);
            }
            $first_time = true;
        }
        $CI->load->library("safe_form_class", $this->config_form);
        if ($CI->safe_form_class->run_validation() == false || $first_time || $force) {
            $view_data['form'] = $CI->safe_form_class->form_input_array();
            $view_data['label'] = $CI->safe_form_class->form_label_array();
            $view_data['form_open'] = $CI->safe_form_class->form_open();
            return true;
        } else return false;
    }
    function &get_line($pk)
    {
        if (empty($this->conf_data) || $this->data_loaded == 0) $this->load_data();
        return $this->table->get_line($this->conf_data, $pk);
    }
    function save_line($post, $pk, $update_only = true)
    {
        // no need to load get_line will do it!
        $line = & $this->get_line($pk);
        if (empty($line)) {
            $this->conf_data[$pk] = $post;
        } else {
            $line = $post;
        }
        return $this->conf->set_data($this->config_section, $this->conf_data, $update_only);
    }
    function delete_line($pk)
    {
        $this->init();
        if ($this->data_loaded == 0) $this->load_data();
        $this->table->delete_line($this->conf_data, $pk);
        return $this->conf->set_data($this->config_section, $this->conf_data, true);
    }
    function is_modified_and_not_saved()
    {
        if ($this->data_loaded == 0) $this->load_data();
        return $this->conf->is_modified_and_not_saved();
    }
    function save_file()
    {
        $this->init();
        if ($this->data_loaded == 0) {
            error_log("safe_crud::safe_file() called without be data_loaded!");
            $this->load_data();
        }
        return $this->conf->save_file();
    }
}
/* End of file safe_crud_class.php */
