<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC RTCP Monitor Page
 * @author Shaunt Libarian
 *         
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('service');
safe_require_class('table');
safe_require_class('crud_table');
safe_require_class('form');
class Nsc_rtcpmon_param_class extends Safe_configurable_object_class
{
    public function __construct()
    {
        parent::__construct('autofill', 'Nsc_rtcpmon_param_class');
    }
    public function configure()
    {
        $this->add_field('ip_addr', 'RTP IP Address', 'string', '', 25);
        $this->set_field_rules('ip_addr', 'valid_ip');
        $this->set_field_help('ip_addr', 'The local or Remote RTP IP address that you would like to search for.');
        $this->add_field('call_leg_unique_id', 'Call Leg Unique ID', 'string', '', 50);
        $this->set_field_rules('call_leg_unique_id', 'valid_uuid');
        $this->set_field_help('call_leg_unique_id', 'Unique Identifer for a particular call. UUID format (32 hexadecimal digits, displayed in five groups separated by hyphens, in the form 8-4-4-4-12).');
        $this->add_field('session_start_time', 'Session Start Time', 'datetime', '', 20);
        $this->set_field_rules('session_start_time', 'valid_date_time');
        $this->set_field_help('session_start_time', 'Search for a particular call started at a specific time or date. Date format is YYYY-MM-DD HH:MM:SS.');
        $this->add_field('session_stop_time', 'Session Stop Time', 'datetime', '', 20);
        $this->set_field_rules('session_stop_time', 'valid_date_time');
        $this->set_field_help('session_stop_time', 'Search for a particular call ended at a specific time or date. Date format is YYYY-MM-DD HH:MM:SS.');
        //item-value-relation dropdown/textbox
        $this->add_enum_field('rtp_quality', 'RTP Quality', 'dropdown', '', array(
            'false' => 'Not Required',
            'Packet Loss Percentage' => 'Packet Loss Percentage',
            'InterArrival Jitter' => 'InterArrival Jitter'
        ));
        $this->set_field_help('rtp_quality', 'Select the RTP Quality type to search.');
        $this->add_enum_field('relation', 'RTP Quality Relation', 'dropdown', '', array(
            'eq' => '= Equal',
            'gt' => '>= Greater than or Equal',
            'lt' => '<= Less than or Equal'
        ));
        $this->set_field_help('relation', 'Set the Relationship used to search for the above RTP Quality type.');
        $this->add_field('rtp_value', 'RTP Quality Value', 'string', '', 10);
        $this->set_field_rules('rtp_value', 'required[rtp_quality]|greater_than[-1]');
        $this->set_field_help('rtp_value', 'Set the RTP Quality value used to search for the above RTP Quality type.');
        $this->create_group('rtp_quality_drop', array(
            'relation',
            'rtp_value'
        ));
        $this->conditional_control('rtp_quality', 'rtp_quality_drop');
        // Auto synch this type of object
        //$this->synch();
    }
}
class Nsc_rtcpmon extends Safe_CI_Controller
{
    private $_db = "";
    private $_rtcpmon = "";
    public function __construct()
    {
        parent::__construct();
        $this->_rtcpmon = $this->_the_product->local_node()->software()->service('rtcpmon');
        $this->_db = $this->_rtcpmon->db();
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        $error = false;
        //Display search parameters in form
        $param = new Nsc_rtcpmon_param_class();
        $param->configure();
        // Check post request
        $post = $this->input->get();
        
        if (isset($post['search'])) {
            unset($post['search']);
            $param->set_data_values($post);
            $config = $param->get_data();
            // Trick validation which rely on $_POST
            $_POST = $post;
            $this->load->library("safe_form_class", $config);
            if ($this->safe_form_class->run_validation($validation_errors)) {
                //$param->save();
                redirect('/' . $this->router->fetch_class() . '/search_results?' . $_SERVER['QUERY_STRING']);
            }
        } else {
            if($post['error'] !=''){
                $error_msg = $post['error'];
                unset($post['error']);
                $param->set_data_values($post);
            }else{
                $error_msg = '';
            }
            $config = $param->get_data();
            $this->load->library("safe_form_class", $config);
        }
        
        // Set the basic data
        $data['page_title'] = 'RTCP Monitor Reports';
        $data['page_summary'] = 'This page displays RTCP Monitor Reports.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $data['form_title'] = 'RTCP Monitor Reports';
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['buttons'] = array(
            array(
                'name' => 'search',
                'value' => 'Search',
                'type' => 'submit'
            ) ,
        );
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $data['form_cfg'] = $form_config;
        // Get the fields group
        // send the group array in our form view
        $field_group = array();
        $field_group = $param->get_group();
        $data['group'] = $field_group;
        // set the form attributes
        $frm_attributes = array(
            'id' => 'rtcpmon',
            'method' => 'get',
            'enctype' => 'application/x-www-form-urlencoded'
        );
        $this->safe_form_class->set_form_attributes($frm_attributes);
        if($error_msg == 'nodata'){
            $data['notif_error'][] = 'Search generated no result';
        }
        $data['form_open'] = $this->safe_form_class->form_open();
        
        $this->load->view("safe_header", $data);
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_form", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Displays search results
     */
    public function search_results()
    {
        // verify if logged
        //safe_authenticate ();
        $form_post = "";;
        $filter = "";
        $order_by = "";
        $having = "";
        $relation = "";
        $value = 0;
        $error = false;
        $result = array();
        /*$post = $_SESSION['data'];
         unset($_SESSION['data']);*/
        $post = $this->input->get();
        if (isset($post['relation'])) {
            if ($post['relation'] == 'gt') $relation = '>=';
            elseif ($post['relation'] == 'lt') $relation = '<=';
            elseif ($post['relation'] == 'eq') $relation = '=';
        }
        // Set the basic data
        $data['page_title'] = 'RTCP Monitor Reports';
        $data['page_summary'] = 'This page displays RTCP Monitor Reports.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $this->load->view("safe_header", $data);
        //Loads the wait message just in case page taking long to load
        $data['wait_message'] = '</br><b>Searching...</b></br>&nbsp;';
        $this->load->view("safe_confirm_dialog", $data);
        $this->load->view("safe_wait", $data);
        //Connect to MySQL Database
        
        $select = '`call_leg_unique_id`, `inflow_rtp_flag`, `event_time`, `session_start_time`, `session_stop_time`,';
        $select.= '`local_member_ip`, `remote_member_ip`, `sent_pkt_cnt`, `sent_byte_cnt`, `sender_report_cnt`, `cumulative_lost_cnt`,';
        // Calculate the maximum jitter
        $select.= '`max_inter_arrival_jitter` * 1000 / `sampling_rate` AS `max_jitter`,';
        // Calculate the average jitter
        $select.= '`average_inter_arrival_jitter` * 1000 / `sampling_rate` AS `average_jitter`,';
        // Calculate the percentage of packet loss, note how we add 0.000001 to the count of sent packets, event though is an unsigned
        // this avoids divide by zero when `sent_pkt_cnt` is 0 and at the same time keeps the precision of the resulting calculation
        $select.= '(`cumulative_lost_cnt`/(`sent_pkt_cnt` + 0.000001)) * 100 AS `pkt_loss_percent`';
        if ($post['ip_addr'] != "") $form_post = 'remote_member_ip = "' . $post['ip_addr'] . '" OR `local_member_ip` = "' . $post['ip_addr'] . '"';
        if ($post['call_leg_unique_id'] != "") {
            if (isset($form_post) && $form_post != "") $form_post.= " AND `";
            $form_post.= 'call_leg_unique_id` = "' . $post['call_leg_unique_id'] . '"';
        }
        if ($post['session_start_time'] != "") {
            if ($form_post != "") $form_post.= " AND `";
            $form_post.= 'session_start_time` >= "' . $post['session_start_time'] . '"';
        }
        if ($post['session_stop_time'] != "") {
            if (isset($form_post) && $form_post != "") $form_post.= " AND `";
            $form_post.= 'session_stop_time` <=' . ' "' . $post['session_stop_time'] . '"';
        }
        if ($post['rtp_quality'] != 'false') {
            if ($post['rtp_quality'] == 'InterArrival Jitter' && $post['rtp_value'] != "") {
                $value = $post['rtp_value'] / 100;
                $having = 'average_jitter' . ' ' . $relation . $value;
                $order_by = 'average_jitter DESC, `event_time` DESC';
            } elseif ($post['rtp_quality'] == 'Packet Loss Percentage' && $post['rtp_value'] != "") {
                $value = $post['rtp_value'];
                $having = 'pkt_loss_percent ' . $relation . ' ' . $value;
                $order_by = 'pkt_loss_percent DESC, `event_time` DESC';
            } else {
                $error = true;
            }
        }
        
        $data_offset = '';
        $total_row = 0;
        $db = $this->_db; //Holds configuration
        $db->connect();
        //get total record
        if (!$error) {
            $record_count = $db->get_select_count('reports', $form_post,'', $select, $having);
        }
        if($record_count == 0){
            
            $str_pos = strpos($_SERVER['QUERY_STRING'],'&search=');
            if($str_pos !== false){
                $_SERVER['QUERY_STRING'] = substr($_SERVER['QUERY_STRING'] ,0 , $str_pos) ;
            }
            redirect('/' . $this->router->fetch_class() . '/?' . $_SERVER['QUERY_STRING'] ."&error=nodata");
            exit();
        }
        // Check how many files we have to create pagination
        $max_per_page = 20;
        if(isset($post['per_page']) && $post['per_page']!=''){
            $offset = $post['per_page'];
        }
        $data_offset = isset($offset) ? $offset : 0;
        
        if ($max_per_page < $record_count) {
            $this->load->library('pagination');
            $str_pos = strpos($_SERVER['QUERY_STRING'],'&per_page');
            if($str_pos !== false){
                $pagination_config['base_url'] = dirname($_SERVER['REQUEST_URI']) . '/search_results?' . substr($_SERVER['QUERY_STRING'] ,0 , $str_pos) ;
            }else{
                $pagination_config['base_url'] = dirname($_SERVER['REQUEST_URI']) . '/search_results?' . $_SERVER['QUERY_STRING'];
            }
            
            $pagination_config['total_rows'] = $record_count;
            $pagination_config['per_page'] = $max_per_page;
            $pagination_config['page_query_string'] = true;
            $this->pagination->initialize($pagination_config);
        }
        $limit = $max_per_page;
        
        if (!$error) {
            if (count($form_post) > 0) {
                //check array if time frames entered
                if ($order_by != "") {
                    if ($having != "") $result = $db->select('reports', $form_post, $limit, $data_offset, $order_by, '', $select, $having);
                    else $result = $db->select('reports', $form_post, $limit, $data_offset, $order_by, '', $select);
                } else $result = $db->select('reports', $form_post, $limit, $data_offset, '', '', $select);
            } else {
                if ($order_by != "") {
                    if ($having != "") $result = $db->select('reports', $form_post, $limit, $data_offset, $order_by, '', $select, $having);
                    else $result = $db->select('reports', $form_post, $limit, $data_offset, $order_by, '', $select);
                } else $result = $db->select('reports', '', $limit, $data_offset, '', '', $select);
            }
        }
        $db->disconnect();
        
        //Prepare table structure
        $data['table_size'] = '100%';
        $table = new Safe_crud_table_class();
        $data['table_title'] = $table->set_title('RTCP Monitor Search Results'."({$record_count})");
        // Prepare heading
        $table->data_formatter = array('none');
        $table->set_headings(array(
                array(
                        'data' => 'UUID',
                        'title' => 'Call leg unique id'
                ) ,
                array(
                        'data' => 'Direction',
                        'title' => ' Indicating the direction of RTP this record\'s statistics represents'
                ) ,
                array(
                        'data' => 'Start Time',
                        'title' => 'The time when the RTP stream starts'
                ) ,
                array(
                        'data' => 'Stop Time',
                        'title' => 'The time when the RTP stream stops'
                ) ,
                array(
                        'data' => 'Local IP',
                        'title' => 'Local side\'s IP of the RTP stream'
                ) ,
                array(
                        'data' => 'Remote IP',
                        'title' => 'Remote side\'s IP of the RTP stream'
                ) ,
                array(
                        'data' => 'Pkts',
                        'title' => 'How many packets have been sent in this direction\'s RTP stream'
                ) ,
                array(
                        'data' => 'Bytes',
                        'title' => 'How many bytes have been sent in this direction\'s RTP stream'
                ) ,
                array(
                        'data' => '% Pkt Loss',
                        'title' => 'Percentage of packet loss'
                ) ,
                array(
                        'data' => 'Max. Jitter',
                        'title' => 'Maximum InterArrival Jitter(in milliseconds) ever happened in this direction\'s RTP stream'
                ) ,
                array(
                        'data' => 'Avg. Jitter',
                        'title' => 'Average InterArrival Jitter(in milliseconds) of all that ever happened in this direction\'s RTP stream'
                ) ,
        ));
        $table->set_controller_url($this->router->fetch_class());
        
        $row_cnt = 0;
        // Get CDR module
        $cdr_module = $this->_the_product->local_node()->software()->application()->module('cdr');
        
        foreach ($result as $row) {
            if ($row->inflow_rtp_flag == 1) $inflow = 'Inflow';
            else $inflow = 'Outflow';
            // Check if cdr available for this uuid
            if (TRUE == $cdr_module->data_key_exists('cdr', $row->call_leg_unique_id.'.cdr')){
                $uuid_col = '<a style="padding:0px;" href="/SAFe/sng_data_manager/view/cdr/cdr/' . $row->call_leg_unique_id . '">' . $row->call_leg_unique_id . '</a>';
            }else{
                $uuid_col = $row->call_leg_unique_id;
            }
            $table->add_row(array(
                    $uuid_col,
                    //$row->call_leg_unique_id,
                    $inflow,
                    $row->session_start_time,
                    $row->session_stop_time,
                    $row->local_member_ip,
                    $row->remote_member_ip,
                    number_format($row->sent_pkt_cnt) ,
                    number_format($row->sent_byte_cnt) ,
                    number_format($row->pkt_loss_percent) ,
                    number_format($row->max_jitter) ,
                    number_format($row->average_jitter)
            ) , '', '');
            $row_cnt++;
        }
        if (isset($pagination_config)) $table->set_footer($this->pagination->create_links());
        // Generate table HTML code
        $data['table'] = $table->generate_table();
        
        $data['notif_warn'][] = '<div style="float:left;height:22px;line-height:22px;">&nbsp;&nbsp;</div>'.
                '<div style="float:left">'.safe_button_click("search", ucfirst('New Search') , '/SAFe/nsc_rtcpmon', array(
                        'float:right;'
                )).'</div>'.
                '<div style="float:left">'.safe_button_click("download", ucfirst('Download') , '/SAFe/nsc_rtcpmon/download?'.$_SERVER['QUERY_STRING'], array(
                        'float:right;'
                )).'</div>'
                        ;
                        
        $this->load->view("safe_notifications", $data);
        if ($row_cnt) {
            $this->load->view("safe_hide_menu");
            $this->load->view("safe_table", $data);
        }
        $this->load->view("safe_footer", $data);
    }
    /**
     * dowload search results
     */
    public function download()
    {
        // verify if logged
        //safe_authenticate ();
        $form_post = "";;
        $filter = "";
        $order_by = "";
        $having = "";
        $relation = "";
        $value = 0;
        $error = false;
        $result = array();
        $post = $this->input->get();
        if (isset($post['relation'])) {
            if ($post['relation'] == 'gt') $relation = '>=';
            elseif ($post['relation'] == 'lt') $relation = '<=';
            elseif ($post['relation'] == 'eq') $relation = '=';
        }
        //Connect to MySQL Database
        $db = $this->_db; //Holds configuration
        $db->connect();
        $select = '`call_leg_unique_id`, `inflow_rtp_flag`, `event_time`, `session_start_time`, `session_stop_time`,';
        $select.= '`local_member_ip`, `remote_member_ip`, `sent_pkt_cnt`, `sent_byte_cnt`, `sender_report_cnt`, `cumulative_lost_cnt`,';
        // Calculate the maximum jitter
        $select.= '`max_inter_arrival_jitter` * 1000 / `sampling_rate` AS `max_jitter`,';
        // Calculate the average jitter
        $select.= '`average_inter_arrival_jitter` * 1000 / `sampling_rate` AS `average_jitter`,';
        // Calculate the percentage of packet loss, note how we add 0.000001 to the count of sent packets, event though is an unsigned
        // this avoids divide by zero when `sent_pkt_cnt` is 0 and at the same time keeps the precision of the resulting calculation
        $select.= '(`cumulative_lost_cnt`/(`sent_pkt_cnt` + 0.000001)) * 100 AS `pkt_loss_percent`';
        if ($post['ip_addr'] != "") $form_post = 'remote_member_ip = "' . $post['ip_addr'] . '" OR `local_member_ip` = "' . $post['ip_addr'] . '"';
        if ($post['call_leg_unique_id'] != "") {
            if (isset($form_post) && $form_post != "") $form_post.= " AND `";
            $form_post.= 'call_leg_unique_id` = "' . $post['call_leg_unique_id'] . '"';
        }
        if ($post['session_start_time'] != "") {
            if ($form_post != "") $form_post.= " AND `";
            $form_post.= 'session_start_time` >= "' . $post['session_start_time'] . '"';
        }
        if ($post['session_stop_time'] != "") {
            if (isset($form_post) && $form_post != "") $form_post.= " AND `";
            $form_post.= 'session_stop_time` <=' . ' "' . $post['session_stop_time'] . '"';
        }
        if ($post['rtp_quality'] != 'false') {
            if ($post['rtp_quality'] == 'InterArrival Jitter' && $post['rtp_value'] != "") {
                $value = $post['rtp_value'] / 100;
                $having = 'average_jitter' . ' ' . $relation . $value;
                $order_by = 'average_jitter DESC, `event_time` DESC';
            } elseif ($post['rtp_quality'] == 'Packet Loss Percentage' && $post['rtp_value'] != "") {
                $value = $post['rtp_value'];
                $having = 'pkt_loss_percent ' . $relation . ' ' . $value;
                $order_by = 'pkt_loss_percent DESC, `event_time` DESC';
            } else {
                $error = true;
            }
        }
        //limit number
        $limit = null;
        $result = array();
        if (!$error) {
            if (count($form_post) > 0) {
                //check array if time frames entered
                if ($order_by != "") {
                    if ($having != "") $result = $db->select('reports', $form_post, $limit, '', $order_by, '', $select, $having);
                    else $result = $db->select('reports', $form_post, $limit, '', $order_by, '', $select);
                } else $result = $db->select('reports', $form_post, $limit, '', '', '', $select);
            } else {
                if ($order_by != "") {
                    if ($having != "") $result = $db->select('reports', $form_post, $limit, '', $order_by, '', $select, $having);
                    else $result = $db->select('reports', $form_post, $limit, '', $order_by, '', $select);
                } else $result = $db->select('reports', '', $limit, '', '', '', $select);
            }
        }
        $db->disconnect();
        $csv_data_array = array();
        $csv_data_array[] = array('UUID','Direction','Start Time','Stop Time','Local IP','Remote IP','Pkts','Bytes','% Pkt Loss','Max. Jitter','Avg. Jitter');
        foreach ($result as $row) {
            if ($row->inflow_rtp_flag == 1) $inflow = 'Inflow';
            else $inflow = 'Outflow';
            // Check if cdr available for this uuid
            $csv_data_array[] =array(
                    $row->call_leg_unique_id,
                    $inflow,
                    $row->session_start_time,
                    $row->session_stop_time,
                    $row->local_member_ip,
                    $row->remote_member_ip,
                    number_format($row->sent_pkt_cnt) ,
                    number_format($row->sent_byte_cnt) ,
                    number_format($row->pkt_loss_percent) ,
                    number_format($row->max_jitter) ,
                    number_format($row->average_jitter)
            );
        }
        safe_csv_download('rtcpmon_search_results',$csv_data_array);
    }
}
?>
