<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS LCR Rate Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('fs', 'application');
class Fs_lcr_rate_class extends Safe_configurable_object_class
{
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        $this->add_field('digits', 'Digits to match', 'string', '', 50);
        $this->set_field_rules('digits', 'required|min_length[1]|max_length[30]');
        $this->set_field_help('digits', 'The entered numbers will be matched with the dialed number to determine which route to use.');
        $this->add_field('rate', 'Least Cost Routing Rate', 'string', '', 50);
        $this->set_field_rules('rate', 'required|decimal');
        $this->set_field_help('rate', 'The rate indicates the relative cost of the using this carrier.');
        $this->add_field('lead_strip', 'Strip Leading Digits', 'string', '', 50);
        $this->set_field_rules('lead_strip', 'greater_than[0]|less_than[29]');
        $this->set_field_help('lead_strip', 'Number of digits to strip off the front off the dialed number.');
        $this->add_field('trail_strip', 'Strip Trailing Digits', 'string', '', 50);
        $this->set_field_rules('trail_strip', 'greater_than[0]|less_than[29]');
        $this->set_field_help('trail_strip', 'Number of digits to strip off the trailing portion of the dialed number.');
        $this->add_field('prefix', 'Prefix', 'string', '', 50);
        $this->set_field_rules('prefix', 'alpha_dash');
        $this->set_field_help('prefix', 'Prefix to add in front of the dialed number.');
        $this->add_field('suffix', 'Suffix', 'string', '', 50);
        $this->set_field_rules('suffix', 'alpha_dash');
        $this->set_field_help('suffix', 'Suffix to add after the dialed number.');
        $this->add_field('date_start', 'Start Date', 'date', '', 20);
        $this->set_field_rules('date_start', 'valid_date');
        $this->set_field_help('date_start', 'Date when the carrier rate will become active. Must be entered in YYYY-MM-DD format.');
        $this->add_field('date_end', 'End Date', 'date', '', 20);
        $this->set_field_rules('date_end', 'valid_date|date_greater_than[today]|date_greater_than[date_start]');
        $this->set_field_help('date_end', 'Date when the carrier rate will end. Must be entered in YYYY-MM-DD format.');
        return parent::configure();
    }
    public function description()
    {
        $cfg = $this->get_data_values(false);
        return 'Digits=' . $cfg['digits'] . ' Rate=' . $cfg['rate'];
    }
    public function summary($type = 'horizontal' , $long = false){
        $table_line = parent::summary($type , $long);
        array_shift($table_line['data']);
        return $table_line;
    }
    
}
?>
