<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS Certificate Module Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_module_require_class('fs', 'application');
safe_module_require_class('fs', 'certificate_config');

class Fs_certificate_rehash_class extends Safe_configuration_user_class
{
    public function __construct($dir)
    {
        parent::__construct($dir, 'c_rehash');
    }
    public function run($node)
    {
        return $node->execute('sudo /usr/bin/c_rehash ' . $this->file_name());
    }
}


class Fs_certificate_module_class extends Fs_module_class
{
    private $_obj_base_path = '';
    private $_ca = array();
    private $_server = array();
    public function __construct($fs_app)
    {
        parent::__construct($fs_app, "certificate");
        $this->_obj_base_path = $this->path() .'/certificate';
    }
    public function configure()
    {
        // Set the module description
        $this->set_description("Certificate");
        // Register objects
        $this->register_aggregate_object('ca',
            array(
                'name' => 'CA',
                'dynamic' => true,
                'base_path' => $this->_obj_base_path .'/ca',
                'class' => 'Fs_ca_certificate_config_class',
                'autoname' => true,
                'popup_add_form' => true,
                'controller' => array(
                        'config_manager' => array(
                                'summary_buttons' => 'View|Delete:confirm'
                        ),
                ),
                'methods' => array(
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => 'Retrieve CA certificate',
                        'request' => 'GET',
                    ),
                    'create' => array(
                        'name' => 'Create',
                        'description' => 'Create CA certificate',
                        'request' => 'POST',
                    ),
                    'update' => array(
                            'name' => 'Create',
                            'description' => 'Update CA certificate',
                            'request' => 'POST',
                    ),
                    'delete' => array(
                            'name' => 'Delete',
                            'description' => 'Delete CA certificate',
                            'request' => 'POST',
                    ),
                ),
            )
        );
        $this->register_aggregate_object('server',
            array(
                'name' => 'Server',
                'dynamic' => false,
                'base_path' => $this->_obj_base_path . '/server',
                'class' => 'Fs_server_certificate_config_class',
                'autoname' => true,
                'popup_add_form' => true,
                'controller' => array(
                        'config_manager' => array(
                                'summary_buttons' => 'View|Delete:confirm'
                        ),
                ),
                'methods' => array(
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => 'Retrieve Server certificate',
                        'request' => 'GET',
                     ),
                    'create' => array(
                        'name' => 'Create',
                        'description' => 'Create Server certificate',
                        'request' => 'POST',
                    ),
                    'update' => array(
                            'name' => 'Create',
                            'description' => 'Update CA certificate',
                            'request' => 'POST',
                    ),
                    'delete' => array(
                            'name' => 'Delete',
                            'description' => 'Delete CA certificate',
                            'request' => 'POST',
                    ),
                ),
            )
        );
        return parent::configure();
    }

    public function api_retrieve_ca($name, $data=null, &$output = null)
    {
        $cas = $this->cas();
        return $cas[$name];
    }
    public function api_create_ca($name, $data=null, &$output = null)
    {
        $profile = new Fs_ca_certificate_config_class($this->node(), $this->_obj_base_path.'/ca', $name);
        $profile->configure();
        if($data) {
            $profile->set_data_values($data);
        }
        return $profile;
    }
    public function api_update_ca($name, $data=null, &$output = null)
    {
        $ca = $this->api_retrieve_ca($name);
        if($ca) {
            if ($ca->validate($data,$output)) {
                if (true == $ca->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    public function api_delete_ca($name, $data=null, &$output = null)
    {
        $ca = $this->api_retrieve_ca($name);
        if($ca) {
            if($ca->can_dispose($output)) {
                return $ca->dispose();
            }
        }
        return false;
    }
    public function api_retrieve_server($name, $data=null, &$output = null)
    {
        $servers = $this->servers();
        return $servers[$name];
    }
    public function api_create_server($name, $data=null, &$output = null)
    {
        $profile = new Fs_server_certificate_config_class($this->node(), $this->_obj_base_path.'/server', $name);
        $profile->configure();
        if($data) {
            $profile->set_data_values($data);
        }
        return $profile;
    }
    public function api_update_server($name, $data=null, &$output = null)
    {
        $server = $this->api_retrieve_server($name);
        if($server) {
            if ($server->validate($data,$output)) {
                if (true == $server->save()) {
                    return true;
                }
            }
        }
        return false;
    }
    public function api_delete_server($name, $data=null, &$output = null)
    {
        $server = $this->api_retrieve_server($name);
        if($server) {
            if($server->can_dispose($output)) {
                return $server->dispose();
            }
        }
        return false;
    }
    /**
     * @brief
     *
     * @param[in out] $obj_type
     *
     * @return
     */
    public function reload_clear_modified($obj_type=null)
    {
        return $this->clear_configuration_modified();
    }
    
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::reload_generate_config($config_manager, $obj_type);
    }

    public function support_reload(&$need_reload = NULL)
    {
        foreach($this->fs_app()->sip_profiles() as $profile){
            if(
               /* $profile->get_certificate_info($i, $j) 
               && */
                $profile->is_modified()){
                $need_reload = true;
                break;
            }
        }
        return true;
    }
    public function is_configuration_modified($include_childs = true)
    {
        // Check if a SIP module is modified
        foreach($this->fs_app()->sip_profiles() as $profile){
            if(
                /* $profile->get_certificate_info($i, $j) && */
                $profile->is_modified()){
                return true;
            }
        }
        return parent::is_configuration_modified($include_childs);
    }

    public function generate_config(&$config_manager)
    {
        if(!$this->_generate_config($config_manager)) return false;
        return parent::generate_config($config_manager);
    }
    const CA_STORE = 'ssl/CA_store/';
    const CA_PROFILES = 'ssl/profiles/';
    private function _generate_config(&$config_manager)
    {
        $this->_serialize_ca($config_manager, $this->cas());
        $this->_serialize_server($config_manager, $this->cas(), $this->fs_app()->sip_profiles());

        return true;
    }
    /**
     * Handles serialization of CA Certificates
     * @param object  $config_manager 
     * @param object  $ca_certificates
     * @return boolean
     */
    protected function _serialize_ca(&$config_manager, $ca_certificates)
    {
        // Remove directories
        $config_manager->add_config(new Safe_configuration_class(Fs_certificate_module_class::CA_STORE, '', Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_DIR));
        $config_manager->add_config(new Safe_configuration_class(Fs_certificate_module_class::CA_STORE, '', Safe_configuration_class::CFG_CREATE, Safe_configuration_class::CFG_DIR));
        foreach ($ca_certificates as $cert) {
            $cert_file = $cert->get_data_value('certificate-file-name', false);
            //Place certificate in CA_store
            $file = Fs_certificate_module_class::CA_STORE . $cert_file;
            $cert_content = $cert->get_data_value('certificate-file-contents', false);
            $config_manager->add_config(
                new Safe_configuration_class(
                    $file, 
                    base64_decode($cert_content) , 
                    Safe_configuration_class::CFG_UPDATE, 
                    Safe_configuration_class::CFG_FILE));
        }
    }

    /**
     * Handles serialization of SIP profile Certificates
     * @param object  $config_manager 
     * @param object  $ca_certificates
     * @param object  $sip_profiles   
     * @return boolean
     */
    protected function _serialize_server(&$config_manager, $ca_certificates, $sip_profiles)
    {
        // Remove directories
        $config_manager->add_config(new Safe_configuration_class(Fs_certificate_module_class::CA_PROFILES, '', Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_DIR));
        // make sure SSL directories exists
        $config_manager->add_config(new Safe_configuration_class(Fs_certificate_module_class::CA_PROFILES, '', Safe_configuration_class::CFG_CREATE, Safe_configuration_class::CFG_DIR));
        $cfg_dir = $config_manager->directory('configuration') . '/';

        // Check SIP profile uses certficate ?
        foreach ($sip_profiles as $sip_cfg) {
            $ua_cert_name = "";
            $ua_cert_content = "";
            if($sip_cfg->get_certificate_info($ua_cert_name)){
                $ua_cert = $this->api_retrieve_server($ua_cert_name);
                $ua_cert_content = $ua_cert->get_data_value('certificate-file-contents', false);
                
                // Create sip profile ssl dir
                $directory = 'ssl/profiles/' . $sip_cfg->name();
                $config_manager->add_config(new Safe_configuration_class($directory, '', Safe_configuration_class::CFG_CREATE, Safe_configuration_class::CFG_DIR));
                // Serialize the profile certificate
                $file = 'ssl/profiles/' . $sip_cfg->name() . '/agent.pem';
                $config_manager->add_config(new Safe_configuration_class($file, base64_decode($ua_cert_content) , Safe_configuration_class::CFG_UPDATE, Safe_configuration_class::CFG_FILE));
             
                // Any CA cert ?
                foreach ($ca_certificates as $cert) {
                    $cert_file = $cert->get_data_value('certificate-file-name', false);
                    //Update the SIP Profile with the symbolic link on CA cert
                    $file_link['original'] = $cfg_dir . Fs_certificate_module_class::CA_STORE . $cert_file;
                    $file_link['target'] = $cfg_dir . Fs_certificate_module_class::CA_PROFILES . $sip_cfg->name() . '/' . $cert_file;
                    $config_manager->add_config(new Safe_configuration_class($file_link, '', Safe_configuration_class::CFG_LINK, Safe_configuration_class::CFG_FILE));

                }
                //run c_rehash
                $dir = $cfg_dir . Fs_certificate_module_class::CA_PROFILES . $sip_cfg->name();
                $config_manager->add_config(new Fs_certificate_rehash_class($dir));
            }
        }

        return true;
    }
    /**
     * Returns all the dialplans
     */
    public function cas()
    {
        $this->_ca = $this->get_aggregate_objects('ca');
        return $this->_ca;
    }
    public function servers()
    {
        $this->_server = $this->get_aggregate_objects('server');
        return $this->_server;
    }
    public function new_fields(&$config_manager, $type)
    {
        $name = Safe_object_serializer_class::build_unique_name($type);
        $config_manager->add_field('profile-name', 'Profile Name', 'hidden', $name, 50);
        $config_manager->add_upload_field('certificate','Certificate','upload','',30,true);
        //$config_manager->set_field_help('certificate','Certificate that will be used with NSC. Must be a valid PEM file.');
        $config_manager->set_field_rules('certificate','required');
        $config_manager->add_field('save', 'Save', 'hidden', 'save', 10);
    }
}
?>
