<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * FS application class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_configuration_manager_class');
safe_require_class('safe_application_class');
safe_module_require_class('sng', 'application');
safe_module_require_class('fs', 'module');
safe_module_require_class('fs', 'core_module');
safe_module_require_class('fs', 'sip_module');
safe_module_require_class('fs', 'dialplan_module');
safe_module_require_class('fs', 'hmr_module');
safe_module_require_class('fs', 'certificate_module');
safe_module_require_class('fs', 'distributor_module');


class Fs_application_class extends Sng_application_class
{
    private $_node = "";
    private $_db = null;

    public function __construct($node, $name, $process_name = null)
    {
        parent::__construct($node, $name, $process_name);
        $this->_node = $node;
    }
    public function register_modules() {
        parent::register_modules();
        $this->register_module(new Fs_core_module_class($this));
        $this->register_module(new Fs_certificate_module_class($this));
        $this->register_module(new Fs_directory_module_class($this));
        $this->register_module(new Fs_media_module_class($this));
        $this->register_module(new Fs_sip_module_class($this));
        $this->register_module(new Fs_distributor_module_class($this));
        $this->register_module(new Fs_dialplan_module_class($this));
        $this->register_module(new Fs_hmr_module_class($this));
    }
    public function configure()
    {
        // Check if application is a service
        if (is_subclass_of($this, 'Safe_service_class')) $this->node()->software()->add_service($this);
        // Register core module
        $this->register_modules();
        // Get DB
        $this->db();

        return parent::configure();
    }
    /**
     * Check to see if the fs service can start
     * @see Safe_service_class::can_start()
     */
    public function can_start(&$reason = array())
    {
        $type = "";
        $license = $this->node()->software()->license();
        if (!$license->status($type)) {
            $reason[] = array(
                "msg" => "License Not Installed",
                "url" => '/SAFe/sng_license',
                "label" => "Update License"
            );
            return false;
        }
        return parent::can_start();
    }
    public function data_rotate($data_name)
    {
        // Use kill SIGHUP to rotate data
        return $this->kill(Safe_service_class::SIGHUP);
    }
    public function eslapi_execute($command, $arguments, &$output)
    {
        // Use fs_cli to execute the command for now
        $bin_path = $this->node()->configuration_manager()->directory('binary');
        $bin_path.= '/';
        // TODO(wadam) - Implement socket
        $rc = $this->node()->execute($bin_path . "fs_cli -x \"" . $command . " " . $arguments . "\"", $output);
        error_log( 'eslapi_execute - ' . $command . ' - ' . ((true == $rc) ? 'OK' : 'ERROR'));
        return $rc;
    }
    /**
     * @brief Reload generate/config handler
     *
     * @param[in out] $config_manager
     * @param[in out] $obj_type
     *
     * @return 
     */
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        if(!$this->_generate_config($config_manager)){
            return false;
        }
        return true;

        // Do not call parent as it may re-generate all config
        //return parent::reload_generate_config($config_manager, $obj_type);
    }
    /**
     * @brief Invoked after a successfull write_config
     *         
     * @return
     */
    public function post_reload()
    {
        $this->reloadxml();
    }
    /**
     * Overloaded Generate configuration.
     * Will produce FS Specific configuration
     * @see Safe_module_class::generate_config()
     */
    private function _generate_config(&$config_manager)
    {
        //Create modules_additional.xml file
        if (!$this->module_additional($config_manager)){
            return false;
        }
        //Create vars_additional.xml file
        if (!$this->vars_additional($config_manager)){
            return false;
        }
        if (!$this->logfile_configuration($config_manager)){
            return false;
        }
        
        return true;
    }
    public function generate_config(&$config_manager)
    {
        if(!$this->_generate_config($config_manager)){
            return false;
        }
        return parent::generate_config($config_manager);
    }
    /**
     * Creates the modules_additional.conf.xml file
     * @param object  $config_manager
     * @return boolean
     */
    public function module_additional(&$config_manager)
    {
        // Create xml document
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        $xml_writer->startDocument('1.0', 'UTF-8');
        $xml_writer->startElement('include');
        $modules = $this->modules();
        foreach ($modules as $module) {
            if (is_subclass_of($module, 'Fs_module_class')) {
                $mod_name = $module->get_fs_module_name();
                if (!is_array($mod_name)) $module_name[$mod_name] = $mod_name;
                else $module_name = $mod_name;
                foreach ($module_name as $mod) {
                    $flag = $module->is_enabled($mod);
                    if ($flag === true) $flag = 'load';
                    if ($flag === false) $flag = 'skip';
                    switch ($flag) {
                    case 'load':
                        $xml_writer->startElement('load');
                        $xml_writer->writeAttribute('module', $mod);
                        if ($module->is_critical($mod)) $xml_writer->writeAttribute('critical', 'true');
                        $xml_writer->endElement();
                        break;

                    case 'noload':
                        $xml_writer->startElement('noload');
                        $xml_writer->writeAttribute('module', $mod);
                        $xml_writer->endElement();
                        break;

                    case 'skip':
                        break;
                    }
                }
                unset($module_name);
            }
        }
        $xml_writer->fullEndElement(); /* </include> */
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = 'autoload_configs/modules_additional.xml';
        $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        return true;
    }
    public function vars_additional(&$config_manager)
    {
        // Create xml document
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        $xml_writer->startDocument('1.0', 'UTF-8');
        $xml_writer->startElement('include');
        // Query global vars from modules
        $modules = $this->modules();
        foreach ($modules as $mod => $module) {
            $vars = $module->get_global_variables();
            foreach ($vars as $k => $v) {
                $xml_writer->startElement('X-PRE-PROCESS');
                $xml_writer->writeAttribute('cmd', 'set');
                $xml_writer->writeAttribute('data', $k . '=' . $v);
                $xml_writer->endElement();
            }
        }
        // Query global vars from services
        $services = $this->node()->software()->services();
        foreach ($services as $ser => $service) {
            $vars = $service->get_global_variables();
            foreach ($vars as $k => $v) {
                $xml_writer->startElement('X-PRE-PROCESS');
                $xml_writer->writeAttribute('cmd', 'set');
                $xml_writer->writeAttribute('data', $k . '=' . $v);
                $xml_writer->endElement();
            }
        }
        //SLIBARIAN: added this as per Moy. Needed an entry in vars_additional.xml when media interfaces are set to disabled
        $transcoding_mode = new Sng_transcoding_config_class($this->node());
        $transcoding_mode->configure();
        $transcoding_cfg = $transcoding_mode->get_data_values(false);
        $xml_writer->startElement('X-PRE-PROCESS');
        $xml_writer->writeAttribute('cmd', 'set');
        if ('false' == $transcoding_cfg['enable_media_interface']) $xml_writer->writeAttribute('data', 'media_server=false');
        elseif ('true' == $transcoding_cfg['enable_media_interface']) $xml_writer->writeAttribute('data', 'media_server=true');
        $xml_writer->endElement();
        $xml_writer->fullEndElement(); /* </include> */
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = 'vars_additional.xml';
        $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        return true;
    }
    public function logfile_configuration(&$config_manager)
    {
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        //$xml_writer->startDocument('1.0', 'UTF-8');
        $xml_writer->startElement('configuration');
        $xml_writer->writeAttribute('name', 'logfile.conf');
        $xml_writer->writeAttribute('description', 'File Logging');
            $xml_writer->startElement('settings');
            $xml_writer->writeComment(' true to auto rotate on HUP, false to open/close ');
                $xml_writer->startElement('param');
                $xml_writer->writeAttribute('name', 'rotate-on-hup');
                $xml_writer->writeAttribute('value', 'true');
                $xml_writer->endElement();//param
            $xml_writer->endElement();//settings
            $xml_writer->startElement('profiles');
                $xml_writer->startElement('profile');
                $xml_writer->writeAttribute('name', 'default');
                    $xml_writer->startElement('settings');
                        $xml_writer->writeComment(' File to log to ');
                        $xml_writer->startElement('param');
                        $xml_writer->writeAttribute('name', 'logfile');
                        $path = $this->node()->configuration_manager()->directory('log').'/' . $this->name() . '.log';
                        $xml_writer->writeAttribute('value', $path);
                        $xml_writer->endElement();//param
                        $xml_writer->writeComment(' At this length in bytes rotate the log file (0 for never) ');
                        $xml_writer->startElement('param');
                        $xml_writer->writeAttribute('name', 'rollover');
                        $xml_writer->writeAttribute('value', '10485760');
                        $xml_writer->endElement();//param
                        $xml_writer->writeComment(' Uncomment to prefix all log lines by the session\'s uuid ');
                        $xml_writer->startElement('param');
                        $xml_writer->writeAttribute('name', 'uuid');
                        $xml_writer->writeAttribute('value', 'true');
                        $xml_writer->endElement();//param
                   $xml_writer->endElement();//settings
                   $xml_writer->startElement('mappings');
                       $xml_writer->writeComment(" name can be a file name, function name or 'all' ");
                       $xml_writer->writeComment(" value is one or more of debug,info,notice,warning,err,crit,alert,all");
                       $xml_writer->writeComment(" Please see comments in console.conf.xml for more information");
                       $xml_writer->startElement('map');
                       $xml_writer->writeAttribute('name', 'all');
                       $xml_writer->writeAttribute('value', 'debug,info,notice,warning,err,crit,alert');
                       $xml_writer->endElement();//map
                   $xml_writer->endElement();//mappings
                $xml_writer->endElement();//profile
            $xml_writer->endElement();//profiles
        $xml_writer->endElement();//configuration
        
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = 'autoload_configs/logfile.conf.xml';
        $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        
        return true;
    }
    
    /**
     * @brief Reload XML files 
     *
     * @return 
     */
    public function reloadxml()
    {
        // Check if FS is running
        if (Safe_service_class::STATUS_RUNNING == $this->status()) {
            $output = array();
            $rc = $this->eslapi_execute("reloadxml", '', $output);
            return $rc;
        }
        return true;
    }
    /**
     * @brief Freeswitch db
     *
     * @return
     */
    function db()
    {
        if(!$this->_db) {
            $cfg_db = array (
                            'hostname' => 'localhost',
                            'username' => 'root',
                            'password' => '',
                            'port' => '3306',
                            'database' => 'freeswitch',
                            'dbdriver' => 'mysql',
                            'dbprefix' => '',
                            'pconnect' => 'false',
                            'db_debug' => 'true',
                            'cache_on' => 'false',
                            'cachedir' => '',
                            'char_set' => 'utf8',
                            'dbcollat' => 'utf8_general_ci',
                            'active-record' => 'true',
                            );
            $this->_db = Safe_database_class::factory($cfg_db);
        }
        return $this->_db;
    }
    /**
     * Returns sip profiles in an array
     */
    public function sip_profiles()
    {
        $sip_module = $this->module('sip');
        if($sip_module) {
            return $sip_module->profiles();
        } else {
            return array();
        }
    }
    public function sip_trunks()
    {
        $sip_module = $this->module('sip');
        if($sip_module) {
            return $sip_module->trunks();
        } else {
            return array();
        }
    }
    public function distributor_lists($type=null)
    {
        $distributor_module = $this->module('distributor');
        if($distributor_module) {
            return $distributor_module->lists($type);
        } else {
            return array();
        }
    }
    /**
     * Returns media profiles in an array
     */
    public function media_profiles()
    {
        $module = $this->module("media");
        if ($module) return $module->profiles();
        else return array();
    }
    /**
     * Returns carrier profiles in an array
     */
    public function carrier_profiles()
    {
        $module = $this->module("lcr");
        if ($module) return $module->carriers();
        else return array();
    }
    /**
     * Returns CAC rules in an array
     * @return array $this->_cac_rule
     *               Array of CAC Rules and Conditions
     */
    public function cac_rules()
    {
        $module = $this->module("cac");
        if ($module) return $module->rules();
        else return array();
    }
    /**
     * Returns domain profiles in an array
     */
    public function domain_profiles()
    {
        $module = $this->module("directory");
        if ($module) return $module->domains();
        else return array();
    }
    public function dialplans()
    {
        $dialplan_module = $this->module("routing");
        if ($dialplan_module) return $dialplan_module->dialplans();
        else return array();
    }
    /**
     * Returns CA Certificates in an array
     */
    public function ca_certificates()
    {
        $dialplan_module = $this->module("certificate");
        if ($dialplan_module) return $dialplan_module->cas();
        else return array();
    }
    /**
     * @brief Return System information used to generate license
     *
     * @return array of key value pairs
     */
    public function system_info()
    {
        $info = parent::system_info();
        $adapters = $this->node()->hardware()->adapters();
        foreach($adapters as $adapter){
            $id=0;
            $modules = $adapter->modules();
            foreach($modules as $module){
                $info[$adapter->name().' Transcoding Module '.$id] = $module->mac();
                $id++;
            }
        }
        return $info;
    }
    public function pid_file()
    {
        $cfg_mgr = $this->node()->configuration_manager();
        $base_dir = $cfg_mgr->directory('base');
        return $base_dir.'/run/freeswitch.pid';
    }
}
/* End of file fs_application_class.php */
