<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SNG Control Panel
 *
 * @author Shaunt Libarian
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('service');
safe_require_class('table');
class Sng_control_panel extends Safe_CI_Controller
{
    private $_checklist = array();

    public function __construct()
    {
        parent::__construct();
    }
    public function index()
    {
        // Validate Checklist
        $this->_the_product->local_node()->checklist($this->_checklist);
        // Prevent using panel if checklist failed 
        // Allow panel access if system is running
        if(!$this->_checklist || Safe_service_class::STATUS_RUNNING == $this->_the_app->status()){
            $this->panel();
        }else{
            $this->wizard();
        }
    }

    public function wizard()
    {
        // Set the basic data
        $data['page_title'] = 'Control Panel';
        $data['page_summary'] = 'This page allows controlling Application hardware and software.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-register.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-register.png';
        $data['errors'] = array();

        // Display reason why we're not displaying control panel
        $data['notif_error'][] = $this->_the_app->description() . ' configuration is not completed.';
        // Checklist table
        $data['table_title'] = 'Configuration Checklist';
        $table = new Safe_table_class();
        $table->apply_data_formatter = false;
        foreach($this->_checklist as $item){
            $module = $this->_the_app->find_module_by_name($item['module']);
            if($module){
                $mod_name = $module->description();
                $obj_def = $module->get_aggregate_object_definition($item['obj_type']);
                if($obj_def){
                    $obj_type = $obj_def['name'];
                    $fix_url = $obj_def['controller_url'];
                }else{
                    $obj_type = $item['obj_type'];
                }
                $obj_name = $item['obj_name'];
            }else{
                $mod_name = $item['module'];
                $obj_type = $item['obj_type'];
                $obj_name = $item['obj_name'];
            }
            $table->data[] = array(
                WEBCONFIG_ICON_XMARK,
                $mod_name,
                $obj_type,
                $obj_name,
                $item['description'],
            );
            $table->line_button[] = array(
                array(
                    'url' => $fix_url,
                    'name' => 'Configure',
                    'label' => ''
                )
            );

        }
        $data['table'] = $table->generate();

        $this->load->view("safe_header", $data);
        $this->load->view("safe_error");
        $this->load->view("safe_notifications");
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }

    public function panel()
    {
        // Set the basic data
        $data['page_title'] = 'Control Panel';
        $data['page_summary'] = 'This page allows controlling Application hardware and software.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-register.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-register.png';
        $data['errors'] = array();

        //Load the library for the control panel
        $this->load->library('sng_control_panel_lib');
        $sng_control_lib = new Sng_control_panel_lib();
        //Creates the data to put inside the table
        //Can place HTML directly into the array elements
        //$this->_the_product = Safe_get_product();
        $sng_control_lib->_the_product = $this->_the_product;
        //Pulls all services required for the gateway and checks their status
        $services = $this->_the_product->local_node()->software()->services();
        $warnings = array();
        $error = array();
        $unrecognized = array();
        // Categorize services
        $service_cat = array();
        foreach ($services as $service) {
            // Check user can control this service
            //if ($service->allow_user_ctl())
            $service_cat[$service->category() ][] = $service;
        }
        // re-organize to have following category order
        // 'Application'
        // ...
        // 'Other'
        $app_cat = $service_cat['Application'];
        unset($service_cat['Application']);
        $other_cat = $service_cat['Other'];
        unset($service_cat['Other']);
        $new_service['Application'] = $app_cat;
        // Add all other categories
        foreach ($service_cat as $k => $v) $new_service[$k] = $v;
        if (!empty($other_cat)) $new_service['Other'] = $other_cat;
        unset($service_cat);
        $service_cat = $new_service;
        // Loop around all categories to create separate tables
        foreach ($service_cat as $cat_name => $services) {
            //Declare Table classes to be used
            $table = new Safe_table_class();
            $gateway_options = new Safe_table_class();
            $tmp_data = array();
            //Prepare the Control Panel Table Title
            $tmp_data['table_title'] = $cat_name . ' Services';
            //Creates the headers of the table
            $table->heading = array(
                "Service",
                "Status",
                "Uptime",
                'CPU(%)',
                'Memory(%)'
            );
            $table->heading_button = '';
            foreach ($services as $service) {
                if ($service->allow_user_ctl() === 'hide') continue;
                // Retrieve status
                $stats = array();
                $mode = $service->startup();
                switch ($mode) {
                case Safe_service_class::STARTUP_AUTOMATIC:
                    $to_mode_name = "To Manual";
                    $url = 'sng_control_panel/set_mode/' . Safe_service_class::STARTUP_MANUAL;
                    break;

                case Safe_service_class::STARTUP_MANUAL:
                default:
                    $to_mode_name = "  To Auto  ";
                    $url = 'sng_control_panel/set_mode/' . Safe_service_class::STARTUP_AUTOMATIC;
                    break;
                }
                $line_button = "";
                switch ($rc = $service->status($stats)) {
                case Safe_service_class::STATUS_RUNNING:
                    $status = 'STARTED';
                    $status_class = 'started';
                    if ($service->allow_user_ctl()) {
                        $line_button = array(
                            array(
                                'url' => 'sng_control_panel/stop_confirm',
                                'name' => 'Stop',
                                'type' => 'confirm'    
                            ) ,
                        );
                    }
                    break;

                case Safe_service_class::STATUS_STOPPED:
                    $status = "STOPPED";
                    $status_class = 'stopped';
                    if ($service->allow_user_ctl()) {
                        $line_button = array(
                            array(
                                'url' => 'sng_control_panel/start_confirm',
                                'name' => 'Start',
                                'label' => '',
                                'type' => 'confirm'
                            ) ,
                        );
                    }
                    break;
                    /* In any other cases, just display Reset */
                case Safe_service_class::STATUS_UNRECOGNIZED:
                case Safe_service_class::STATUS_ERROR:
                case Safe_service_class::STATUS_DEAD:
                default:
                    $status = 'UNKNOWN';
                    $status_class = 'error';
                    $line_button = array(
                        array(
                            'url' => 'sng_control_panel/reset_confirm',
                            'name' => 'Reset',
                            'label' => '',
                            'type' => 'confirm'
                        )
                    );
                    $error[] = $service->description();
                    break;
                }
                $table->line_button[] = $line_button;
                //Appends to the $table->data array. This adds the service and its status as an element
                array_push($table->data, array(
                    array(
                        'data' => $service->description() ,
                        'style' => 'font-weight:bold; width:30%;'
                    ) ,
                    array(
                        'data' => $status,
                        'class' => $status_class
                    ) ,
                    $stats['cpu']['time'],
                    $stats['cpu']['percent'],
                    $stats['mem']['percent']
                ));
                //Creates the primary key of each line to pass when the form is parsed
                //$table->primary_key = array(1,2);
                array_push($table->primary_key, $service->name());
            }
            $table->footer_button = array(
                array(
                    'url' => base_url('sng_control_panel') ,
                    'name' => 'Refresh'
                )
            );
            if($table->data){
                $tmp_data['table'] = $table->generate();
                $data_tables[] = $tmp_data;
            }
        }
        //Calls function that checks for notification messages
        $sng_control_lib->check_errors($unrecognized, $error, $data['notif_error'], $table, $data);
        $sng_control_lib->check_warnings($warnings, $data['notif_warn']);
        $this->load->view("safe_header", $data);
        $this->load->view("safe_error");
        $this->load->view("safe_notifications");
        foreach ($data_tables as $data_table) $this->load->view("sng_control_panel", $data_table);
        $this->load->view("safe_footer", $data);
    }
    public function start_confirm($service_name)
    {
        $service = $this->_the_product->local_node()->software()->service($service_name);
        $data['page_title'] = 'Service ' . $service->description() ;
        if ($service->can_start($service_result)) {
            $data['message'] = 'Confirm to start  service : <b>' . $service->description() . '</b>?';
            $data['message_type'] = 'notice';
            $data['result'] = true;
            $data['action_url'] = base_url($this->router->fetch_class()). '/start/'. $service_name;
            $data['setting']['title'] = 'Starting ' .$service->description();
            $data['setting']['sec'] = '60';
            $data['setting']['msg'] = 'Ooops ! Server time out...';
            $data['setting']['label'] = 'Back';
            $data['setting']['url'] = base_url('sng_control_panel');
            echo json_encode($data);
        }else{
            $data['message'] = 'Start ' .$service_name .' error.';
            $reason = array();
            foreach ($service_result as $failure_reason) {
                $reason[] = $failure_reason['msg'];
            }
            if($reason != null){
                $data['message'] =  $data['message'] .'<br/>' .implode('<br/>',$reason);
            }
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    //Function that runs when starting a process
    public function start($service_name)
    {
        // verify if logged
        //safe_authenticate ();
        //Start Service
        $result = null;
        $output = null;
        $mode = null;
        $service_result = null;
        //$the_product = Safe_get_product();
        $service = $this->_the_product->local_node()->software()->service($service_name);
        // Set the basic data
        if ($service->can_start($service_result)) {
            $result = $service->start($output);
            $mode = $service->set_startup(Safe_service_class::STARTUP_AUTOMATIC);
            // Redirect to main page on success
            if (!$result && $mode){
                $data['result'] = true;
                $data['redirect_url'] =  base_url('sng_control_panel');
                echo json_encode($data);
                exit();
            }
            $data['notif_warn'] = $output;
        } else {
            foreach ($service_result as $failure_reason) {
                if (isset($failure_reason['url'])) {
                    $data['notif_error'][] = safe_form_with_submit_button($failure_reason['msg'], $failure_reason['url'], $failure_reason['label']);
                } else {
                    $data['notif_warn'][] = $failure_reason['msg'];
                }
            }
        }
        //return error message
        $data['message'] = 'Start ' .$service_name .' error.';
        if($data['notif_warn']){
            $data['message'] =  $data['message'] .'<br/>' .implode('<br/>',$data['notif_warn']);
            unset($data['notif_warn']);
        }
        $data['message_type'] = 'alert';
        $data['result'] = false;
        echo json_encode($data);
    }
    public function reset_confirm($service_name)
    {
        $service = $this->_the_product->local_node()->software()->service($service_name);
        $data['page_title'] = 'Reset Service ' . $service->description() ;
        $data['message'] = 'Confirm to reset  service : <b>' . $service->description() . '</b>?';
        $data['message_type'] = 'notice';
        $data['result'] = true;
        $data['action_url'] = base_url($this->router->fetch_class()). '/reset/'. $service_name;
        $data['setting']['title'] = 'Resetting '.$service->description();
        $data['setting']['sec'] = '10';
        $data['setting']['msg'] = 'Ooops ! Server time out...';
        $data['setting']['lable'] = 'Back';
        $data['setting']['url'] = base_url('sng_control_panel');
        echo json_encode($data);
    }
    public function reset($service_name)
    {
        // verify if logged
        //safe_authenticate ();
        //Restart Service
        $retCode = null;
        //$the_product = Safe_get_product();
        $service = $this->_the_product->local_node()->software()->service($service_name);
        $service->reset($retCode);
        // Redirect to main page on success
        if ($retCode == 0) {
            $data['result'] = true;
            $data['redirect_url'] =  base_url('sng_control_panel');
            echo json_encode($data);
            exit();
        }else {
            $data['message'] = 'Reset ' .$service_name .' error.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    //Function that runs when restarting a process
    public function restart($service_name)
    {
        // verify if logged
        //safe_authenticate ();
        //Restart Service
        $result = null;
        $output = null;
        //$the_product = Safe_get_product();
        $service = $this->_the_product->local_node()->software()->service($service_name);
        $result = $service->restart(false, $output);
        // Redirect to main page on success
        if (!$result) safe_redirect(base_url('sng_control_panel'));
        //Declare Table classes to be used
        $table = new Safe_table_class();
        //Prepare the Control Panel Table Title
        $data['table_title'] = "Starting " . $service_name;
        $table->line_button = null;
        $table->data = $output;
        $table->footer_button = array(
            array(
                'url' => base_url('sng_control_panel') ,
                'name' => 'Back'
            )
        );
        $data['table'] = $table->generate();
        // Set the basic data
        $data['page_title'] = 'Control Panel';
        $data['page_summary'] = 'This page allows controlling Application hardware and software.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-register.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-register.png';
        $data['errors'] = array();
        $this->load->view("safe_header", $data);
        $this->load->view("safe_error");
        //$this->output->append_output( $service_name );
        $this->load->view("sng_control_panel_start", $data);
        $this->load->view("safe_footer", $data);
    }
    public function stop_confirm($service_name)
    {
        $service = $this->_the_product->local_node()->software()->service($service_name);
        $data['page_title'] = 'Service ' . $service->description() ;
        $data['message'] = 'Confirm to stop  service : <b>' . $service->description() . '</b>?';
        $data['message_type'] = 'notice';
        $data['result'] = true;
        $data['action_url'] = base_url($this->router->fetch_class()). '/stop/'. $service_name;
        $data['setting']['title'] = 'Stopping '.$service->description() ;
        $data['setting']['sec'] = '10';
        $data['setting']['msg'] = 'Ooops ! Server time out...';
        $data['setting']['lable'] = 'Back';
        $data['setting']['url'] = base_url('sng_control_panel');
        echo json_encode($data);
    }
    //Function that runs when stopping a process
    public function stop($service_name)
    {
        // verify if logged
        //safe_authenticate ();
        //Stop Service
        $result = null;
        $output = null;
        $mode = null;
        //$the_product = Safe_get_product();
        $service = $this->_the_product->local_node()->software()->service($service_name);
        $result = $service->stop($output);
        $mode = $service->set_startup(Safe_service_class::STARTUP_MANUAL);
        // Redirect to main page on success
        if (!$result && $mode) {
            $data['result'] = true;
            $data['redirect_url'] =  base_url('sng_control_panel');
            echo json_encode($data);
            exit();
        }else{
            $data['message'] = 'Stop ' .$service_name .' error.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    //Changes the service mode
    public function set_mode($mode, $service_name)
    {
        // verify if logged
        //safe_authenticate ();
        $result = false;
        //$the_product = Safe_get_product();
        $service = $this->_the_product->local_node()->software()->service($service_name);
        // check mode to apply
        switch ($mode) {
        case Safe_service_class::STARTUP_MANUAL:
        case Safe_service_class::STARTUP_AUTOMATIC:
            $result = $service->set_startup($mode);
            break;

        default:
            echo "Invalid mode " . $mode;
            break;
        }
        // Redirect to main page on success
        if ($result) safe_redirect(base_url('sng_control_panel'));
        //Declare Table classes to be used
        $table = new Safe_table_class();
        $table->data = array(
            '<b>' . $service_name . '</b> was not able to be set as ' . $mode . ' Startup'
        );
        //Prepare the Control Panel Table Title
        $data['table_title'] = "Changing " . $service_name . ' startup mode';
        $table->line_button = null;
        $table->footer_button = array(
            array(
                'url' => base_url('sng_control_panel') ,
                'name' => 'Back'
            )
        );
        $data['table'] = $table->generate();
        // Set the basic data
        $data['page_title'] = 'Control Panel';
        $data['page_summary'] = 'This page allows controlling Application hardware and software.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-register.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-register.png';
        $data['errors'] = array();
        $this->load->view("safe_header", $data);
        $this->load->view("safe_error");
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    /*
     * get system running status
    */
    public function get_system_status($format = 'json'){
        $application_service = null;
        foreach ($this->_services as $service) {
            if($service->category() == 'Application'){
                $application_service = $service;
                break;
            }
        }
        if ($application_service != null){
            $system_status = $application_service->status();
        }else{
            $system_status = 'notfound';
        }
        $data = array();
        switch ($system_status) {
            case Safe_service_class::STATUS_RUNNING:
                $data['status']       = 'ok';//STARTED
                $data['description']  = 'System started.';
                $data['url']          = '/SAFe/sng_control_panel';
                break;
            case Safe_service_class::STATUS_STOPPED:
                $data['status']        = "warning";//STOPPED
                $data['description']   = 'System stopped.';
                $data['url']           = '/SAFe/sng_control_panel';
                break;
            case Safe_service_class::STATUS_UNRECOGNIZED:
            case Safe_service_class::STATUS_ERROR:
            case Safe_service_class::STATUS_DEAD:
            default:
                $data['status']        = 'error';//UNKNOWN
                $data['description']   = 'System error!';
                $data['url']           = '/SAFe/sng_control_panel';
                break;
        }
        if($format == 'array'){
            return $data;
        }else{
            echo json_encode($data);
            return true;
        }
    }
    /*
     * get configuration status
    */
    public function get_configuration_status($format = 'json'){
        $list=array();
        if ($this->_the_product->local_node()->checklist($list)) {
            $data['status']       = 'warning';
            $data['description']  = 'Configuration not completed.';
            $data['url']          = '/SAFe/sng_config_manager';
        }else if (!$this->_the_product->local_node()->is_configuration_generated()) {
            $data['status']       = 'warning';
            $data['description']  = 'Configuration not generated.';
            $data['url']          = '/SAFe/sng_config_manager';
        } else if ($this->_the_product->local_node()->is_configuration_modified()) {
            $data['status']       = 'warning';
            $data['description']  = 'Configuration modified.';
            $data['url']          = '/SAFe/sng_config_manager';
        }else{
            $data['status']       = 'ok';
            $data['description']  = 'Configuration is up to date.';
            $data['url']          = '/SAFe/sng_config_manager';
        }
        if($format == 'array'){
            return $data;
        }else{
            echo json_encode($data);
            return true;
        }
    }
    /*
     * get configuration status
    */
    public function get_status_html(){
        $data['system'] = $this->get_system_status('array'); 
        $data['configuration'] = $this->get_configuration_status('array'); 
        $this->load->view("safe_iframe_notice", $data);
    }
    /*
     * get Notification  status
    */
    public function get_notifications(){
        /*
        $db = $this->_the_app->db();
        $db->connect();
        $select = '*';
        $conditions = "status ='0'";
        $order_by = 'id desc';
        $result = $db->select('notification', $conditions, 10, 0, $order_by, '', $select, '');
        $db->disconnect();
        */
        $test_data ='[{
                    	"id": "4",
                    	"add_time": "2013-04-04 15:03:06",
                    	"notification_type": "warning",
                    	"status": "0",
                    	"description": "system warning 223!",
                    	"url": ""
                    },
                    {
                    	"id": "3",
                    	"add_time": "2013-04-04 15:03:05",
                    	"notification_type": "warning",
                    	"status": "0",
                    	"description": "system warning 222!",
                    	"url": ""
                    },
                    {
                    	"id": "2",
                    	"add_time": "2013-04-04 15:03:05",
                    	"notification_type": "error",
                    	"status": "0",
                    	"description": "system error 112!",
                    	"url": ""
                    },
                    {
                    	"id": "1",
                    	"add_time": "2013-04-04 15:03:05",
                    	"notification_type": "error",
                    	"status": "0",
                    	"description": "system error 111!",
                    	"url": "/SAFe/sng_config_manager/edit/rtcpmon"
                    }]
                ';
        $result = json_decode($test_data);
        
        $notification['number'] = 0;//count($result);
        if($notification['number'] > 0){
            $notification['data'] = $result;
        }
        echo json_encode($notification);
    }
}
