<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/* 
 * Dashboard
 *
 * Parameters:
 *     $system     = System data series 
 *                    ['cpu'] => CPU data series (pie)
 *                    ['memory'] => Memory data series (pie)
 *                    ['events'] => Events/hours data series (bar with 
 *                    info/warning/critical)
 *     $services   = Array of services data series
 *                   For each services
 *                     ['cpu'] => CPU data series (vertical bar)
 *                     ['memory'] => Memory data series (vertical bar)
 *                     ['events'] => Count of events for this service (just 
 *                     number)
 *     $curren_date = Current datetime in string format
 *     $hour_range = Hour range
*/
?>
<!--[if lte IE 8]><script language="javascript" type="text/javascript" src="../../excanvas.min.js"></script><![endif]-->
<style>
  .ui-progressbar {
    position: relative;
    height: 15px;
  }
  .progress-label {
    position: absolute;
    left: 50%;
    top: 1px;
    font-weight: bold;
    text-shadow: 1px 1px 0 #fff;
  }
  .hyperlink {
        padding: 0 !important;
  }
  .plot {
    margin-left: auto;
    margin-right: auto;
    }
  .pie {
    width:200px;
    height:125px
    }
  .bar {
    width:300px;
    height:125px
    }
</style>
<script language="javascript" type="text/javascript" src="/SAFe/js/flot/jquery.flot.js"></script>
<script language="javascript" type="text/javascript" src="/SAFe/js/flot/jquery.flot.pie.js"></script>
<script language="javascript" type="text/javascript" src="/SAFe/js/flot/jquery.flot.stack.js"></script>
<script language="javascript" type="text/javascript" src="/SAFe/js/flot/jquery.flot.time.js"></script>
<script type="text/javascript">

// A custom label formatter used by several of the plots
function plotPieLabelFormatter(label, series) {
    return "<div style='font-size:8pt; text-align:center; padding:2px; color:white;'>" + label + "<br/>" + Math.round(series.percent) + "%</div>";
}

function renderSystem(data_system){
    try{
    var placeholder = $("#plot_pie_system_cpu");
    $.plot(placeholder, data_system.cpu, {
      series: {
        pie: { 
          show: true,
            radius: 1,
            label: {
              show: true,
              radius: 2/3,
              formatter: plotPieLabelFormatter,
              threshold: 0.1
            }
        }
      },
      legend: {
        show: false,
        container: $("#system_cpu_legend"),
        noColumns:4
      }
    });
    var placeholder = $("#plot_pie_system_memory");
    $.plot(placeholder, data_system.memory, {
      series: {
        pie: { 
          show: true,
            radius: 1,
            label: {
              show: true,
              radius: 2/3,
              formatter: plotPieLabelFormatter,
              threshold: 0.1
            }
        }
      },
      legend: {
        show: false,
        container: $("#system_memory_legend"),
        noColumns:3
      }
    });
    }catch(exp){
        console.log(exp);
    }
}
function renderEvents(data_events){
    try{
    var placeholder = $("#plot_bar_system_events");
    var dateMax = new Date(data_events.current_date);
    var dateMin = new Date(dateMax - (data_events.hour_range*60*60*1000));
    $.plot(placeholder, data_events.events, {
        xaxis: {
            mode: "time",
            timezone: "browser",
            minTickSize: [1, "hour"],
            twelveHourClock: true,
            min: dateMin.getTime(),
            max: dateMax.getTime()
        },
      series: {
        stack: true,
        bars: {
            show: true,
            align: "right",
            barWidth: 60*60*1000
        },
        lines: {
            show: false
        }

      },
      legend: {
        show: true,
        container: $("#system_events_legend"),
        noColumns:3
      }
    });
    }catch(exp){
        console.log(exp);
    }
}
function fetchDataSystem(){
    function onDataReceived(data){
        renderSystem(data);
    }
    $.ajax({
        url:"/SAFe/sng_dashboard/system_stats_json",
            type: "GET",
            dataType:"json",
            success:onDataReceived
    });
    setTimeout(fetchDataSystem, 10 * 1000);
}
function fetchDataEvents(){
    function onDataReceived(data){
        renderEvents(data.summary);
    }
    $.ajax({
        url:"/SAFe/sng_dashboard/system_events_json",
            type: "GET",
            dataType:"json",
            success:onDataReceived
    });
    setTimeout(fetchDataEvents, 60 * 1000);
}
$(function() {
    var data_system = <?php echo $system;?>;
    var data_events = <?php echo $events;?>;
    renderSystem(data_system);
    renderEvents(data_events.summary);
    setTimeout(fetchDataSystem, 5 * 1000);
    setTimeout(fetchDataEvents, 60 * 1000);

});

</script>

<?php echo safe_webtabletitleopen("Overview", '100%', '') ?>
  <tr>
    <th class="mytableheader" style="text-align: center;">CPU</th>
    <th class="mytableheader" style="text-align: center;">Memory</th>
    <th class="mytableheader" style="text-align: center;">Events</th>
  </tr>
  <tr>
    <td width="30%">
      <div id="plot_pie_system_cpu" class="plot pie"></div>
      <div id="system_cpu_legend" class="plot"/>
    </td>
    <td width="30%">
      <div id="plot_pie_system_memory" class="plot pie"></div>
      <div id="system_memory_legend" class="plot"/>
    </td>
    <td width="40%">
      <a href="<?php echo $controller_uri;?>/events" class="hyperlink">
      <div id="plot_bar_system_events" class="plot bar"></div>
      <div id="system_events_legend" class="plot" align="center"/>
      </a>
    </td>
  </tr>
<?php echo safe_webtableclose() ?>

