#!/bin/bash

_pwd="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
# remove all symlinks
for d in ${_pwd}/libs/*
do
  if [ -h ${d} ]; then
    rm -f ${d}
  fi
done

# Symlink all packages
for d in ${_pwd}/packages/*
do
  if [ -d ${d} ]; then
    dir=`basename $d`
    echo "Install package: ${dir}"
    if [ -d ${_pwd}/packages/${dir}/${dir} ]; then
      ln -snf ${_pwd}/packages/${dir}/${dir} ${_pwd}/libs/${dir}
    fi
    if [ -d ${_pwd}/packages/${dir}/lib/${dir} ]; then
      ln -snf ${_pwd}/packages/${dir}/lib/${dir} ${_pwd}/libs/${dir}
    fi
  fi
done


# Symlink all data
for d in ${_pwd}/data/*
do
  if [ -d ${d} ]; then
    dir=`basename $d`
    echo "Install data: ${dir}"
    ln -snf ${_pwd}/data/${dir} ${_pwd}/libs/${dir}
  fi
done
