CREATE DATABASE IF NOT EXISTS `nsc` DEFAULT CHARACTER SET = utf8;

CREATE DATABASE IF NOT EXISTS `freeswitch` DEFAULT CHARACTER SET = utf8;

GRANT ALL ON freeswitch.* to 'fsodbc'@'localhost' IDENTIFIED BY 'sangoma';

CREATE TABLE IF NOT EXISTS `freeswitch`.`carriers` (
  `id` int(11) NOT NULL,
  `carrier_name` varchar(255) default NULL,
  `enabled` boolean NOT NULL DEFAULT '1',
   PRIMARY KEY  (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `freeswitch`.`carrier_gateway` (
  `id` int(11) NOT NULL,
  `carrier_id` int(11) default NULL,
  `prefix` varchar(255) NOT NULL,
  `suffix` varchar(255) NOT NULL,
  `codec` varchar(255) NOT NULL,
  `enabled` boolean NOT NULL DEFAULT '1',
  PRIMARY KEY  (`id`),
  KEY `carrier_id` (`carrier_id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `freeswitch`.`lcr` (
  `id` int(11) NOT NULL,
  `digits` varchar(15) default NULL,
  `rate` float(11,5) unsigned NOT NULL,
  `intrastate_rate` float(11, 5) unsigned NOT NULL,
  `intralata_rate` float(11, 5) unsigned NOT NULL,
  `carrier_id` int(11) NOT NULL,
  `lead_strip` int(11) NOT NULL,
  `trail_strip` int(11) NOT NULL,
  `prefix` varchar(16) NOT NULL,
  `suffix` varchar(16) NOT NULL,
  `lcr_profile` varchar(32) default NULL,
  `date_start` datetime NOT NULL DEFAULT '1970-01-01',
  `date_end` datetime NOT NULL DEFAULT '2030-12-31',
  `quality` float(10,6) NOT NULL,
  `reliability` float(10,6) NOT NULL,
  `cid` varchar(32) NOT NULL DEFAULT '',
  `enabled` boolean NOT NULL DEFAULT '1',
  `lrn` boolean NOT NULL DEFAULT '0',
   PRIMARY KEY  (`id`),
   KEY `carrier_id` (`carrier_id`),
   KEY `digits` (`digits`),
   KEY `lcr_profile` (`lcr_profile`),
   KEY `rate` (`rate`),
   KEY `digits_profile_cid_rate` USING BTREE (`digits`,`rate`),
   CONSTRAINT `carrier_id` FOREIGN KEY (`carrier_id`) REFERENCES `carriers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
   ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `freeswitch`.`npa_nxx_company_ocn` (
  `npa` smallint NOT NULL,
  `nxx` smallint NOT NULL,
  `company_type` varchar(20),
  `ocn` varchar(10),
  `company_name` varchar(60),
  `lata` integer,
  `ratecenter` varchar(20),
  `state` varchar(5)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE UNIQUE INDEX `npanxx_idx` USING BTREE ON `freeswitch`.`npa_nxx_company_ocn` (`npa`, `nxx`);

LOAD data local infile '/usr/local/nsc/etc/npa-nxx-companytype-ocn.csv' INTO TABLE `freeswitch`.`npa_nxx_company_ocn` fields terminated by ',' enclosed by '"' lines terminated by '\n';

