<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * Product class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_node_class');
define('SNG_PRODUCT_DEF', '/usr/local/sng/conf/prod-def.xml');
$g_safe_product = null;
function &Safe_get_product()
{
    global $g_safe_product;
    if(null == $g_safe_product) {
        /*
        * Retrieve product from prod-def.xml
        */

        $dom = new DOMDocument();
        $dom->load(SNG_PRODUCT_DEF);
        $dom->xinclude();

        $xml = simplexml_import_dom($dom);
        // Get only the product
        $xml = $xml->xpath('//product');
        $tmp_def = json_decode(json_encode($xml) , true);
        $prod_def = array('product' => $tmp_def[0]);

        unset($xml);
        unset($tmp_def);

        // Try to locate the product specific class
        $product_name = strtolower($prod_def['product']['@attributes']['name']);
        $safe_product = safe_new_module_class($product_name, 'product');
        if (null == $safe_product) $safe_product = new Safe_product_class();
        // Configure product
        $safe_product->configure($prod_def);
        unset($prod_def);
        // Latch to global
        $g_safe_product = $safe_product;
        
    }
    return $g_safe_product;
}
class Safe_product_class extends Safe_object_class
{
    private $_name;
    private $_nodes = array();
    public $_application = NULL;
    public function __construct($name = "Product name")
    {
        parent::__construct('', $name);
    }
    public function configure($product_def = array())
    {
        parent::configure();
        // Create local node
        $this->_nodes['local'] = new safe_local_node($this);
        $this->_nodes['local']->configure($product_def);
        // Create empty remote nodes
        $this->_nodes['remote'] = array();
        // Create the application
        $this->_application = $this->create_application();
        // Configure and register application
        $this->_application->configure();
        $this->local_node()->software()->set_application($this->_application);
        // Add services as defined in configuration
        $services = $this->local_node()->configuration_manager()->services();
        foreach ($services as $service) {
            // Check if generic service class is implemented by application
            $service_name = $service['name'] . '_service';
            if (safe_module_require_class(strtolower($this->name()) , $service_name)) {
                $service_class = Safe_module_class_name(strtolower($this->name()) , $service_name);
                $service_object = new $service_class($this->local_node()->software() , $service['name']);
            } else if (safe_module_require_class('sng', $service_name)) {
                $service_class = Safe_module_class_name('sng', $service_name);
                $service_object = new $service_class($this->local_node()->software() , $service['name']);
            } else $service_object = new Safe_service_class($this->local_node()->software() , $service['name']);
            $service_object->configure();
            if (isset($service['description'])) $service_object->set_description($service['description']);
            if (isset($service['category'])) $service_object->set_category($service['category']);
            $this->local_node()->software()->add_service($service_object);
        }
        return TRUE;
    }
    public function &local_node()
    {
        return $this->_nodes['local'];
    }
    public function remote_nodes()
    {
        return $this->_nodes['remote'];
    }
    // Can be overloaded by real product class
    public function &create_application()
    {
        return NULL;
    }
    public function create_software_class($node)
    {
        return new Safe_software_class($node);
    }
    public function create_hardware_class($node)
    {
        return new Safe_hardware_class($node);
    }
    /*
     * Backup/restore hooks
     * To loop around all services
    */
    public function can_backup(&$reason)
    {
        foreach ($this->local_node()->software()->services() as $service) {
            if (TRUE != $service->can_backup($reason)) return FALSE;
        }
        return TRUE;
    }
    /**
     * @brief Pre backup hook
     *           
     * @param[in out] $reason
     *           
     * @return TRUE/FALSE
     */
    public function pre_backup(&$reason)
    {
        $service_status = array();
        foreach ($this->local_node()->software()->services() as $service) {
            if (TRUE != $service->pre_backup($reason)) return FALSE;
            $service_status[$service->name() ]['status'] = $service->status();
            $service_status[$service->name() ]['startup'] = $service->startup();
        }
        // Store service status in db
        $ser = safe_object_serializer_class::get_serializer();
        $ser->store_object('/tmp', 'service_status', 'none', $service_status, 'tmp');
        // close and reopen db so cache is flushed to disk
        $ser = Safe_object_serializer_class::get_serializer(TRUE);
        return TRUE;
    }
    /**
     * @brief Post backup hook
     *           
     * @param[in out] $reason
     *           
     * @return TRUE/FALSE
     */
    public function post_backup(&$reason)
    {
        foreach ($this->local_node()->software()->services() as $service) {
            if (TRUE != $service->post_backup($reason)) return FALSE;
        }
        return TRUE;
    }
    /**
     * @brief Check if archive restore can be done
     *           
     * @param[in out] $reason
     *           
     * @return TRUE/FALSE
     */
    public function can_restore(&$reason)
    {
        foreach ($this->local_node()->software()->services() as $service) {
            if (TRUE != $service->can_restore($reason)) return FALSE;
        }
        return TRUE;
    }
    /**
     * @brief Pre restore hook
     *           
     * @param[in out] $reason
     *           
     * @return TRUE/FALSE
     */
    public function pre_restore(&$reason)
    {
        foreach ($this->local_node()->software()->services() as $service) {
            if (TRUE != $service->pre_restore($reason)) return FALSE;
        }
        // All good, now here are pre restore steps:
        // 1- Remove all (N) record from object table
        // 2- Change all records to (D)
        // 3- Disable error checking in configuration manager
        // 4- Generate config (this will proceed to all delete)
        $ser = Safe_object_serializer_class::get_serializer(TRUE);
        $ser->delete_object_with_status($this->local_node()->object_name() , TRUE, Safe_object_serializer_class::OBJ_STATUS_NEW);
        $ser->update_object_with_status($this->local_node()->object_name() , TRUE, NULL, Safe_object_serializer_class::OBJ_STATUS_DELETED);
        $this->local_node()->configuration_manager()->forget_error(TRUE);
        $this->local_node()->generate_config();
        return TRUE;
    }
    /**
     * @brief Post restore hook
     *           
     * @param[in out] $reason
     *           
     * @return TRUE/FALSE
     */
    public function post_restore(&$reason)
    {
        // Ensure DB is accessible as well as conf directory
        $this->local_node()->mkdir('/var/webconfig/SAFe/application/db');

        try {
            $conf = $this->local_node()->configuration_manager()->directory('configuration');
            $this->local_node()->mkdir($conf);
        } catch( Exception $e){
        }
        // All good, now here are post restore steps
        // 1- Remove all (D) records, should not happen but just in case
        // 2- Update all records to (N)
        // 3- Generate config
        $ser = Safe_object_serializer_class::get_serializer(TRUE);
        $ser->delete_object_with_status($this->local_node()->object_name() , TRUE, Safe_object_serializer_class::OBJ_STATUS_DELETED);
        $ser->update_object_with_status($this->local_node()->object_name() , TRUE, NULL, Safe_object_serializer_class::OBJ_STATUS_NEW);
        // Re configure hardware
        $this->local_node()->hardware()->post_restore($reason);
        // Re configure software as record content may have changed
        $this->local_node()->software()->configure();

        // Retrieve service status in db
        $service_status = array();
        $ser = safe_object_serializer_class::get_serializer();
        $ser->retrieve_object('/tmp', 'service_status', $service_status);
        // Now inform all service restore is done
        foreach ($this->local_node()->software()->services() as $service) {
            // Should not stop on error :(
            $service->post_restore($reason);
            // Check if we can restore startup ?
            if (isset($service_status[$service->name() ]) && isset($service_status[$service->name() ]['startup'])) {
                $service->set_startup($service_status[$service->name() ]['startup']);
            }
        }
        // Re generate configuration
        $this->local_node()->configuration_manager()->forget_error(FALSE);
        if (TRUE != $this->local_node()->generate_config()) return FALSE;

        // Ensure product is up to date
        $result = array();
        $this->local_node()->os()->execute('/usr/local/sng/scripts/update-product.sh', $result, true, true);
        return TRUE;
    }
    public function restore_progress()
    {
        return $this->local_node()->configuration_manager()->progress();
    }
}
/* End of file safe_product_class.php */
