<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Generic error libs ( user and  system errors/warnings)
 *
 * @author Michel Buczynski
 * @version
 */
class Safe_errors_lib
{
    public $errors = array();
    public function add_error($error, $apache_log = false, $include_backtrace = true, $terminated = false)
    {
        if (!empty($error)) {
            $e = array(
                0
            );
            $this->fix_errors();
            if (is_string($error)) $this->errors[] = $e[] = $error;
            if ($include_backtrace) {
                $dbt = debug_backtrace();
                if ($dbt[1]['function'] == 'safe_add_error') $dbt = $dbt[2];
                else $dbt = $dbt[1];
                $this->errors[] = $e[] = $dbt = safe_debug_info_line($dbt);
                error_log("DEBUG:" . $dbt);
            }
            $this->fix_errors();
            $e = array_filter(array_filter($e));
            if ($apache_log) foreach ($e as $v) error_log("Safe: $v");
            if (!$terminated) return $this->errors;
            else exit(implode("<br/>", $this->errors));
        }
    }
    private function fix_errors()
    {
        if (is_array($this->errors)) $this->errors = array_filter(array_filter($this->errors));
        else $this->errors = array(
            (!is_string(($this->errors)) ? $this->errors : '')
        );
    }
    public function get_errors()
    {
        //var_dump($this->errors);
        return $this->errors;
    }
}
/* End of file safe_errors_lib.php */
