<?php
/**
 * This is load ClearOS 5.2 Webconfig libs. Create also some helper function that fix this integration with CodeIgniter.
 * @author Michel Buczsynski
 *
 */
require_once ("/var/webconfig/gui/Webconfig.inc.php");
global $SAFE_WC_HELPER;
global $PATH_INFO;
global $SAFE_WC_BASENAME;
// extract the PATH_INFO and ClearOS 5.x WebConfig modules basename
if (isset($_SERVER['PATH_INFO'])) {
    $PATH_INFO = $_SERVER['PATH_INFO'];
    $SAFE_WC_BASENAME = preg_replace('#^/([^/]+)#', '$1', $_SERVER['PATH_INFO']);
} elseif (isset($_SERVER['REQUEST_URI'])) {
    $PATH_INFO = preg_replace('#index.php[/\?]+([^/]+)#', '/$1', $_SERVER['REQUEST_URI']);
    $PATH_INFO = preg_replace('#[/]*SAFe[/]+([^/]+)$#', '/$1', $PATH_INFO);
    $PATH_INFO = preg_replace('#\?.*$#', '', $PATH_INFO); // this give back
    // the PATH_INFO
    $SAFE_WC_BASENAME = preg_replace('#^/([^/]+)#', '$1', $PATH_INFO);
} else {
    $SAFE_WC_BASENAME = 'index';
} {
    global $SAFE_WC_HELPER;
    $SAFE_WC_HELPER = array();
    try {
        $php_self = $_SERVER['PHP_SELF'];
        //Controls Accordian Menu
        //echo "BASE NAME = " . $SAFE_WC_BASENAME;
        if (count(explode('/', $SAFE_WC_BASENAME)) > 1) {
            $base_url = explode('/', $SAFE_WC_BASENAME);
            if ($base_url[2] != "") {
                //GO THROUGH ALL THE URLS AND MAKE SURE THIS ISN'T A NEW PAGE AND IT IS
                //A LINK
                $pagedata = WebMenuFetch();
                foreach ($pagedata as $info) {
                    $url_elements = explode('/', $info['url']);
                    foreach ($url_elements as $element) {
                        if (preg_match("'\b" . $base_url[2] . "\b'", $element)) {
                            //MATCHED A URL
                            //echo "MATCHED A URL<br />";
                            $_SERVER['PHP_SELF'] = '/' . $base_url[0] . '/' . $base_url[1] . '/' . $base_url[2];
                            $menu_done = true;
                            break;
                        }
                    }
                    //FOUND AN ENTRY IN THE MENU SYSTEM AND DISPLAY THE APPROPRIATE MENU
                    //IN THE ACCORDIAN
                    if ($menu_done) break;
                }
            }
        } else {
            //ONLY 1 ELEMENT FOUND IN THE BASE NAME VARIABLE. NO NEED TO TRY AND MATCH
            //ELEMENTS. JUST DISPLAY THE PROPER ACCORDIAN MENU ENTRY
            if (preg_match("'\bSAFe\b'", $SAFE_WC_BASENAME)) {
                $_SERVER['PHP_SELF'] = '/' . $SAFE_WC_BASENAME;
                $menu_done = true;
            } elseif (!preg_match("'\bSAFe\b'", $SAFE_WC_BASENAME)) {
                $_SERVER['PHP_SELF'] = '/SAFe/' . $SAFE_WC_BASENAME;
                $menu_done = true;
            }
        }
        if (!$menu_done) {
            $base_url = explode('/', $SAFE_WC_BASENAME);
            if ($base_url[2] != "") {
                //GO THROUGH ALL THE URLS AND MAKE SURE THIS ISN'T A NEW PAGE AND IT IS
                //A LINK
                $pagedata = WebMenuFetch();
                foreach ($pagedata as $info) {
                    $url_elements = explode('/', $info['url']);
                    foreach ($url_elements as $element) {
                        if (preg_match("'\b" . $base_url[1] . "\b'", $element)) {
                            //MATCHED A URL
                            //echo "MATCHED A URL<br />";
                            $_SERVER['PHP_SELF'] = '/' . $base_url[0] . '/' . $base_url[1];
                            $menu_done = true;
                            break;
                        }
                    }
                    //FOUND AN ENTRY IN THE MENU SYSTEM AND DISPLAY THE APPROPRIATE MENU
                    //IN THE ACCORDIAN
                    if ($menu_done) break;
                }
            }
        }
        if (isset($_SERVER['REDIRECT_URL'])) $_SERVER['REDIRECT_URL'] = preg_replace('#/var/webconfig/SAFe/#', '/', $_SERVER['REDIRECT_URL']);
        ob_start();
        WebHeader('__TITLE__', 'default', '<!--HEAD_ADD-->', '__ONLOAD__');
        // HEAD_ADD is added before the javascript load and after the ccs load.
        // __ONLOAD__ is unused, better to insert before </head>
        $SAFE_WC_HELPER['header'] = ob_get_contents();
        ob_end_clean();
        ob_start();
        WebFooter();
        $SAFE_WC_HELPER['footer'] = ob_get_contents();
        ob_end_clean();
        //WebDialogIntro($title, $icon, $summary) has a flush(); so we have to
        // rewrite it
        {
            ob_start();
            $title = '__TITLE__';
            $summary = '__SUMMARY__';
            $pagedata = WebMenuFetch();
            // <wadam>
            $menu_pages = WebMenuFetch();
            $page = array();
            // Pick out the current pages section and subsection for menu highlighting
            foreach ($menu_pages as $pageinfo) {
                // FIXME: branding hack
                $pageinfo['section'] = preg_replace("/ClearCenter/", "Sangoma", $pageinfo['section']);
                // wadam - Find longest url match in request_uri to catch MVC url
                if (!strncmp($pageinfo['url'], $_SERVER['REQUEST_URI'], strlen($pageinfo['url']))) {
                    // Check already matched ?
                    if (empty($page) || strlen($pageinfo['url']) > $page['match']) {
                        $page['page'] = $pageinfo['url'];
                        $page['section'] = $pageinfo['section'];
                        $page['subsection'] = $pageinfo['subsection'];
                        $page['title'] = $pageinfo['title'];
                        $page['match'] = strlen($pageinfo['url']);
                    }
                }
            }
            // </wadam>
            $page['summary'] = $summary;
            $page['user_guide_url'] = $_SESSION['system_online_help'] . $_SERVER['PHP_SELF'];
            $page['large_icon'] = '__LARGE_ICON__';
            $page['small_icon'] = '__SMALL_ICON__';
            if (file_exists(WEBCONFIG_PATH . "/templates/" . $_SESSION['system_template'] . "/widgets/summary.inc")) require (WEBCONFIG_PATH . "/templates/" . $_SESSION['system_template'] . "/widgets/summary.inc");
            else if (file_exists(WEBCONFIG_PATH . "/templates/" . $_SESSION['system_template'] . "/html/summary.inc")) require (WEBCONFIG_PATH . "/templates/" . $_SESSION['system_template'] . "/html/summary.inc");
            else require (WEBCONFIG_PATH . "/templates/base/html/summary.inc");
            if (WEBCONFIG_CONSOLE) echo "<hr>";
            $SAFE_WC_HELPER['dialogintro'] = ob_get_contents();
            ob_end_clean();
        }
        ob_start();
        WebTableOpen('__TITLE__', '__WIDTH__', '__ID__', '__PADDING__');
        $SAFE_WC_HELPER['tableopen'] = ob_get_contents();
        ob_end_clean();
        ob_start();
        WebTableClose();
        $SAFE_WC_HELPER['tableclose'] = ob_get_contents();
        ob_end_clean();
        ob_start();
        WebDialogBox('dialogwarning', WEBCONFIG_LANG_WARNING, WEBCONFIG_DIALOG_ICON_WARNING, '__TEXT__');
        $SAFE_WC_HELPER['dialogwarning'] = ob_get_contents();
        ob_end_clean();
        ob_start();
        WebDialogBox('__CLASS__', WEBCONFIG_LANG_INFO, '__ICON__', '__TEXT__');
        $SAFE_WC_HELPER['dialog'] = ob_get_contents();
        ob_end_clean();
        ob_start();
        WebTableOpen('__TEXT__', '__-__', '__ID__', '__CPADDING__');
        $SAFE_WC_HELPER['tableopen'] = ob_get_contents();
        ob_end_clean();
    }
    catch(Exception $e) {
        ob_end_clean();
        echo 'Caught exception: ', $e->getMessage() , "\n";
    }
    ob_end_flush();
    $_SERVER['PHP_SELF'] = $php_self;
}
/**
 *
 * @return boolean(should never return false, page are recreated or redirected
 *         or the function exit.)
 */
function SAFE_WC_AUTHENTICATE()
{
    global $PATH_INFO;
    try {
        // I don't know why something the _GET dosen't appear in the _REQUEST
        foreach ($_GET as $k => $v) $_REQUEST[$k] = $v;
        $php_self = $_SERVER['PHP_SELF'];
        // $_SERVER ['PHP_SELF'] = '/admin/' . $basename .'.php';
        //SLIBARIAN: added this if statement so that when a user logs out from an aggregated view
        //they will not get an error where /SAFe is appended to the actual url and it will use the existing path
        ///SAFe was being duplicated in aggregated views
        if (strpos($PATH_INFO, 'SAFe') !== false) $_SERVER['PHP_SELF'] = $PATH_INFO;
        else $_SERVER['PHP_SELF'] = '/SAFe' . $PATH_INFO;
        WebAuthenticate();
        // this if for fixing menu creation bug when the user had just login
        if (isset($_REQUEST['Login'])) {
            header("Location: " . $_SERVER['PHP_SELF']);
        }
        $_SERVER['PHP_SELF'] = $php_self;
    }
    catch(Exception $e) {
        echo 'Caught exception: ', $e->getMessage() , "\n";
        return false;
    }
    return true;
}
/**
 *
 * @param $title string
 * @return string
 */
function SAFE_WC_HEADER($title = '')
{
    global $SAFE_WC_HELPER;
    $html = '';
    $html = $SAFE_WC_HELPER['header'];
    $html = preg_replace('/__TITLE__/', $title, $html);
    // place updated javascript
    $html = preg_replace('/[\"\'][^\"\']+jquery-1[^\"\']+\.min\.js[\"\']/', '"/SAFe/js/jquery/jquery-1.8.2.min.js"', $html);
    $html = preg_replace('/[\"\'][^\"\']+jquery-ui[^\"\']+\.min\.js[\"\']/', '"/SAFe/js/jquery-ui/jquery-ui-1.9.1.custom.min.js"', $html);
    $html = preg_replace('/[\"\'][^\"\']+ui\.accordion[^\"\']*\.js[\"\']/', '"/SAFe/js/jquery-ui/jquery.ui.accordion.js"', $html);
    $html = preg_replace('/[\"\'][^\"\']+superfish[^\"\']*\.js[\"\']/', '"/SAFe/js/superfish.js"', $html);
    // place additional javascript libs just before </HEAD>
    $appendhead = <<<EOD

  <!-- SAFe added JavaScript libs -->
  <script type="text/javascript" src="/SAFe/js/jquery-ui/jquery.ui.accordion.js"></script>
  <link rel="stylesheet" type="text/css" href="/SAFe/js/jquery-ui/jquery-ui-timepicker-addon.css">
  <script type="text/javascript" src="/SAFe/js/jquery-ui/jquery-ui-timepicker-addon.js"></script>


</head>
EOD;
    $html = preg_replace('#</HEAD[^>]*>#i', $appendhead, $html);
    return $html;
}
function SAFE_WC_FOOTER()
{
    global $SAFE_WC_HELPER;
    $html = '';
    $html = $SAFE_WC_HELPER['footer'];
    return $html;
}
function SAFE_WC_TABLEOPEN($title = '', $width = '100%', $id = '', $extra_class = '', $extra_style = '', $padding = '3px')
{
    global $SAFE_WC_HELPER;
    $html = '';
    $html = $SAFE_WC_HELPER['tableopen'];
    //<div class='ui-widget' style='margin-top: 6px; margin-bottom: 6px;'>
    //  <div class='widget-content-header ui-state-active ui-corner-top' style='padding: 5px; width=100%'>__TEXT__</div>
    //  <div class='widget-content-body ui-state-active ui-corner-bottom' style='padding: 1px; width=100%'>
    //     <table cellspacing='0' cellpadding='__CPADDING__' width='100%' border='0' class='mytable' id='__ID__'>
    $html = preg_replace('/__TEXT__/', $title, $html);
    if (!empty($width)) {
        $html = preg_replace("/style='/", "style='width:" . $width . "; display:inline-block; ", $html, 1);
    }
    $html = preg_replace('/width=100%/', '', $html);
    if (empty($id)) $id = sprintf("tid-%x", rand());
    $html = preg_replace('/__ID__/', 'table-' . $id, $html);
    $html = preg_replace('/<div /', "<div id='" . $id . "'", $html);
    if (!empty($extra_class)) {
        $html = preg_replace("/class='/", "class='" . $extra_class . " ", $html, 1);
    }
    if (!empty($extra_style)) {
        $html = preg_replace("/style='/", "style='" . $extra_style . " ", $html, 1);
    }
    $html = preg_replace('/__CPADDING__/', $padding, $html);
    return $html;
}
function SAFE_WC_TABLECLOSE()
{
    global $SAFE_WC_HELPER;
    $html = '';
    $html = $SAFE_WC_HELPER['tableclose'];
    return $html;
}
function SAFE_WC_DIALOGINTRO($title, $summary, $large_icon, $small_icon)
{
    global $SAFE_WC_HELPER;
    $html = '';
    $html = $SAFE_WC_HELPER['dialogintro'];
    $html = preg_replace('/__TITLE__/', $title, $html);
    $html = preg_replace('/__SUMMARY__/', $summary, $html);
    $html = preg_replace('/__LARGE_ICON__/', $large_icon, $html);
    $html = preg_replace('/__SMALL_ICON__/', $small_icon, $html);
    return $html;
}
function SAFE_WC_DIALOGWARNING($message)
{
    global $SAFE_WC_HELPER;
    $html = '';
    $html = $SAFE_WC_HELPER['dialogwarning'];
    $html = preg_replace('/__TEXT__/', $message, $html);
    return $html;
}
//echo "caliste!2";
function SAFE_WC_DIALOGINFO($message)
{
    global $SAFE_WC_HELPER;
    $html = '';
    $html = $SAFE_WC_HELPER['dialog'];
    $html = preg_replace('/__TEXT__/', $message, $html);
    // WebDialogBox("dialoginfo", WEBCONFIG_LANG_INFO,
    // WEBCONFIG_DIALOG_ICON_INFO, '__TEXT__');
    $html = preg_replace('/__ICON__/', WEBCONFIG_DIALOG_ICON_INFO, $html);
    return $html;
}
function SAFE_WC_DIALOG($message, $icon, $class = '')
{
    global $SAFE_WC_HELPER;
    $html = '';
    $html = $SAFE_WC_HELPER['dialog'];
    $html = preg_replace('/__TEXT__/', $message, $html);
    // WebDialogBox ( '__CLASS__', WEBCONFIG_LANG_INFO, '__ICON__', '__TEXT__' );
    $html = preg_replace('/__CLASS__/', $class, $html);
    $html = preg_replace("/class='/", "class='" . $class . ' ', $html);
    $html = preg_replace('/__ICON__/', /* '<img src="'. */
    $icon /* .'" alt align="top">' */
    , $html);
    return $html;
}
/* End of file safe_wc_helper.php */
/* Location: ./application/helpers/safe_wc_helper.php */
