<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SIP Secmon rules page
 * @author Shaunt Libarian
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('crud_table');
safe_require_class('form');
class Nsc_sipsecmon_rules_param_class extends Safe_configurable_object_class
{
    public function __construct()
    {
        parent::__construct('autofill', 'Nsc_sipsecmon_rules_config_class');
    }
    public function configure($rule_count)
    {
        //Pull a count of all rules
        $c = $rule_count + 1;
        $this->add_field('name', 'Rule Name', 'string', 'New_NSC_Rule_' . $c, 50);
        $this->set_field_rules('name', 'required|alpha_dash');
        parent::configure();
        //$this->synch();
        
    }
}
class Nsc_sipsecmon_rules extends Safe_CI_Controller
{
    public $_rules;
    public $_sipsecmon;
    public function __construct()
    {
        parent::__construct();
        $this->_sipsecmon = $this->_the_product->local_node()->software()->service('sipsecmon');
        $this->_rules = $this->_sipsecmon->rules();
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        $not_cfg = true;
        // Set the basic data
        $data['page_title'] = 'SIP Firewall';
        $data['page_summary'] = 'This page allows managing SIP Firewall Rules.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        //Prepare table structure
        $data['table_size'] = '100%';
        if ($this->_sipsecmon->is_enabled() == false) {
            $data['notif_error'][] = safe_form_with_submit_button('SIP Firewall Not Configured. ', '/SAFe/sng_config_manager/edit/sipsecmon', 'Click to enable the SIP Firewall');
            $not_cfg = true;
        } else {
            $table = new Safe_crud_table_class();
            $data['table_title'] = $table->set_title('SIP Firewall Rules');
            // Prepare heading
            $table->set_headings(array(
                'Rule Name',
                'SIP Profile'
            ));
            $table->set_controller_url($this->router->fetch_class());
            foreach ($this->_rules as $profile) {
                if (isset($profile)) {
                    $prof_data = $profile->get_data_values();
                    $table->add_row(array(
                        $profile->name() ,
                        $prof_data['profile_filter'],
                    ) , $profile->name() , 'Edit|Delete:confirm', '');
                }
            }
            $table->allow_create(true);
            // Generate table HTML code
            $data['table'] = $table->generate_table();
            $data['notif_warn'][] = safe_button_click('', 'Click to change SIP Firewall Settings', '/SAFe/sng_config_manager/edit/sipsecmon');
            $not_cfg = false;
        }
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
        $this->load->view("safe_notifications", $data);
        if (!$not_cfg) $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Modifies an existing rule
     * @param String $profile_name:
     *                              					Profile being modified
     */
    public function edit($profile_name)
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($profile_name)) exit('Profile name required');
        $rules = $this->_rules[$profile_name];
        $new_obj = false;
        if(!$rules) {
            $rules = new Nsc_sipsecmon_rules_config_class($this->_sipsecmon->node() , $this->_sipsecmon->object_name() . '/rules', $profile_name);
            $rules->configure();
            $new_obj = true;
        }
        // Check post request
        $post = $this->input->post();
        if (isset($post['cancel'])) {
            redirect('/' . $this->router->fetch_class() , 'refresh');
        } elseif (isset($post['save'])) {
            // TODO(wadam) - Validate and save
            //print_r($post);
            unset($post['save']);
            $rules->set_data_values($post);
            // Prepare an array to retreive errors if any
            $validation_errors = array();
            // Prepare the form for validation with posted data
            // Note that this is the form that will be used by edit code (after this if/else block)
            // if the validation fail
            $this->load->library('safe_form_class', $rules->get_data());
            // Check new data are valid
            if ($this->safe_form_class->run_validation($validation_errors, $rules->user_rule_msgs())) {
                // TODO(wadam) - run validation
                if (TRUE == $rules->save()) redirect('/' . $this->router->fetch_class() , 'refresh');
            }
        } else {
            $this->load->library('safe_form_class', $rules->get_data());
        }
        // Set the basic data
        $data['page_title'] = $rules->name() . ' SIP Firewall Rule';
        $data['page_summary'] = 'This page allows managing SIP Firewall Rules.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $cfg_data['form_cfg'] = $form_config;
        // Get the fields group
        // send the group array in our form view
        $field_group = array();
        $field_group = $rules->get_group();
        $cfg_data['group'] = $field_group;
        $cfg_data['label'] = $this->safe_form_class->form_label_array();
        // set the form attributes
        $frm_attributes = array(
            'id' => 'sipsecmon_rule'
        );
        $this->safe_form_class->set_form_attributes($frm_attributes);
        $cfg_data['form_title'] = 'SIP Firewall Rule: ' . $rules->name();
        $cfg_data['form'] = $this->safe_form_class->form_input_array();
        $cfg_data['label'] = $this->safe_form_class->form_label_array();
        $cfg_data['form_open'] = $this->safe_form_class->form_open();
        $cfg_data['buttons'] = array(
            array(
                'name' => 'save',
                'value' => 'Save',
                'type' => 'submit'
            ) ,
            array(
                'name' => 'cancel',
                'value' => 'Cancel',
                'type' => 'submit'
            ) ,
        );
        $this->load->view("safe_header", $data);
        $this->load->view("safe_form", $cfg_data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Function create a json encoded form to adds a new rule
     *   using popup dialog in browser
     */
    public function add_form($reload=false)
    {
        $data['page_title'] = 'New SIP Firewall Rule';
        $rule_count = 0;
        if (isset($this->_rules)) {
            foreach ($this->_rules as $rule) {
                $rule_count++;
            }
        }
        $param = new Nsc_sipsecmon_rules_param_class();
        $param->configure($rule_count);
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        $data['form_title'] = 'SIP Firewall : New SIP Firewall Rule';
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_cfg'] = $this->safe_form_class->config;
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
                array(
                        'name' => 'create',
                        'value' => 'Create',
                        'type' => 'submit'
                ) ,
                array(
                        'name' => 'cancel',
                        'value' => 'Cancel',
                        'type' => 'submit'
                ) ,
        );
        //******
        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $this->load->view("safe_form_json", $data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        
        $data['page_title'] = $data['form_title'];
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        } 
        $data['reload'] = $reload;
        $data['action_url'] = base_url($this->router->fetch_class().'/add/');
        $data['action_method'] = 'POST';
        echo json_encode($data);

    }
    /**
     * Function which adds a new rule
     */
    public function add()
    {
        // verify if logged
        //safe_authenticate ();
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'New SIP Firewall Rule';
        $rule_count = 0;
        if (isset($this->_rules)) {
            foreach ($this->_rules as $rule) {
                $rule_count++;
            }
        }
        $param = new Nsc_sipsecmon_rules_param_class();
        $param->configure($rule_count);
        
        $wizard_data = $param->get_data_values();
        $wizard_data['profile-name'] = $post['name'];
        $param->set_data_values($wizard_data);
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        if ($this->safe_form_class->run_validation($validation_errors)) {
            // Check that profile does not exist
            if (isset($this->_rules[$post['name']])) {
                //Profile exists, throw an error
                $data['message'] = "<b>" . $post['name'] . "</b> exists. Please use a different profile name";
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            } else {
                $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit/' . $post['name']);
                $data['result'] = true;
                echo json_encode($data);
            }
        }else{
          //return a json encode form with a error message
          $this->add_form(true);
        }
    }
    /**
     * Confirm to Delete a rule
     *
     * @param string $profile_name
     *                             				rule being deleted
     */
    public function delete_confirm($profile_name)
    {
        $data['page_title'] = 'Delete SIP Firewall Rule';
        if (isset($this->_rules[$profile_name])) {
            $sip = $this->_rules[$profile_name];
            //Check to make sure you can delete, then delete the object
            $reason = array();
            if ($sip->can_dispose($reason)) {
                $data['message'] = 'Are you sure you would like to delete the rule, <b>' . $profile_name . '</b>?';
                $data['message_type'] = 'notice';
                $data['result'] = true;
                $data['action_url'] = base_url($this->router->fetch_class()). '/delete/'.$profile_name;
                echo json_encode($data);
            }else{
                $reason_msg='';
                if($reason){
                    $reason_msg =(is_array($reason)) ? implode('<br>',$reason) : $reason;
                }
                $reason_msg = ($reason_msg=='')?'':'<br>'.$reason_msg;
                $data['message'] = 'Delete SIP Firewall Rule '.$profile_name.' Failed'.$reason_msg;
                $data['message_type'] = 'notice';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            $data['message'] = 'No SIP Firewall Rule found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Delete a rule
     *
     * @param string $profile_name
     *                             				rule being deleted
     */
    public function delete($profile_name)
    {
        // Set the basic data
        $data['page_title'] = 'Delete SIP Firewall Rule';
        if (isset($this->_rules[$profile_name])) {
            $rule = $this->_rules[$profile_name];
            $rule->dispose();
            //return redirect url
            $data['result'] = true;
            $data['redirect_url'] = base_url( $this->router->fetch_class());
            echo json_encode($data);
        }else{
            //return error message
            $data['message'] = 'No SIP Firewall Rule found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    
}
