<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SIP Security Monitor Blocked IP List
 * @author Shaunt Libarian
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('service');
safe_require_class('table');
safe_require_class('crud_table');
safe_require_class('form');
class Nsc_sipsecmon_blockedip extends Safe_CI_Controller
{
    private $_db = "";
    private $_sipsecmon = "";
    private $_status = "";
    public function __construct()
    {
        parent::__construct();
        $this->_sipsecmon = $this->_the_product->local_node()->software()->service('sipsecmon');
        $this->_status = $this->_the_product->local_node()->software()->service('sipsecmon')->status();
        $this->_db = $this->_sipsecmon->db();
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        $filter = "";
        $order_by = "";
        // Set the basic data
        $data['page_title'] = 'SIP Security Monitor - Blocked IPs';
        $data['page_summary'] = 'This page displays IPs blocked by the SIP Security Monitor.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $this->load->view("safe_header", $data);
        $stopped = false;
        $unrecognized = false;
        if ($this->_status == 1 || $this->_status == 3) {
            $data['notif_error'][] = 'SIP Security Monitor is currently not running.';
            $data['notif_error'][] = 'You will not be able to modify and blocked IP Addresses.';
            $data['notif_error'][] = safe_form_with_submit_button('Click here to ', '/SAFe/sng_control_panel', 'Start the Service', '');
            $stopped = true;
        } elseif ($this->_status == - 1) {
            //Unrecognized state
            // Set the basic data
            $data['notif_error'][] = 'The SIP Security Monitor is currently not recognized by the system.';
            $data['notif_error'][] = 'Please contact Sangoma Support.';
            $this->load->view("safe_error");
            $this->load->view("safe_notifications", $data);
            $this->load->view("safe_footer", $data);
            $unrecognized = true;
            break;
        }
        if (!$unrecognized) {
            //Loads the wait message just in case page taking long to load
            $data['wait_message'] = '</br><b>Searching...</b></br>&nbsp;';
            $this->load->view("safe_confirm_dialog", $data);
            $this->load->view("safe_wait", $data);
            safe_flush_ouput();
            $select = "sip_secmon_blocked_objects.name,sip_secmon_blocked_objects.block_time,sip_secmon_blocked_objects.block_expiration,sip_secmon_rules.name AS rule_name, sip_secmon_blocked_objects.rule_id";
            $join = array(
                'rules',
                'rules.rule_id = sip_secmon_blocked_objects.rule_id',
                'left'
            );
            //Connect to MySQL Database
            $db = $this->_db; //Holds configuration
            $db->connect();
            $result = $db->select('blocked_objects', '', '', '', '', $join, $select);
            $db->disconnect();
            //Prepare table structure
            $data['table_size'] = '100%';
            $table = new Safe_crud_table_class();
            $data['table_title'] = $table->set_title('Blocked IPs');
            // Prepare heading
            $table->set_headings(array(
                'IP',
                'Block Time',
                'Block Expiration',
                'Blocking Rule'
            ));
            $table->set_controller_url($this->router->fetch_class());
            // Display all blocked ips
            foreach ($result as $row) {
                $table->add_row(array(
                    $row->name,
                    $row->block_time,
                    ("9999-12-31 23:59:59" == $row->block_expiration) ? "Never" : $row->block_expiration,
                    ($row->rule_name != "" && isset($row->rule_name)) 
                        ? $row->rule_name 
                        : (0 == $row->rule_id) ? 'SIP Profile Limits':'<b>Rule Deleted</b>. ID = ' . $row->rule_id
                ) , $row->name, ($stopped) ? '' : 'Unblock:confirm');
            }
            // Generate table HTML code
            $data['table'] = $table->generate_table();
            $this->load->view("safe_notifications", $data);
            $this->load->view("safe_table", $data);
            $this->load->view("safe_footer", $data);
        }
    }
    /**
     * confirm to Unblocks an IP Address
     * @param string $blocked_ip
     *                           					IP to unblock
     */
    public function unblock_confirm($blocked_ip)
    {
        $data['page_title'] = 'UnBlocked IPs';
        $data['message'] = 'Are you sure you would like to UnBlock  <b>' . $blocked_ip . '</b>?';
        $data['message_type'] = 'notice';
        $data['result'] = true;
        $data['action_url'] = base_url($this->router->fetch_class()). '/unblock/'.$blocked_ip;
        echo json_encode($data);
    }
    /**
     * Unblocks an IP Address
     * @param string $blocked_ip
     *                           					IP to unblock
     */
    public function unblock($blocked_ip)
    {
        // Set the basic data
        $data['page_title'] = 'SIP Security Monitor - Blocked IPs';
        //Unblock IP
        $res = $this->_sipsecmon->unblock_ip($blocked_ip);
        if ($res) {
            //success
            //return redirect url
            $data['result'] = true;
            $data['redirect_url'] = base_url( $this->router->fetch_class());
            echo json_encode($data);
        } else {
            //fail
            //return error message
            $data['message'] = 'There was an error unblocking <b>' . $blocked_ip . '</b>';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
}
?>
