<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC SIP Profile Page
 *
 * @author Shaunt Libarian
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('object');
safe_require_class('crud_table');
safe_require_class('form');
safe_module_require_class('sng', 'transcoding_config');
class Nsc_sip_domain_profile_param_class extends Safe_configurable_object_class
{
    public $_domain_profiles;
    public $_the_product;
    public $_the_app;
    public function __construct()
    {
        //parent::__construct('autofill','Nsc_sip_domain_profile_class');
        
    }
    public function configure($profile)
    {
        $this->_the_product = Safe_get_product();
        $this->_the_app = $this->_the_product->local_node()->software()->application();
        $this->_sip_profiles = $this->_the_app->sip_profiles(); //Holds all SIP Profiles
        $this->_domain_profiles = $this->_the_app->domain_profiles(); //Holds all Domain Profiles
        $def_name = array();
        $names = array();
        $sip_profile = $this->_sip_profiles[$profile];
        $config = $sip_profile->get_data_values();
        //Set sip profiles
        if (isset($this->_domain_profiles)) {
            foreach ($this->_domain_profiles as $profile) {
                if (isset($profile)) {
                    $prof_data = $profile->get_data_values();
                    $names[] = $profile->name();
                }
            }
        }
        foreach ($config['domains'] as $sip_domain) {
            foreach ($this->_domain_profiles as $profile) {
                if (isset($profile)) {
                    $prof_data = $profile->get_data_values();
                    if (strtolower($profile->name()) == $sip_domain) $def_name[] = $profile->name();
                }
            }
        }
        $this->add_multiple_field('domain[]', '', 'checkbox', $def_name, $names);
    }
}
class Nsc_sip_profile_param_class extends Safe_configurable_object_class
{
    public function __construct()
    {
        parent::__construct('autofill', 'Nsc_sip_profile_param_class');
    }
    public function configure($sip_profiles=null)
    {
        $c = count($sip_profiles)+1;
        $this->add_field('profile-name', 'Profile Name', 'string', 'NSC_SIP_Profile' . $c, 50);
        $this->set_field_rules('profile-name', 'required|alpha_dash');
        if($sip_profiles) {
            // Create enum list of existing profiles
            $profile_list['__none__'] = " -- None -- ";
            foreach($sip_profiles as $k=>$v){
                $profile_list[$k] = $v->name();
            }

            $this->add_enum_field('src', 'Copy From', 'dropdown', '__none__', $profile_list);
        }
        parent::configure();
        //$this->synch();
        
    }
}
class Nsc_sip_profiles extends Safe_CI_Controller
{
    public $_sip_profiles;
    public $_sip_limits;
    public $_sip_module;
    public function __construct()
    {
        parent::__construct();
        $this->_sip_module = $this->_the_app->module('sip');
        $this->_sip_profiles = $this->_sip_module->profiles(); //Holds all SIP Profiles
        
    }
    public function index()
    {
        // Set the basic data
        $data['page_title'] = 'SIP Profiles';
        $data['page_summary'] = 'This page allows managing SIP profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        //Prepare table structure
        $data['table_size'] = '100%';
        $table = new Safe_crud_table_class();
        $data['table_title'] = $table->set_title('SIP Profiles');
        // Prepare heading
        $table->set_headings(array(
            'Name',
            'User Agent',
            'IP address',
            'Transport',
            'Port'
        ));
        $table->set_controller_url($this->router->fetch_class());
        foreach ($this->_sip_profiles as $profile) {
            if (isset($profile)) {
                $prof_data = $profile->get_data_values();
                $table->add_row(array(
                    $profile->name() ,
                    $prof_data['user-agent-string'],
                    $prof_data['sip-ip'],
                    $prof_data['transport'],
                    $prof_data['sip-port'],
                ) , $profile->name() , 'Modify|Delete:confirm', '');
            }
        }
        $table->allow_create(true);//add a 'Add' button
        // Generate table HTML code
        $data['table'] = $table->generate_table();
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load dialog js and css
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    public function modify($profile_name)
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($profile_name)) exit('Profile name required');
        $sip_profile = $this->_sip_profiles[$profile_name];
        // Set the basic data
        $data['page_title'] = $sip_profile->name() . ' SIP Profile';
        $data['page_summary'] = 'This page allows managing SIP profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $config = $sip_profile->get_data_values();
        $def_if = '';
        // IP value is handled differently, only ethernet if name is stored in
        // object. Need to get the unresolved data.
        $ip_value = $sip_profile->get_data_value('sip-ip', false);
        // Find the IP address used in the specific SIP Profile
        //$mgmt_if = $this->_the_app->node()->hardware()->adapters(Safe_hardware_adapter_class::ETHERNET_ADAPTER);
        $transcoding_mode = new Sng_transcoding_config_class($this->_the_app->node());
        $adapter_type = $transcoding_mode->adapter_type();
        $mgmt_if = $this->_the_app->node()->hardware()->adapters($adapter_type);
        $if_enum = array();
        foreach ($mgmt_if as $if_name => $if) {
            if ($ip_value == $if->name()) {
                $def_if = $if->name() . ' - ' . $if->ip_address();
                break;
            }
        }
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load dialog js and css
        // Display
        //Load a bar to go back to main page
        //$data['notif_warn'][] = "Editing <b>" . $profile_name . "</b>";
        $data['notif_warn'][] = safe_form_with_submit_button('Please click here to ', '/SAFe/nsc_sip_profiles', 'view all profiles', '');
        $this->load->view("safe_notifications", $data);
        $table = new Safe_crud_table_class();
        $data['table_size'] = '100%';
        $data['table_title'] = $table->set_title('SIP Profile: ' . $profile_name);
        $table->set_controller_url($this->router->fetch_class());
        $table->set_url_suffix('profile');
        $table->primary_key = $profile_name;
        if ($config['transport'] == "UDP+TCP+TLS" || $config['transport'] == "TLS") {
            $table_line = array(
                'User Agent' => $config["user-agent-string"],
                'IP Address' => $def_if,
                'Port' => $config["sip-port"],
                'Transport' => $config['transport'],
                'Load Limiting' => $config['enable-load-limit'],
                'TLS Certificate Filename' => $config['TLS/certificate-file-name'],
                '' => $table->create_button(true, 'Edit', $button_css_class = '', $table->primary_key) /*.
                 $table->create_button(true, 'Cancel', $button_css_class='', '')*/
            );
        } else {
            $table_line = array(
                'User Agent' => $config["user-agent-string"],
                'IP Address' => $def_if,
                'Port' => $config["sip-port"],
                'Transport' => $config['transport'],
                'Load Limiting' => $config['enable-load-limit'],
                '' => $table->create_button(true, 'Edit', $button_css_class = '', $table->primary_key) /*.
                 $table->create_button(true, 'Cancel', $button_css_class='', '')*/
            );
        }
        // Generate table HTML code
        $data['table'] = $table->generate_vertical_line_table('', $profile_name, $table_line);
        $this->load->view("safe_table", $data);
        //Display Domains
        $this->display_domains($profile_name);
        $this->display_limits($profile_name);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Uploads the file the server
     * @param string $file_name
     *                           File name of the pem file being uploaded
     * @return string $location
     *                File location and filename of the server
     */
    public function upload_file(&$file_name, &$file_content, &$msg)
    {
        $status = "";
        $msg = "";
        $file_element_name = 'TLS/certificate';
        $data = array();
        $config = array();
        $config['upload_path'] = '/tmp/tls-files/';
        $config['allowed_types'] = 'pem';
        $config['max_size'] = 1024 * 8;
        $config['encrypt_name'] = FALSE;
        $config['overwrite'] = TRUE;
        if (!file_exists($config['upload_path'])) mkdir($config['upload_path'], '0755', true);
        $this->load->library('upload', $config);
        if (!$this->upload->do_upload($file_element_name)) {
            $status = 'error';
            $msg = $this->upload->display_errors('', '');
            return false;
        }
        $status = "success";
        $msg = "File successfully uploaded";
        //echo json_encode(array('status' => $status, 'msg' => $msg));
        $file_name = $_FILES['TLS/certificate']['name'];
        $data = $this->upload->data();
        $file_content = file_get_contents($data['full_path']);
        @unlink($data['full_path']);
        return true;
    }
    /**
     * Modifies an existing sip profile
     * @param String $profile_name:
     *                              Profile being modified
     */
    public function edit_profile($profile_name, $src_profile=null)
    {
        // verify if logged
        //safe_authenticate ();
        $error = false;
        $error_tcp = false;
        $port = "";
        $transport = "";
        $interface = "";
        if (!isset($profile_name)) exit('Profile name required');
        $sip_profile = $this->_sip_profiles[$profile_name];
        $new_obj = false;
        if(!$sip_profile) {
            $sip_profile = $this->_sip_module->api_create_profile($profile_name);
            $new_obj = true;
            if($src_profile){
                // Copy from another profile
                $src_obj = $this->_sip_profiles[$src_profile];
                if($src_obj){
                    $sip_profile->set_data_values($src_obj->get_data_values(false));
                }
            }
        }
        $sip = $sip_profile->get_data_values(false);
        // Check post request
        $post = $this->input->post();
        if (isset($post['cancel'])) {
            if($new_obj) {
                redirect('/' . $this->router->fetch_class());
            }else{
                redirect('/' . $this->router->fetch_class() . '/modify/' . $profile_name, 'refresh');
            }
        } elseif (isset($post['save'])) {
            unset($post['save']);
            //check to make sure file was uploaded
            // Prepare an array to retreive errors if any
            $validation_errors = array();
            // Prepare the form for validation with posted data
            // Note that this is the form that will be used by edit code (after this if/else block)
            // if the validation fail
            $sip_profile->set_data_values($post);
            $this->load->library('safe_form_class', $sip_profile->get_data());
            // Check new data are valid
            if (!$this->safe_form_class->run_validation($validation_errors)) $error = true;
            if ($post['transport'] == "udptcptls" || $post['transport'] == "tls") {
                //check if entry present
                if ($_FILES['TLS/certificate']['name'] == "" && $sip['TLS/certificate-file-name'] == "") {
                    $error = true;
                    $data['notif_error'][] = "No SSL/TLS Certificate uploaded. Please upload a certificate.";
                }
            }
            if ($post['transport'] == "udptcp" || $post['transport'] == "udp" || $post['transport'] == "tcp") {
                if (($_FILES['TLS/certificate']['name'] != "")) {
                    $error = true;
                    $data['notif_error'][] = "No SSL/TLS Certificate is required when using either TCP, UDP or Both.";
                }
            }
            foreach ($this->_sip_profiles as $profile) {
                if ($profile->name() != $profile_name) {
                    $profile->get_sip_transport_info($transport, $port, $interface);
                    if ($post['sip-ip'] == $interface) {
                        if ($port == $post['sip-port']) {
                            $error = true;
                            $data['notif_error'][] = "SIP Port currently in use by another profile";
                            break;
                        }
                    }
                }
            }
            if (!$error) {
                if ($post['transport'] == "udptcptls" || $post['transport'] == "tls") {
                    if (($_FILES['TLS/certificate']['name'] != "")) {
                        $file_name = "";
                        $file_content = "";
                        if ($this->upload_file($file_name, $file_content, $msg)) {
                            $post['TLS/certificate'] = $file_name;
                            $post['TLS/certificate-file-name'] = $file_name;
                            $post['TLS/certificate-file-content'] = base64_encode($file_content);
                        } else {
                            $error = true;
                            $data['notif_error'][] = $msg;
                        }
                    }
                }
            }
            if (!$error) {
                $sip_profile->set_data_values($post);
                if (TRUE == $sip_profile->save()) {
                    // Is this a copy from ?
                    if($src_profile && $src_obj){
                        // Need to copy limits as well
                        foreach($src_obj->request_limits() as $k=>$v) {
                            $limit = new Fs_sip_request_limit_config_class($this->_the_app->node() , $this->_the_app->object_name() . '/profile/sip/' . $profile_name . '/limits', $k);
                            $limit->configure();
                            $limit->synch();
                            $limit->set_data_values($v->get_data_values(false));
                            $limit->save();
                        }
                    }
                    redirect('/' . $this->router->fetch_class() . '/modify/' . $profile_name, 'refresh');
                }
            }
        }
        // Set the basic data
        $data['page_title'] = $sip_profile->name() . ' SIP Profile';
        $data['page_summary'] = 'This page allows managing SIP profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $config = $sip_profile->get_data();
        $this->load->library("safe_form_class", $config);
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $data['form_cfg'] = $form_config;
        // Get the fields group
        // send the group array in our form view
        $field_group = array();
        $field_group = $sip_profile->get_group();
        $data['group'] = $field_group;
        // set the form attributes
        $frm_attributes = array(
            'id' => 'sip_profile'
        );
        $this->safe_form_class->set_form_attributes($frm_attributes);
        $data['form_title'] = 'SIP profile : ' . $sip_profile->name();
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open_multipart();
        $data['buttons'] = array(
            array(
                'name' => 'save',
                'value' => 'Save',
                'type' => 'submit'
            ) ,
            array(
                'name' => 'cancel',
                'value' => 'Cancel',
                'type' => 'submit'
            ) ,
        );
        $this->load->view("safe_header", $data);
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_form", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * ceate a form to bind domain to sip profile
     * @param string $profile_name
     *                             SIP Profile being bind
     */
    public function bind_form_domain($profile_name)
    {
        if (isset($profile_name)) {
            
            // Check post request
            $post = $this->input->post();
            $sip_profile = $this->_sip_profiles[$profile_name];
            $sip_compare = $sip_profile->get_data_values();
            $param = new Nsc_sip_domain_profile_param_class();
            $param->configure($profile_name);
            // Set the basic data
            $data['page_title'] = $sip_profile->name() . ' SIP Profile';
            //Display form with checkboxes
            $config = $param->get_data();
            $this->load->library("safe_form_class", $config);
            $data['form_title'] = 'Bind Domains to ' . $profile_name;
            $data['form'] = $this->safe_form_class->form_input_array();
            $data['label'] = $this->safe_form_class->form_label_array();
            $data['form_open'] = $this->safe_form_class->form_open();
            $data['buttons'] = array(
                    array(
                            'name' => 'add',
                            'value' => 'Bind',
                            'type' => 'submit'
                    ) ,
                    array(
                            'name' => 'cancel',
                            'value' => 'Cancel',
                            'type' => 'submit'
                    ) ,
            );
            //******
            //clear the content in page cache and get the view content
            ob_start();
            ob_clean();
            $this->load->view("safe_form_json", $data);
            $data['content'] = ob_get_contents();
            ob_clean();
            //******
            $data['form_title'] = 'Bind Domains';
            $data['page_title'] = $data['form_title'];
            $data['result'] = true;
            if($reload === true){
                $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
            }
            $data['reload'] = $reload;
            $data['action_url'] = base_url($this->router->fetch_class().'/bind_domain/'.$profile_name);
            $data['action_method'] = 'POST';
            echo json_encode($data);
        }else{
            $data['message'] = "Profile name required";
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
        
    }
    /**
     * bind domain to sip profile
     * @param string $profile_name
     *                             SIP Profile being bind
     */
    public function bind_domain($profile_name)
    {
        // verify if logged
        //safe_authenticate ();
        if (isset($profile_name)){
            // Check post request
            $post = $this->input->post();
            $sip_profile = $this->_sip_profiles[$profile_name];
            $sip_compare = $sip_profile->get_data_values();
            $param = new Nsc_sip_domain_profile_param_class();
            $param->configure($profile_name);
            
            //Store domain addition in the db
            $temp = $sip_profile->get_data_values();
            //Removes old domain information to submit new domain information into object. This way you will not have duplicated domains
            unset($temp['domains']);
            if (isset($post['domain'])) {
                foreach ($post['domain'] as $domain) {
                    $temp['domains'][] = $domain;
                }
            }
            $sip_profile->set_data_values($temp);
            // TODO(wadam) - Validate and save;
            unset($post['add']);
            // TODO(wadam) - run validation
            if (TRUE == $sip_profile->save()) {
                $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/modify/' . $profile_name);
                $data['result'] = true;
                echo json_encode($data);
            }
        }else{
            $data['message'] = "Profile name required";
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    
    /**
     * Remove a domain from a SIP Profile
     * @param string $profile_name
     *                             SIP profile where the domain is being removed from
     * @param string $domain_name
     *                             Domain name being removed
     */
    public function unbind_domain($profile_name, $domain_name)
    {
        // Set the basic data
        $data['page_title'] = 'Unbind Domain from SIP Profile';
        $data['page_summary'] = 'This page allows managing SIP profile settings.';
        if (isset($this->_sip_profiles[$profile_name])) {
            $sip = $this->_sip_profiles[$profile_name];
            $temp['domains'] = array();
            foreach ($sip as $profile) {
                for ($a = 0; $a < count($profile['domains']['default']); $a++) {
                    if ($profile['domains']['default'][$a] != $domain_name) $temp['domains'][] = $profile['domains']['default'][$a];
                }
            }
            $sip->set_data_values($temp);
            if (TRUE == $sip->save()) {
                $data['result'] = true;
                $data['redirect_url'] = base_url( $this->router->fetch_class()). '/modify/' . $profile_name;
                echo json_encode($data);
            }else{
                $data['message'] = 'Unbind the Domain <b>' . $domain_name . '</b> from the SIP Profile: <b>' . $profile_name . '</b> error.';
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            $data['message'] = 'No sip profile found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    public function add_form_limit($sip_profile,$reload=false)
    {
        $data['page_title'] = 'SIP Limit Rule';
        $data['content'] = 'Create SIP Limit Rule?<br><form></form>';
        
        
        
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        }
        $data['reload'] = $reload;
        $data['action_url'] = base_url($this->router->fetch_class().'/add_limit/'. $sip_profile);
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * Function which adds a new sip limit
     */
    public function add_limit($sip_profile)
    {
        // verify if logged
        //safe_authenticate ();
        $ser = Safe_object_serializer_class::get_next_unique_id();
        $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit_limit/' . $sip_profile . '/' . $ser);
        $data['result'] = true;
        echo json_encode($data);
    }
    /**
     * Function create a json encoded form to adds a new sip profile
     *   using popup dialog in browser
     */
    public function add_form($reload=false)
    {
        // Set the basic data
        $data['page_title'] = 'New SIP Profile';
        $param = new Nsc_sip_profile_param_class();
        $param->configure($this->_sip_profiles);
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $data['form_cfg'] = $form_config;
        $data['form_title'] = 'SIP profile : New Profile';
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
                array(
                        'name' => 'create',
                        'value' => 'Create',
                        'type' => 'submit'
                ) ,
                array(
                        'name' => 'cancel',
                        'value' => 'Cancel',
                        'type' => 'submit'
                ) ,
        );
        //******
        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $this->load->view("safe_form_json", $data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        
        $data['page_title'] = $data['form_title'];
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        } 
        $data['reload'] = $reload;
        $data['action_url'] = base_url($this->router->fetch_class().'/add/');
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * Function which adds a new sip profile
     */
    public function add()
    {
        $data['page_title'] = 'SIP profile : New Profile';
        // verify if logged
        // Check post request
        $post = $this->input->post();
        $param = new Nsc_sip_profile_param_class();
        $param->configure($this->_sip_profiles);
        
        /*$wizard_data = $param->get_data_values();
        $wizard_data['profile-name'] = $post['profile-name'];
        $param->set_data_values($wizard_data);*/
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        if ($this->safe_form_class->run_validation($validation_errors)) {
            $param->save();
            // Check that profile does not exist
            if (isset($this->_sip_profiles[$post['profile-name']])) {
                //Profile exists, throw an error
                $data['message'] = "<b>" . $post['profile-name'] . "</b> exists. Please use a different profile name.";
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            } else {
                unset($post['create']);
                $data['result'] = true;
                if($post['src'] == '__none__') {
                    $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit_profile/' . $post['profile-name']);
                } else {
                    $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit_profile/' . $post['profile-name'] . '/' . $post['src']);
                }
                echo json_encode($data);
            }
        }else{
            //return a json encode form with a error message
            $this->add_form(true);
        }
    }
    /**
     * Displays the domain CRUD Table
     */
    public function display_domains($profile_name)
    {
        // Check if some domains are created
        if (0 == sizeof($this->_the_app->domain_profiles())) {
            //Load a bar to go back to main page
            $data['notif_warn'][] = safe_form_with_submit_button('No domain defined', '/SAFe/nsc_domain_profiles', 'create domain', '');
            $this->load->view("safe_notifications", $data);
        } else {
            //Prepare table structure
            $table = new Safe_crud_table_class();
            $data['table_size'] = '100%';
            $data['table_title'] = $table->set_title('SIP Domains');
            // Prepare heading
            $table->set_headings(array(
                'Domain'
            ));
            $table->set_controller_url($this->router->fetch_class());
            $table->set_url_suffix('domain');
            unset($table->primary_key);
            $sip_profile = $this->_sip_profiles[$profile_name];
            if (isset($sip_profile)) {
                foreach ($sip_profile as $profile) {
                    if (isset($profile)) {
                        foreach ($profile['domains']['default'] as $value) {
                            $primary_key = $profile_name . '/' . $value;
                            $table->add_row(array(
                                $value
                            ) , $primary_key, 'Unbind:confirm', '', true);//set_url_suffix('domain'), action_url=unbind_confirm_domain
                        }
                    }
                }
                $table->custom_footer_button('bind', $profile_name,'create');
            }
            // Generate table HTML code
            $data['table'] = $table->generate_table();
            $this->load->view("safe_table", $data);
        }
    }
    /**
     * Confirm to unbind domain name
     *
     */
    public function unbind_confirm_domain($profile_name, $domain_name)
    {
        // Set the basic data
        $data['page_title'] = 'Unbind Domain from SIP Profile';
        if (isset($this->_sip_profiles[$profile_name])) {
            $data['message'] = 'Are you sure you would like to unbind the Domain <b>' . $domain_name . '</b> from the SIP Profile: <b>' . $profile_name . '</b>?<br>'.
                    'This will not delete the domain but unbind it from the current SIP profile.';
            $data['message_type'] = 'notice';
            $data['result'] = true;
            $data['action_url'] = base_url($this->router->fetch_class()). '/' . 'unbind_domain'.'/'. $profile_name .'/'.$domain_name;
            echo json_encode($data);
        }else{
            $data['message'] = 'No SIP Profile found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Displays the limit CRUD Table
     */
    public function display_limits($profile_name)
    {
        //Prepare table structure
        $table = new Safe_crud_table_class();
        $data['table_size'] = '100%';
        $data['table_title'] = $table->set_title('SIP Limits Rules');
        // Prepare heading
        $table->set_headings(array(
            'Method',
            'Host',
            'Rate Limit',
            'Rate Period'
        ));
        $table->set_controller_url($this->router->fetch_class());
        $table->set_url_suffix('limit');
        unset($table->primary_key);
        $_sip_limits = $this->_sip_profiles[$profile_name]->request_limits();
        if (!empty($_sip_limits)) {
            foreach ($_sip_limits as $profile) {
                $prof_data = $profile->get_data_values();
                $primary_key = $profile_name . '/' . $profile->name();
                $table->add_row(array(
                    $prof_data['method'],
                    $prof_data['host'],
                    $prof_data['limit'],
                    $prof_data['period'],
                ) , $primary_key, 'Edit|Delete:confirm', '', true);
            }
        }
        $table->set_url_suffix('limit');
        $table->allow_create(true, $profile_name);
        // Generate table HTML code
        $data['table'] = $table->generate_table();
        $this->load->view("safe_table", $data);
    }
    /**
     * Delete a sip profile confirm
     *
     * @param string $profile_name
     *                             sip profile being deleted
     */
    public function delete_confirm($profile_name)
    {
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'Delete SIP Profile';
        if (isset($this->_sip_profiles[$profile_name])) {
            $sip = $this->_sip_profiles[$profile_name];
            //Check to make sure you can delete, then delete the object
            $reason = array();
            if ($sip->can_dispose($reason)) {
                $data['message'] = 'Are you sure you would like to delete <b>' . $profile_name . '</b>?<br>'.
                        'Deleting <b>' . $profile_name . '</b> will not remove any media or domain profiles.';
                $data['message_type'] = 'notice';
                //for ajax json data return
                $data['result'] = true;
                $data['action_url'] = $this->router->fetch_class(). '/' . 'delete'.'/'.$profile_name;
                echo json_encode($data);
            } else {
                $data['message'] = 'You cannot delete <b>' . $profile_name . '</b>. It is still being used by:<br>';
                foreach ($reason as $k) $data['message'] = $data['message'].'<br>'.$k;
            
                //for ajax json data return
                $data['message_type'] = 'notice';
                $data['result'] = false;
                echo json_encode($data);
            } 
        }else{
            //for ajax json data return
            $data['message'] = 'No profile name found';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
        
    }
    /**
     * Delete a sip profile
     *
     * @param string $profile_name
     *                             sip profile being deleted
     */
    public function delete($profile_name)
    {
        // Check post request
        $post = $this->input->post();
        if (isset($this->_sip_profiles[$profile_name])) {
            $sip = $this->_sip_profiles[$profile_name];
            //Dispose all SIP Limits attached to profile
            $limits = $sip->request_limits();
            if (!empty($limits)) {
                foreach ($limits as $limit) {
                    $limit_del = $limits[$limit->name() ];
                    $limit_del->dispose();
                }
            }
            //Dispose SIP Profile
            $sip->dispose();
            //return redirect url
            $data['result'] = true;
            $data['redirect_url'] =  $this->router->fetch_class();
            echo json_encode($data);
        }else{
            $data['message'] = 'No profile name found!';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Modifies an existing SIP Limit
     * @param String $profile_name:
     *                              Profile being modified
     */
    public function edit_limit($sip_profile, $profile_name)
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($profile_name)) exit('Limit Profile required');
        $sip = $this->_sip_profiles[$sip_profile];
        $this->_limit_profiles = $sip->request_limits();
        if (isset($this->_limit_profiles[$profile_name])){
            $limit = $this->_limit_profiles[$profile_name];
            $new_obj = false;
        }else{
            $limit = new Fs_sip_request_limit_config_class($this->_the_app->node() , $this->_the_app->object_name() . '/profile/sip/' . $sip_profile . '/limits', $profile_name);
            $limit->configure();
            $new_obj = true;
        }
        // Check post request
        $post = $this->input->post();
        if (isset($post['cancel'])) {
            redirect('/' . $this->router->fetch_class() . '/modify/' . $sip_profile, 'refresh');
        } elseif (isset($post['save'])) {
            // TODO(wadam) - Validate and save
            //print_r($post);
            unset($post['save']);
            $limit->set_data_values($post);
            // Prepare an array to retreive errors if any
            $validation_errors = array();
            // Prepare the form for validation with posted data
            // Note that this is the form that will be used by edit code (after this if/else block)
            // if the validation fail
            $this->load->library('safe_form_class', $limit->get_data());
            // Check new data are valid
            if ($this->safe_form_class->run_validation($validation_errors)) {
                if (TRUE == $limit->save()) redirect('/' . $this->router->fetch_class() . '/modify/' . $sip_profile, 'refresh');
            }
        }
        // Set the basic data
        $data['page_title'] = 'SIP Limit Profile';
        $data['page_summary'] = 'This page allows managing SIP profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $config = $limit->get_data();
        $this->load->library("safe_form_class", $config);
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $data['form_cfg'] = $form_config;
        // Get the fields group
        // send the group array in our form view
        $field_group = array();
        $field_group = $limit->get_group();
        $data['group'] = $field_group;
        // set the form attributes
        $frm_attributes = array(
            'id' => 'limit'
        );
        $this->safe_form_class->set_form_attributes($frm_attributes);
        $data['form_title'] = 'SIP Limit Rule';
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
            array(
                'name' => 'save',
                'value' => 'Save',
                'type' => 'submit'
            ) ,
            array(
                'name' => 'cancel',
                'value' => 'Cancel',
                'type' => 'submit'
            ) ,
        );
        $this->load->view("safe_header", $data);
        $this->load->view("safe_form", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * confirm to Deletes a sip limit from the sip profile
     *
     * @param string $sip_profile
     *                            SIP Profile which limit being deleted is attached to
     * @param string $limit_name
     *                            username being deleted from a profile
     */
    public function delete_confirm_limit($sip, $limit_profile)
    {
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'Delete SIP Limit';
        $sip_profile = $this->_sip_profiles[$sip];
        $limits = $sip_profile->request_limits();
        if (isset($limits[$limit_profile])) {
            $limit = $limits[$limit_profile];
            //Check to make sure you can delete, then delete the object
            if ($limit->can_dispose()) {
                $data['message'] = 'Are you sure you would like to delete this rule?';
                $data['message_type'] = 'notice';
                $data['result'] = true;
                $data['action_url'] = base_url($this->router->fetch_class()). '/delete_limit/'.$sip.'/'.$limit_profile;
                echo json_encode($data);
            } else {
                $data['message'] = 'The SIP Limit cannot be removed.';
                $data['message_type'] = 'notice';
                $data['result'] = false;
                echo json_encode($data);
            }
        } else {
            $data['message'] = 'No SIP Limit profile found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Deletes a sip limit from the sip profile
     *
     * @param string $sip_profile
     *                            SIP Profile which limit being deleted is attached to
     * @param string $limit_name
     *                            username being deleted from a profile
     */
    public function delete_limit($sip, $limit_profile)
    {
        // verify if logged
        //safe_authenticate ();
        // Check post request
        $post = $this->input->post();
        $sip_profile = $this->_sip_profiles[$sip];
        $limits = $sip_profile->request_limits();
        if (isset($limits[$limit_profile])) {
            $limit = $limits[$limit_profile];
            $limit->dispose();
            //return redirect url
            $data['result'] = true;
            $data['redirect_url'] =  base_url($this->router->fetch_class()). '/modify/' . $sip;
            echo json_encode($data);
        }else{
            //return error message
            $data['message'] = 'No SIP Limit profile found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    
    public function dump()
    {
        foreach ($this->_the_app->sip_profiles() as $profile) {
            echo '</br>';
            echo "Profile " . $profile->name() . '</br>';
            print_r($profile->get_data_values(false));
        }
        foreach ($this->_the_app->media_profiles() as $profile) {
            echo '</br>';
            echo "Profile " . $profile->name() . '</br>';
            print_r($profile->get_data_values(false));
        }
        foreach ($this->_the_app->proxy_profiles() as $profile) {
            echo '</br>';
            echo "Profile " . $profile->name() . '</br>';
            print_r($profile->get_data_values(false));
        }
    }
}
?>
