<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC Carrier Profile Page
 *
 * @author Shaunt Libarian
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('crud_table');
safe_require_class('form');
class Nsc_carrier_profile_param_class extends safe_configurable_object_class
{
    public function __construct()
    {
        parent::__construct('autofill', 'Nsc_carrier_profile_param_class');
    }
    public function configure($rule_count)
    {
        $c = $rule_count + 1;
        $this->add_field('profile-name', 'Profile Name', 'string', 'NSC_new_carrier_profile' . $c, 50);
        $this->set_field_rules('profile-name', 'required|alpha_dash');
        parent::configure();
        //$this->synch();
        
    }
}
class Nsc_carrier_rate_param_class extends Safe_configurable_object_class
{
    public function __construct()
    {
        parent::__construct('autofill', 'Nsc_carrier_rate_param_class');
    }
    public function configure($rule_count = 0)
    {
        $c = $rule_count + 1;
        $this->add_field('rate_name', 'Carrier Rate', 'string', 'new_carrier_rate' . $c, 50);
        $this->set_field_rules('rate_name', 'required|alpha_dash');
        parent::configure();
        //$this->synch();
        
    }
}
class Nsc_carrier_profile extends Safe_CI_Controller
{
    public $_carrier_profile;
    public function __construct()
    {
        parent::__construct();
        $this->_carrier_profile = $this->_the_app->carrier_profiles(); //Holds all Carrier Profiles
        
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Carrier Profiles';
        $data['page_summary'] = 'This page allows managing carrier profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        //Prepare table structure
        $data['table_size'] = '100%';
        $table = new Safe_crud_table_class();
        $data['table_title'] = $table->set_title('Carrier Profiles');
        // Prepare heading
        $table->set_headings(array(
            'Name',
            'Status'
        ));
        $table->set_controller_url($this->router->fetch_class());
        //print_r ($this->_carrier_profile);
        foreach ($this->_carrier_profile as $profile) {
            if (isset($profile)) {
                $prof_data = $profile->get_data_values();
                $table->add_row(array(
                    $profile->name() ,
                    $prof_data['enabled']
                ) , $profile->name() , 'Modify|Delete:confirm', '');
            }
        }
        $table->allow_create(true);
        // Generate table HTML code
        $data['table'] = $table->generate_table();
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Function create a json encoded form to adds a new carrier profile
     *   using popup dialog in browser
     */
    public function add_form($reload=false)
    {
        $rule_count = 0;
        // Set the basic data
        $data['page_title'] = 'New Carrier Profile';
        if (!empty($this->_carrier_profile)) {
            foreach ($this->_carrier_profile as $carrier) {
                $rule_count++;
            }
        }
        $param = new Nsc_carrier_profile_param_class();
        $param->configure($rule_count);
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $data['form_cfg'] = $form_config;
        $data['form_title'] = 'Carrier profile : New Profile';
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
                array(
                        'name' => 'create',
                        'value' => 'Create',
                        'type' => 'submit'
                ) ,
                array(
                        'name' => 'cancel',
                        'value' => 'Cancel',
                        'type' => 'submit'
                ) ,
        );
        //******
        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $this->load->view("safe_form_json", $data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        
        $data['page_title'] = $data['form_title'];
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        } 
        $data['reload'] = $reload;
        $data['action_url'] = base_url($this->router->fetch_class().'/add/');
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * Function which adds a new carrier profile
     */
    public function add()
    {
        // verify if logged
        //safe_authenticate ();
        $rule_count = 0;
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'New Carrier Profile';
        if (!empty($this->_carrier_profile)) {
            foreach ($this->_carrier_profile as $carrier) {
                $rule_count++;
            }
        }
        $param = new Nsc_carrier_profile_param_class();
        $param->configure($rule_count);
        
        /*$wizard_data = $param->get_data_values();
         $wizard_data['profile-name'] = $post['profile-name'];
        $param->set_data_values($wizard_data);
        $param->serialize();*/
            
        // Prepare an array to retreive errors if any
        $validation_errors = array();
        $param->set_data_values($post);
        $this->load->library('safe_form_class', $param->get_data());
        // Check new data are valid
        if ($this->safe_form_class->run_validation($validation_errors)) {
            if (isset($this->_carrier_profile[$post['profile-name']])) {
                //Profile exists, throw an error
                $data['message'] = "<b>" . $post['profile-name'] . "</b> exists. Please use a different profile name";
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            } else {
                $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit_profile/' . $post['profile-name']);
                $data['result'] = true;
                echo json_encode($data);
            }
        }else{
          //return a json encode form with a error message
          $this->add_form(true);
        }
    }
    /**
     * Delete a carrier profile
     *
     * @param string $profile_name carrier profile being deleted
     *                             				
     */
    public function delete($profile_name)
    {
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'Delete Carrier Profile';
        if (isset($this->_carrier_profile[$profile_name])) {
            //dispose all carrier_rates attached to current profile
            $carrier = $this->_carrier_profile[$profile_name];
            $rates = $carrier->carrier_rate();
            if (isset($rates)) {
                foreach ($rates as $rate) {
                    $rate_del = $rates[$rate->name() ];
                    $rate_del->dispose();
                }
            }
            $carrier->dispose();
            //return redirect url
            $data['result'] = true;
            $data['redirect_url'] =  $this->router->fetch_class();
            echo json_encode($data);
        }else{
            //return error message
            $data['message'] = 'No profile name found!';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    
    /**
     * Confirm to Delete a carrier profile
     *
     * @param string $profile_name carrier profile being deleted
     *  
     */
    public function delete_confirm($profile_name)
    {
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'Delete Carrier Profile';
        
        if (isset($this->_carrier_profile[$profile_name])) {
            $sip = $this->_carrier_profile[$profile_name];
            //Check to make sure you can delete, then delete the object
            if ($sip->can_dispose($profile_name)) {
                $data['message'] = 'Are you sure you would like to delete <b>' . $profile_name . '</b>?<br>'.
                                           'Deleting <b>' . $profile_name . '</b> will remove least cost routing rules as well.';
                $data['message_type'] = 'notice';
                //for ajax json data return
                $data['result'] = true;
                $data['action_url'] = $this->router->fetch_class(). '/' . 'delete'.'/'.$profile_name;
                echo json_encode($data);
            } else {
                $data['message'] = 'You cannot delete <b>' . $profile_name . '</b>. It is still being used by a SIP Trunk!<br>'.
                                             safe_form_with_submit_button('Click here to view all ', '/SAFe/nsc_sip_trunk', 'SIP Trunks', '');
                //add style for warning msg
                $data['message_type'] = 'notice';
                //for ajax json data return
                 $data['result'] = false;
                 echo json_encode($data);
            }
        }else{
            //for ajax json data return
            $data['message'] = 'No profile name found';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    
    
    /**
     * Modifies an existing carrier profile
     * @param String $profile_name:Profile being modified
     *                              					
     */
    public function edit_profile($profile_name)
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($profile_name)) exit('Profile name required');
        $carrier_profile = $this->_carrier_profile[$profile_name];
        $new_obj = false;
        if(!$carrier_profile) {
            $carrier_profile = new Nsc_lcr_carrier_class($this->_the_app->node() , $this->_the_app->object_name() . '/profile/carrier', $profile_name);
            $carrier_profile->configure();
            $new_obj = true;
        }
        // Check post request
        $post = $this->input->post();
        if (isset($post['cancel'])) {
            if($new_obj){
                redirect(base_url('/' . $this->router->fetch_class()));
            }else{
                redirect('/' . $this->router->fetch_class() . '/modify/' . $profile_name, 'refresh');
            }
        } elseif (isset($post['save'])) {
            // TODO(wadam) - Validate and save
            //print_r($post);
            unset($post['save']);
            $carrier_profile->set_data_values($post);
            // TODO(wadam) - run validation
            if (TRUE == $carrier_profile->save()) redirect('/' . $this->router->fetch_class() . '/modify/' . $profile_name, 'refresh');
        }
        // Set the basic data
        $data['page_title'] = $carrier_profile->name() . ' Carrier Profile';
        $data['page_summary'] = 'This page allows managing carrier profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $config = $carrier_profile->get_data();
        $this->load->library("safe_form_class", $config);
        $data['form_title'] = 'Carrier profile : ' . $carrier_profile->name();
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
            array(
                'name' => 'save',
                'value' => 'Save',
                'type' => 'submit'
            ) ,
            array(
                'name' => 'cancel',
                'value' => 'Cancel',
                'type' => 'submit'
            ) ,
        );
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $data['form_cfg'] = $form_config;
        $this->load->view("safe_header", $data);
        $this->load->view("safe_form", $data);
        $this->load->view("safe_footer", $data);
    }
    public function modify($profile_name)
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($profile_name)) exit('Profile name required');
        $carrier_profile = $this->_carrier_profile[$profile_name];
        // Set the basic data
        $data['page_title'] = $carrier_profile->name() . ' Carrier Profile';
        $data['page_summary'] = 'This page allows managing carrier profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $config = $carrier_profile->get_data_values();
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
        //Load a bar to go back to main page
        $data['notif_warn'][] = safe_form_with_submit_button('Please click here to ', '/SAFe/nsc_carrier_profile', 'view all profiles', '');
        $this->load->view("safe_notifications", $data);
        $table = new Safe_crud_table_class();
        $data['table_size'] = '100%';
        $data['table_title'] = $table->set_title('Carrier Profile: ' . $carrier_profile->name());
        $table->set_controller_url($this->router->fetch_class());
        $table->set_url_suffix('profile');
        $table->primary_key = $profile_name;
        $table_line = array(
            'Enabled' => $config['enabled'],
            '' => $table->create_button(true, 'Edit', $button_css_class = '', $table->primary_key) /*.
             $table->create_button(true, 'Cancel', $button_css_class='', '')*/
        );
        // Generate table HTML code
        $data['table'] = $table->generate_vertical_line_table('', $profile_name, $table_line);
        $this->load->view("safe_table", $data);
        //Display lcr rules
        $this->display_lcr($profile_name);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Function create a json encoded form to adds a new rate plan record
     *   using popup dialog in browser
     */
    public function add_form_rate($carrier_name,$reload=false)
    {
        $rule_count = 0;
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'New Carrier Rate Plan';
        $carrier_profile = $this->_carrier_profile[$carrier_name];
        $carrier_rates = $carrier_profile->carrier_rate();
        if (isset($carrier_rates)) {
            foreach ($carrier_rates as $rates) {
                $rule_count++;
            }
        }
        $param = new Nsc_carrier_rate_param_class();
        $param->configure($rule_count);
        
        unset($post);
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $data['form_cfg'] = $form_config;
        $data['form_title'] = 'Carrier Rate : New Rate Plan Record';
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
                array(
                        'name' => 'create',
                        'value' => 'Create',
                        'type' => 'submit'
                ) ,
                array(
                        'name' => 'cancel',
                        'value' => 'Cancel',
                        'type' => 'submit'
                ) ,
        );
        //******
        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $this->load->view("safe_form_json", $data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        
        $data['page_title'] = $data['form_title'];
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        } 
        $data['reload'] = $reload;
        $data['action_url'] = base_url($this->router->fetch_class().'/add_rate/'.$carrier_name);
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * Add a new rate plan record
     */
    public function add_rate($carrier_name)
    {
        // verify if logged
        //safe_authenticate ();
        $rule_count = 0;
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'New Carrier Rate Plan';
        $carrier_profile = $this->_carrier_profile[$carrier_name];
        $carrier_rates = $carrier_profile->carrier_rate();
        if (isset($carrier_rates)) {
            foreach ($carrier_rates as $rates) {
                $rule_count++;
            }
        }
        $param = new Nsc_carrier_rate_param_class();
        $param->configure($rule_count);
        
        $wizard_data = $param->get_data_values();
        $wizard_data['user_id'] = $post['rate_name'];
        $param->set_data_values($wizard_data);
        $param->serialize();
        // Check that profile does not exist
        
        // Prepare an array to retreive errors if any
        $validation_errors = array();
        $param->set_data_values($post);
        // Prepare the form for validation with posted data
        // Note that this is the form that will be used by edit code (after this if/else block)
        // if the validation fail
        $this->load->library('safe_form_class', $param->get_data());
        // Check new data are valid
        if ($this->safe_form_class->run_validation($validation_errors)) {
            if (isset($carrier_rates[$post['rate_name']])) {
                //Profile exists, throw an error
                $data['message'] = "<b>" . $post['rate_name'] . "</b> exists. Please use a different rate plan name";
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            } else {
                if ($new_obj = new Nsc_lcr_rate_class($this->_the_app->node() , $this->_the_app->object_name() . '/profile/carrier/' . $carrier_name . '/rate', $post['rate_name'])) {
                    $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit_rate/' . $carrier_name . '/' . $post['rate_name']);
                    $data['result'] = true;
                    echo json_encode($data);
                }
            }
        }else{
          //return a json encode form with a error message
          $this->add_form_rate($carrier_name,true);
        }
    }
    /**
     * Modifies an existing carrier rate
     * @param String $profile_name:
     *                              					rate being modified
     * @param String $carrier_name:
     *                              					carrier being modified
     */
    public function edit_rate($carrier_name, $profile_name)
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($profile_name)) exit('Carrier Rate Name Required');
        $carrier_profile = $this->_carrier_profile[$carrier_name];
        $rates = $carrier_profile->carrier_rate();
        $rate = $rates[$profile_name];
        
        $new_obj = false;
        if(!$rate) {
            $rate = $new_obj = new Nsc_lcr_rate_class($this->_the_app->node() , $this->_the_app->object_name() . '/profile/carrier/' . $carrier_name . '/rate', $profile_name); 
            $rate->configure();
            $new_obj = true;
        }
        // Check post request
        $post = $this->input->post();
        if (isset($post['cancel'])) {
            redirect('/' . $this->router->fetch_class() . '/modify/' . $carrier_name, 'refresh');
        } elseif (isset($post['save'])) {
            // TODO(wadam) - Validate and save
            //print_r($post);
            unset($post['save']);
            $rate->set_data_values($post);
            // Prepare an array to retreive errors if any
            $validation_errors = array();
            $rate->set_data_values($post);
            // Prepare the form for validation with posted data
            // Note that this is the form that will be used by edit code (after this if/else block)
            // if the validation fail
            $this->load->library('safe_form_class', $rate->get_data());
            // Check new data are valid
            if ($this->safe_form_class->run_validation($validation_errors)) {
                if (TRUE == $rate->save()) redirect('/' . $this->router->fetch_class() . '/modify/' . $carrier_name, 'refresh');
            }
        }
        // Set the basic data
        $data['page_title'] = $profile_name . ' Carrier LCR Rate';
        $data['page_summary'] = 'This page allows managing carrier profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $config = $rate->get_data();
        $this->load->library("safe_form_class", $config);
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $data['form_cfg'] = $form_config;
        $data['form_title'] = 'Carrier LCR Rate : ' . $profile_name;
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
            array(
                'name' => 'save',
                'value' => 'Save',
                'type' => 'submit'
            ) ,
            array(
                'name' => 'cancel',
                'value' => 'Cancel',
                'type' => 'submit'
            ) ,
        );
        $this->load->view("safe_header", $data);
        $this->load->view("safe_form", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Confirm to Deletes a rate from a carrier
     *
     * @param string $carrier_name
     *                             				carrier profile name
     * @param string $rate_profile
     *                             				rate being deleted from a profile
     */
    public function delete_confirm_rate($carrier_name, $rate_profile)
    {
        $data['page_title'] = 'Delete LCR Rate';
        $carrier_profile = $this->_carrier_profile[$carrier_name];
        $rates = $carrier_profile->carrier_rate();
        if (isset($rates[$rate_profile])) {
            $rate = $rates[$rate_profile];
            //Check to make sure you can delete, then delete the object
            $reason = array();
            if ($rate->can_dispose($reason)) {
                $data['message'] = 'Are you sure you would like to delete <b>' . $rate_profile . '</b>?';
                $data['message_type'] = 'notice';
                $data['result'] = true;
                $data['action_url'] = base_url($this->router->fetch_class()). '/delete_rate/'.$carrier_name.'/'.$rate_profile;
                echo json_encode($data);
            }else{
                $reason_msg='';
                if($reason){
                    $reason_msg =(is_array($reason)) ? implode('<br>',$reason) : $reason;
                }
                $reason_msg = ($reason_msg=='')?'':'<br>'.$reason_msg;
                $data['message'] = 'Delete LCR Rate '.$rate_profile.' Failed'.$reason_msg;
                $data['message_type'] = 'notice';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            $data['message'] = 'No LCR Rate found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Deletes a rate from a carrier
     *
     * @param string $carrier_name
     *                             				carrier profile name
     * @param string $rate_profile
     *                             				rate being deleted from a profile
     */
    public function delete_rate($carrier_name, $rate_profile)
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Delete LCR Rate';
        $carrier_profile = $this->_carrier_profile[$carrier_name];
        $rates = $carrier_profile->carrier_rate();
        if (isset($rates[$rate_profile])) {
            $rate = $rates[$rate_profile];
            $rate->dispose();
            $data['result'] = true;
            $data['redirect_url'] = base_url( $this->router->fetch_class()). '/modify/' . $carrier_name;
            echo json_encode($data);
            //redirect('/' . $this->router->fetch_class() . '/modify/' . $carrier_name, 'refresh');
        }else{
            //return error message
            $data['message'] = 'No LCR Rate found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    function display_lcr($profile_name)
    {
        //Prepare table structure
        $table = new Safe_crud_table_class();
        $data['table_size'] = '100%';
        $data['table_title'] = $table->set_title('Least Cost Routing Rates: ' . $profile_name);
        // Prepare heading
        $table->set_headings(array(
            'Name',
            'Description'
        ));
        $table->set_controller_url($this->router->fetch_class());
        $table->set_url_suffix('rate/' . $profile_name);
        $carrier_profile = $this->_carrier_profile[$profile_name];
        $rate = $carrier_profile->carrier_rate();
        $table->primary_key = "";
        if (isset($rate)) {
            foreach ($rate as $profile) {
                if (isset($profile)) {
                    $prof_data = $profile->get_data_values();
                    $table->add_row(array(
                        $profile->name() ,
                        $profile->description() ,
                    ) , $profile->name() , 'Edit|Delete:confirm', '', true);
                }
            }
        }
        $table->set_url_suffix('rate');
        $table->allow_create(true, $profile_name);
        // Generate table HTML code
        $data['table'] = $table->generate_table();
        $this->load->view("safe_table", $data);
    }
}
?>
