<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC CAC Rule
 * @author Shaunt Libarian
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('object');
safe_require_class('crud_table');
safe_require_class('form');
safe_module_require_class('fs', 'cac_rule');
safe_module_require_class('fs', 'user_cac_condition');
safe_module_require_class('fs', 'ipaddr_cac_condition');
class Nsc_cac_sip_profile_param_class extends Safe_configurable_object_class
{
    public $_sip_profiles;
    public $_cac_rules;
    public $_the_product;
    public $_the_app;
    public function __construct()
    {
        //parent::__construct('autofill','Nsc_sip_domain_profile_class');
        
    }
    public function configure($profile)
    {
        $this->_the_product = Safe_get_product();
        $this->_the_app = $this->_the_product->local_node()->software()->application();
        $this->_sip_profiles = $this->_the_app->sip_profiles(); //Holds all SIP Profiles
        $this->_cac_rules = $this->_the_app->cac_rules(); //Holds all cac_rules
        $def_name = array();
        $names = array();
        //$sip_profile = $this->_sip_profiles[$profile];
        $cac_rule = $this->_cac_rules[$profile];
        $config = $cac_rule->get_data_values();
        //Set sip profiles
        if (isset($this->_sip_profiles)) {
            foreach ($this->_sip_profiles as $profile) {
                if (isset($profile)) {
                    $prof_data = $profile->get_data_values_exploded(false);
                    $names[] = $profile->name();
                }
            }
        }
        foreach ($config['sip-profiles'] as $sip) {
            foreach ($this->_sip_profiles as $profile) {
                if (isset($profile)) {
                    if (trim(strtolower($profile->name())) == trim(strtolower($sip))) $def_name[] = $profile->name();
                }
            }
        }
        $this->add_multiple_field('sip-profiles[]', '', 'checkbox', $def_name, $names);
    }
}
class Nsc_cac_rule_param_class extends Safe_configurable_object_class
{
    public function __construct()
    {
        parent::__construct('autofill', 'Nsc_CAC_condition');
    }
    public function configure($rule_count = 0)
    {
        $c = $rule_count + 1;
        $this->add_field('profile-name', 'Profile Name', 'string', 'CAC_Profile' . $c, 50);
        $this->set_field_rules('profile-name', 'required|alpha_dash');
        parent::configure();
        //$this->synch();
        
    }
}
class Nsc_new_cac_condition_param_class extends Safe_configurable_object_class
{
    public function __construct()
    {
        parent::__construct('autofill', 'Nsc_CAC_rule');
    }
    public function configure($rule_count = 0)
    {
        $rule_types = array(
            'user' => 'User Rule',
            'ipaddr' => 'IP Address Rule'
        );
        $c = $rule_count + 1;
        $this->add_field('condition_name', 'Rule Name', 'string', 'Rule' . $c, 50);
        $this->set_field_rules('condition_name', 'required|alpha_dash');
        $this->add_enum_field('rule_type', 'Condition Type', 'dropdown', '', $rule_types);
        parent::configure();
        //$this->synch();
        
    }
}
class Nsc_cac_rules extends Safe_CI_Controller
{
    private $_cac_rules = array();
    public function __construct()
    {
        parent::__construct();
        $this->_cac_rules = $this->_the_app->cac_rules();
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'CAC Profile';
        $data['page_summary'] = 'This page allows managing Call Admission Control conditions.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        //Prepare table structure
        $data['table_size'] = '100%';
        $table = new Safe_crud_table_class();
        $data['table_title'] = $table->set_title('Call Admission Control Profiles');
        // Prepare heading
        $table->set_headings(array(
            'Name',
            'SIP Profiles',
        ));
        $table->set_controller_url($this->router->fetch_class());
        foreach ($this->_cac_rules as $profile) {
            // Get the SIP profiles
            $sip_profiles = $profile->profile_binding();
            $sip_list = '';
            foreach($sip_profiles as $sip_profile) {
                $sip_list .= '<li>'.$sip_profile.'</li>';
            }
            $prof_data = $profile->get_data_values();
            $table->add_row(array(
                $profile->name() ,
                $sip_list,
            ) , $profile->name() , 'Modify|Delete:confirm', '');
        }
        $table->allow_create(true);
        // Generate table HTML code
        $data['table'] = $table->generate_table();
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Function create a json encoded form to Adds a CAC rule
     *   using popup dialog in browser
     */
    public function add_form($reload=false)
    {
        $rule_count = 0;
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'CAC Profiles';
        if (isset($this->_cac_rules)) {
            foreach ($this->_cac_rules as $rule) {
                $rule_count++;
            }
        }
        $param = new Nsc_cac_rule_param_class();
        $param->configure($rule_count);
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $data['form_cfg'] = $form_config;
        $data['form_title'] = 'CAC Profiles: New CAC Profile';
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
                array(
                        'name' => 'create',
                        'value' => 'Create',
                        'type' => 'submit'
                ) ,
                array(
                        'name' => 'cancel',
                        'value' => 'Cancel',
                        'type' => 'submit'
                ) ,
        );
        //******
        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $this->load->view("safe_form_json", $data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        
        $data['page_title'] = $data['form_title'];
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        } 
        $data['reload'] = $reload;
        $data['action_url'] = base_url($this->router->fetch_class().'/add/');
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * Adds a CAC rule
     */
    public function add()
    {
        // verify if logged
        //safe_authenticate ();
        $rule_count = 0;
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'CAC Profiles';
        if (isset($this->_cac_rules)) {
            foreach ($this->_cac_rules as $rule) {
                $rule_count++;
            }
        }
        $param = new Nsc_cac_rule_param_class();
        $param->configure($rule_count);
        //$wizard_data = $param->get_data_values();
        //$wizard_data['profile-name'] = $post['profile-name'];
        //$param->set_data_values($wizard_data);
        //$param->serialize();
        //$param->set_data_values($post);
        $this->load->library('safe_form_class', $param->get_data());
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        if ($this->safe_form_class->run_validation($validation_errors)) {
            $validation_errors = array();
            if (isset($this->_cac_rules[$post['profile-name']])) {
                //Profile exists, throw an error
                $data['message'] = "<b>" . $post['profile-name'] . "</b> exists. Please use a different profile name";
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            }else{
                $new_obj = new Fs_cac_rule_class($this->_the_app->node() , $this->_the_app->object_name() . '/profile/sip/cac', $post['profile-name']);
                $new_obj->configure();
                $new_obj->synch();
                unset($post['create']);
                $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/modify/' . $post['profile-name']);
                $data['result'] = true;
                echo json_encode($data);
            }
        }else{
          //return a json encode form with a error message
          $this->add_form(true);
        }
    }
    /**
     * Function create a json encoded form to Create a new condition for an existing rule
     */
    public function add_form_condition($rule_name,$reload=false)
    {
        $rule_count = 0;
        // Set the basic data
        $data['page_title'] = 'CAC Profiles';
        $cac = $this->_cac_rules[$rule_name];
        if (isset($this->_cac_rules)) {
            $conditions = $cac->conditions();
            if (isset($conditions)) {
                foreach ($conditions as $condition) $rule_count++;
            }
        }
        $param = new Nsc_new_cac_condition_param_class();
        $param->configure($rule_count);
        
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $data['form_cfg'] = $form_config;
        $data['form_title'] = $rule_name . ': New Rule';
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
                array(
                        'name' => 'create',
                        'value' => 'Create',
                        'type' => 'submit'
                ) ,
                array(
                        'name' => 'cancel',
                        'value' => 'Cancel',
                        'type' => 'submit'
                ) ,
        );
        //******
        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $this->load->view("safe_form_json", $data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        
        $data['page_title'] = $data['form_title'];
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        } 
        $data['reload'] = $reload;
        $data['action_url'] = base_url($this->router->fetch_class().'/add_condition/'.$rule_name);
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * Create a new condition for an existing rule
     * @param string $rule_name
     *                          					CAC Rule being modified
     */
    public function add_condition($rule_name)
    {
        // verify if logged
        //safe_authenticate ();
        $data['message'] ='';
        $rule_count = 0;
        // Check post request
        $post = $this->input->post();
        $allow_rule_type = array( 'user', 'ipaddr' );
        if(isset($post['rule_type']) && in_array($post['rule_type'],$allow_rule_type))
        {
            $rule_type = $post['rule_type'];
        }else{
            $rule_type = '';
            $data['message'] = "<b>Rule_type</b> not set. ";
        }
        // Set the basic data
        $data['page_title'] = 'CAC Profiles';
        if (isset($this->_cac_rules[$rule_name])) {
            $cac = $this->_cac_rules[$rule_name];
            $conditions = $cac->conditions($rule_type);
            if (isset($conditions)) {
                foreach ($conditions as $condition) $rule_count++;
            }
        }else{
            $data['message'] = "<b>" . $rule_name . "</b> not exists. ";
        }
        $param = new Nsc_new_cac_condition_param_class();
        $param->configure($rule_count);
        
        /*$wizard_data = $param->get_data_values();
         $wizard_data['condition_name'] = $post['condition_name'];
        $wizard_data['rule_type'] = $post['rule_type'];
        $param->set_data_values($wizard_data);
        $param->serialize();*/
        // Check that profile does not exist
        
        // Prepare an array to retreive errors if any
        if($data['message'] =='')
        {
            $validation_errors = array();
            $param->set_data_values($post);
            $this->load->library('safe_form_class', $param->get_data());
            if ($this->safe_form_class->run_validation($validation_errors)) {
                if (isset($conditions[$post['condition_name']])) {
                    //Profile exists, throw an error
                    $data['message'] = "<b>" . $post['condition_name'] . "</b> exists. Please use a different rule name";
                    $data['message_type'] = 'alert';
                    $data['result'] = false;
                    echo json_encode($data);
                } else {
                    $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit_condition/' . $rule_name . '/' . $post['rule_type']. '/' . $post['condition_name'] );
                    $data['result'] = true;
                    echo json_encode($data);
                }
            }else{
              //return a json encode form with a error message
              $this->add_form_condition($rule_name,true);
            }
        }else{
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * confirm to Deletes a CAC Rule and All Conditions attached to CAC Rule
     *
     * @param string $rule_name
     *                          				CAC Rule being deleted
     */
    public function delete_confirm($rule_name)
    {
        // Set the basic data
        $data['page_title'] = 'Delete Call Admission Control Profiles';
        $cac = $this->_cac_rules[$rule_name];
        if (isset($this->_cac_rules[$rule_name])) {
            $rule = $this->_cac_rules[$rule_name];
            //Check to make sure you can delete, then delete the object
            $reason = array();
            if ($rule->can_dispose($reason)) {
                $data['message'] = 'Are you sure you would like to delete <b>' . $rule_name . '</b>?';
                $data['message_type'] = 'notice';
                $data['result'] = true;
                $data['action_url'] = base_url($this->router->fetch_class()). '/delete/'.$rule_name;
                echo json_encode($data);
            }else{
                $reason_msg='';
                if($reason){
                    $reason_msg =(is_array($reason)) ? implode('<br>',$reason) : $reason;
                }
                $reason_msg = ($reason_msg=='')?'':'<br>'.$reason_msg;
                $data['message'] = 'Delete Call Admission Control Profile '.$rule_name .' Failed'.$reason_msg;
                $data['message_type'] = 'notice';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            $data['message'] = 'No Call Admission Control Profiles found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Deletes a CAC Rule and All Conditions attached to CAC Rule
     *
     * @param string $rule_name
     *                          				CAC Rule being deleted
     */
    public function delete($rule_name)
    {
        // Set the basic data
        $data['page_title'] = 'Delete Call Admission Control Profiles';
        $cac = $this->_cac_rules[$rule_name];
        if (isset($this->_cac_rules[$rule_name])) {
            $conditions = $cac->conditions();
            if (isset($conditions)) {
                foreach ($conditions as $condition) $condition->dispose();
            }
            $cac->dispose();
            //return redirect url
            $data['result'] = true;
            $data['redirect_url'] = base_url( $this->router->fetch_class());
            echo json_encode($data);
        }else{
            //return error message
            $data['message'] = 'No Call Admission Control Profiles found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
     /**
     * Confirm to Deletes a condition from a specific rule
     */
    public function delete_confirm_condition($rule_name, $rule_type, $condition_name)
    {
        $data['message'] = '';
        // Set the basic data
        $data['page_title'] = 'Delete Call Admission Control Profile Rule Condition';
        if (isset($this->_cac_rules[$rule_name])) {
            $cac = $this->_cac_rules[$rule_name];
            $conditions = $cac->conditions($rule_type);
            if($conditions && isset($conditions[$condition_name])){
                $condition = $conditions[$condition_name];
            }else{
                $data['message'] = 'No Call Admission Control Profile Rule condition found.';
            }
        }else{
            $data['message'] = 'No Call Admission Control Profile Rule found.';
        }
        if($data['message'] == ''){
            //Check to make sure you can delete, then delete the object
            $reason = array();
            if ($condition->can_dispose($reason)) {
                $data['message'] = 'Are you sure you would like to delete <b>' . $rule_type.'/'.$condition_name . '</b>?';
                $data['message_type'] = 'notice';
                $data['result'] = true;
                $data['action_url'] = base_url($this->router->fetch_class()). '/delete_condition/'.$rule_name.'/'.$rule_type.'/'.$condition_name;
                echo json_encode($data);
            }else{
                $reason_msg='';
                if($reason){
                    $reason_msg =(is_array($reason)) ? implode('<br>',$reason) : $reason;
                }
                $reason_msg = ($reason_msg=='')?'':'<br>'.$reason_msg;
                $data['message'] = 'Delete Admission Control Profile Rule Condition '.$condition_name.' Failed'.$reason_msg;
                $data['message_type'] = 'notice';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Deletes a condition from a specific rule
     */
    public function delete_condition($rule_name, $rule_type, $condition_name)
    {
        $data['message'] = '';
        // Set the basic data
        $data['page_title'] = 'Delete Call Admission Control Profile Rules';
        if (isset($this->_cac_rules[$rule_name])) {
            $cac = $this->_cac_rules[$rule_name];
            $conditions = $cac->conditions($rule_type);
            if($conditions && isset($conditions[$condition_name])){
                $condition = $conditions[$condition_name];
            }else{
                $data['message'] = 'No Call Admission Control Profile Rule conditions found.';
            }
        }else{
            $data['message'] = 'No Call Admission Control Profile Rule name found.';
        }
        if ($data['message'] == '') {
            $condition->dispose();
            //return redirect url
            $data['result'] = true;
            $data['redirect_url'] = base_url( $this->router->fetch_class()). '/modify/' . $rule_name;
            echo json_encode($data);
        }else{
            //return error message
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Displays aggregated view of all conditions and sip profiles attached to a CAC rule
     * @param string $rule_name
     *                          							Rule being displayed in an aggregated view
     */
    public function modify($rule_name)
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($rule_name)) exit('Profile name required');
        $data['page_title'] = 'CAC Profiles';
        $data['page_summary'] = 'This page allows managing Call Admission Control Profiles.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
        //Load a bar to go back to main page
        $data['notif_warn'][] = "Editing <b>" . $rule_name . "</b>";
        $data['notif_warn'][] = safe_form_with_submit_button('Please click here to ', '/SAFe/nsc_cac_rules', 'view all profiles', '');
        $this->load->view("safe_notifications", $data);
        //Pull all CAC conditions associated to this particular rule in a CRUD Table
        $rule = $this->_cac_rules[$rule_name];
        $conditions['ipaddr'] = $rule->conditions('ipaddr');
        $conditions['user'] = $rule->conditions('user');
        //Prepare table structure
        $data['table_size'] = '100%';
        $table = new Safe_crud_table_class();
        $data['table_title'] = $table->set_title('Call Admission Control Rules');
        // Prepare heading
        $table->set_headings(array(
            'Rule Name',
            'User/IP Address',
            'Maximum Concurrent Sessions',
            'Session Rate'
        ));
        $table->set_controller_url('/' . $this->router->fetch_class());
        $table->set_url_suffix('condition');
        $count = 0;
        foreach($conditions as $k => $condition_item ){
            if (!empty($condition_item)) {
                foreach ($condition_item as $profile) {
                    $prof_data = $profile->get_data_values();
                    if (isset($prof_data['sip_received_ip'])) {
                        $condition_name = $prof_data['sip_received_ip'];
                        $rule_type = 'ipaddr';
                    }
                    elseif (isset($prof_data['sip_auth_username'])) {
                        $condition_name = $prof_data['sip_auth_username'];
                        $rule_type = 'user';
                    }
                    $table->add_row(array(
                            $profile->name() ,
                            $condition_name,
                            $prof_data['max'],
                            $prof_data['rate1'] . '/' . $prof_data['rate2']
                    ) , $rule_name . '/'.$k.'/' . $profile->name() , 'Edit|Delete:confirm', '', true);
                    $count++;
                }
            }
        }
            
        $table->allow_create(true, $rule_name);
        // Generate table HTML code
        $data['table'] = $table->generate_table();
        $this->load->view("safe_table", $data);
        //Display SIP Profiles added to rule
        $this->display_sip_profiles($rule_name);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Edit a condition within a CAC Rule
     * @param string $rule_name     
     *                               							Rule which the condition belongs to
     * @param string $condition_name
     *                               							Condition being editted
     */
    public function edit_condition($rule_name,$rule_type,$condition_name)
    {
        // verify if logged
        //safe_authenticate ();
        $data['message'] = '';
        if (!isset($rule_name) || !isset($condition_name)) {
            $data['message'] = 'Rule name and condition name required';
        }
        if (isset($this->_cac_rules[$rule_name])) {
            $cac = $this->_cac_rules[$rule_name];
            $conditions = $cac->conditions($rule_type);
            if($conditions && isset($conditions[$condition_name])){
                $condition = $conditions[$condition_name];
                $new_obj = false;
            }else{
                if ($rule_type == "ipaddr") $condition = new Fs_ipaddr_cac_condition_class($this->_the_app->node() , $this->_the_app->object_name() . '/profile/sip/cac/' . $rule_name . '/ipaddr', $condition_name);
                elseif ($rule_type == "user") $condition = new Fs_user_cac_condition_class($this->_the_app->node() , $this->_the_app->object_name() . '/profile/sip/cac/' . $rule_name . '/user', $condition_name);
                $condition->configure();
                $new_obj = true;
            }
        }else{
            $data['message'] = 'No Call Admission Control Profile Rule found.';
        }
        // Check post request
        $post = $this->input->post();
        if (isset($post['cancel'])) {
            redirect(base_url($this->router->fetch_class()) . '/modify/' . $rule_name, 'refresh');
        } elseif (isset($post['save']) && $data['message'] == '') {
            unset($post['save']);
            // Prepare an array to retreive errors if any
            $validation_errors = array();
            //$condition->set_data_values($post);
            //$this->load->library('safe_form_class', $condition->get_data());
            // Check new data are valid
            $rs_update = $condition->validate($post,$validation_errors);
            if ($rs_update) {
                if (TRUE == $condition->save()) {
                    redirect(base_url($this->router->fetch_class()) . '/modify/' . $rule_name, 'refresh');
                }else{
                    $data['message'] ='Save Obj error.';
                }
            }
        }
        if ($data['message'] != ''){
            $data['notif_error'][] = $data['message'];
        }
        $safe_form = $condition->get_form();
        // Set the basic data
        $data['page_title'] = $condition->name() . ': Call Admission Control Rule';
        $data['page_summary'] = 'This page allows managing Call Admission Control conditions.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $form_config = array();
        $form_config = $safe_form->config;
        $data['form_cfg'] = $form_config;
        // Get the fields group
        // send the group array in our form view
        $field_group = array();
        $field_group = $condition->get_group();
        $data['group'] = $field_group;
        // set the form attributes
        $frm_attributes = array(
            'id' => 'sip_trunk'
        );
        $safe_form->set_form_attributes($frm_attributes);
        $data['form_title'] = 'Call Admission Control Rule: ' . $condition->name();
        $data['form'] = $safe_form->form_input_array();
        $data['label'] = $safe_form->form_label_array();
        $data['form_open'] = $safe_form->form_open();
        $data['buttons'] = array(
            array(
                'name' => 'save',
                'value' => 'Save',
                'type' => 'submit'
            ) ,
            array(
                'name' => 'cancel',
                'value' => 'Cancel',
                'type' => 'submit'
            ) ,
        );
        $this->load->view("safe_header", $data);
        
        if(count($data['notif_error'])>0)
        {
            $this->load->view("safe_notifications", $data);
        }
        $this->load->view("safe_form", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Create a form to Add a sip profile to a cac rule
     * @param string $profile_name
     *                             		CAC Rule being modified
     */
    public function bind_form_sip_profiles($profile_name)
    {
        if (isset($profile_name)){
            $cac_rule = $this->_cac_rules[$profile_name];
            $cac_compare = $cac_rule->get_data_values(false);
            $param = new Nsc_cac_sip_profile_param_class();
            $param->configure($profile_name);
            
            // Set the basic data
            $data['page_title'] = ' Call Admission Control Condition: ' . $cac_rule->name();
            //Display form with checkboxes
            $config = $param->get_data();
            $this->load->library("safe_form_class", $config);
            $data['form_title'] = 'Bind SIP Profiles';
            $data['form'] = $this->safe_form_class->form_input_array();
            $data['label'] = $this->safe_form_class->form_label_array();
            $data['form_open'] = $this->safe_form_class->form_open();
            $data['buttons'] = array(
                    array(
                            'name' => 'bind',
                            'value' => 'Bind',
                            'type' => 'submit'
                    ) ,
                    array(
                            'name' => 'cancel',
                            'value' => 'Cancel',
                            'type' => 'submit'
                    ) ,
            );
            //******
            //clear the content in page cache and get the view content
            ob_start();
            ob_clean();
            $this->load->view("safe_form_json", $data);
            $data['content'] = ob_get_contents();
            ob_clean();
            //******
            $data['page_title'] = $data['form_title'];
            $data['result'] = true;
            if($reload === true){
                $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
            }
            $data['reload'] = $reload;
            $data['action_url'] = base_url($this->router->fetch_class().'/bind_sip_profiles/'.$profile_name);
            $data['action_method'] = 'POST';
            echo json_encode($data);
        }else{
            $data['message'] = "Profile name required";
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Add a sip profile to a cac rule
     * @param string $profile_name
     *                             		CAC Rule being modified
     */
    public function bind_sip_profiles($profile_name)
    {
        $data['page_title'] = 'Bind SIP Profiles';
        // verify if logged
        //safe_authenticate ();
        if (isset($profile_name)){
            // Check post request
            $post = $this->input->post();
            $cac_rule = $this->_cac_rules[$profile_name];
            $cac_compare = $cac_rule->get_data_values(false);
            $param = new Nsc_cac_sip_profile_param_class();
            $param->configure($profile_name);
            //POST
            
            if (!empty($post['sip-profiles'])) {
                $temp = $cac_rule->get_data_values();
                //Removes old sip profile information to submit new sip profile information into object. This way you will not have duplicated sip profiles
                unset($temp['sip-profiles']);
                foreach ($post['sip-profiles'] as $sip) $temp['sip-profiles'][] = $sip;
                $cac_rule->set_data_values($temp);
                unset($post['add']);
                if (TRUE == $cac_rule->save()) {
                    $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/modify/' . $profile_name);
                    $data['result'] = true;
                    echo json_encode($data);
                }else{
                    $data['message'] = "Bind SIP Profile error";
                    $data['message_type'] = 'alert';
                    $data['result'] = false;
                    echo json_encode($data);
                }
            } else {
                $data['message'] = "Profile name required";
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            $data['message'] = "Profile name required";
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
        
    }
    
    /**
     * Displays the SIP Profile CRUD Table
     */
    public function display_sip_profiles($profile_name)
    {
        //Check to see that there are any sip profiles configured
        if (0 != sizeof($this->_the_app->sip_profiles())) {
            //Prepare table structure
            $table = new Safe_crud_table_class();
            $data['table_size'] = '100%';
            $data['table_title'] = $table->set_title('SIP Profiles');
            // Prepare heading
            $table->set_headings(array(
                'SIP Profile'
            ));
            $table->set_controller_url($this->router->fetch_class());
            $table->set_url_suffix('sip_profiles');
            unset($table->primary_key);
            $cac_rule = $this->_cac_rules[$profile_name];
            if (isset($cac_rule)) {
                foreach ($cac_rule as $profile) {
                    if (isset($profile)) {
                        foreach ($profile['sip-profiles']['default'] as $value) {
                            $primary_key = $profile_name . '/' . $value;
                            $table->add_row(array(
                                $value
                            ) , $primary_key, 'Unbind:confirm', '', true);
                        }
                    }
                }
                $table->custom_footer_button('bind', $profile_name,'create');
            }
            // Generate table HTML code
            $data['table'] = $table->generate_table();
            $this->load->view("safe_table", $data);
        } else {
            $data['notif_warn'][] = safe_form_with_submit_button('No SIP Profiles defined.', '/SAFe/nsc_sip_profiles', 'Create a SIP Profile', '');
            $this->load->view("safe_notifications", $data);
        }
    }
    /**
     * Confirm Remove a SIP Profile from a CAC Rule
     * @param string $profile_name
     *                             			CAC Rule where the SIP Profile is being removed from
     * @param string $sip_name
     *                             			SIP Profile being removed
     */
    public function unbind_confirm_sip_profiles($profile_name, $sip_name)
    {
        $data['page_title'] = 'Unbind a SIP Profile from a Call Admission Control Profile';
        if (isset($this->_cac_rules[$profile_name])) {
            $cac = $this->_cac_rules[$profile_name];
            //Check to make sure you can delete, then delete the object
            $reason = array();
            if ($cac->can_dispose($reason)) {
                $data['message'] = 'Are you sure you would like to unbind the SIP Profile <b>' . $sip_name . '</b> from the CAC Profile: <b>' . $profile_name . '</b>?<br>'.
                                    'This will not delete the SIP Profile but unbind it from the current CAC Rule';
                $data['message_type'] = 'notice';
                $data['result'] = true;
                $data['action_url'] = base_url($this->router->fetch_class()). '/unbind_sip_profiles/'.$profile_name.'/'.$sip_name;
                echo json_encode($data);
            }else{
                $reason_msg='';
                if($reason){
                    $reason_msg =(is_array($reason)) ? implode('<br>',$reason) : $reason;
                }
                $reason_msg = ($reason_msg=='')?'':'<br>'.$reason_msg;
                $data['message'] = 'Unbind the SIP Profile <b>' . $sip_name . '</b> from the CAC Profile: <b>' . $profile_name . '</b> Failed'.$reason_msg;
                $data['message_type'] = 'notice';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            $data['message'] = 'No Call Admission Control Profile found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Remove a SIP Profile from a CAC Rule
     * @param string $profile_name
     *                             			CAC Rule where the SIP Profile is being removed from
     * @param string $sip_name
     *                             			SIP Profile being removed
     */
    public function unbind_sip_profiles($profile_name, $sip_name)
    {
        // Set the basic data
        $data['page_title'] = 'Unbind a SIP Profile from a Call Admission Control Profile';
        if (isset($this->_cac_rules[$profile_name])) {
            $cac = $this->_cac_rules[$profile_name];
            $temp['sip-profiles'] = array();
            foreach ($cac as $profile) {
                for ($a = 0; $a < count($profile['sip-profiles']['default']); $a++) {
                    if ($profile['sip-profiles']['default'][$a] != $sip_name) $temp['sip-profiles'][] = $profile['sip-profiles']['default'][$a];
                }
            }
            $cac->set_data_values($temp);
            if (TRUE == $cac->save()) {
                //return redirect url
                $data['result'] = true;
                $data['redirect_url'] = base_url( $this->router->fetch_class()). '/modify/' . $profile_name;
                echo json_encode($data);
            }else{
                $data['message'] = 'Unbind the SIP Profile <b>' . $sip_name . '</b> from the CAC Profile: <b>' . $profile_name . '</b> Failed';
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            //return error message
            $data['message'] = 'No Call Admission Control Profile found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    
}
?>
