<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC Domain Users Class
 * @author: Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_module_require_class('nsc', 'application');
safe_module_require_class('fs', 'domain_user');
class Nsc_domain_users_class extends Fs_domain_users_class
{
    private $_the_app = "";
    /**
     * @brief
     *           
     * @param[in out] $node
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($node, $parent_name, $name);
        $this->_the_app = $node->software()->application();
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        $this->add_field('password', 'Password', 'password', '', 50);
        $this->set_field_rules('password', 'required');
        $this->set_field_help('password', 'SIP Password for this domain user');
        $this->add_field('effective_caller_id_name', 'Caller ID Name', 'string', '', 50);
        $this->set_field_rules('effective_caller_id_name', '');
        $this->set_field_help('effective_caller_id_name', 'Caller ID Name of this Domain User');
        $this->add_field('effective_caller_id_number', 'Caller ID Number', 'string', '', 50);
        $this->set_field_rules('effective_caller_id_number', '');
        $this->set_field_help('effective_caller_id_number', 'Caller ID Number of this Domain User.');
        $this->add_field('sip_force_expires', 'Force Expires', 'string', '', 10);
        $this->set_field_rules('sip_force_expires', 'integer|greater_or_equal[5]');
        $this->set_field_help('sip_force_expires', 'If specified, it is the number of seconds to force registration expiration to. Minimum value is 5.');
        //Add dialplans drop downs
        $dialplans = array();
        $dialplans['default'] = '-- SIP Profile Default --';
        $_dialplans = $this->_the_app->dialplans();
        foreach ($_dialplans as $dialplan) {
            $real_name = 'user-' . $dialplan->name();
            $dialplans[$real_name] = $dialplan->name();
        }
        $this->add_enum_field('call-routing', 'Routing Plan', 'dropdown', 'default', $dialplans);
        $this->set_field_help('call-routing', 'Use a specific routing plan for this domain user.');
        return parent::configure();
    }
}
?>
