<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC Application Class
 *
 */
safe_require_class('safe_db_class');
safe_module_require_class('nsc', 'domain');
safe_module_require_class('nsc', 'sip_profiles');
safe_module_require_class('nsc', 'domain_users');
safe_module_require_class('nsc', 'sipsecmon_rules_config');
safe_module_require_class('nsc', 'sip_trunk');
safe_module_require_class('nsc', 'lcr_carrier');
safe_module_require_class('nsc', 'directory_module');
safe_module_require_class('nsc', 'media_module');
safe_module_require_class('nsc', 'sip_module');
safe_module_require_class('fs', 'sngms_module');
safe_module_require_class('fs', 'cdr_module');
safe_module_require_class('fs', 'radius_module');
safe_module_require_class('fs', 'cac_rule');
safe_module_require_class('fs', 'enum_module');
safe_module_require_class('fs', 'dialplan_module');
safe_module_require_class('fs', 'media_module');
safe_module_require_class('fs', 'cac_module');
safe_module_require_class('fs', 'lcr_module');
safe_module_require_class('sng', 'rest_module');
safe_module_require_class('sng', 'update_module');
safe_module_require_class('sng', 'network_service');
class Nsc_application_class extends Fs_application_class
{
    const NSC_SERVICE_CONF_DIR = '/etc/sysconfig/';
    private $_proxy_profiles = array();
    public function __construct($software)
    {
        // Parent constructor
        parent::__construct($software, 'nsc');
        $this->set_description("Vega Session Controller");
    }
    /**
     * @brief 
     *
     * @return 
     */
    public function register_modules(){
        // Register Freeswitch modules
        $this->register_module(new Fs_sngms_module_class($this));
        $this->register_module(new Fs_cdr_module_class($this));
        $this->register_module(new Fs_enum_module_class($this));
        $this->register_module(new Fs_radius_module_class($this));
        $this->register_module(new Fs_dialplan_module_class($this));
        $this->register_module(new Fs_cac_module_class($this));
        $this->register_module(new Fs_lcr_module_class($this));
        // register base modules
        parent::register_modules();
        // Overloaded NSC modules
        $this->register_module(new Nsc_directory_module_class($this));
        $this->register_module(new Nsc_media_module_class($this));
        $this->register_module(new Nsc_sip_module_class($this));
        // SNG modules
        $this->register_module(new Sng_network_service_class($this));
        $this->register_module(new Sng_rest_module_class($this));
        $this->register_module(new Sng_update_module_class($this));
    }
    /**
     * @brief Generates the services configuration file
     *           
     * @param[in out] $config_manager
     *           
     * @return
     */
    private function _generate_services_configuration(&$config_manager)
    {
        $content = array(
            'INSTALLDIR=' . $config_manager->directory('base') ,
            'CUSTOM_PYTHON_PATH=' . $config_manager->directory('python-packages')
        );
        // Get all the services configuration
        $services = $this->node()->software()->services();
        foreach ($services as $service) {
            if ($service->config()) {
                $service_cfg = $service->config()->get_data_values_exploded(false);
                if (isset($service_cfg['global'])) {
                    foreach ($service_cfg['global'] as $k => $v) {
                        // Convert bool to proper sting
                        if (is_bool($v)) $content[] = $k . '=' . (($v) ? 'true' : 'false');
                        else $content[] = $k . '=' . $v;
                    }
                }
            }
        }
        $file = self::NSC_SERVICE_CONF_DIR . $this->name();
        $config_manager->add_config(new Safe_configuration_class($file, $content));
        return true;
    }
    /**
     * @brief Generates the application configurations files
     *           
     * @param[in out] $config_manager
     *           
     * @return
     */
    public function generate_config(&$config_manager)
    {
        // Services configuration
        if (!$this->_generate_services_configuration($config_manager)) return false;
        return parent::generate_config($config_manager);
    }
}
?>
