<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SNG modulde data manager
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('table');
safe_require_class('crud_table');
safe_require_class('form');
safe_require_class('upload');
class Sng_data_manager extends Safe_CI_Controller
{
    public function __construct()
    {
        parent::__construct();
    }
    private function _get_module($module_name)
    {
        return $this->_the_app->find_module_by_name($module_name);
    }
    private function _build_data_array($mod, &$data_cfg)
    {
        $app_data = $mod->get_data_settings();
        if (count($app_data)) {
            foreach ($app_data as $data_name => $data) {
                // Prepare buttons
                $buttons = "";
                // Prepare key
                // module name / data name
                $key = $mod->name() . '/';
                $key.= $data_name;
                foreach ($data['capabilities'] as $cap) {
                    if (strlen($buttons)) $buttons.= '|';
                    $buttons.= $cap;
                }
                // Get data count
                $count = $mod->get_data_count($data_name);
                $data_cfg[] = array(
                    'module' => $mod->description() ,
                    'desc' => $data['description'],
                    'name' => $data_name,
                    'count' => $count,
                    'buttons' => $buttons,
                    'key' => $key,
                );
            }
        }
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        safe_redirect('/SAFe/' . $this->router->fetch_class() . '/data');
    }
    public function data($module_name = NULL)
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $data['page_summary'] = 'This page allows managing Application Data.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        //Prepare table structure
        $table = new Safe_crud_table_class();
        // Prepare heading
        $table->set_headings(array(
            'Module',
            'Type',
            'Count'
        ));
        // TODO(WADAM) - Figure out why adding safe prefix is required
        $table->set_controller_url('/SAFe/' . $this->router->fetch_class());
        $table->set_form_method('get');
        if (isset($_SERVER['HTTP_REFERER'])) $table->footer_button = array(
            array(
                'name' => 'Back',
                'url' => $_SERVER['HTTP_REFERER'],
                'label' => ''
            )
        );
        // Check for application and services data settings
        $data_cfg = array();
        if (isset($module_name)) {
            // Get back the module
            $module = $this->_get_module($module_name);
            if (isset($module)) {
                $this->_build_data_array($module, $data_cfg);
            }
        } else {
            // Does application has a data ?
            $this->_build_data_array($this->_the_app, $data_cfg);
            // Loop around services
            foreach ($this->_services as $service) {
                // Skip application
                if (!is_subclass_of($service, 'Safe_application_class')) $this->_build_data_array($service, $data_cfg);
                // Check services modules
                foreach ($service->modules() as $mod) {
                    $this->_build_data_array($mod, $data_cfg);
                }
            }
        }
        // Populate table with application data rows
        foreach ($data_cfg as $cfg) {
            $table->add_row(array(
                $cfg['module'],
                $cfg['desc'],
                $cfg['count'],
            ) , $cfg['key'], 'manage');
        }
        // Check some data available
        if (count($data_cfg)) {
            // Yes, create table
            $data['table_size'] = '100%';
            $data['table_title'] = $table->set_title('Application Data');
            $table->allow_create(false);
            $table->set_footer('&nbsp;');
            // Generate table HTML code
            $data['table'] = $table->generate_table();
        } else {
            // No data available :(
            $data['notif_warn'][] = 'No module data available.';
        }
        // Display views
        $this->load->view("safe_header", $data);
        $this->load->view("safe_notifications", $data);
        if (isset($data['table'])) $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    public function manage($module_name, $data_name, $offset = NULL)
    {
        // verify if logged
        //safe_authenticate ();
        $module = NULL;
        $data_cfg = array();
        // Get back the module
        $module = $this->_get_module($module_name);
        // Get service data config
        $data_cfg = $module->get_data_settings();
        // Grab only the data we're interested in
        if (isset($data_cfg[$data_name])) $data_cfg = $data_cfg[$data_name];
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $data['page_summary'] = 'This page allows managing '.$module->description().' '.$data_cfg['description'].'.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        // Get data count
        $data_cnt = $module->get_data_count($data_name);
        // Check if global capabilities defined
        $glob_caps = array();
        if ($data_cfg['global_capabilities_no_data']) $glob_caps = array_merge($glob_caps, $data_cfg['global_capabilities_no_data']);
        if ($data_cnt && $data_cfg['global_capabilities']) $glob_caps = array_merge($glob_caps, $data_cfg['global_capabilities']);
        $global_opt = "";
        foreach ($glob_caps as $glob_cap) {
            if($glob_cap == 'upload'){
                $tmp_button = str_replace('type="submit"','type="button" onclick="safe_handle_create_button(this);"',safe_form_with_submit_button('', '/SAFe/' . $this->router->fetch_class() . '/' . $glob_cap .'_form'. '/' . $module_name . '/' . $data_name, ucfirst($glob_cap), $glob_cap, 'POST', 'float:left;'));
                $global_opt.= '<div>'.$tmp_button.'</div>'; 
            }else{
                $global_opt.= '<div style="float:left">'.safe_button_click($glob_cap, ucfirst($glob_cap) , '/SAFe/' . $this->router->fetch_class() . '/' . $glob_cap . '/' . $module_name . '/' . $data_name, array(
                        'float:right;'
                )).'</div>';
            }
        }
        if ($global_opt) {
            $data['notif_warn'][] = '<div style="float:left;height:22px;line-height:22px;">Global Options for ' . $data_cfg['description'] . ':&nbsp;&nbsp;</div>' . $global_opt;
        }
        // Prepare the list view with data
        $table = new Safe_crud_table_class();
        // Prepare heading
        $table->set_headings(array(
            ''
        ));
        $table->set_controller_url('/SAFe/' . $this->router->fetch_class());
        $table->set_form_method('get');
        $data_files = $module->get_data_files($data_name);
        // Check how many files we have to create pagination
        $max_per_page = 20;
        $array_offset = isset($offset) ? $offset : 0;
        if ($max_per_page < count($data_files)) {
            $this->load->library('pagination');
            $pagination_config['base_url'] = '/SAFe/' . $this->router->fetch_class() . '/' . $this->router->fetch_method() . '/' . $module_name . '/' . $data_name;
            $pagination_config['total_rows'] = count($data_files);
            $pieces = explode("/", $_SERVER['REQUEST_URI']);
            $pagination_config['uri_segment'] = 5;
            if(count($pieces) > 7 ){
                $pagination_config['uri_segment'] = count($pieces) - 2;
            }
            $pagination_config['per_page'] = $max_per_page;
            $this->pagination->initialize($pagination_config);
            // Adjust data_files array
            $data_files = array_slice($data_files, $array_offset, $max_per_page, true );
        }
        
        if($data_cfg['singleton'] && 0 != count($data_files)){
            $output = array();
            $keys = array_keys($data_files);
            $data_key = $keys[0];
            $desc_data = $module->describe_data($data_name, $key, $output);
            $table = new Safe_crud_table_class();
            $data['table_size'] = '100%';
            $data['table_title'] = $table->set_title($data_cfg['description']);
            $table_line = array();
            if($output){
                foreach($output as $k => $v){
                    $k= ucfirst($k);
                    $table_line[$k] = $v;
                }
                foreach ($data_cfg['capabilities'] as $key => $capabilities_value) {
                    if(strtolower($capabilities_value)=='delete' || strtolower($capabilities_value)=='restore' || strtolower($capabilities_value)=='install'){
                        $tmp_tutton['type'] = 'confirm';
                        $tmp_tutton['url'] = base_url($this->router->fetch_class().'/'.$capabilities_value.'_confirm/' . $module_name.'/'.$data_name.'/'.$data_key) ;
                    }else{
                        $tmp_tutton['type'] = 'button';
                        $tmp_tutton['url'] = base_url($this->router->fetch_class().'/'.$capabilities_value.'/' . $module_name.'/'.$data_name.'/'.$data_key) ;
                    }
                    $tmp_tutton['name'] =  ucfirst($capabilities_value);
                    
                    $table->footer_button[] = $tmp_tutton;
                }
            }else{
                $table_line[''] = " No ".$data_cfg['description'] ." available.";
            }
            $data['table'] = $table->generate_vertical_line_table('', '', $table_line);
            unset($table);
        }else{
            //add confirm tag to delete and restore
            foreach ($data_cfg['capabilities'] as $key => $capabilities_value) {
                if(strtolower($capabilities_value)=='delete' || strtolower($capabilities_value)=='restore'){
                    $data_cfg['capabilities'][$key] = $capabilities_value.':confirm';
                }
            }
            foreach ($data_files as $key => $file) {
                $table->add_row(array(
                    $key,
                ) , $module_name . '/' . $data_name . '/' . $key, implode('|', $data_cfg['capabilities']) , '');
            }
            // Yes, create table
            $data['table_size'] = '100%';
            $data['table_title'] = $table->set_title($module->description() . ' - ' . $data_cfg['description']);
            $table->allow_create(false);
            // Add pagination
            if (isset($pagination_config)) $table->set_footer($this->pagination->create_links());
            else $table->set_footer('&nbsp;');
            // Generate table HTML code
            $data['table'] = $table->generate_table();
        }
        
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
        $this->load->view("safe_notifications", $data);
        if (isset($data['table'])) $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    public function install($module_name, $data_name, $data_key = NULL)
    {
        // Set the basic data
        $data['page_title'] = 'Configuration Manager';
        $data['page_summary'] = 'This page allows managing System configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // Get back the module
        $module = $this->_get_module($module_name);
        $data_cfg = $module->get_data_settings();
        // Grab only the data we're interested in
        if (isset($data_cfg[$data_name])) $data_cfg = $data_cfg[$data_name];
        // From this point we will display something for sure, so display header
        $this->load->view("safe_header", $data);
        $data['wait_message'] = '<b>Installing ' .$data_cfg['description'].' '.$data_key.' ...</b>';
        $this->load->view("safe_confirm_dialog", $data);
        $data['timeout_sec'] = 300;
        $this->load->view("safe_wait", $data);
        safe_flush_ouput();
        
        $param = null;
        $output = array();
        if($module->install_data($data_name, $param, $output)){
            $data['notif_warn'][] = $data_cfg['description'].' - '.$data_key.' installed successfully. Please Restart System.' . safe_form_with_submit_button('', '/admin/shutdown.php', 'Restart', '', 'get', 'float:left;' ).' '.safe_form_with_submit_button('', '/SAFe/'.$this->router->fetch_class().'/manage/'.$module_name.'/'.$data_name, 'Back');
        }else{
            $data['notif_error'][] =$data_cfg['description'].' - '.$data_key.' install failed.'. safe_form_with_submit_button('', '/SAFe/'.$this->router->fetch_class().'/manage/'.$module_name.'/'.$data_name, 'Back', '', 'get', 'float:left;');
        }
        $data_log['table_size'] = '100%';
        $data_log['table_title'] = $data_cfg['description'] . ' : ' . $data_key .' - Install Log';
        // TODO(wadam) - get those values from somewhere (not hard coded)
        $data_log['width'] = "715px";
        $data_log['height'] = "550px";
        $data_log['min_height'] = "0px";
        $data_log['url_back'] = $_SERVER['HTTP_REFERER'];
        $data_log['editor_data'] = $module->get_data_file_content_by_key($data_name, $data_key, NULL, 4096);
        
        $this->load->view("safe_notifications", $data);
        if (!empty($data_log['editor_data'])) $this->load->view("safe_texteditor", $data_log);
        $this->load->view("safe_footer", $data);
    }
    public function download($module_name, $data_name, $data_key = NULL)
    {
        // verify if logged
        //safe_authenticate ();
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        // Get service data config
        $data_cfg = $module->get_data_settings();
        // Grab only the data we're interested in
        if (isset($data_cfg[$data_name])) $data_cfg = $data_cfg[$data_name];
        // Retrieve data files
        $data_files = $module->get_data_files($data_name);
        // Download a specific file ?
        if (isset($data_key)) {
            // Keep specified data_key
            $tmp[$data_key] = $data_files[$data_key];
            unset($data_files);
            $data_files = $tmp;
        }
        if (count($data_files) > 1) {
            // All of them, zip and dowload
            ini_set('memory_limit', '300M');
            // Ready to ZIIIIP....
            $this->load->library('zip');
            $name = php_uname('n') . '-' . $data_name . '-' . date('Y-m-d-H-i-s') . '.zip';
            foreach ($data_files as $key => $file) {
                $rc = $this->zip->read_file($file);
            }
            // Proceed to download
            $rc = $this->zip->download($name);
        } else if (count($data_files)) {
            // Download the file
            $name = php_uname('n') . '-' . date('Y-m-d-H-i-s') . $data_key;
            safe_download($data_files[$data_key], NULL, $data_key);
        } else {
            safe_back();
        }
        // Redirect on success
        if ($rc)
        // Redirect to referrer
        safe_back();
        // Somethig bad happens, dsplay error
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $data['page_summary'] = 'This page allows managing Application Data.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        // Prepare back url
        $post = $this->input->post();
        if (isset($post['back_url'])) $back_url = $post['back_url'];
        else $back_url = '/SAFe/' . $this->router->fetch_class();
        $data['notif_error'][] = 'Fail to download ' . $data_cfg['description'] . '.<br/>' . safe_form_with_submit_button('', $back_url, 'Back', 'back', 'get', 'float:left;');
        // Display views
        $this->load->view("safe_header", $data);
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_footer", $data);
    }
    public function view($module_name, $data_name, $data_key)
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $data['page_summary'] = 'This page allows managing Application Data.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        // Get service data config
        $data_cfg = $module->get_data_settings();
        // Grab only the data we're interested in
        if (isset($data_cfg[$data_name])) $data_cfg = $data_cfg[$data_name];
        $data['table_size'] = '100%';
        $data['table_title'] = $data_cfg['description'] . ' : ' . $data_key;
        $data['text_mode'] = "xml";
        $ext = pathinfo($data_cfg['pattern']);
        $data['text_mode'] = $ext['extension'];
        // TODO(wadam) - get those values from somewhere (not hard coded)
        $data['width'] = "930px";
        $data['height'] = "600px";
        $data['min_height'] = "0px";
        $data['url_back'] = $_SERVER['HTTP_REFERER'];
        $data['editor_data'] = $module->get_data_file_content_by_key($data_name, $data_key, NULL);
        if (empty($data['editor_data'])) {
            $data['notif_error'][] = $data_cfg['description'] . ' ' . $data_key . ' not found.<br/>' . safe_button_click('cancel', 'Back', $data['url_back']);
        }
        // Display views
        $this->load->view("safe_header", $data);
        $this->load->view("safe_hide_menu");
        $this->load->view("safe_notifications", $data);
        if (!empty($data['editor_data'])) $this->load->view("safe_texteditor", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Confirm to Delete backup
     *
     * @param string $module_name being deleted
     * @param string $data_name   being deleted
     * @param string $data_key    being deleted
     *
     */
    public function delete_confirm($module_name, $data_name, $data_key = null)
    {
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        // Get service data config
        $data_cfg = $module->get_data_settings();
        // Grab only the data we're interested in
        if (isset($data_cfg[$data_name])){
            $data_cfg = $data_cfg[$data_name];
            $data['message'] = 'Are you sure you would like to delete the <b>' . $data_cfg['description']  . ' '.$data_key. '</b>?';
            $data['message_type'] = 'notice';
            $data['result'] = true;
            $data['action_url'] = base_url($this->router->fetch_class()). '/delete/'.$module_name.'/'.$data_name;
            if($data_key !== NULL){
                $data['action_url'] = $data['action_url'] .'/'.$data_key;
            }
            echo json_encode($data);
        }else{
            $data['message'] = 'No data found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Confirm to Delete backup
     *
     * @param string $module_name being deleted
     * @param string $data_name   being deleted
     * @param string $data_key    being deleted
     *
     */
    public function delete($module_name, $data_name, $data_key = NULL)
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Application Data Manager Delete Data';
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        // Get service data config
        $data_cfg = $module->get_data_settings();
        // Grab only the data we're interested in
        if (isset($data_cfg[$data_name])) {
            $data_cfg = $data_cfg[$data_name];
            $post = $this->input->post();
            $back_url = $this->input->get_post('back_url');
            if (!$back_url) $back_url = '/SAFe/' . $this->router->fetch_class() . '/manage/' . $module_name . '/' . $data_name;
            // Proceed to delete
            if ($module->delete_data($data_name, $data_key)) {
                //return redirect url
                $data['result'] = true;
                //safe_back url HTTP_REFERER  window.history.go('-1');
                $data['redirect_url'] = $back_url;
                echo json_encode($data);
            } else {
                $data['message'] = 'Fail to delete ' . $data_cfg['description'] ;
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            //return error message
            $data['message'] = 'No Data found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    public function logs()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Application Logs';
        $data['page_summary'] = 'This page displays Application Log.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        $data['tabs'] = array();
        // Create tab for each log entry with content
        foreach ($this->_services as $service) {
            $data_cfg = $service->get_data_settings();
            if (isset($data_cfg['log'])) {
                // Get content
                $log_content = $this->_data_get($service->name() , 'log');
                $data['tabs'][] = array(
                    'title' => $service->description() ,
                    'mode' => 'table',
                    'content' => $log_content['data'],
                );
            }
        }
        // Display views
        $this->load->view("safe_header", $data);
        $this->load->view("safe_hide_menu");
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_tabs", $data);
        $this->load->view("safe_footer", $data);
    }
    public function json_get($module_name, $data_name)
    {
        // verify if logged
        //safe_authenticate ();
        echo json_encode($this->_data_get($module_name, $data_name));
    }
    private function _data_get($module_name, $data_name, $max = 1000)
    {
        // Figure out module and log key
        $rc = FALSE;
        $module = NULL;
        $output = array();
        // Get back the module
        $module = $this->_get_module($module_name);
        $data_cfg = $module->get_data_settings();
        if (isset($data_cfg[$data_name])) {
            // Get data file by key
            $files = $module->get_data_files($data_name);
            $keys = array_keys($files);
            $file = $keys[0];
            $content = $module->get_data_file_content_by_key($data_name, $file, $max);
            // explode content
            $output = explode('\n', $content);
            $rc = TRUE;
        }
        return array(
            'module' => $module_name,
            'key' => $data_name,
            'rc' => $rc,
            'data' => $output
        );
    }
    public function restore($module_name, $data_name, $data_key)
    {
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $data['page_summary'] = 'This page allows managing Application Data.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        // From this point we will display something for sure, so display header
        $this->load->view("safe_header", $data);
        // Process to adapter detection
        $data['wait_message'] = '</br><b>Restoring configuration...</b></br>&nbsp;';
        $this->load->view("safe_confirm_dialog", $data);
        $data['timeout_sec'] = 60;
        $this->load->view("safe_wait", $data);
        safe_flush_ouput();
        sleep(0.1);
        // Get archive manager
        $archive_mgr = $this->_cfg_mgr->archive_manager();
        // Prepare back url
        $post = $this->input->post();
        $back_url = $this->input->get_post('back_url');
        if (!$back_url) $back_url = '/SAFe/' . $this->router->fetch_class() . '/manage/' . $module_name . '/' . $data_name;
        
        // First ask application if we can restore archive ?
        $reason = array();
        if ($this->_the_product->can_restore($reason)) {
            // Loop through all service/modules for pre-restore
            if (!($rc = $this->_the_product->pre_restore($reason))
            // Restore
             || !($rc = $archive_mgr->restore_archive($data_key))
            // Post restore
             || !($rc = $this->_the_product->post_restore($reason))) {
                $data['notif_error'][] = 'Fail to Restore Archive ' . $data_key . '.';
                // Populate generation result table
                $data['table_title'] = 'Configuration Restore - ' . $data_key;
                $table = new Safe_table_class();
                $table->data = $this->_the_product->restore_progress();
                $table->footer_button = array(
                    array(
                        'url' => $back_url,
                        'name' => 'Back'
                    )
                );
                $data['table'] = $table->generate();
            } else {
                $data['notif_warn'][] = 'Archive ' . $data_key . ' Restored successfully.</br></br>Please Restart System.' . safe_form_with_submit_button('', '/admin/shutdown.php', 'Restart');
            }
        } else {
            $data['notif_error'][] = 'Cannot Restore Archive ' . $data_key . ' :' . $reason;
        }
        // Already done - $this->load->view ( "safe_header", $data );
        $this->load->view("safe_notifications", $data);
        if ($data['table']) $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    /*
     * confirm to restore to one of the backuped settings
    *
    * @param string $module_name being restored
    * @param string $data_name being restored
    * @param string $data_key being restored
    */
    public function restore_confirm($module_name, $data_name, $data_key)
    {
        // Set the basic data
        $data['page_title'] = 'Restore Application Data';
        // Get archive manager
        $archive_mgr = $this->_cfg_mgr->archive_manager();
        // Prepare back url
        $post = $this->input->post();
        $back_url = $this->input->get_post('back_url');
        if (!$back_url) $back_url = '/SAFe/' . $this->router->fetch_class() . '/manage/' . $module_name . '/' . $data_name;
        // First ask application if we can restore archive ?
        $reason = array();
        if ($this->_the_product->can_restore($reason)) {
            $data['message'] = 'Are you sure you would like to restore from <b>' . $data_key . '</b>?';
            $data['message_type'] = 'notice';
            $data['result'] = true;
            $data['action_url'] = base_url($this->router->fetch_class()). '/restore_action/'.$module_name. '/' . $data_name. '/' . $data_key;
            echo json_encode($data);
        }else {
            $reason_msg='';
              if($reason){
                  $reason_msg =(is_array($reason)) ? implode('<br>',$reason) : $reason;
              }
              $reason_msg = ($reason_msg=='')?'':'<br>'.$reason_msg;
            $data['message'] = 'Restore Application Data '.$data_key.' Failed'.$reason_msg;
            $data['message_type'] = 'notice';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /*
     * restore to one of the backuped settings
     * 
     * @param string $module_name being restored
     * @param string $data_name being restored
     * @param string $data_key being restored
     */
    public function restore_action($module_name, $data_name, $data_key)
    {
        // Set the basic data
        $data['page_title'] = 'Restore Application Data';
        // Get archive manager
        $archive_mgr = $this->_cfg_mgr->archive_manager();
        // Prepare back url
        $post = $this->input->post();
        $back_url = $this->input->get_post('back_url');
        if (!$back_url) $back_url = '/SAFe/' . $this->router->fetch_class() . '/manage/' . $module_name . '/' . $data_name;
        // First ask application if we can restore archive ?
        $data['result'] = true;
        $data['redirect_url'] = base_url($this->router->fetch_class()). '/restore/'.$module_name. '/' . $data_name. '/' . $data_key;
        echo json_encode($data);
    }
    public function backup($module_name, $data_name)
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $data['page_summary'] = 'This page allows managing Application Data.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        // Prepare back url
        $post = $this->input->post();
        $back_url = $this->input->get_post('back_url');
        if (!$back_url) $back_url = '/SAFe/' . $this->router->fetch_class() . '/manage/' . $module_name . '/' . $data_name;
        // Retrieve file and directories to backup
        $archive_mgr = $this->_cfg_mgr->archive_manager();
        $this->load->view("safe_header", $data);
        // First check if we can backup
        if ($this->_the_product->can_backup($reason = "")) {
            $data['wait_message'] = '</br><b> Backup running...</b></br>&nbsp;';
            $this->load->view("safe_wait", $data);
            safe_flush_ouput();
            sleep(0.2);
            // Pre backup hook
            $this->_the_product->pre_backup($reason = "");
            // Create archive
            $archive = $archive_mgr->create_archive();
            // Post backup hook
            $this->_the_product->post_backup($reason = "");
            if (FALSE !== $archive) {
                $download_url = '/SAFe/' . $this->router->fetch_class() . '/download/' . $this->_the_app->name() . '/archive/' . $archive;
                $data['notif_warn'][] = 'Archive ' . $archive . ' successfuly created.' . safe_form_with_submit_button('', $download_url, 'Download', 'download', 'get', 'float:left;') . safe_form_with_submit_button('', $back_url, 'Back', 'back', 'get', 'float:left;');
            } else {
                // Display error
                $data['notif_error'][] = 'Fail to create archive' . safe_form_with_submit_button('', $back_url, 'Back', 'back', 'get', 'float:left;');
            }
        } else {
            // Display error
            $data['notif_error'][] = 'Fail to create archive. ' . $reason . '.' . safe_form_with_submit_button('', $back_url, 'Back', 'back', 'get', 'float:left;');
        }
        // Display views
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_footer", $data);
    }
    public function rotate($module_name, $data_name)
    {
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $data['page_summary'] = 'This page allows managing Application Data.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-backup-settings.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-backup-settings.png';
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        $data_cfg = $module->get_data_settings();
        $data_cfg = $data_cfg[$data_name];
        // Prepare back url
        $post = $this->input->post();
        $back_url = $this->input->get_post('back_url');
        if (!$back_url) $back_url = '/SAFe/' . $this->router->fetch_class() . '/manage/' . $module_name . '/' . $data_name;
        if ($module->data_rotate($data_name)) safe_redirect($back_url);
        // Display error
        $data['notif_error'][] = 'Fail to rotate ' . $module->description() . ' ' . $data_cfg['description'] . safe_form_with_submit_button('', $back_url, 'Back', 'back', 'get', 'float:left;');
        // Display views
        $this->load->view("safe_header", $data);
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * @brief Upload data for a specific module/service
     *
     * @param[in out] $module_name
     * @param[in out] $data_name
     *
     * @return
     */
    public function upload_form($module_name, $data_name)
    {
        // Set the basic data
        $data['page_title'] = 'Application Data Manager';
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        $data_cfg = $module->get_data_settings();
        $data_cfg = $data_cfg[$data_name];
        // Prepare back url
        $post = $this->input->post();

        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $upload_data['file_label'] = $data_cfg['description'].' File:';
        $this->load->view("safe_upload_ajax", $upload_data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        $data['buttons'] = array(
                array(
                        'name' => 'upload',
                        'value' => 'Upload',
                        'type' => 'button'
                ) 
        );
        $data['page_title'] = 'Upload ' . $data_cfg['description'];
        $data['result'] = true;
        $data['action_url'] = base_url($this->router->fetch_class().'/upload_save/'.$module_name.'/'.$data_name);
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * @brief Upload data for a specific module/service
     *
     * @param[in out] $module_name
     * @param[in out] $data_name
     *
     * @return
     */
    public function upload_save($module_name, $data_name)
    {
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        $data_cfg = $module->get_data_settings();
        $data_cfg = $data_cfg[$data_name];
        // Prepare back url
        $post = $this->input->post();
        $back_url = $this->input->get_post('back_url');
        if (!$back_url) $back_url = '/SAFe/' . $this->router->fetch_class() . '/manage/' . $module_name . '/' . $data_name;
        // Load upload library
        $upload_lib = new Safe_upload_class();
        // Are we currently uploading ?
        $data['notif_error'] = null;
        if ($upload_lib->is_uploading()) {
            if($data_cfg['singleton']){
                //only allow one file
                $module->delete_data($data_name);
            }
            // Yes, proceed to upload
            ini_set('memory_limit', '300M');
            // path and ext are based data_cfg pattern
            $ext = pathinfo($data_cfg['pattern']);
            $upload_lib->set_upload_path($ext['dirname']);
            $upload_lib->set_allowed_types($ext['extension']);
            $upload_lib->set_max_size(300 * 1024);
            $rc = $upload_lib->upload();
            $up_data = $upload_lib->get_data();
            // Check result
            if ($rc) {
                if($data_cfg['singleton']){
                    //after upload ini
                    $output = array();
                    if($module->initialize_data($data_name, $up_data['file_name'], $output)){
                    }else{
                        $data['notif_error'][] = 'Fail to initialize '.$data_cfg['description'].'! <br>';
                        if($output){
                            $data['notif_error'] = array_merge($data['notif_error'], $output);
                        }
                    }
                }
            }else{
                $data['notif_error'][] = 'Fail to upload ' . $module->description() . ' ' . $data_cfg['description'] . ' : ' . implode(',', $upload_lib->get_errors());
            }
        }else{
            $data['notif_error'][] = 'Fail to upload ' . $module->description() . ' ' . $data_cfg['description'];
        }
        if($data['notif_error'] == null){
            $data['message_type'] = 'notice';
            $data['message'] ='File Uploaded Successfully.';
            $data['result'] = true;
            $data['redirect_url'] = $back_url;
        }else{
            $data['page_title'] = 'Upload ' .$data_cfg['description']; 
            $data['message_type'] = 'alert';
            $data['message'] = implode("<br>", $data['notif_error']).'<br>'.$up_data['file_name'];
            $data['result'] = false;
        }
        echo json_encode($data);
    }
    /*
     * confirm to install update package
    *
    * @param string $module_name being install
    * @param string $data_name being install
    * @param string $data_key being install
    */
    public function install_confirm($module_name, $data_name, $data_key)
    {
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        $data_cfg = $module->get_data_settings();
        $data_cfg = $data_cfg[$data_name];
        //check if can install
        $output = array();
        $rs = $module->can_install_data($data_name, $data_key, $output);
        if($rs){
            $data['message'] = 'Are you sure you would like to install <b>' . $data_cfg['description'] .' '.$data_key . '</b>?';
            $data['result'] = true;
        }else{
            $data['message'] = "Fail to install ". $data_cfg['description'] .' '.$data_key;
            if($output){
                $data['message'] = $data['message'] . '<br> Reason:' .implode(',', $output);
            }
            $data['result'] = false;
        }
        $data['page_title'] = 'Install ' .$data_cfg['description'];
        $data['message_type'] = 'notice';
        $data['action_url'] = base_url($this->router->fetch_class().'/install_action/'.$module_name.'/'.$data_name.'/'.$data_key);
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /*
     * redirect to install update package
    *
    * @param string $module_name being install
    * @param string $data_name being install
    * @param string $data_key being install
    */
    public function install_action($module_name, $data_name, $data_key)
    {
        // Set the basic data
        $module = NULL;
        // Get back the module
        $module = $this->_get_module($module_name);
        $data_cfg = $module->get_data_settings();
        $data_cfg = $data_cfg[$data_name];
        
        $data['page_title'] = 'Install ' .$data_cfg['description'].' '.$data_key;
        $data['result'] = true;
        $data['redirect_url'] = base_url($this->router->fetch_class()). '/install/'.$module_name. '/' . $data_name. '/' . $data_key;
        echo json_encode($data);
    }
}
/* End of file sng_data_manager.php */

