<?php
/**
 * FS Fialplan Class
 * @author: Shaunt Libarian
 */

if (! defined ( 'BASEPATH' ))
  exit ( 'No direct script access allowed' );

require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('object');
safe_require_class('crud_table');
safe_require_class('form');
safe_module_require_class('fs','advanced_dialplan');

class Fs_dialplan_param_class extends Safe_configurable_object_class {
  public function __construct() {
    parent::__construct('autofill', 'new_dialplan');
  }
  public function configure($node, $dialplans){
  	$c = count($dialplans)+1;
  	
    $dialplan_types = array(
        //'basic'=>'basic',
        'advanced'=>'advanced'
    );
    $this->add_field('dialplan_name', 'Dialplan Name', 'string', 'new_dialplan'.$c, 50);
    $this->set_field_rules('dialplan_name', 'required|alpha_dash');
    //$this->add_enum_field('dialplan_type','Dialplan Type','dropdown','',$dialplan_types);
    $this->add_field('dialplan_type','Dialplan Type','hidden','advanced');
    // Check if we ever have some custom dialplan
    $conf_dir = $node->configuration_manager()->directory('configuration');
    $file_list = $node->os()->search_files($conf_dir.'/custom/dialplan/templates/*.xml');
    // Create enum list of existing templates
    if($file_list || $dialplans) {
        $template_list['__none__'] = " -- None -- ";
        foreach($file_list as $k){
          $template_list['templates/'.basename($k)] = 'templates/'.basename($k);
        }
        // Add user dialplans
        foreach($dialplans as $k=>$v) {
          $template_list['users/'.$v->name()] = $k;
        }
      
      $this->add_enum_field('src', 'Copy From', 'dropdown', '__none__', $template_list);
   }

    parent::configure();
    //$this->synch();
  }
}

class Fs_dialplan extends Safe_CI_Controller {
  private $_modules;
  private $_dialplans=array();
  private $_dialplan_module;
  private $_preferences;
  
  public function __construct() {
    parent::__construct();
    $this->_dialplan_module = $this->_the_app->module('dialplan');
    if($this->_dialplan_module)
      $this->_dialplans = $this->_dialplan_module->dialplans();
    $this->_preferences = $this->_the_app->api_retrieve_preferences();
  }
  
  
  public function index() {
    // verify if logged
    //safe_authenticate();
    
    // Set the basic data
    $data ['page_title'] = 'Call Routing';
    $data ['page_summary'] = 'This page allows managing the Call Routing.';
    $data ['page_large_icon'] = '/images/icons/32x32/icon-network.png';
    $data ['page_small_icon'] = '/images/icons/16x16/icon-network.png';
    
    //Prepare table structure
    $data['table_size'] = '100%';
    
    $table = new Safe_crud_table_class();
    $data['table_title'] = $table->set_title('Call Routing');
    // Prepare heading
    $table->set_headings(array('Name', 'Description'));
    $table->set_controller_url( $this->router->fetch_class() );

    foreach($this->_dialplans as $dialplan) {
      if (isset($dialplan)) {
        $table->add_row(array(
            $dialplan->name(),
            $dialplan->description(),
        ),$dialplan->name() , 'Edit|Delete:confirm','');
      }
    }
    
    $table->allow_create(true);
    // Generate table HTML code
    $data ['table'] = $table->generate_table();
    
    $this->load->view ( "safe_header", $data );
    $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
    $this->load->view ( "safe_table", $data );
    $this->load->view ( "safe_footer", $data );
  }

  /**
    * @brief Apply Call Routing modifications
    *
    * @return 
   */
  public function apply() {
    // verify if logged
    //safe_authenticate ();
  	
    // Set the basic data
    $data ['page_title'] = 'Dialplan';
    $data ['page_summary'] = 'This page allows managing the Dialplan.';
    $data ['page_large_icon'] = '/images/icons/32x32/icon-network.png';
    $data ['page_small_icon'] = '/images/icons/16x16/icon-network.png';

    // From this point we will display something for sure, so display header
    $this->load->view ( "safe_header", $data);
    // Process to adapter detection
    $data ['wait_message'] = '</br><b>Generating configuration...</b></br>&nbsp;';
    $this->load->view("safe_confirm_dialog", $data);
    $this->load->view ( "safe_wait", $data);
    safe_flush_ouput();

    // Get configuration manager
    $cfg_mgr = $this->_the_product->local_node()->configuration_manager();
    $url_back = '/SAFe/'.$this->router->fetch_class();

    // Invoke module generate
    if($this->_dialplan_module->generate_config($cfg_mgr)
      &&
      !$cfg_mgr->errors()
      &&
      $cfg_mgr->write_config($this->_the_product->local_node())
      )
    {
      // Post write config hook
      if($this->_dialplan_module->post_write_config()){
        // Cleanup modified flags
        Safe_object_serializer_class::get_serializer()->clear_modified($this->_dialplan_module->object_name(),true);
        Safe_redirect($url_back);
      }else{
        $data['notif_warn'][] = 'Failed to reload Call Routing.';
      }
    }else{
      $data['notif_error'][] = 'Configuration generation failed.';
    }
    // Populate generation result table
    $data['table_title'] = 'Configuration Generation';
    $table = new Safe_table_class();
    $table->data = $cfg_mgr->progress();
    $table->footer_button = array(array ('url' => $url_back, 'name'=> 'Back'));
    $data['table'] = $table->generate();

    $this->load->view ( "safe_notifications", $data);
    $this->load->view ( "safe_table", $data );
    $this->load->view ( "safe_footer", $data );
  }
  /**
   * Function create a json encoded form to Add a Dialplan Rule
   *  using popup dialog in browser
   */
  public function add_form($reload=false) {
      // verify if logged
      //safe_authenticate ();
      $row_count = 0;
      // Set the basic data
      $data ['page_title'] = 'Call Routing';
      
      $param = new Fs_dialplan_param_class();
      $param->configure($this->_the_product->local_node(),$this->_dialplans);
      $config = $param->get_data();
      $this->load->library("safe_form_class", $config);
      
      $form_config = array();
      $form_config = $this->safe_form_class->config;
      $data['form_cfg'] = $form_config;
      $data['form_title'] = 'Dialplan: New Dialplan';
      $data['form']=$this->safe_form_class->form_input_array();
      $data['label']=$this->safe_form_class->form_label_array();
      $data['form_open']=$this->safe_form_class->form_open();
      
      $data['buttons'] = array(
              array( 'name' => 'create', 'value'=>'Create', 'type'=>'submit' ),
              array( 'name' => 'cancel', 'value'=>'Cancel', 'type'=>'submit' ),
      );
      //******
      //clear the content in page cache and get the view content
      ob_start();
      ob_clean();
      $this->load->view("safe_form_json", $data);
      $data['content'] = ob_get_contents();
      ob_clean();
      //******
      $data['page_title'] = $data['form_title'];
      $data['result'] = true;
      if($reload === true){
          $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
      }
      $data['reload'] = $reload;
      $data['action_url'] = base_url($this->router->fetch_class().'/add/');
      $data['action_method'] = 'POST';
      echo json_encode($data);
  }
  /**
   * Add a Dialplan Rule
   */
  public function add() {
      // verify if logged
      //safe_authenticate ();
      $row_count = 0;

      // Check post request
      $post = $this->input->post();
      
      // Set the basic data
      $data ['page_title'] = 'Call Routing';
  
      $param = new Fs_dialplan_param_class();
      $param->configure($this->_the_product->local_node(),$this->_dialplans);
  
      $wizard_data['profile-name'] = $post['dialplan_name'];
      $param->set_data_values($wizard_data);
      $param->serialize();
      
      // Validate data
      $config = $param->get_data();
      $this->load->library("safe_form_class", $config);
      if($this->safe_form_class->run_validation($validation_errors)){
          if (isset($this->_dialplans[$post['dialplan_name']]))
          {
              //Profile exists, throw an error
              $data['message'] = "<b>" . $post['dialplan_name'] . "</b> exists. Please use a different dialplan name.";
              $data['message_type'] = 'alert';
              $data['result'] = false;
              echo json_encode($data);
          }else{
              // Defaulf dialplan is advanced
              if(!isset($post['dialplan_type']))    $post['dialplan_type'] = 'advanced';
              if ($this->_dialplan_module->create_dialplan($post['dialplan_name'],$post['dialplan_type'],false)) {
                  //false not save the obj
                  unset($post['create']);
                  if($post['src'] && $post['src'] == '__none__')
                    unset($post['src']);
                  if ($post['dialplan_type'] == "advanced")
                  {
                      $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit_advanced/' . $post['dialplan_name'] . '/' . $post['src']);
                  }
                  elseif ($post['dialplan_type'] == "basic")
                  {
                      $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit_basic/' . $post['dialplan_name']);
                  }
                  $data['result'] = true;
                  echo json_encode($data);
              }
          }
      }else{
          //return a json encode form with a error message
          $this->add_form(true);
      }
  }
  /**
   * Confirm to Delete a dialplan rule
   * @param string $dialplan_name
   */
  public function delete_confirm($dialplan_name) {
      // verify if logged
      //safe_authenticate();
      // Set the basic data
      $data ['page_title'] = 'Delete Dialplan';
      $dialplan = $this->_dialplans[$dialplan_name];
      if (isset($this->_dialplans[$dialplan_name]))
      {
          //Check to make sure you can delete, then delete the object
          $reason = array();          
          if ($dialplan->can_dispose($reason))
          {
              $data['message'] = 'Are you sure you would like to delete <b>' . $dialplan_name . '</b>?';
              $data['message_type'] = 'notice';
              $data['result'] = true;
              $data['action_url'] = base_url($this->router->fetch_class()). '/delete/'.$dialplan_name;
              echo json_encode($data);
          }else{
              $reason_msg='';
              if($reason){
                  $reason_msg =(is_array($reason)) ? implode('<br>',$reason) : $reason;
              }
              $reason_msg = ($reason_msg=='')?'':'<br>'.$reason_msg;
              $data['message'] = 'Delete Dialplan '.$dialplan_name.' Failed'.$reason_msg;
              $data['message_type'] = 'notice';
              $data['result'] = false;
              echo json_encode($data);
          }
              
      }else{
          $data['message'] = 'No dialplan found.';
          $data['message_type'] = 'alert';
          $data['result'] = false;
          echo json_encode($data);
      }
          
  }
  /**
   * Delete a dialplan rule
   * @param string $dialplan_name
   */
  public function delete($dialplan_name) {
    // verify if logged
    //safe_authenticate();
    // Set the basic data
    $data ['page_title'] = 'Delete Dialplan';
    $dialplan = $this->_dialplans[$dialplan_name];
    if (isset($this->_dialplans[$dialplan_name]))
    {
        $dialplan->dispose();
        //return redirect url
        $data['result'] = true;
        $data['redirect_url'] = base_url( $this->router->fetch_class());
        echo json_encode($data);
    }else{
        //return error message
        $data['message'] = 'No dialplan found.';
        $data['message_type'] = 'alert';
        $data['result'] = false;
        echo json_encode($data);
    }
  }
  public function edit($dialplan_name) {
    // verify if logged
    //safe_authenticate();
    if (!isset($dialplan_name))
      exit( 'Dialplan name required');

    $dialplan = $this->_dialplans[$dialplan_name];
    switch($dialplan->type()){
      case 'advanced':
      redirect ( '/' . $this->router->fetch_class() . '/edit_advanced/'.$dialplan_name, 'refresh' );
      break;
    }

    // Default is go back to dialplan list
    redirect ( '/' . $this->router->fetch_class(), 'refresh' );
  }

  /**
   * Edit a dialplan
   * @param string $dialplan_name
   */
  public function edit_advanced($dialplan_name, $src_type=null, $src_template=null) {
    // verify if logged
    //safe_authenticate();

    if (!isset($dialplan_name))
      exit( 'Dialplan name required');

    // Handle redirect
    if (isset($post['cancel']))
      redirect (base_url($this->router->fetch_class()) ,'refresh' );

    $dialplan = $this->_dialplans[$dialplan_name];
    $new_obj = false;
    if(!$dialplan) {
        $dialplan = $this->_dialplan_module->create_dialplan($dialplan_name,'advanced',false);
        $dialplan->configure();
        $new_obj = true;
        if($src_type && $src_template) {
          $config = $dialplan->get_data_values(false);
          if($src_type == 'templates') {
            $conf_dir = $this->_the_product->local_node()->configuration_manager()->directory('configuration');
            if($this->_the_product->local_node()->os()->read_file($conf_dir.'/custom/dialplan/templates/'.$src_template, $content)) {
              $config['data'] = "<!--\n";
              $config['data'] .= "\tThis call routing plan has been generated out of a template '$src_template'.\n";
              $config['data'] .= "\tNote that you need to change some data such as IP addresses, SIP profile names, regular expressions etc,\n";
              $config['data'] .= "\tin order to make your dialplan work in your specific setup.\n";
              $config['data'] .= "-->\n";
              $config['data'] .= $content;
            }
          } else if($src_type == 'users') {
            $src_obj = $this->_dialplans[$src_template];
            if($src_obj) {
              $config = $src_obj->get_data_values(false);
            }
          }
          $dialplan->set_data_values($config);
        }
    }
    $config = $dialplan->get_data_values(false);

    // Set the basic data
    $data ['page_title'] = 'Dialplan';
    $data ['page_summary'] = 'This page allows managing the Dialplan.';
    $data ['page_large_icon'] = '/images/icons/32x32/icon-network.png';
    $data ['page_small_icon'] = '/images/icons/16x16/icon-network.png';

    //Prepare table structure
    $data['table_size'] = '100%';
    $data['table_title'] = 'Advanced Dialplan: ' . $dialplan_name;
    $data['text_mode'] = "xml";
    //$data['keyboard_mode'] = "emacs";
    //$data['keyboard_mode'] = "vim";
    $data['keyboard_mode'] = "standard";
    if(isset($this->_preferences)){
      $data['keyboard_mode'] = $this->_preferences->get_data_value('keyboard_mode',false);
      //$data['auto_hide'] = 'notif_warn';
      $data['notif_warn'][] = 'Editor mode is '.$this->_preferences->get_data_value('keyboard_mode',true)
        .' click '.safe_hyperlink('/SAFe/sng_settings_config','here').' to change.';
    }

    if(isset($config['data']) && !empty($config['data'])) {
      $data['editor_data'] = htmlspecialchars($config['data']);
    } else {
      $data['editor_data'] = "<extension name=\"main\">\n";
      $data['editor_data'] .= "\t<condition field=\"destination_number\" expression=\"(.*)\">\n";
      $data['editor_data'] .= "\t\t<action application=\"\" data=\"\" />\n";
      $data['editor_data'] .= "\t</condition>\n";
      $data['editor_data'] .= "</extension>";
      $data['editor_data'] = htmlspecialchars($data['editor_data']);
    }
    $data['url_save'] = base_url($this->router->fetch_class()).'/save/'.$dialplan_name;
    $data['url_cancel'] = base_url($this->router->fetch_class());
  
    $this->load->view("safe_header", $data );
    $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
    $this->load->view("safe_hide_menu", $data );

    $this->load->view('safe_notifications',$data);
    if($data['keyboard_mode'] == "standard")
      $this->load->view("safe_texteditor",$data);
    else
      $this->load->view("safe_texteditor_ace",$data);
    $this->load->view("safe_footer", $data );
  }
  
  /**
   * Validates the XML entered within the textarea and returns true/false based on pass/fail
   * @param unknown_type $xml
   * @return boolean
   */
  private function validate_xml($xml) {
    $xml_doc = simplexml_load_string($xml);
    
    $result = $xml_doc->xpath('param');
    print_r ($result);
    return true;
  }
  public function save($dialplan_name){
    // verify if logged
    //safe_authenticate();
    // Check post request
    $post = $this->input->post();

    // Default is error
    $response = array(
      'result' => 'ERROR' );

    if (isset($post['data'])) {
      $dialplan_data = array(
        'data' => base64_decode($post['data']));
      // Validate XML
      //
      // Reload dialplan object
      if(isset($this->_dialplans[$dialplan_name])){
          $dialplan = $this->_dialplans[$dialplan_name];
      }else{
          $dialplan = $this->_dialplan_module->create_dialplan($dialplan_name,'advanced',false);
          $dialplan->configure();
      }
        //validate xml
        $error = "";
        if ($dialplan->save($dialplan_data, $error)) {
            $response['result'] = "OK";
            $response['redirect'] = base_url($this->router->fetch_class());
        }else{
          $response['message'] = $error;
        }
      
    }

    echo json_encode($response);
  }
  
}
?>
