<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS Directory Domain configuration class
 * @author: William Adam
 */
class Fs_domain_class extends Safe_configurable_object_class
{
    protected $_node = null;
    private $_users = array();
    /**
     * @brief
     *           
     * @param[in out] $node
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name);
        $this->_node = $node;
    }
    public function node(){
        return $this->_node;
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        parent::configure();
        // Register objects
        $this->register_aggregate_object('user', 
            array(
                'name' => 'User',
                'dynamic' => true,
                'base_path' => $this->object_name() . '/user',
            )
        );
    }
    /**
     * Returns domain users in an array
     */
    public function users()
    {
        $this->_users = $this->get_aggregate_objects('user');
        return $this->_users;
    }
    public function create_user($user_name)
    {
        return new Fs_domain_user_class($this->node() , $this->object_name() . '/user', $user_name);
    }
}
?>
