<?php
/**
 * FS CA Certificate Management Page
 * @author Shaunt Libarian
 */

if (! defined ( 'BASEPATH' ))
	exit ( 'No direct script access allowed' );

require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('object');
safe_require_class('crud_table');
safe_require_class('form');
safe_module_require_class('fs','application');
safe_module_require_class('fs','ca_certificate_config');

class Fs_ca_certificate_param_class extends Safe_configurable_object_class {
	public function __construct() {
		parent::__construct('autofill','Fs_ca_certificate_param_class');
	}
	public function configure() {
		$this->add_upload_field('certificate','CA Certificate','upload','',30,true);
		$this->set_field_help('certificate','CA Certificate that will be used with NSC. Must be a valid PEM file.');
		$this->set_field_rules('certificate','required');
		parent::configure();
		$this->synch();
	}
}


class Fs_ca_certificate extends Safe_CI_Controller {

	private $_ca_certificates;
	
	public function __construct() {
		parent::__construct();
		$this->_ca_certificates = $this->_the_app->ca_certificates();
	}
	
	public function index(){
		// verify if logged
		//safe_authenticate ();
	
		// Set the basic data
		$data ['page_title'] = 'CA Certificates';
		$data ['page_summary'] = 'This page allows managing CA certificates settings.';
		$data ['page_large_icon'] = '/images/icons/32x32/icon-network.png';
		$data ['page_small_icon'] = '/images/icons/16x16/icon-network.png';
	
		//Prepare table structure
		$data['table_size'] = '100%';
	
		$table = new Safe_crud_table_class();
		$data['table_title'] = $table->set_title('CA Certificates');
		// Prepare heading
		$table->set_headings(array('Name', 'Subject', 'Issuer','Expires'));
		$table->set_controller_url( $this->router->fetch_class() );

    foreach($this->_ca_certificates as $profile) {
      if (isset($profile)) {
        $prof_data = $profile->get_data_values();

        $table->add_row(array(
            $profile->name(),
            $prof_data['subject'],
            $prof_data['issuer'],
            $prof_data['expires'],
        ),$profile->name() , 'View|Delete:confirm','');
      }
    }
	
		$table->allow_create(true);
		// Generate table HTML code
		$data ['table'] = $table->generate_table();
		$this->load->view ( "safe_header", $data );
		$this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
		$this->load->view ( "safe_table", $data );
		$this->load->view ( "safe_footer", $data );
	}
	
	
	/**
	 * Uploads the file the server
	 * @param string $file_name
	 * 							File name of the pem file being uploaded
	 * @return string $location
	 * 							File location and filename of the server
	 */
	public function upload_file(&$file_name,&$issuer,&$subject,&$expires,&$file_content,&$msg)
	{
		$status = "";
		$msg = "";
		$file_element_name = 'certificate';
		$data = array();
		$config = array();

		$config['upload_path'] = '/tmp/tls-files/';
		$config['allowed_types'] = 'pem';
		$config['max_size']  = 1024 * 8;
		$config['encrypt_name'] = FALSE;
		$config['overwrite'] = TRUE;

		if (!file_exists($config['upload_path']))
			mkdir ($config['upload_path'],'0755',true);

		$this->load->library('upload', $config);

		if (!$this->upload->do_upload($file_element_name))
		{
			$status = 'error';
			$msg = $this->upload->display_errors('', '');
			return false;
		}
		$status = "success";
		$msg = "File successfully uploaded";

		//echo json_encode(array('status' => $status, 'msg' => $msg));
		$file_name =  'certificate_'.$_FILES['certificate']['name'];
		$data = $this->upload->data();

		$file_content = file_get_contents($data['full_path']);
		$ssl = openssl_x509_parse($file_content);

		if(isset($ssl['issuer']))
			if(isset($ssl['issuer']['CN']))
				$issuer = $ssl['issuer']['CN'];
		if(isset($ssl['subject']))
			if(isset($ssl['subject']['CN']))
				$subject = $ssl['subject']['CN'];
		if(isset($ssl['validTo_time_t']))
			$expires = date("Y-m-d H:i:s", $ssl['validTo_time_t']);

		@unlink($data['full_path']);
		return true;
	}
	/**
	 * Function create a json encoded form to adds a new CA Certificate file
	 *   using popup dialog in browser
	 */
	public function add_form($reload=false)
	{
	    // Check post request
	    $post = $this->input->post ();
	    
	    $param = new Fs_ca_certificate_param_class();
	    $param->configure();
	    
	    // Set the basic data
	    $data ['page_title'] = 'CA Certificates';
	    
	    //Display form with checkboxes
	    $config = $param->get_data();
	    
	    $this->load->library("safe_form_class", $config);
	    $data['form_title'] = 'Add CA Certificate';
	    $data['form']=$this->safe_form_class->form_input_array();
	    $data['label']=$this->safe_form_class->form_label_array();
	    $data['form_open']=$this->safe_form_class->form_open_multipart();
	    
	    $data['buttons'] = array(
	            array( 'name' => 'add', 'value'=>'Add', 'type'=>'submit' ),
	            array( 'name' => 'cancel', 'value'=>'Cancel', 'type'=>'submit' ),
	    );
	    
	    //******
        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $this->load->view("safe_form_json", $data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        
        $data['page_title'] = $data['form_title'];
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        } 
        $data['reload'] = $reload;
        $data['action_url'] = base_url($this->router->fetch_class().'/add/');
        $data['action_method'] = 'POST';
        echo json_encode($data);
	}
	public function add() {
	    // verify if logged
	    //safe_authenticate ();
	    // Set the basic data
	    $data ['page_title'] = 'CA Certificates';
	    
	    $error=false;
	    $exists=false;
	    $subject="";
	    $issuer="";
	    $expires="";
	    $original_location="";
	
	    // Check post request
	    $post = $this->input->post ();
	
	    $param = new Fs_ca_certificate_param_class();
	    $param->configure();
	
        if ($_FILES['certificate']['name'] != "") {
            $wizard_data = $param->get_data_values();
            //$wizard_data['certificate'] = $_FILES['certificate']['name'];
            $param->set_data_values($wizard_data);
            $param->serialize();
            // Check that profile does not exist
            if (isset($this->_ca_certificates['certificate_'.$_FILES['certificate']['name']]))
            {
                //Profile exists, throw an error
                $data['message'] = "<b>certificate_" . $_FILES['certificate']['name'] . "</b> exists. Please use a different profile name";
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            }else{
                $file_name = "";
                $file_content = "";
                $msg ='';
                if($this->upload_file($file_name,$issuer,$subject,$expires,$file_content,$msg)) {
                    $post['certificate'] = $file_name;
                    $post['certificate-file-name'] = $file_name;
                    $post['certificate-file-contents'] = base64_encode ($file_content);
                    $post['issuer'] = $issuer;
                    $post['subject'] = $subject;
                    $post['expires'] = $expires;
                    $post['name'] = $file_name;

                    $new_obj = new Fs_ca_certificate_config_class($this->_the_app->node(), $this->_the_app->object_name() . '/profile/ca', 'certificate_'.$_FILES['certificate']['name']);
                    $new_obj->configure();
                    $new_obj->set_data_values($post);
                    $new_obj->synch();
                    $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/view/' . $file_name);
                    $data['result'] = true;
                    echo json_encode($data);
                }else{
                    $data['message'] = $msg;
                    $data['message_type'] = 'alert';
                    $data['result'] = false;
                    echo json_encode($data);
                }
            }
        }else {
            $data['message'] = 'Please select a file!';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
	}

	/**
	 * Displays ca certificate information
	 * @param string $cert
	 * 			Certificate name to display
	 */
	public function view($cert) {
		// verify if logged
		//safe_authenticate ();
		$ca_certificate = $this->_ca_certificates[$cert];
		$ca_cert = $ca_certificate->get_data_values(false);
		// Set the basic data
		$data ['page_title'] = 'CA Certificates';
		$data ['page_summary'] = 'This page allows managing CA certificates settings.';
		$data ['page_large_icon'] = '/images/icons/32x32/icon-network.png';
		$data ['page_small_icon'] = '/images/icons/16x16/icon-network.png';
		
		//Prepare table structure
		$data['table_size'] = '100%';
		
		$table = new Safe_crud_table_class();
		$data['table_title'] = $table->set_title('CA Certificate: ' . $ca_certificate->name());
		// Prepare heading
		$table->set_headings(array('Certificate Name'));
		$table->set_controller_url( base_url($this->router->fetch_class() ));
		
		//Re-create certificate to run openssl command on it
		$retCode="";
		safe_sudo_exec('touch /tmp/file.pem');
		Safe_sudo_exec('/bin/chown webconfig /tmp/file.pem');
		safe_sudo_exec('/bin/chmod 655 /tmp/file.pem');
		file_put_contents('/tmp/file.pem',base64_decode($ca_cert['certificate-file-contents']));
		$cert_content = safe_sudo_exec('/usr/bin/openssl x509 -in /tmp/file.pem','-noout -text',$retCode);
		
    	$table_line = array(
    			'Name' => $ca_cert["name"],
    			'Subject'=> $ca_cert["subject"],
    			'Issuer' => $ca_cert['issuer'],
    			'Expires' => $ca_cert['expires'],
    			'' => $table->create_button(false,'Back', $button_css_class='', '')
    	);
   
    	
    	// Generate table HTML code
    	$data ['table'] = $table->generate_vertical_line_table('',$cert,$table_line);
		$this->load->view ( "safe_header", $data );
		$this->load->view ( "safe_table", $data );
		
		unset($table);
		$table = new Safe_crud_table_class();
		// Prepare heading
		$data['table_title'] = $table->set_title('PEM Contents');
		$table->set_headings(array(''));
		 
		$table->add_row(array($cert_content),'','','');
		$data ['table'] = $table->generate_table();
		
		$this->load->view ( "safe_table", $data );
		$this->load->view ( "safe_footer", $data );
	}
	/**
	 * Confirm to Deletes a CA Certificate
	 * @param string $cert
	 * 			Certificate name to display
	 */
	public function delete_confirm($cert) {
	    // Set the basic data
	    $data ['page_title'] = 'Delete CA Certificates';
	    if (isset($this->_ca_certificates[$cert])){
	        $ca_certificate = $this->_ca_certificates[$cert];
	        //Check to make sure you can delete, then delete the object
	        if ($ca_certificate->can_dispose()){
	            $data['message'] = 'Are you sure you would like to delete <b>' . $cert . '</b>?';
	            $data['message_type'] = 'notice';
	            $data['result'] = true;
	            $data['action_url'] = base_url($this->router->fetch_class()). '/delete/'.$cert;
	            echo json_encode($data);
	        }else{
	            $data['message'] = 'You cannot delete <b>' . $cert . '</b>.<br>';
	            //safe_form_with_submit_button('Click here to view all ', '/SAFe/fs_ca_certificate', 'CA Certificates', '');
	            $data['message_type'] = 'notice';
	            $data['result'] = false;
	            echo json_encode($data);
	        }
	    }else{
	        $data['message'] = 'No CA Certificates found.';
	        $data['message_type'] = 'alert';
	        $data['result'] = false;
	        echo json_encode($data);
	    }
	}
	/**
	 * Deletes a CA Certificate
	 * @param string $cert
	 * 			Certificate name to display
	 */
	public function delete($cert) {
	    // Set the basic data
	    $data ['page_title'] = 'Delete CA Certificates';
        if (isset($this->_ca_certificates[$cert])) {
            $ca_certificate = $this->_ca_certificates[$cert];
            $ca_certificate->dispose();
            //return redirect url
            $data['result'] = true;
            $data['redirect_url'] = base_url( $this->router->fetch_class());
            echo json_encode($data);
        }else{
            //return error message
            $data['message'] = 'No CA Certificates found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
	}
	
}

?>
