<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS LCR Carrier Class
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('object');
safe_require_class('hardware');
safe_module_require_class('fs', 'application');
safe_module_require_class('fs', 'lcr_rate');
class Fs_lcr_carrier_class extends Safe_configurable_object_class
{
    private $_rates;
    private $_the_app;
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        $this->add_enum_field('enabled', 'Enabled', 'dropdown', '1', array(
            '1' => 'Enabled',
            '2' => 'Disabled'
        ));
        $this->set_field_help('enabled', 'Enable/Disable Carrier from being used for Least Cost Routing.');
        // Register aggregate objects
        $this->register_aggregate_object('rate', 
            array(
                'name' => 'Carrier Rate',
                'dynamic' => true,
                'base_path' => $this->object_name() . '/rate',
            )
        );
        return parent::configure();
    }
    /**
     * Returns carrier rate profiles in an array
     */
    public function carrier_rate()
    {
        $this->_rates = $this->get_aggregate_objects('rate');
        return $this->_rates;
    }
    public function can_dispose($carrier_name)
    {
        $this->_the_app = $this->_node->software()->application();
        $this->_sip_trunks = $this->_the_app->sip_trunks();
        foreach ($this->_sip_trunks as $profile) {
            if($profile->carrier_check($carrier_name)){
                return false;
            }
        }
        return true;
    }
}
?>
