<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * FS CDR module class
*/
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_module_require_class('fs', 'application');
class Fs_cdr_config_class extends Safe_configurable_object_class
{
    /**
     * @brief Constructor
     *           
     * @param[in out] $parent_name
     * @param[in out] $name
     *           
     * @return
     */
    public function __construct($node, $parent_name)
    {
        parent::__construct($parent_name, "cdr");
    }
    /**
     * @brief Configure the config class object
     *         
     * @return
     */
    public function configure()
    {
        // local storage
        $this->add_enum_field('global/local', 'Local Storage', 'dropdown', 'false', $this->enable_disable_enum());
        // Set categories
        $this->set_field_category('global/local', 'Local Storage');
        
        $this->create_group('local', 
                array(
                    'local/max_size',
                    'local/schedule'
                )
        );
        
        $this->conditional_control('global/local', 'local');
        
        // local storage hidden fields
        $this->add_field('local/log-dir', 'log-dir', 'hidden', '');
        $this->add_field('local/max_size', 'Local Max Size', 'int', '100', 5);
        $this->set_field_rules('local/max_size', 'required[global/local]|integer|greater_than[0]');
        $this->set_field_help('local/max_size',
                array(
                        'This option sets the size limit of CDR stroage in MB.',
                )
        );
        
        $this->add_enum_field('local/schedule', 'Cleanup Frequency', 'dropdown', 'daily', 
                array(
                        'hourly' =>  'Hourly',
                        'daily' =>  'Daily',
                        'weekly' =>  'Weekly',
                        'monthly' =>  'Monthly'
                        )
        );
        
        // HTTP storage
        $this->add_enum_field('global/http', 'HTTP Storage', 'dropdown', 'false', $this->enable_disable_enum());
        
        $this->set_field_category('global/http', 'HTTP Storage');
        // Add Conditional Control for global/http
        // 1. create the group control 'http'
        $this->create_group('http', 
                array(
                    'http/url',
                    'http/retries',
                    'http/delay'
                )
        );
        // 2. tell the field 'global/http' which existing group it can control (http)
        $this->conditional_control('global/http', 'http');
        $this->add_field('http/url', 'HTTP URL', 'string', '', 64);
        // Optionnaly validate url if HTTP storage is activated
        $this->set_field_rules('http/url', 'required[global/http]|valid_url');
        $this->add_field('http/retries', 'Number of Retries', 'int', 2);
        $this->set_field_rules('http/retries', 'required[global/http]|greater_than[0]');
        // Add help support for the field http/retries
        //$this->set_field_help('http/retries', 'HELP for http/retries!');
        $this->add_field('http/delay', 'Retry Delay', 'int', 5);
        $this->set_field_rules('http/delay', 'required[global/http]|greater_than[0]');
        // HTTP storage hidden fields
        $this->add_field('http/encode', 'encode', 'hidden', 'textxml');
        $this->add_field('http/log-http-and-disk', 'log-http-and-disk', 'hidden', 'true');
        $this->add_field('http/auth-scheme', 'auth-scheme', 'hidden', 'any');
        // common stuff (hidden)
        $this->add_field('common/log-b-leg', 'log-b-leg', 'hidden', 'true');
        $this->add_field('common/prefix-a-leg', 'prefix-a-leg', 'hidden', 'false');
        
        return parent::configure();
    }
    /**
     * @brief Returns a config description string
     *         
     * @return string
     */
    public function description()
    {
        // Get the data values (not enum resolved)
        $cfg = $this->get_data_values(false);
        // Any storage enabled ?
        if ('true' == $cfg['global/local'] || 'true' == $cfg['global/http']) {
            // Yes, so create a string stating which one is on and off
            $desc = "Enable: ";
            if ('true' == $cfg['global/local']) $desc.= 'Local ';
            if ('true' == $cfg['global/http']) $desc.= 'HTTP ';
            return $desc;
        } else {
            // No storage enabled
            return 'Disable';
        }
    }
}
class Fs_cdr_module_class extends Fs_module_class
{
    private $_mod_name = "mod_xml_cdr";
    /**
     * @brief
     *           
     * @param[in out] $fs_app
     *           
     * @return
     */
    public function __construct($fs_app)
    {
        parent::__construct($fs_app, "cdr");
    }
    /**
     * @brief
     *         
     * @return
     */
    public function configure()
    {
        // Set the module description
        $this->set_description("CDR");
        // Create the config object
        $cfg = new Fs_cdr_config_class($this->node() , $this->fs_app()->object_name() , $this->name());
        // Synch with DB
        $cfg->configure();
        $cfg->synch();
        // Attach config to module
        $this->set_config($cfg);
        return parent::configure();
    }
    public function is_enabled($mod_name = "")
    {
        $cfg = $this->config()->get_data_values(false);
        if (!empty($cfg)) {
            if ('true' == $cfg['global/local'] || 'true' == $cfg['global/http']) return true;
            else return false;
        } else return false;
    }
    /**
     * @brief Return FS module name
     *         Overloaded because of xml_ prefix
     *         
     * @return string
     */
    public function get_fs_module_name()
    {
        return $this->_mod_name . '.so';
    }
    /**
     * @brief
     *           
     * @param[in out] $config_manager
     *           
     * @return
     */
    public function generate_config(&$config_manager)
    {
        // Get our configuration data (unresolved)
        $cfg = $this->config()->get_data_values_exploded(false);
        
        // Check if local enabled
        if ('true' != $cfg['global']['local']) {
            // Remove local parameters
            unset($cfg['local']);
        }else{
            $cfg['local']['rotate'] = 'true';
            // Extract cron related data
            $cleanup['schedule'] = $cfg['local']['schedule'];
            $cleanup['max_size'] = $cfg['local']['max_size'];
            unset($cfg['local']['schedule']);
            unset($cfg['local']['max_size']);
        }
        if ('true' != $cfg['global']['http']) {
            // Remove http parameters
            unset($cfg['http']);
        }
        // Remove global config
        unset($cfg['global']);
        // Create xml document
        $xml_writer = new XMLWriter();
        $xml_writer->openMemory();
        $xml_writer->startDocument('1.0', 'UTF-8');
        // Document container
        $xml_writer->startElement('configuration');
        $xml_writer->writeAttribute('name', 'xml_cdr.conf');
        $xml_writer->writeAttribute('description', 'XML CDR CURL logger');

        // Add all parameters
        $xml_writer->startElement('settings');
        foreach ($cfg as $category => $cat_cfg) {
            foreach ($cat_cfg as $k => $v) {
                $xml_writer->startElement('param');
                $xml_writer->writeAttribute('name', $k);
                $xml_writer->writeAttribute('value', $v);
                $xml_writer->endElement();
            }
        }
        // Close settings
        $xml_writer->fullEndElement();
        $xml_writer->endDocument();
        $xmlstr = Safe_format_xml($xml_writer->outputMemory(true));
        $file = 'autoload_configs/xml_cdr.conf.xml';
        $config_manager->add_config(new Safe_configuration_class($file, $xmlstr));
        
 
        $file_name = 'sng-cdr-cleanup';
        //delete all sng-cdr-cleanup  under /etc/cron.<local/schedule> directory cause we don't know if it was previously enabled and with which schedule.        
        $config_manager->add_config(new Safe_configuration_class('/etc/cron.daily/'.$file_name, '', Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_FILE));
        $config_manager->add_config(new Safe_configuration_class('/etc/cron.hourly/'.$file_name, '', Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_FILE));
        $config_manager->add_config(new Safe_configuration_class('/etc/cron.weekly/'.$file_name, '', Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_FILE));
        $config_manager->add_config(new Safe_configuration_class('/etc/cron.monthly/'.$file_name, '', Safe_configuration_class::CFG_DELETE, Safe_configuration_class::CFG_FILE));
        
        //creates a file named sng-cdr-cleanup will be created in /etc/cron.<local/schedule> directory 
        if($cleanup){
            $data_settings = $this->get_data_settings();
            $xml_dir = $data_settings['cdr']['file_dir'];
            $file_content = '#!/bin/bash'.PHP_EOL.
            'nice -n 20 /usr/local/nsc/bin/python /usr/local/sng/scripts/sng-cdr-rotator --path ' . $xml_dir . ' --size '.
            $cleanup['max_size'] . ' --service_name ' . $this->fs_app()->name() . PHP_EOL;
            //create file 
            $config_manager->add_config(new Safe_configuration_class('/etc/cron.'.$cleanup['schedule'].'/'.$file_name, $file_content, Safe_configuration_class::CFG_UPDATE, Safe_configuration_class::CFG_FILE));
            //chmod add executable to file
            $config_manager->add_config(new Safe_configuration_class('/etc/cron.'.$cleanup['schedule'].'/'.$file_name, ' +x ', Safe_configuration_class::CFG_UPDATE, Safe_configuration_class::CFG_CHMOD));
            //File owner should be changed to root
            $config_manager->add_config(new Safe_configuration_class('/etc/cron.'.$cleanup['schedule'].'/'.$file_name, ' root ', Safe_configuration_class::CFG_UPDATE, Safe_configuration_class::CFG_CHOWN));
            $config_manager->add_config(new Safe_configuration_class('/etc/cron.'.$cleanup['schedule'].'/', ' root ', Safe_configuration_class::CFG_UPDATE, Safe_configuration_class::CFG_CHOWN));
        }
        
        return parent::generate_config($config_manager);
    }
    public function get_data_settings()
    {
        $cfg_manager = $this->node()->configuration_manager();
        $data = array(
            'cdr' => array(
                'description' => 'Call Data Records',
                'filesystem' => true,
                'pattern' => $cfg_manager->directory('log') . '/xml_cdr/*.xml',
                'file_ext' => 'cdr.xml',
                'file_dir' => $cfg_manager->directory('log') . '/xml_cdr',
                'recursive' => true,
                'global_capabilities' => array(
                    'download',
                    'delete'
                ) ,
                'capabilities' => array(
                    'download',
                    'delete',
                    'view'
                )
            )
        );
        return $data;
    }
    public function get_data_file_key($data_name, $file)
    {
        // Only CDR available for now so don't bother with data_name
        $base = basename($file);
        $regex_pattern = "/(?P<key>.*)\.cdr\.xml/";
        preg_match($regex_pattern, $base, $match);
        return $match['key'];
    }
    /**
     * @brief Invoked after a successfull write_config
     *         
     * @return
     */
    public function post_write_config()
    {
        // Reload configuration
        if (Safe_service_class::STATUS_RUNNING == $this->fs_app()->status()){
            if($this->is_enabled()){
                $rc = $this->eslapi_execute("reload ".$this->_mod_name, '', $output);
            }else{
                $rc = $this->eslapi_execute("unload ".$this->_mod_name, '', $output);
            }
        }
        return parent::post_write_config();
    }
    public function support_reload(&$cfg_modified = null)
    {
        parent::support_reload($cfg_modified);
        return true;
    }
    /**
     * @brief Create config jobs for dialplan module
     *           
     * @param[in out] $config_manager
     *           
     * @return
     */
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        if(!$this->generate_config($config_manager)) return false;
        return parent::reload_generate_config($config_manager, $obj_type);
    }

    /**
     * @brief 
     *
     * @param[in out] $obj_type
     *
     * @return 
     */
    public function reload_clear_modified($obj_type=null)
    {
        // the hard way :)
        Safe_object_serializer_class::get_serializer()->clear_modified($this->_obj_base_path, true);
    }
}
/* End of file fs_application_class.php */
