<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SNG Ethernet Adapter Class
 * @author: Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_node_class');
safe_require_class('safe_hardware_class');
safe_module_require_class('sng', 'transcoding_module');
class Sng_ethernet_adapter_class extends Safe_ethernet_adapter_class
{
    private $_modules = array();
    public function __construct($hardware, $ifname, $mac = null, $ip = null, $mask = null, $adapter_type = Safe_hardware_adapter_class::ETHERNET_ADAPTER)
    {
        parent::__construct($hardware, $ifname, $mac, $ip, $mask, $adapter_type);
    }
    public function configure()
    {
        $this->_modules = array();
        // Check if modules already serialized
        $ser = new Safe_object_serializer_class();
        $modules = $ser->find_objects($this->object_name() . "/module");
        // Restore objects
        foreach ($modules as $mod => $data) {
            $obj = new Sng_transcoding_module_class($this, $mod);
            $obj->configure();
            $obj->synch();
            $this->_modules[$obj->name() ] = $obj;
        }
        unset($ser);
        $this->register_aggregate_object('modules', 'Transcoding Modules');
        return parent::configure();
    }
    public function api_upgrade_module($obj_name=null, $params=null, &$output=null)
    {
        if($this->modules()){
            $rc = $this->node()->os()->execute('nohup /usr/local/sng/bin/sng-update-transcoding-modules update ' . $this->name(), $output, true, true);
            // Clean up
            foreach ($this->_modules as $mod) {
                $mod->dispose();
            }
            $this->delete_media_info();
        }
        return true;
    }
    public function detect_modules(&$arguments, &$ip_list = array())
    {
        // Clean up
        foreach ($this->_modules as $mod) {
            $mod->dispose();
        }
        unset($this->_modules);
        $this->_modules = array();
        // Run detection through backend
        $output = array();
        $this->node()->execute('sudo nohup /usr/local/sng/bin/sng-detect-transcoding-modules ' . $this->name() , $output);
        foreach ($output as $mod_def) {
            // Process line, format =
            // 1. MAC=00-0C-90-1B-4F-97 Ver=01.04.08-B7-PR Capacity=480 EthPort=1
            $raw_data = explode(' ', $mod_def);
            $mac = explode('=', $raw_data[1]);
            $ver = explode('=', $raw_data[2]);
            $cap = explode('=', $raw_data[3]);
            $port = explode('=', $raw_data[4]);
            //Check IP Address if in use or not.
            $valid_ip = false;
            if (isset($arguments['ip_address'])) {
                $ip_addr = $arguments['ip_address'];
                while (!($valid_ip = $this->check_ip_valid($ip_addr, $ip_list))) {
                    // Increment base IP
                    increment_ip($ip_addr);
                };
                $arguments['ip_address'] = $ip_addr;
                // Add this ip address to used ones
                $ip_list[] = $ip_addr;
            }
            //Check if base IP address in use or not
            $valid_ip = false;
            if (isset($arguments['ext_ip_address']) && $arguments['ext_ip_address'] != "") {
                $ip_addr = $arguments['ext_ip_address'];
                while (!($valid_ip = $this->check_ip_valid($ip_addr, $ip_list))) {
                    // Increment base IP
                    increment_ip($ip_addr);
                };
                $arguments['ext_ip_address'] = $ip_addr;
                // Add this ip address to used ones
                $ip_list[] = $ip_addr;
            }
            if (isset($arguments['individual-ip']) && 'true' != $arguments['individual-ip']) {
                // Aggregate mode, update UDP range
                $diff = $arguments['udp_end'] - $arguments['udp_begin'];
                $arguments['udp_end'] = $arguments['udp_begin'] + $diff;
            }
            //Save Module Information
            $module = new Sng_transcoding_module_class($this, $mac[1]);
            $module->configure($ver[1], $cap[1], $port[1], $arguments);
            $this->_modules[$module->name() ] = $module;
            $module->save();
            // Prepare UDP range for next module if in aggreagate mode
            if (isset($arguments['individual-ip']) && 'true' != $arguments['individual-ip']) {
                // Aggregate mode, update UDP range
                $diff = $arguments['udp_end'] - $arguments['udp_begin'];
                $arguments['udp_begin'] = $arguments['udp_end'] + 1;
                $arguments['udp_end'] = $arguments['udp_begin'] + $diff;
            }
        }
        return !empty($this->_modules);
    }
    public function modules()
    {
        return $this->_modules;
    }
    public function check_modules_version(&$output=array())
    {
        $rc = true;
        if($this->modules()){
            $rc = $this->node()->os()->execute('nohup /usr/local/sng/bin/sng-update-transcoding-modules verify ' . $this->name(), $output, true, true);
        }
        return $rc;
    }
    public function module($mac)
    {
        $mod = null;
        if (isset($this->_modules[$mac])) $mod = $this->_modules[$mac];
        return $mod;
    }
    /**
     * Removes media module information from the db
     */
    public function delete_media_info()
    {
        $ser = new Safe_object_serializer_class();
        $ser->delete_object($this->object_name() . "/module");
        unset($ser);
    }
    /**
     * Checks if the IP address is valid and not used by other ethernet/transcoding adapters
     * @param string  $ip_address
     * @param array   $ip_list   
     * @return boolean
     */
    public function check_ip_valid($ip_address, $ip_list)
    {
        $found_ip = false;
        foreach ($ip_list as $ip) {
            if ($ip == $ip_address) $found_ip = true;
        }
        if ($found_ip) return false;
        else return true;
    }
}
?>
