<?php
/* vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: */
/* coding: utf-8: */
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * CodeMirror test page
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('table');
safe_require_class('crud_table');
safe_require_class('form');
safe_module_require_class('sng', 'transcoding_config');
class Ntg_media_server_interfaces extends Safe_CI_Controller
{
    public $_hardware;
    public $_transcoding_if;
    public $_ethernet_if;
    public function __construct()
    {
        parent::__construct();
        $this->_hardware = $this->_the_product->local_node()->hardware();
        $this->_transcoding_if = $this->_hardware->adapters(Safe_hardware_adapter_class::TRANSCODING_ADAPTER);
        $this->_ethernet_if = $this->_hardware->adapters(Safe_hardware_adapter_class::ETHERNET_ADAPTER);
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Media server interfaces';
        $data['page_summary'] = 'This page allows managing Media server interfaces.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // Check list:
        // 0 - Check transcoding interfaces exists
        //     If NOT - we're in trouble
        // 1 - All Transcoding adapter MUST have IP address set
        //     If NOT - Error and redirect to Network settings
        // 2 - All Transcoding adapter MUST have at least one module
        //     If NOT - Redirect to scan page
        //
        // If all good, present interface tables with modules
        // Allow user to re-scan and change aggregation mode (Single-IP)
        $this->load->view("safe_header", $data);
        // Check if Network configured on transcoding interfaces
        $no_ip = array();
        foreach ($this->_transcoding_if as $if) {
            if (!strlen($if->ip_address())) {
                $no_ip[] = $if->name();
            }
        }
        // Display TRANSCODING media mode
        $transcoding_mode = new Sng_transcoding_config_class($this->_the_product->local_node());
        $mode = $transcoding_mode->media_check();
        if ($mode == 'false') {
            // Hardware Transcoding disabled
            $table = new Safe_crud_table_class();
            $mode_data['table_size'] = '100%';
            $mode_data['table_title'] = $table->set_title('Media Server Configuration');
            $table->set_controller_url($this->router->fetch_class());
            $table_line = array(
                'Media Server Mode' => 'Software',
                '' => $table->create_button(true, 'Modify', '', NULL, 'scan')
            );
            $mode_data['table'] = $table->generate_vertical_line_table('1', '2', $table_line);
        } elseif ($mode == 'true') {
            // Hardware Transcoding enabled
            $table = new Safe_crud_table_class();
            $mode_data['table_size'] = '100%';
            $mode_data['table_title'] = $table->set_title('Media Server Configuration');
            $table->set_controller_url($this->router->fetch_class());
            if (empty($this->_transcoding_if)) $mode = "Exposed";
            else $mode = $transcoding_mode->ip_mode();
            $table_line = array(
                'Media Server Mode' => 'Hardware',
                'Media Server Interfaces IP Mode' => $mode,
                '' => $table->create_button(true, 'Modify:confirm', '', NULL, 'scan')
            );
            $mode_data['table'] = $table->generate_vertical_line_table('1', '2', $table_line);
            unset($table);
            foreach (array_merge($this->_ethernet_if, $this->_transcoding_if) as $if) {
                if(!$if->modules()){
                    continue;
                }
                // Check modules up to date ?
                if(!$if->check_modules_version()){
                    $data['notif_error'] = array('notif_error' =>
                        safe_form_with_submit_button_confirm(
                            'Media Server Modules Version Out Of Date.',
                            '/SAFe/ntg_media_server_interfaces/update_confirm', 'Update',
                            '')
                    );
                    continue;
                }

                if ($if->ip_address() != "") {
                    $table = new Safe_table_class();
                    // Prepare heading
                    $table->heading = array(
                        '',
                        'MAC',
                        'Version',
                        'IP address'
                    );
                    $i = 0;
                    // Prepare rows
                    $table->data = array();
                    $table->line_button = array();
                    foreach ($if->modules() as $mod) {
                        if ($mod->mac() != "") {
                            $table->data[] = array(
                                (true == $mod->enable()) ? WEBCONFIG_ICON_OK : WEBCONFIG_ICON_XMARK,
                                strtoupper($mod->mac()) ,
                                $mod->version() ,
                                $mod->ip_address() ,
                            );
                            array_push($table->primary_key, $mod->mac());
                            array_push($table->line_button, array(
                                array(
                                    'url' => '/SAFe/ntg_media_server_interfaces/edit/' . $if->name() ,
                                    'name' => 'Edit',
                                    'label' => ''
                                )
                            ));
                            $i++;
                            $create_table = true;
                        } else $create_table = false;
                    }
                    // Generate table HTML code
                    if ($create_table) {
                        $data['tables'][] = array(
                            'table_title' => 'Media interface ' . $if->name() ,
                            'table' => $table->generate()
                        );
                    }
                    unset($create_table);
                }
            }
        }
        unset($table);
        //load js and css
        $this->load->view("safe_confirm_dialog", $data);
        // Display
        if ($mode_data) $this->load->view("safe_table", $mode_data);
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_multitable", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Confirm to Modify Media Interfaces
     *
     */
    public function modify_confirm()
    {
        // Set the basic data
        $data['page_title'] = 'Modify Media Interfaces';
        $data['message'] = 'Interfaces detection process will delete current configuration!<br>'.
                            'A new configuration will be generated.';
        $data['message_type'] = 'alert';
        //for ajax json data return
        $data['result'] = true;
        $data['action_url'] = $this->router->fetch_class(). '/' . 'modify_action';
        echo json_encode($data);
    }
    public function update_confirm()
    {
        // Set the basic data
        $data['page_title'] = 'Update Media Interfaces';
        if(Safe_service_class::STATUS_RUNNING == $this->_the_app->status()){
            $data['message'] = 'Cannot Update Media Interfaces while '.$this->_the_app->description().' is Running.';
            $data['message_type'] = 'alert';
            //for ajax json data return
            $data['result'] = false;
            $data['action_url'] = $this->router->fetch_class();
        }else{
            $data['message'] = 'Interfaces Update process will delete current configuration!';
            $data['message_type'] = 'alert';
            //for ajax json data return
            $data['result'] = true;
            $data['action_url'] = $this->router->fetch_class(). '/' . 'update_action';
        }
        echo json_encode($data);
    }

    /**
     *  Modify Media Interfaces action
     *
     */
    public function modify_action()
    {
        //for ajax json data return
        $data['result'] = true;
        $data['redirect_url'] =  $this->router->fetch_class(). '/' . 'scan';
        echo json_encode($data);
    }
    public function update_action()
    {
        //for ajax json data return
        $data['result'] = true;
        $data['redirect_url'] =  $this->router->fetch_class(). '/' . 'update';
        echo json_encode($data);
    }

    public function update()
    {
        // Set the basic data
        $data['page_title'] = 'Media Server Interfaces detection';
        $data['page_summary'] = 'This page allows Updating Media Server Interfaces.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // Display wait
        $data['wait_message'] = '</br><b>Updating Media Server Interfaces...</b><br/>This may take several minutes</br>&nbsp;';
        $data['timeout_sec'] = 600;
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);
        $this->load->view("safe_wait", $data);
        safe_flush_ouput();

        // Proceed to update
        $adapters = $this->_hardware->adapters();

        $full_output = array();
        $success = true;

        foreach($adapters as $adapter){
            $output = array();
            if(!$adapter->api_upgrade_module(null, null, $output)){
                $success = false;
            }
            $full_output = array_merge($full_output, $output);
        }
        if($success){
            $data['notif_warn'][] = 'Media Server Interfaces Update Completed Successfully.';
            $data['notif_warn'][] = safe_form_with_submit_button(
                'Please ', 
                '/SAFe/ntg_media_server_interfaces/scan', 'Click Here to re-scan.', '');
        }else{
            $data['notif_error'][] = 'Media Server Interfaces Update Failed.';
            $table = new Safe_table_class();
            $table->apply_data_formatter = false;
            $data['table_title'] = 'Media Server Interface Update';
            $table->data = $full_output;
            $table->footer_button = array(
                    array(
                            'url' => '/SAFe/' . $this->router->fetch_class(),
                            'name' => 'Back'
                    )   
            );  
            
            $data['table'] = $table->generate();
        }

        $this->load->view("safe_notifications", $data);
        if($data['table']){
            $this->load->view("safe_table", $data);
        }
        $this->load->view("safe_footer", $data);
    }

    public function scan()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Media Server Interfaces detection';
        $data['page_summary'] = 'This page allows detecting Media Server Interfaces.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        //
        // Create the configuration data for the form
        // TODO(wadam) - Get base IP, mask and gw from the ethernet interface
        $param = new Sng_transcoding_config_class($this->_the_product->local_node());
        $param->configure();
        $this->load->view("safe_header", $data);
        $post = $this->input->post();
        if (isset($post['cancel'])) {
            safe_redirect('/SAFe/ntg_media_server_interfaces');
            exit();
        }
        // Is this a scan request ?
        elseif (isset($post['scan'])) {
            // Scan requested
            unset($post['scan']);
            if ($post['enable_media_interface'] == 'false') {
                $param->set_data_values($post);
                $param->serialize();
                safe_redirect('/SAFe/ntg_media_server_interfaces');
                exit();
            }
            //If the user selected to enable media interfaces or there is a transcoding adapter, continue
            elseif ($post['enable_media_interface'] || !empty($this->_transcoding_if)) {
                // We MUST ensure media is enabled
                $post['enable_media_interface'] = 'true';
                // Validate the data
                $param->set_data_values($post);
                $config = $param->get_data();
                $this->load->library("safe_form_class", $config);
                if ($this->safe_form_class->run_validation($validation_errors)) {
                    // Process to adapter detection
                    $data['wait_message'] = '</br><b>Detecting Media Server Interfaces...</b></br>&nbsp;';
                    $this->load->view("safe_confirm_dialog", $data);
                    $this->load->view("safe_wait", $data);
                    safe_flush_ouput();

                    $param->serialize();
                    //Remove all old information from the db
                    foreach ($this->_transcoding_if as $if) {
                        $if->delete_media_info();
                    }
                    unset($if);
                    foreach ($this->_ethernet_if as $if) {
                        $if->delete_media_info();
                    }
                    unset($if);
                    unset($post['scan']);
                    $post_copy = $post;
                    // Check if external ip defined
                    if (isset($post_copy['ext_ip_address']) && !strlen($post_copy['ext_ip_address'])) unset($post_copy['ext_ip_address']);
                    // Detect interfaces
                    $detected_modules = 0;
                    //Create an array of ip addresses to validate
                    $a = 0;
                    if (!empty($this->_ethernet_if)) {
                        foreach ($this->_ethernet_if as $if) {
                            $ip_list[$a] = $if->ip_address();
                            $a++;
                        }
                    }
                    unset($if);
                    if (!empty($this->_transcoding_if)) {
                        foreach ($this->_transcoding_if as $if) {
                            $ip_list[$a] = $if->ip_address();
                            $a++;
                        }
                    }
                    unset($if);
                    if (!empty($post['interfaces'])) {
                        //External Transcoding Mode (D150)
                        foreach ($post['interfaces'] as $interface) {
                            if (isset($this->_transcoding_if[$interface])) $if = $this->_transcoding_if[$interface];
                            elseif (isset($this->_ethernet_if[$interface])) $if = $this->_ethernet_if[$interface];
                            $post['individual-ip'] = 'true';
                            $detected_modules+= $if->detect_modules($post, $ip_list);
                            unset($if);
                        }
                    } else {
                        //Internal Transcoding Mode (D100/D500)
                        //Just do sngdsp interfaces
                        foreach ($this->_transcoding_if as $if) {
                            if ('true' != $post['individual-ip']) {
                                // Copy back original parameter for aggregate mode
                                $upd_begin = $post['udp_begin']; 
                                $post = $post_copy;
                                // Update IP and gw address
                                $ip_addr = $if->ip_address();
                                increment_ip($ip_addr);
                                $post['ip_address'] = $ip_addr;
                                $post['mask'] = $if->mask();
                                $post['gateway'] = $if->ip_address();
                                $post['udp_begin'] = $upd_begin; 
                                $post['udp_end'] = $post['udp_begin'] + 3999;
                            }
                            $detected_modules+= $if->detect_modules($post, $ip_list);
                            unset($if);
                        }
                    }
                    // TODO(wadam) - Handle detect error and no if detected case
                    if (!$detected_modules) {
                        $data['notif_error'][] = "Media Interface detection failed.";
                        $data['notif_error'][] = safe_form_with_submit_button('No Media Interfaces found. ', '/SAFe/ntg_media_server_interfaces/scan', 'Click Here to re-scan.', '');
                        $this->load->view("safe_notifications", $data);
                    }
                    $this->load->view("safe_footer", $data);
                    unset($post);
                    // Return to index
                    if ($detected_modules > 0) {
                        safe_redirect('/SAFe/ntg_media_server_interfaces');
                    }
                    // In any cases we're done, exit
                    return;
                }
            }
        } else {
            // Do not suggest anything
            if (0) {
                // Try to get some IP info based on eth0 settings
                $eths = $this->_hardware->adapters(Safe_hardware_adapter_class::ETHERNET_ADAPTER);
                // Get 1st adapter with IP address set
                foreach ($eths as $eth_if) {
                    if (strlen($eth_if->ip_address())) {
                        $def_eth = $eth_if;
                        break;
                    }
                }
                if (isset($def_eth)) {
                    $wizard_data = $param->get_data_values(false);
                    $eth = $def_eth;
                    $ip_addr = $eth->ip_address();
                    increment_ip($ip_addr);
                    $wizard_data['ip_address'] = $ip_addr;
                    $wizard_data['mask'] = $eth->mask();
                    $wizard_data['gateway'] = $eth->gateway();
                    // Update param object
                    $param->set_data_values($wizard_data);
                }
            }
            // Build the form
            $config = $param->get_data();
            $this->load->library("safe_form_class", $config);
        }
        
        // Prepare form to be displayed
        $data['form'] = $this->safe_form_class->form_input_array();
        for($i=0;$i<count($data['form']);$i++){
            if(stripos($data['form'][$i],'onchange')!==false){
                $data['form'][$i] = str_replace('onchange="','onchange="change_button(this);',$data['form'][$i]);
                break;
            }
        }
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        
        $data['form_cfg'] = $form_config;
        // Get the fields group
        // send the group array in our form view
        $field_group = array();
        $field_group = $param->get_group();
        $data['group'] = $field_group;
        $data['label'] = $this->safe_form_class->form_label_array();
        // set the form attributes
        $frm_attributes = array(
            'id' => 'media_server_manager'
        );
        $this->safe_form_class->set_form_attributes($frm_attributes);
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['form_title'] = 'Media Server Parameters';
        $data['buttons'] = array(
            array(
                'name' => 'scan',
                'value' => 'Detect',
                'type' => 'submit'
            ) ,
        );
        // Add cancel button if detection already done
        $data['buttons'][] = array(
            'name' => 'cancel',
            'value' => 'Cancel',
            'type' => 'submit'
        );
        // Add warning that configuration will be wiped :(
        $this->load->view("safe_notifications", $data);
        $this->load->view("ntg_media_server_interfaces_js", $data);
        $this->load->view("safe_form", $data);
        $this->load->view("safe_footer", $data);
    }
    public function edit($ifname, $mac)
    {
        // Set the basic data
        $data['page_title'] = 'Media server interfaces';
        $data['page_summary'] = 'This page allows managing Media server interfaces.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // Retrieve adapter and module
        if (isset($this->_transcoding_if[$ifname])) $adapter = $this->_transcoding_if[$ifname];
        elseif (isset($this->_ethernet_if[$ifname])) $adapter = $this->_ethernet_if[$ifname];
        $module = $adapter->module($mac);
        // Check post request
        $post = $this->input->post();
        if (isset($post['cancel'])) {
            redirect('/ntg_media_server_interfaces/', 'refresh');
        } elseif (isset($post['save'])) {
            // TODO(wadam) - Validate and save
            //print_r($post);
            unset($post['save']);
            $module->set_data_values($post);
            // Prepare stuff we can edit (hide other info)
            $config = $module->get_data();
            $config['mac']['type'] = 'hidden';
            $config['version']['type'] = 'hidden';
            $this->load->library("safe_form_class", $config);
            // TODO(wadam) - run validation
            if ($this->safe_form_class->run_validation($validation_errors)) {
                if (TRUE == $module->save()) redirect('/ntg_media_server_interfaces/', 'refresh');
            }
        } else {
            // Prepare stuff we can edit (hide other info)
            $config = $module->get_data();
            $config['mac']['type'] = 'hidden';
            $config['version']['type'] = 'hidden';
            $this->load->library("safe_form_class", $config);
        }
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $data_form['form_cfg'] = $form_config;
        // Get the fields group
        // send the group array in our form view
        $field_group = array();
        $field_group = $module->get_group();
        $data_form['group'] = $field_group;
        $data_form['label'] = $this->safe_form_class->form_label_array();
        // set the form attributes
        $frm_attributes = array(
            'id' => 'ntg_media_server_interface'
        );
        $this->safe_form_class->set_form_attributes($frm_attributes);
        $data_form['form_title'] = "Configuration";
        $data_form['form'] = $this->safe_form_class->form_input_array();
        $data_form['label'] = $this->safe_form_class->form_label_array();
        $data_form['form_open'] = $this->safe_form_class->form_open();
        $data_form['buttons'] = array(
            array(
                'name' => 'save',
                'value' => 'Save',
                'type' => 'submit'
            ) ,
            array(
                'name' => 'cancel',
                'value' => 'Cancel',
                'type' => 'submit'
            ) ,
        );
        // Edit
        $config_ro = $module->get_data();
        unset($config_ro['enable']);
        unset($config_ro['ip_address']);
        unset($config_ro['ext_ip_address']);
        unset($config_ro['mask']);
        unset($config_ro['gateway']);
        unset($config_ro['udp_begin']);
        unset($config_ro['udp_end']);
        unset($config_ro['vlan_id']);
        // Remove stuff from config to be read only
        // Form read only
        $this->safe_form_class->set_config($config_ro);
        $data_form_ro['form_title'] = "Information";
        $data_form_ro['label'] = $this->safe_form_class->form_label_array();
        $data_form_ro['form_open'] = $this->safe_form_class->form_open();
        $data_form_ro['form'] = array();
        foreach ($config_ro as $k => $v) {
            if ($v['type'] != 'hidden') $data_form_ro['form'][] = $module->get_data_value($k);
        }
        //$this->safe_form_class->form_input_array();
        $data_form_ro['buttons'] = array();
        $this->load->view("safe_header", $data);
        $this->load->view("safe_form", $data_form_ro);
        $this->load->view("safe_form", $data_form);
        $this->load->view("safe_footer", $data);
    }
}
/* End of file safe_edito.php */
