<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

require_once("../../gui/Webconfig.inc.php");
require_once("../../gui/Charts.inc.php");
require_once("../../api/File.class.php");
require_once("../../api/ShellExec.class.php");
require_once(GlobalGetLanguageTemplate(__FILE__));
require_once("../include/SngProduct.class.php");


///////////////////////////////////////////////////////////////////////////////
//
// Variables
//
///////////////////////////////////////////////////////////////////////////////
define ("SNMP_RUNNING", 'started');
define ("SNMP_STOPPED", "stopped");
$error=array();
$last_info=array();
$info=array();

///////////////////////////////////////////////////////////////////////////////
//
// Main
//
///////////////////////////////////////////////////////////////////////////////


WebAuthenticate();
WebHeader(WEB_LANG_PAGE_TITLE);
WebDialogIntro(WEB_LANG_PAGE_TITLE, "/images/icon-diskusage.png", WEB_LANG_PAGE_INTRO);

checkFormPost($error);
grabDBInfo($last_info);

$snmppid = trim(shell_exec ('pidof snmpd'));
$snmpBoot = trim (shell_exec ('sudo /sbin/chkconfig --list snmpd | grep on'));

if ($snmppid != "")
	snmpActiveNotif();	
showServiceButtons($snmppid,$snmpBoot);

if ($snmppid == "") {
	snmpdConfiguration($error,$last_info);
}

WebFooter();
customJQuery();

///////////////////////////////////////////////////////////////////////////////
// F U N C T I O N S
///////////////////////////////////////////////////////////////////////////////

function snmpActiveNotif ($snmpstatus) {
	WebDialogWarning('SNMP Service is <b>RUNNING</b>. Please stop the service in order to make changes.');
}

function showServiceButtons($snmppid,$snmpBoot) {
	WebFormOpen($_SERVER['PHP_SELF']);
	WebTableOpen('Service Information');
	echo "<tr>";
	echo "<td width='70%'><b>SNMP</b></td>";
	if ($snmppid == "")
		echo "<td><input type='submit' name='start' value='Start' class='ui-state-default ui-corner-all' /></td>";
	elseif ($snmppid != "")
		echo "<td><input type='submit' name='start' value='Start' class='ui-state-default ui-corner-all' disabled='disabled' style=\"color:#C0C0C0\" /></td>";
	
	if ($snmppid == "")
		echo "<td><input type='submit' name='stop' value='Stop' class='ui-state-default ui-corner-all' disabled='disabled' style=\"color:#C0C0C0\" /></td>";
	elseif ($snmppid != "")
		echo "<td><input type='submit' name='stop' value='Stop' class='ui-state-default ui-corner-all' /></td>";	
	
	if ($snmppid == "") 		
		echo "<td><input type='submit' name='restart' value='Restart' class='ui-state-default ui-corner-all' disabled='disabled' style=\"color:#C0C0C0\" /></td>";
	elseif ($snmppid != "")
		echo "<td><input type='submit' name='restart' value='Restart' class='ui-state-default ui-corner-all' /></td>";
	
	if ($snmpBoot == "")
		echo "<td><input type='submit' name='toauto' value='To Auto' class='ui-state-default ui-corner-all' /></td>";
	elseif ($snmpBoot != "")
		echo "<td><input type='submit' name='manual' value='Manual' class='ui-state-default ui-corner-all' /></td>";
	echo "</tr>";
	WebTableClose();
	WebFormClose();
}

function snmpdConfiguration($error,$last_info) {
	WebFormOpen($_SERVER['PHP_SELF']);
	WebTableOpen('SNMP Configuration');
	echo "<tr>";
	echo "<td width='37%' class='mytablesubheader'>SNMP Version</td>";
	echo "<td>";
	echo "<select name='version' id='version'>";
	echo "<option value='1and2' ";
	if ($last_info['version_1and2'] == "yes")
		echo "selected='selected' ";
	echo ">Version 1 and 2</option>";
	echo "<option value='3' ";
	if ($last_info['version_3'] == "yes")
		echo "selected='selected' ";
	echo ">Version 3</option>";
	echo "</select>";
	echo "</td>";
	echo "</tr>";
	echo "<tr id='username_tr'>";
	echo "<td width='37%' class='mytablesubheader' id='username_td' >SNMP Version 3 Username</td>";
	echo "<td><input type='text' name='snmp_username' value='" . $last_info['snmp_username'] . "' id='snmp_username' disabled='disabled'/></td>";
	echo "<td>" . $error['snmp_username'] . "</td>";
	echo "</tr>";
	echo "<tr id='password_tr'>";
	echo "<td width='37%' class='mytablesubheader' id='password_td'>SNMP Version 3 Password</td>";
	echo "<td><input type='password' name='snmp_password' value='" . $last_info['snmp_password'] . "' id='snmp_password' disabled='disabled'/></td>";
	echo "<td>" . $error['snmp_password'] . "</td>";	
	echo "</tr>";
	echo "<tr>";
	echo "<td width='37%' class='mytablesubheader'></td>";
	echo "<td><input type='submit' name='apply' value='Apply' class='ui-state-default ui-corner-all' /></td>";
	echo "</tr>";		
	WebTableClose();
	WebFormClose();	
}

function grabDBInfo(&$last_info) {

	//$db_location = 'sqlite:/usr/local/nsg/nginx/html/php/sqlite/cardinfo.db';
  $db_location = 'sqlite:/var/webconfig/SAFe/application/db/safe.db';
  $db = select_statement($db_location,'snmp_db','*','id = 1');

	if ($_POST['version'] == "1and2")
		$last_info['version_1and2'] = 'yes';
	elseif ($_POST['version'] == "3")
		$last_info['version_3'] = 'yes';
	elseif ($db['snmp_version'] == "1and2")
		$last_info['version_1and2'] = 'yes';
	elseif ($db['snmp_version'] == '3')
		$last_info['version_3'] = 'yes';
		
	if ($_POST['snmp_username'] != "")
		$last_info['snmp_username'] = $_POST['snmp_username'];
	elseif ($db['username'] != "")
		$last_info['snmp_username'] = $db['username'];

	if ($_POST['snmp_password'] != "")
		$last_info['snmp_password'] = $_POST['snmp_password'];
	elseif ($db['password'] != "")
		$last_info['snmp_password'] = $db['password'];		
}

function checkFormPost(&$error) {
	//Check POST for validation and 
	if (count($_POST) > 0) {
		if ($_POST['start']) {
			passthru ("sudo service snmpd start > /dev/null 2>&1",$ret_code);
			if ($ret_code != 0)
				WebDialogWarning('Unable to start the SNMP Service.');
		}
		elseif ($_POST['stop']) {
			passthru ("sudo service snmpd stop > /dev/null 2>&1",$ret_code);
			if ($ret_code != 0) 
				WebDialogWarning('Unable to stop the SNMP Service.');
		}
		elseif ($_POST['restart']) {
			passthru ("sudo service snmpd stop > /dev/null 2>&1",$ret_code);
			if ($ret_code == 0) {
				sleep(2);
				passthru ("sudo service snmpd start > /dev/null 2>&1",$ret_code);	
				if ($ret_code != 0)
					WebDialogWarning ('Unable to restart the SNMP Service');	
			}
			else
				WebDialogWarning('Unable to restart the SNMP Service.');
		}
		elseif ($_POST['toauto']) {
			exec ('sudo /sbin/chkconfig --level 3 snmpd on');
			WebDialogInfo('SNMP boot option changed from manual start to automatic start');
		}
		elseif ($_POST['manual']) {
			exec ('sudo /sbin/chkconfig snmpd off');			
			WebDialogInfo('SNMP boot option changed from automatic start to manual start');			
		}
		elseif ($_POST['apply']) {
			$version_bool = false;
			
			//Check Version Nummber
			if ($_POST['version'] == "1and2") {
				//update db with proper information about snmp				
				//$db_location = 'sqlite:/usr/local/nsg/nginx/html/php/sqlite/cardinfo.db';
        $db_location = 'sqlite:/var/webconfig/SAFe/application/db/safe.db';

				if (check_for_table($db_location,'snmp_db') > 1) {

					$info = select_statement($db_location,'snmp_db','*','id = 1');

					if ($info['id'] != "") {
						
						//check if v3 was setup. If it was, remove v3 information
						if ($info['snmp_version'] == '3') {
							//remove snmpv3 info from config file
							removeSNMPUser();
							
							//remove from db and re-insert
							delete_generic($db_location, 'snmp_db', 'id=1');
							$insert_param = 'id, snmp_version';
							$insert_values = '1, "' . $_POST['version'] . '"';
							insert_statement($db_location, 'snmp_db', $insert_param, $insert_values);							
						}
						else {
							//update information
							$update_param = 'snmp_version = "' . $_POST['version'] . '"';
							$update_where = 'id = 1';
							update_table ($db_location, 'snmp_db', $update_param, $update_where);
						}
					}
					else {
						//insert information
						$insert_param = 'id, snmp_version';
						$insert_values = '1, "' . $_POST['version'] . '"';
						insert_statement($db_location, 'snmp_db', $insert_param, $insert_values);
					}
				}
				else {
					//create table
					$create_param = "id integer, snmp_version varchar(30), username varchar(30), password varchar(30)";
					create_table($db_location,'snmp_db',$create_param);

					//insert information
					$insert_param = 'id, snmp_version';
					$insert_values = '1, "' . $_POST['version'] . '"';
					insert_statement($db_location, 'snmp_db', $insert_param, $insert_values);
				}
				$version_bool = true;
				
			}
			elseif ($_POST['version'] == "3") {
				//Validate Username and Password on apply post
				if (validate($error)) {
					//Validate pass, show success notification, edit snmp v3 file, and get user to start service
					//update db with proper information about snmp				
					//$db_location = 'sqlite:/usr/local/nsg/nginx/html/php/sqlite/cardinfo.db';
           $db_location = 'sqlite:/var/webconfig/SAFe/application/db/safe.db';

					if (check_for_table($db_location,'snmp_db') > 1) {
	
						$info = select_statement($db_location,'snmp_db','id','id = 1');
	
						if ($info['id'] != "") {
							//update information
							$update_param = 'snmp_version = "' . $_POST['version'] . '", username="'. $_POST['snmp_username'] . '", password="' . $_POST['snmp_password'] . '"';
							$update_where = 'id = 1';
							update_table ($db_location, 'snmp_db', $update_param, $update_where);
						}
						else {
							//insert information
							$insert_param = 'id, snmp_version, username, password';
							$insert_values = '1, "' . $_POST['version'] . '", "'. $_POST['snmp_username'] . '", "' . $_POST['snmp_password'] . '"';
							insert_statement($db_location, 'snmp_db', $insert_param, $insert_values);
						}
					}
					else {
						//create table
						$create_param = "id integer, snmp_version varchar(30), username varchar(30), password varchar(30)";
						create_table($db_location,'snmp_db',$create_param);
	
						//insert information
						$insert_param = 'id, snmp_version, username, password';
						$insert_values = '1, "' . $_POST['version'] . '", "'. $_POST['snmp_username'] . '", "' . $_POST['snmp_password'] . '"';
						insert_statement($db_location, 'snmp_db', $insert_param, $insert_values);
					}					
					
					//Run command to add username and password to snmpv3
					$cmd = "sudo net-snmp-config --create-snmpv3-user -A \"" . $_POST['snmp_password'] . "\" " . $_POST['snmp_username'] . "  > /dev/null 2>&1";
					//echo $cmd;
					passthru ($cmd,$ret_code);
					
					if ($ret_code == 0)
						$version_bool=true;
					else
						$version_bool=false;
				}
				else
					$version_bool=false;
			}
			
			if ($version_bool) {
				//show notification of success
				WebDialogInfo('SNMP Configuration Completed. Please start the SNMP Service');
			}
			else {
				//show notification of failure
				WebDialogWarning('Unable to configure SNMP Service.');
			}
		}
	}	
}

function validate(&$error) {
	
	if ($_POST['snmp_username'] == "") {
		$error['snmp_username'] = '<font color="red">Please enter a username.</font>';
		$error_counter++;
	}
	
	if ($_POST['snmp_password'] == "") {
		$error['snmp_password'] = '<font color="red">Please enter a password.</font>';
		$error_counter++;
	}
	elseif (strlen($_POST['snmp_password']) < 8) {
		$error['snmp_password'] = '<font color="red">Please enter a password greater than 8 characters.</font>';
		$error_counter++;
	}
	
	if ($error_counter == 0)
		return true;
	else
		return false;
	
}

function customJQuery() {
?>
<script type='text/javascript'>
	$('#version').change(function() {
		if ($('#version').val() == "1and2") {
			$('#snmp_username').hide();
			$('#snmp_password').hide();
			$('#username_td').hide();
			$('#password_td').hide();			
			$('#username_tr').hide();
			$('#password_tr').hide();			
			$('#snmp_username').attr('disabled',true);
			$('#snmp_password').attr('disabled',true);
		} else {
			$('#snmp_username').show();
			$('#snmp_password').show();
			$('#username_td').show();
			$('#password_td').show();			
			$('#username_tr').show();
			$('#password_tr').show();
			$('#snmp_username').removeAttr('disabled');
			$('#snmp_password').removeAttr('disabled');			
		}
	});
	$(document).ready(function () {
		if ($('#version').val() == "1and2") {
			$('#snmp_username').hide();
			$('#snmp_password').hide();
			$('#username_td').hide();
			$('#password_td').hide();			
			$('#username_tr').hide();
			$('#password_tr').hide();			
			$('#snmp_username').attr('disabled',true);
			$('#snmp_password').attr('disabled',true);
		} else {
			$('#snmp_username').show();
			$('#snmp_password').show();
			$('#username_td').show();
			$('#password_td').show();			
			$('#username_tr').show();
			$('#password_tr').show();
			$('#snmp_username').removeAttr('disabled');
			$('#snmp_password').removeAttr('disabled');			
		}		
	});
</script>
<?php
}

function create_table($db_location, $table_name, $parameters)
{
	$create = "CREATE TABLE " . $table_name . " (" . $parameters . ");";
	//echo "$create<br />";

	try
	{
		//open the database
		$db = new PDO($db_location);

		$db->exec($create);

		// close the database connection
		$db = NULL;
	}
	catch(PDOException $e)
	{
		print 'Exception : '.$e->getMessage(). '<br />';
		echo "Database location = $db_location, table = $table_name<br />";
		echo "SQL Select statement = $create<br />";
	}		
}

//Check if a table exists in a database
function check_for_table ($db_location, $table_name)
{
	//Checks if the database exists
	try
	{
		//open the database
		$db = new PDO($db_location);
		$q = "SELECT name FROM sqlite_master WHERE type='table' and name='" . $table_name . "';";

		$result = $db->query($q);

		$tables = $result->fetch();	
		$totaltables = count($tables);
	
		// close the database connection
		$db = NULL;
	}
	catch(PDOException $e)
	{
		print 'Exception : '.$e->getMessage(). '<br />';
		echo "Database location = $db_location, table = $table_name<br />";
		echo "SQL Select statement = $q<br />";
	}

	return $totaltables;
}

//Update Generic
function update_table ($db_location, $table_name, $parameters, $where_param)
{
	$update = "UPDATE " . $table_name . " SET ". $parameters . " WHERE " . $where_param . ";";
	//echo $update . "<br />";
	
	try
	{
		//open the database
		$db = new PDO($db_location);

		$db->exec($update);

		// close the database connection
		$db = NULL;
	}
	catch(PDOException $e)
	{
		print 'Exception : '.$e->getMessage(). '<br />';
		echo "Database location = $db_location, table = $table_name<br />";
		echo "SQL Select statement = $update<br />";
	}	
}

//Select Generic
function select_statement ($db_location, $table_name, $paramters, $where_param)
{
	$table = check_for_table($db_location,$table_name);
	
	if ($table > 1)
	{
		if ($where_param == "")
			$select = "SELECT " . $paramters . " FROM " . $table_name . ";";
		else
			$select = "SELECT " . $paramters . " FROM " . $table_name . " WHERE " . $where_param . ";";
		//echo $select . "<br />";

		try
		{
			//open the database
			$db = new PDO($db_location);
			//echo "before query<br />";
			$result = $db->query($select);
		
			foreach($result as $row)
				$values = $row;

			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			//echo "hello <br />";
			echo "Database location = $db_location, table = $table_name<br />";
			echo "SQL Select statement = $select<br />";
			print 'Exception : '.$e->getMessage() . '<br />';
		}
	}
	
	return $values;
}

//Insert Statement Generic
function insert_statement($db_location, $table_name, $parameters, $values)
{	
	$insert = "INSERT INTO " . $table_name . " ( " . $parameters . " ) VALUES (" . $values . ");";
	//echo $insert . "<br />";

	try
	{
		//open the database
		$db = new PDO($db_location);

		$db->exec($insert);

		// close the database connection
		$db = NULL;
	}
	catch(PDOException $e)
	{
		print 'Exception : '.$e->getMessage() . '<br />';
		echo "Database location = $db_location, table = $table_name<br />";
		echo "SQL Select statement = $insert<br />";
	}			
}

//Generic SQL Delete statement
function delete_generic($db_location, $table_name, $parameters)
{
	$delete = "DELETE FROM " . $table_name . " WHERE " . $parameters . ";";
	//echo $delete . "<br />";

	try
	{
		//open the database
		$db = new PDO($db_location);

		$db->exec($delete);

		// close the database connection
		$db = NULL;
		}
	catch(PDOException $e)
	{
		echo "Database location = $db_location, table = $table_name<br />";
		echo "SQL Select statement = $delete<br />";
		print 'Exception : '.$e->getMessage(). '<br />';
	}	
}

function removeSNMPUser() {
	shell_exec ("sudo chmod 766 /etc/snmp/snmpd.conf");
	shell_exec ("sudo chmod 777 /etc/snmp");	
	shell_exec ("sudo cp -fr /etc/snmp/snmpd.conf /etc/snmp/snmpd.conf.old");
	shell_exec ("sudo /bin/sed '/\brwuser\b/d' /etc/snmp/snmpd.conf >> /etc/snmp/test");
	shell_exec ("sudo mv /etc/snmp/test /etc/snmp/snmpd.conf");
}
?>
