<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC SIP Trunk
 *
 * @author Shaunt Libarian
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('crud_table');
safe_require_class('form');
class Nsc_sip_trunk_param_class extends Safe_configurable_object_class
{
    public function __construct()
    {
        parent::__construct('autofill', 'Nsc_SIP_trunk');
    }
    public function configure($row_count = 0)
    {
        $c = $row_count + 1;
        $this->add_field('profile-name', 'Profile Name', 'string', 'Nsc_SIP_trunk' . $c, 50);
        $this->set_field_rules('profile-name', 'required|alpha_dash');
        parent::configure();
        //$this->synch();
        
    }
}
class Nsc_sip_trunk extends Safe_CI_Controller
{
    public $_sip_trunk;
    public $_sip_module;
    public function __construct()
    {
        parent::__construct();
        $this->_sip_module = $this->_the_app->module('sip');
        $this->_sip_trunk = $this->_sip_module->trunks(); //Holds all SIP Trunks Profiles
        
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'SIP Trunks';
        $data['page_summary'] = 'This page allows managing SIP Trunk settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        //Prepare table structure
        $data['table_size'] = '100%';
        $table = new Safe_crud_table_class();
        $data['table_title'] = $table->set_title('SIP Trunks');
        // Prepare heading
        $table->set_headings(array(
            'Name',
            'Domain',
            'Profile',
        ));
        $table->set_controller_url($this->router->fetch_class());
        //print_r ($this->_carrier_profile);
        foreach ($this->_sip_trunk as $profile) {
            if (isset($profile)) {
                $prof_data = $profile->get_data_values();
                $table->add_row(array(
                    $profile->name() ,
                    $prof_data['realm'],
                    $prof_data['sip_profile'],
                ) , $profile->name() , 'Edit|Delete:confirm', '');
            }
        }
        $table->allow_create(true);
        // Generate table HTML code
        $data['table'] = $table->generate_table();
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Function create a json encoded form to adds a new sip profile
     *   using popup dialog in browser
     */
    public function add_form($reload=false)
    {
        // Set the basic data
        $data['page_title'] = 'New SIP Trunk';
        $row_count = 0;
        
        if (!empty($this->_sip_trunk)) {
            foreach ($this->_sip_trunk as $profile) $row_count++;
        }
        $param = new Nsc_sip_trunk_param_class();
        $param->configure($row_count);
        
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $data['form_cfg'] = $form_config;
        $data['form_title'] = 'SIP Trunk : New Profile';
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
                array(
                        'name' => 'create',
                        'value' => 'Create',
                        'type' => 'submit'
                ) ,
                array(
                        'name' => 'cancel',
                        'value' => 'Cancel',
                        'type' => 'submit'
                ) ,
        );
        //******
        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $this->load->view("safe_form_json", $data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        
        $data['page_title'] = $data['form_title'];
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        } 
        $data['reload'] = $reload;
        $data['action_url'] = base_url($this->router->fetch_class().'/add/');
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * Function which adds a new SIP trunk
     */
    public function add()
    {
        // verify if logged
        //safe_authenticate ();
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'New SIP Trunk';
        $row_count = 0;
        
        if (!empty($this->_sip_trunk)) {
            foreach ($this->_sip_trunk as $profile) $row_count++;
        }
        $param = new Nsc_sip_trunk_param_class();
        $param->configure($row_count);
        //$wizard_data = $param->get_data_values();
        //$wizard_data['profile-name'] = $post['profile-name'];
        //$param->set_data_values($wizard_data);
        // Validate the data
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        if ($this->safe_form_class->run_validation($validation_errors)) {
            $param->save();
            // Check that profile does not exist
            if (isset($this->_sip_trunk[$post['profile-name']])) {
                //Profile exists, throw an error
                $data['message'] = "<b>" . $post['profile-name'] . "</b> exists. Please use a different profile name";
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            } else {
                // Prepare an array to retreive errors if any
                $validation_errors = array();
                $param->set_data_values($post);
                // Prepare the form for validation with posted data
                // Note that this is the form that will be used by edit code (after this if/else block)
                // if the validation fail
                $this->load->library('safe_form_class', $param->get_data());
                // Check new data are valid
                if ($this->safe_form_class->run_validation($validation_errors)) {
                    $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit/' . $post['profile-name']);
                    $data['result'] = true;
                    echo json_encode($data);
                }
            }
        }else{
          //return a json encode form with a error message
          $this->add_form(true);
        }
    }
    /**
     * confirm to Delete a SIP Trunk
     *
     * @param string $profile_name
     *                             				SIP Trunk being deleted
     */
    public function delete_confirm($profile_name)
    {
        // Set the basic data
        $data['page_title'] = 'Delete SIP Trunk';
        if (isset($this->_sip_trunk[$profile_name])) {
            $sip = $this->_sip_trunk[$profile_name];
            //Check to make sure you can delete, then delete the object
            if ($sip->can_dispose()) {
                $data['message'] = 'Are you sure you would like to delete <b>' . $profile_name . '</b>?';
                $data['message_type'] = 'notice';
                $data['result'] = true;
                $data['action_url'] = $this->router->fetch_class(). '/delete/'.$profile_name;
                echo json_encode($data);
            } else {
                $data['message'] = 'You cannot delete <b>' . $profile_name . '</b>. It is still being used by a carrier.<br>';
                $data['message_type'] = 'notice';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            $data['message'] = 'No SIP Trunk profile found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Delete a SIP Trunk
     *
     * @param string $profile_name
     *                             				SIP Trunk being deleted
     */
    public function delete($profile_name)
    {
        // Set the basic data
        $data['page_title'] = 'Delete SIP Trunk';
        if (isset($this->_sip_trunk[$profile_name])) {
            $sip = $this->_sip_trunk[$profile_name];
            $sip->dispose();
            //return redirect url
            $data['result'] = true;
            $data['redirect_url'] =  $this->router->fetch_class();
            echo json_encode($data);
        }else{
            //return error message
            $data['message'] = 'No SIP Trunk profile found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Modifies an existing SIP Trunk
     * @param String $profile_name:
     *                              					Profile being modified
     */
    public function edit($profile_name)
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($profile_name)) exit('Profile name required');
        $sip_trunk = $this->_sip_trunk[$profile_name];
        $new_obj = false;
        if(!$sip_trunk) {
            $sip_trunk = $this->_sip_module->api_create_trunk($profile_name);
            $sip_trunk->configure();
            $new_obj = true;
        }
        // Check post request
        $post = $this->input->post();
        if (isset($post['cancel'])) {
            redirect(base_url($this->router->fetch_class()) , 'refresh');
        } elseif (isset($post['save'])) {
            unset($post['save']);
            // Prepare an array to retreive errors if any
            $validation_errors = array();
            $rs_update = $sip_trunk->validate($post,$validation_errors);
            if (true == $rs_update) {
                if (TRUE == $sip_trunk->save()) redirect(base_url($this->router->fetch_class()) , 'refresh');
            }
        }
        
        $safe_form = $sip_trunk->get_form();
        // Set the basic data
        $data['page_title'] = $sip_trunk->name() . ' SIP Trunk';
        $data['page_summary'] = 'This page allows managing SIP Trunk settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $form_config = array();
        $form_config = $safe_form->config;
        $data['form_cfg'] = $form_config;
        // Get the fields group
        // send the group array in our form view
        $field_group = array();
        $field_group = $sip_trunk->get_group();
        $data['group'] = $field_group;
        // set the form attributes
        $frm_attributes = array(
            'id' => 'sip_trunk'
        );
        $safe_form->set_form_attributes($frm_attributes);
        $data['form_title'] = 'SIP Trunk : ' . $sip_trunk->name();
        $data['form'] = $safe_form->form_input_array();
        $data['label'] = $safe_form->form_label_array();
        $data['form_open'] = $safe_form->form_open();
        $data['buttons'] = array(
            array(
                'name' => 'save',
                'value' => 'Save',
                'type' => 'submit'
            ) ,
            array(
                'name' => 'cancel',
                'value' => 'Cancel',
                'type' => 'submit'
            ) ,
        );
        $this->load->view("safe_header", $data);
        $this->load->view("safe_form", $data);
        $this->load->view("safe_footer", $data);
    }
}
?>
