<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * CodeMirror test page
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('table');
safe_require_class('crud_table');
safe_require_class('form');
class Nsc_media_profile_param_class extends Safe_configurable_object_class
{
    public function __construct()
    {
        parent::__construct('autofill', 'Nsc_media_profile_param_class');
    }
    public function configure($row_count = 0)
    {
        $c = $row_count + 1;
        $this->add_field('profile-name', 'Profile Name', 'string', 'NSC_New_Media_Profile' . $c, 70);
        $this->set_field_rules('profile-name', 'required|alpha_dash');
        // Auto synch this type of object
        //$this->synch();
        
    }
}
class Nsc_media_profiles extends Safe_CI_Controller
{
    public $_media_profiles;
    public function __construct()
    {
        parent::__construct();
        $this->_media_profiles = $this->_the_app->media_profiles();
        $this->_media_module = $this->_the_app->module("media");
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Media Profile';
        $data['page_summary'] = 'This page allows managing Media profiles.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        //Prepare table structure
        $data['table_size'] = '100%';
        $table = new Safe_crud_table_class();
        $data['table_title'] = $table->set_title('Media Profiles');
        // Prepare heading
        $table->set_headings(array(
            'Name',
            'Codec List'
        ));
        $table->set_controller_url($this->router->fetch_class());
        if (isset($this->_media_profiles)) {
            foreach ($this->_media_profiles as $profile) {
                if (isset($profile)) {
                    $prof_data = $profile->get_data_values();
                    //Create the Codec List
                    $codec_list = array(
                        $prof_data['codec-1'],
                        $prof_data['codec-2'],
                        $prof_data['codec-3'],
                        $prof_data['codec-4'],
                        $prof_data['codec-5']
                    );
                    // At least one codec is required
                    $codec_list_format = '<ul>';
                    foreach ($codec_list as $codec) {
                        if (trim($codec)) {
                            if ($codec == 'INVALID') $codec_list_format.= '<li style="color:red; ">' . $codec . '</li>';
                            else $codec_list_format.= '<li>' . $codec . '</li>';
                        }
                    }
                    $codec_list_format.= '</ul>';
                    $table->add_row(array(
                        $profile->name() ,
                        $codec_list_format,
                    ) , $profile->name() , 'Edit|Delete:confirm', '');
                }
            }
        } else {
            //Redirects to the add new profile page when there is no sip profile
            redirect('/' . $this->router->fetch_class() . '/add', 'refresh');
        }
        $table->allow_create(true);
        // Generate table HTML code
        $data['table'] = $table->generate_table();
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Function create a json encoded form to Add a new Media Profile
     */
    public function add_form($reload=false)
    {
        $row_count = 0;
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'New Media Profile';
        if (isset($this->_media_profiles)) {
            foreach ($this->_media_profiles as $profile) {
                $row_count++;
            }
        }
        $param = new Nsc_media_profile_param_class();
        $param->configure($row_count);
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        $data['form_title'] = 'Media profile : New Profile';
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_cfg'] = $this->safe_form_class->config;
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
                array(
                        'name' => 'create',
                        'value' => 'Create',
                        'type' => 'submit'
                ) ,
                array(
                        'name' => 'cancel',
                        'value' => 'Cancel',
                        'type' => 'submit'
                ) ,
        );
        
        //******
        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $this->load->view("safe_form_json", $data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        
        $data['page_title'] = $data['form_title'];
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        }
        $data['reload'] = $reload;
        $data['action_url'] = base_url($this->router->fetch_class().'/add/');
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * Add a new Media Profile
     */
    public function add()
    {
        // verify if logged
        //safe_authenticate ();
        $row_count = 0;
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'New Media Profile';
        if (isset($this->_media_profiles)) {
            foreach ($this->_media_profiles as $profile) {
                $row_count++;
            }
        }
        $param = new Nsc_media_profile_param_class();
        $param->configure($row_count);
        
        /*$wizard_data = $param->get_data_values();
         $wizard_data['profile-name'] = $post['profile-name'];
        $param->set_data_values($wizard_data);*/
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        if ($this->safe_form_class->run_validation($validation_errors)) {
            $param->serialize();
            // Check that profile does not exist
            if (isset($this->_media_profiles[$post['profile-name']])) {
                //Profile exists, throw an error
                $data['message'] = "<b>" . $post['profile-name'] . "</b> exists. Please use a different profile name";
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            } else {
                $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit/' . $post['profile-name']);
                $data['result'] = true;
                echo json_encode($data);
            }
        }else{
          //return a json encode form with a error message
          $this->add_form(true);
        }
    }
    /**
     * Edits a particular media profile
     * @param string $profile_type
     *
     */
    public function edit($profile)
    {
        $post = $this->input->post();
        $new_obj = false;
        $media_profile = $this->_media_module->api_retrieve_profile($profile);
        if(!$media_profile) {
            $media_profile = $this->_media_module->api_create_profile($profile);
            $new_obj = true;
        }
        if (isset($post['cancel'])) {
            redirect('/nsc_media_profiles/', 'refresh');
        } elseif (isset($post['save'])) {
            unset($post['save']);
            $validation_errors = array();
            $rs_update = $media_profile->validate($post,$validation_errors);
            if (true == $rs_update){
                $media_profile->save();
                redirect('/nsc_media_profiles/', 'refresh');
            }
        }
        $safe_form = $media_profile->get_form();
        // Set the basic data
        $data['page_title'] = 'Media Profile';
        $data['page_summary'] = 'This page allows managing media profiles.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $form_config = array();
        $form_config = $safe_form->config;
        $data['form_cfg'] = $form_config;
        
        // Get the fields group
        // send the group array in our form view
        $field_group = array();
        $field_group = $media_profile->get_group();
        $data['group'] = $field_group;
        // set the form attributes
        $frm_attributes = array(
                'id' => 'media-profile'
        );
        
        $safe_form->set_form_attributes($frm_attributes);
        $data['errors'] = $safe_form->validation_errors();
        $data['form_title'] = 'Media profile : ' . $media_profile->name();
        $data['form'] = $safe_form->form_input_array();
        $data['label'] = $safe_form->form_label_array();
        $data['form_open'] = $safe_form->form_open();
        $data['buttons'] = array(
                array(
                        'name' => 'save',
                        'value' => 'Save',
                        'type' => 'submit'
                ) ,
                array(
                        'name' => 'cancel',
                        'value' => 'Cancel',
                        'type' => 'submit'
                ) ,
        );
        $this->load->view("safe_header", $data);
        $this->load->view("safe_form", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Confirm to Delete a media profile
     *
     * @param string $profile_name
     *                             				domain being deleted
     */
    public function delete_confirm($profile_name)
    {
        $data['page_title'] = 'Delete Media Profile';
        if (isset($this->_media_profiles[$profile_name])) {
            $media = $this->_media_profiles[$profile_name];
            //Check to make sure you can delete, then delete the object
            $reasons = array();
            if ($media->can_dispose($reasons)){
                $data['message'] = 'Are you sure you would like to delete <b>' . $profile_name . '</b>?';
                $data['message_type'] = 'notice';
                $data['result'] = true;
                $data['action_url'] = $this->router->fetch_class(). '/delete/'.$profile_name;
                echo json_encode($data);
            } else {
                $reasons_txt = '';
                foreach($reasons as $reason) {
                    if($reasons_txt)
                        $reasons_txt .= '<br/>';
                    $reasons_txt .= $reason;
                }
                $data['message'] = 'The Media Profile <b>' . $profile_name . '</b>, cannot be removed.<br>'.$reasons_txt;
                $data['message_type'] = 'notice';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            $data['message'] = 'No media profile found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Delete a media profile
     *
     * @param string $profile_name
     *                             				domain being deleted
     */
    public function delete($profile_name)
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Delete Media Profile';
        if (isset($this->_media_profiles[$profile_name])) {
            $media = $this->_media_profiles[$profile_name];
            $media->dispose();
            //return redirect url
            $data['result'] = true;
            $data['redirect_url'] =  $this->router->fetch_class();
            echo json_encode($data);
        }else{
            //return error message
            $data['message'] = 'No media profile found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
}
?>
