<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC Domain Users Page
 * @author: Shaunt Libarian
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('crud_table');
safe_require_class('form');
safe_module_require_class('nsc', 'domain_users');
function validate_sip_username($str)
{
    return (!preg_match("/^([-a-z.0-9_-i\+\&=\!~\$\?\(\)\*\'\,\;\/])+$/i", $str)) ? FALSE : TRUE;
}
class Nsc_domain_users_param_class extends Safe_configurable_object_class
{
    public function __construct()
    {
        parent::__construct('autofill', 'Nsc_domain_users_param_class');
    }
    public function configure()
    {
        $this->add_field('user_id', 'Domain User ID', 'string', '', 50);
        $this->set_field_rules('user_id', 'required|validate_sip_username');
        $this->set_user_rule_msgs(array(
            'validate_sip_username' => 'Invalid SIP user name.',
        ));
        // Auto synch this type of object
        //$this->synch();
        
    }
}
class Nsc_domain_profile_param_class extends Safe_configurable_object_class
{
    public function __construct()
    {
        parent::__construct('autofill', 'Nsc_domain_profile_param_class');
    }
    public function configure()
    {
        $this->add_field('domain-name', 'Domain Name', 'string', '', 50);
        $this->set_field_rules('domain-name', 'required|alpha_dash');
        // Auto synch this type of object
        //$this->synch();
        
    }
}
class Nsc_domain_profiles extends Safe_CI_Controller
{
    public $_domain_profiles;
    public $_domain_users;
    public $_directory_module = NULL;
    public function __construct()
    {
        parent::__construct();
        $this->_directory_module = $this->_the_app->module('directory');
        $this->_domain_profiles = $this->_directory_module->domains(); //Holds all Domain Profiles
        
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Domain Profiles';
        $data['page_summary'] = 'This page allows managing domain profiles settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        //Prepare table structure
        $data['table_size'] = '100%';
        $table = new Safe_crud_table_class();
        $data['table_title'] = $table->set_title('Domain Profiles');
        // Prepare heading
        $table->set_headings(array(
            'Domain Name',
            'Forward',
            'Registrar Server',
            'Registrar Port',
            'Force Expires',
        ));
        $table->set_controller_url($this->router->fetch_class());
        foreach ($this->_domain_profiles as $profile) {
            if (isset($profile)) {
                $prof_data = $profile->get_data_values();
                $table->add_row(array(
                    $profile->name() ,
                    $prof_data['forward-registration'],
                    ($profile->is_forward_enabled()) ? $prof_data['registrar-server'] : 'N/A',
                    ($profile->is_forward_enabled()) ? $prof_data['registrar-port'] : 'N/A',
                    $prof_data['sip-force-expires'],
                ) , $profile->name() , 'Modify|Delete:confirm', '');
            }
        }
        $table->allow_create(true);
        // Generate table HTML code
        $data['table'] = $table->generate_table();
        $this->load->view("safe_header", $data);
        //load js and css
        $this->load->view("safe_confirm_dialog", $data);
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Function create a json encoded form to adds a new domain profile
     *   using popup dialog in browser
     */
    public function add_form($reload=false)
    {
        // Set the basic data
        $data['page_title'] = 'New Domain Profile';
        $param = new Nsc_domain_profile_param_class();
        $param->configure();
        
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);

        $data['form_title'] = 'Domain profile : New Profile';
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_cfg'] = $this->safe_form_class->config;
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
                array(
                        'name' => 'create',
                        'value' => 'Create',
                        'type' => 'submit'
                ) ,
                array(
                        'name' => 'cancel',
                        'value' => 'Cancel',
                        'type' => 'submit'
                ) ,
        );
        //******
        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $this->load->view("safe_form_json", $data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        
        $data['page_title'] = $data['form_title'];
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        } 
        $data['reload'] = $reload;
        $data['action_url'] = base_url($this->router->fetch_class().'/add/');
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * Function which adds a new domain profile
     */
    public function add()
    {
        // verify if logged
        //safe_authenticate ();
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'New Domain Profile';
        
        $param = new Nsc_domain_profile_param_class();
        $param->configure();
        
        //$wizard_data = $param->get_data_values();
        //$wizard_data['domain-name'] = $post['domain-name'];
        //$param->set_data_values($wizard_data);
        // Validate the data
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        if ($this->safe_form_class->run_validation($validation_errors)) {
            //$param->save();
            $domain_name = $post['domain-name'];
            // Check that profile does not exist
            if (isset($this->_domain_profiles[$domain_name])) {
                //Profile exists, throw an error
                $data['message'] = "<b>" . $domain_name . "</b> exists. Please use a different profile name";
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            } else {
                $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit_profile/' . $domain_name);
                $data['result'] = true;
                echo json_encode($data);
            }
        }else{
          //return a json encode form with a error message
          $this->add_form(true);
        }
    }
    /**
     * Displays relevant information regarding the particular domain name
     * @param string $domain_name
     */
    public function modify($domain_name)
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($domain_name)) exit('Domain Profile name required');
        $domain_profile = $this->_domain_profiles[$domain_name];
        // Set the basic data
        $data['page_title'] = $domain_profile->name() . ' Domain Profile';
        $data['page_summary'] = 'This page allows managing Domain profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $config = $domain_profile->get_data();
        $config_values = $domain_profile->get_data_values();
        //Load a bar to go back to main page
        $data['notif_warn'][] = safe_form_with_submit_button('Please click here to ', '/SAFe/nsc_domain_profiles', 'view all profiles', '');
        $table = new Safe_crud_table_class();
        $data['table_size'] = '100%';
        $data['table_title'] = $table->set_title('Domain Profile: ' . $domain_profile->name());
        $table->set_controller_url($this->router->fetch_class());
        $table->set_url_suffix('profile');
        $table->primary_key = $domain_name;
        if (strtolower($config_values["forward-registration"]) == 'disable') {
            $table_line = array(
                'Forward Registration / Authentication' => $config_values["forward-registration"],
                'SIP Force Expires' => $config_values["sip-force-expires"],
                '' => $table->create_button(true, 'Edit', $button_css_class = '', $table->primary_key)
            );
        } else {
            $table_line = array(
                'Forward Registration / Authentication' => $config_values["forward-registration"],
                'Registrar Server' => $config_values["registrar-server"],
                'Registrar Server Port' => $config_values["registrar-port"],
                'SIP Force Expires' => $config_values["sip-force-expires"],
                '' => $table->create_button(true, 'Edit', $button_css_class = '', $table->primary_key) /*.
                 $table->create_button(true, 'Cancel', $button_css_class='', '')*/
            );
        }
        // Generate table HTML code
        $data['table'] = $table->generate_vertical_line_table('', $domain_name, $table_line);
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load dialog js and css
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_table", $data);
        //Display Users
        $this->_display_users($domain_profile);
        $this->load->view("safe_footer", $data);
    }
    /**
     * @brief Apply domain's users configuration change
     *           
     * @param[in out] $domain_name
     *           
     * @return
     */
    public function apply_user($domain_name)
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($domain_name)) exit('Domain Profile name required');
        $domain_profile = $this->_domain_profiles[$domain_name];
        // Set the basic data
        $data['page_title'] = $domain_profile->name() . ' Domain Profile';
        $data['page_summary'] = 'This page allows managing Domain profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        //
        // From this point we will display something for sure, so display header
        $this->load->view("safe_header", $data);
        // Process to adapter detection
        $data['wait_message'] = '</br><b>Generating configuration...</b></br>&nbsp;';
        $this->load->view("safe_confirm_dialog", $data);
        $this->load->view("safe_wait", $data);
        safe_flush_ouput();
        // Get configuration manager
        $cfg_mgr = $this->_the_product->local_node()->configuration_manager();
        $url_back = '/SAFe/' . $this->router->fetch_class() . '/modify/' . $domain_name;
        // Invoke module generate
        if ($this->_directory_module->generate_user_config($cfg_mgr, $domain_profile) && !$cfg_mgr->errors() && $cfg_mgr->write_config($this->_the_product->local_node())) {
            // Post write config hook
            if ($this->_directory_module->post_write_config()) {
                // Cleanup modified flags
                Safe_object_serializer_class::get_serializer()->clear_modified($domain_profile->object_name() . '/user', true);
                Safe_redirect($url_back);
            } else {
                $data['notif_error'][] = 'Reload Domain Users Configuration Failed.';
            }
        } else {
            $data['notif_error'][] = 'Configuration Generation Failed.';
        }
        // Populate generation result table
        $data['table_title'] = 'Configuration Generation';
        $table = new Safe_table_class();
        $table->data = $cfg_mgr->progress();
        $table->footer_button = array(
            array(
                'url' => $url_back,
                'name' => 'Back'
            )
        );
        $data['table'] = $table->generate();
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Modifies an existing domain profile
     * @param String $profile_name:
     *                              Profile being modified
     */
    public function edit_profile($profile_name)
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($profile_name)) exit('Domain Profile name required');
        if (isset($this->_domain_profiles[$profile_name])){
            $domain_profile = $this->_domain_profiles[$profile_name];
            $new_obj = false;
        }else{
            $domain_profile = $this->_directory_module->create_domain($profile_name);
            $domain_profile->configure();
            $new_obj = true;
        }
        // Check post request
        $post = $this->input->post();
        if (isset($post['cancel'])) {
            if($new_obj) {
                redirect('/' . $this->router->fetch_class());
            }else{
                redirect('/' . $this->router->fetch_class() . '/modify/' . $profile_name, 'refresh');
            }
        } elseif (isset($post['save'])) {
            // TODO(wadam) - Validate and save
            //print_r($post);
            unset($post['save']);
            $validation_errors = array();
            $domain_profile->set_data_values($post);
            $this->load->library('safe_form_class', $domain_profile->get_data());
            // Check new data are valid
            if ($this->safe_form_class->run_validation($validation_errors)) {
                if (TRUE == $domain_profile->save()) redirect('/' . $this->router->fetch_class() . '/modify/' . $profile_name, 'refresh');
            }
        }
        // Set the basic data
        $data['page_title'] = $domain_profile->name() . ' Domain Profile';
        $data['page_summary'] = 'This page allows managing Domain profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $this->load->library("safe_form_class", $domain_profile->get_data());
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $data['form_cfg'] = $form_config;
        // Get the fields group
        // send the group array in our form view
        $field_group = array();
        $field_group = $domain_profile->get_group();
        $data['group'] = $field_group;
        // set the form attributes
        $frm_attributes = array(
            'id' => 'domain_profile'
        );
        $this->safe_form_class->set_form_attributes($frm_attributes);
        $data['form_title'] = 'Domain profile : ' . $domain_profile->name();
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
            array(
                'name' => 'save',
                'value' => 'Save',
                'type' => 'submit'
            ) ,
            array(
                'name' => 'cancel',
                'value' => 'Cancel',
                'type' => 'submit'
            ) ,
        );
        $this->load->view("safe_header", $data);
        $this->load->view("safe_form", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Displays the users CRUD Table
     */
    private function _display_users($domain)
    {
        //Prepare table structure
        $table = new Safe_crud_table_class();
        $data_user['table_size'] = '100%';
        $data_user['table_title'] = $table->set_title('Domain Users: ' . $domain->name());
        // Prepare heading
        $table->set_headings(array(
            'User ID',
            'Caller ID Name',
            'Caller ID Number',
            'SIP Force Expires',
        ));
        $table->set_controller_url($this->router->fetch_class());
        $table->set_url_suffix('user/' . $domain->name());
        $users = $domain->users();
        $table->primary_key = "";
        foreach ($users as $profile) {
            if (isset($profile)) {
                $prof_data = $profile->get_data_values();
                $table->add_row(array(
                    $profile->name() ,
                    $prof_data['effective_caller_id_name'],
                    $prof_data['effective_caller_id_number'],
                    $prof_data['sip_force_expires'],
                ) , $profile->id() , 'Edit|Delete:confirm', '', true);
            }
        }
        $table->set_url_suffix('user');
        $table->allow_create(true, $domain->name());
        // Generate table HTML code
        $data_user['table'] = $table->generate_table();
        $this->load->view("safe_table", $data_user);
    }
    /**
     * confirm to Deletes a user from a domain
     *
     * @param string $user_name
     *                          username being deleted from a profile
     */
    public function delete_confirm_user($domain_name, $user_id)
    {
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'Delete Domain User';
        $domain_profile = $this->_domain_profiles[$domain_name];
        $users = $domain_profile->users();
        // retrieve user by id and set user_name
        foreach ($users as $k => $v) {
            if ($user_id == $v->id()) {
                $user_name = $k;
                break;
            }
        }
        if (isset($users[$user_name])) {
            $domain = $this->_domain_profiles[$domain_name];
            $user = $users[$user_name];
            //Check to make sure you can delete, then delete the object
            $reason = array();
            if ($user->can_dispose($reason)) {
                $data['message'] = 'Are you sure you would like to delete <b>' . $user_name . '</b>?';
                $data['message_type'] = 'notice';
                //for ajax json data return
                $data['result'] = true;
                $data['action_url'] = base_url('/' . $this->router->fetch_class(). '/' . 'delete_user'.'/'.$domain_name.'/'.$user_id);
                echo json_encode($data);
                
            } else {
                $reason_msg='';
                if($reason){
                    $reason_msg =(is_array($reason)) ? implode('<br>',$reason) : $reason;
                }
                $reason_msg = ($reason_msg=='')?'':'<br>'.$reason_msg;
                $data['message'] = 'Delete user <b>' . $user_name . '</b> Failed'.$reason_msg;
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            }
        } else {
            //for ajax json data return
            $data['message'] = 'Unknown user <b>' . $user_name . '</b>';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Deletes a user from a domain
     *
     * @param string $user_name
     *                          username being deleted from a profile
     */
    public function delete_user($domain_name, $user_id)
    {
        // verify if logged
        //safe_authenticate ();
        // Check post request
        // Set the basic data
        $data['page_title'] = 'Delete Domain User';
        $domain_profile = $this->_domain_profiles[$domain_name];
        $users = $domain_profile->users();
        // retrieve user by id and set user_name
        foreach ($users as $k => $v) {
            if ($user_id == $v->id()) {
                $user_name = $k;
                break;
            }
        }
        if (isset($users[$user_name])) {
            $user = $users[$user_name];
            $user->dispose();
            $data['result'] = true;
            $data['redirect_url'] =  base_url('/'.$this->router->fetch_class(). '/modify/' . $domain_name);
            echo json_encode($data);
        }else{
            $data['message'] = 'No user name found!';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Delete a domain profile confirm
     *
     * @param string $domain_name
     *                            domain being deleted
     */
    public function delete_confirm($domain_name)
    {
        $data['page_title'] = 'Delete Domain Profile';
        if (isset($this->_domain_profiles[$domain_name])) {
            $domain = $this->_domain_profiles[$domain_name];
            //Check to make sure you can delete, then delete the object
            if ($domain->can_dispose()) {
                $data['message'] = 'Are you sure you would like to delete the domain <b>' . $domain_name . '</b>?<br>'.
                                         'Any domain users associated with the domain, <b>' . $domain_name . '</b>, will be removed as well.';
                $data['message_type'] = 'notice';
                $data['result'] = true;
                $data['action_url'] = $this->router->fetch_class(). '/' . 'delete'.'/'.$domain_name;
                echo json_encode($data);
            } else {
                $data['message'] = 'The Domain Profile, <b>' . $domain_name . '</b>, cannot be removed.<br>'.
                                   'The Domain profile is in use by a SIP profile. Please adjust your SIP profiles before removing <b>' . $domain_name . '</b>';

                $data['message_type'] = 'notice';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            //return error message
            $data['message'] = 'No domain profile name found!';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Delete a domain profile 
     *
     * @param string $domain_name
     *                            domain being deleted
     */
    public function delete($domain_name)
    {
        $data['page_title'] = 'Delete Domain Profile';
        $post = $this->input->post();
        if (isset($this->_domain_profiles[$domain_name])) {
            //Dispose domain users
            $domain_profile = $this->_domain_profiles[$domain_name];
            $user_name = $domain_profile->users();
            foreach ($user_name as $user) {
                $user->dispose();
            }
            //Dispose domain
            $domain = $this->_domain_profiles[$domain_name];
            $domain->dispose();
            //return redirect url
            $data['result'] = true;
            $data['redirect_url'] =  $this->router->fetch_class();
            echo json_encode($data);
        }else{
            //return error message
            $data['message'] = 'No domain profile name found!';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Function create a json encoded form to adds a new user for domain profile
     *   using popup dialog in browser
     */
    public function add_form_user($domain_name,$reload=false)
    {
        // Set the basic data
        $data['page_title'] = 'New Domain User';
        $param = new Nsc_domain_users_param_class();
        $param->configure();
        $domain_profile = $this->_domain_profiles[$domain_name];
        $domain_users = $domain_profile->users();
        
        
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        
        $data['form_title'] = 'Domain Users : New User';
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_cfg'] = $this->safe_form_class->config;
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
                array(
                        'name' => 'create',
                        'value' => 'Create',
                        'type' => 'submit'
                ) ,
                array(
                        'name' => 'cancel',
                        'value' => 'Cancel',
                        'type' => 'submit'
                ) ,
        );
        //******
        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $this->load->view("safe_form_json", $data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        
        $data['page_title'] = $data['form_title'];
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        } 
        $data['reload'] = $reload;
        $data['action_url'] = base_url($this->router->fetch_class().'/add_user/'.$domain_name);
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * Add a new user
     */
    public function add_user($domain_name)
    {
        // verify if logged
        //safe_authenticate ();
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = 'New Domain User';
        $param = new Nsc_domain_users_param_class();
        $param->configure();
        $domain_profile = $this->_domain_profiles[$domain_name];
        $domain_users = $domain_profile->users();
        
        /*$wizard_data = $param->get_data_values();
         $wizard_data['user_id'] = $post['user_id'];
        $param->set_data_values($wizard_data);*/
        // Validate the data
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        if ($this->safe_form_class->run_validation($validation_errors, $param->user_rule_msgs())) {
            $param->save();
            // Check that profile does not exist
            if (isset($domain_users[$post['user_id']])) {
                //Profile exists, throw an error
                $data['message'] = "<b>" . $post['user_id'] . "</b> exists. Please use a different username";
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            } else {
                // TODO(wadam) - Probably need a domain method to create user, this will
                // avoid having to know object path
                $new_obj = $domain_profile->create_user($post['user_id']);
                if ($new_obj) {
                    $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit_user/' . $domain_name . '/' . $new_obj->id(). '/' . $post['user_id']);
                    $data['result'] = true;
                    echo json_encode($data);
                }else{
                    $data['message'] = "Create <b>" . $post['user_id'] . "</b> Failed";
                    $data['message_type'] = 'alert';
                    $data['result'] = false;
                    echo json_encode($data);
                }
            }
        }else{
          //return a json encode form with a error message
          $this->add_form_user($domain_name,true);
        }
    }
    /**
     * Modifies an existing domain user
     * @param String $profile_name:
     *                              Profile being modified
     */
    public function edit_user($domain_name, $user_id, $urer_name='')
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($user_id)) exit('Domain user id required');
        $domain_profile = $this->_domain_profiles[$domain_name];
        $users = $domain_profile->users();
        // retrieve user by id and set user_name
        foreach ($users as $k => $v) {
            if ($user_id == $v->id()) {
                $profile_name = $k;
                break;
            }
        }
        //$profile_name user naem
        if (isset($profile_name)){
            $user = $users[$profile_name];
            $new_obj = false;
        }else{
            $user = $domain_profile->create_user($urer_name);
            $user->configure();
            $user_id=$user->id();
            $new_obj = true;
        }
        
        // Check post request
        $post = $this->input->post();
        if (isset($post['cancel'])) {
            redirect('/' . $this->router->fetch_class() . '/modify/' . $domain_name, 'refresh');
        } elseif (isset($post['save'])) {
            // TODO(wadam) - Validate and save
            //print_r($post);
            unset($post['save']);
            $user->set_data_values($post);
            $validation_errors = array();
            $this->load->library('safe_form_class', $user->get_data());
            // Check new data are valid
            if ($this->safe_form_class->run_validation($validation_errors)) {
                if (TRUE == $user->save()) redirect('/' . $this->router->fetch_class() . '/modify/' . $domain_name, 'refresh');
            }
        }
        // Set the basic data
        $data['page_title'] = $user->name() . ' Domain User Profile';
        $data['page_summary'] = 'This page allows managing Domain profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $config = $user->get_data();
        $this->load->library("safe_form_class", $config);
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $data['form_cfg'] = $form_config;
        // Get the fields group
        // send the group array in our form view
        $field_group = array();
        $field_group = $domain_profile->get_group();
        $data['group'] = $field_group;
        // set the form attributes
        $frm_attributes = array(
            'id' => 'domain_user'
        );
        $this->safe_form_class->set_form_attributes($frm_attributes);
        $data['form_title'] = 'Domain User : ' . $user->name();
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
            array(
                'name' => 'save',
                'value' => 'Save',
                'type' => 'submit'
            ) ,
            array(
                'name' => 'cancel',
                'value' => 'Cancel',
                'type' => 'submit'
            ) ,
        );
        $this->load->view("safe_header", $data);
        $this->load->view("safe_form", $data);
        $this->load->view("safe_footer", $data);
    }
}
?>
