<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Contains a configurable object of sipsecmon rules
 * @author Shaunt Libarian
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_object_class');
safe_require_class('safe_hardware_class');
safe_module_require_class('nsc', 'application');
/*
 * SIP SecMon specific validation rules
*/
function validate_account_filter($str)
{
    // Rules are:
    // 1/ Empty string
    // 2/ 'unknown' string
    // 3/ comma separated account list (email)
    // 4/ 'regex=xxxxx' string
    $rc = (bool)FALSE;
    $str = trim($str);
    if ('' == $str || 'unknown' == strtolower($str) || 'NULL' == $str || !strncmp($str, 'regex=', strlen('regex='))) {
        return (bool)TRUE;
    } else {
        // Coma separeted account list
        // default is all good :)
        $rc = (bool)TRUE;
        $account_list = explode(',', $str);
        foreach ($account_list as $account) {
            // check for exclamation mark
            $account = trim($account);
            if ($account) {
                if (!strncmp($account, '!', 1)) $account = substr($account, 1);
                if (FALSE == filter_var($account, FILTER_VALIDATE_EMAIL) || !preg_match('/@.+\./', $account)) {
                    $rc = (bool)FALSE;
                    break;
                }
            }
        }
    }
    return $rc;
}

function validate_user_agent_filter($str)
{
    // Rules are:
    // 1/ Empty string
    // 3/ Full string
    // 4/ 'regex=xxxxx' string
    $str = trim($str);
    if ('' == $str || $str || !strncmp($str, 'regex=', strlen('regex='))) {
        return (bool)TRUE;
    }
    return (bool)FALSE;
}

//SIP SEC MON Rules Configurable class
class Nsc_sipsecmon_rules_config_class extends Safe_configurable_object_class
{
    private $_sip_profiles = "";
    private $_the_app = "";
    /**
     * Constructor for sipsecmon config class
     * @param $node       
     * @param $parent_name
     * @param $name       
     */
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        $this->add_field('failed_attempts', 'Failed Attempts', 'integer', '', 4);
        $this->set_field_rules('failed_attempts', 'required');
        $this->set_field_help('failed_attempts', 'Number of failed registration attempts to match the rule.');
        $this->add_field('time_frame', 'Interval', 'integer', '', 4);
        $this->set_field_rules('time_frame', 'required');
        $this->set_field_help('time_frame', 'Number of minutes to wait before resetting the counter for failed attempts.');
        $this->add_field('src_ip_filter_expr', 'Source IP Filter', 'string', '', 50);
        $this->set_field_rules('src_ip_filter_expr', 'src_ip_filter_rule');
        $this->set_field_help('src_ip_filter_expr', array(
            '
				Whether to filter registration attempts based on source IP.',
            "",
            "Below is the syntax that must be used for the source IP filter:",
            "",
            "1) NULL = No source IP/Network filtering will be performed.",
            "2) IPv4 IP Address (10.10.0.1)",
            "3) IPv4 Network Address (172.16.0.0/16)",
            "4) Comma seperated list of IPv4 addresses or networks (10.10.0.1, 172.16.0.0/16)"
        ));
        $sip_filter_enum[''] = 'none';
        $this->sip_profiles();
        if (isset($this->_sip_profiles)) {
            foreach ($this->_sip_profiles as $sip) {
                $prof_data = $sip->get_data_values();
                //Create enum array
                $sip_filter_enum[$sip->name() ] = $sip->name();
            }
        }
        $this->add_enum_field('profile_filter', 'SIP Profile Filter', 'dropdown', '', $sip_filter_enum);
        $this->set_field_help('profile_filter', 'Whether to filter registration attempts based on SIP profile.');
        $this->add_field('account_filter_expr', 'Account Registration Filter', 'string', '', 50);
        $this->set_field_rules('account_filter_expr', 'validate_account_filter');
        $this->set_field_help('account_filter_expr', array(
            'Whether to filter registration attempts based on account.',
            "",
            "Below is the syntax that must be used for the Account Registration filter:",
            "",
            '1) NULL = No account filtering will be perfomed.',
            '2) Unknown = The string "unknown" matches any accounts that are not known to the registrar (ie, trying to register joe@domain.com where the domain.com registrar does not know about any joe user). This option only works when SIP thru registration is disabled for the profile receiving the REGISTER request.',
            '3) Comma-separated list of accounts to match, ie "bob@company.com, alice@company.com".',
            '4) A regular expression matching the desired accounts in format: regex="the regular expression"',
        ));
        $this->add_field('user_agent_filter_expr', 'User Agent Filter', 'string', '', 50);
        $this->set_field_rules('user_agent_filter_expr', 'validate_user_agent_filter');
        $this->set_field_help('user_agent_filter_expr', array(
            'Whether to filter registration attempts based on user agent.',
            "",
            "Below is the syntax that must be used for the user agent filter:",
            "",
            '1) NULL = No user agent filtering will be perfomed.',
            '2) Any string (this will be an exact match of the string with the user agent)',
            '3) A regular expression matching the desired user agent in format: regex="the regular expression"',
        ));
        // Action and parameter
        $this->add_enum_field('action_expr', 'Action', 'dropdown', 'false', array(
            'false' => "Log",
            'block_ip' => "Block IP"
        ));
        $this->set_field_help('action_expr', 'Action to perform when the rule matches');
        $this->add_field('action_param', 'Action Parameter', 'string', '', 50);
        // Set validation rule for block_ip as it's currently the only one supported
        $this->set_field_rules('action_param', 'required[action_expr]|greater_or_equal[0]|less_than[1440]');
        $this->set_field_help('action_param', array(
            "<b><u>Defines parameter of the selected action:</u></b>",
            "",
            "<b>Block IP</b> - Number of minutes the IP will remain blocked, from [0 to 1439]. 0 means block this IP forever, until admin manually unblocks it."
        ));
        $this->add_field('comments', 'Comments', 'string', '', 80);
        // Add Conditional Control for global/http
        // 1. create the group control 'http'
        $this->create_group('action', array(
            'action_param'
        ));
        // 2. tell the field 'global/http' which existing group it can control (http)
        $this->conditional_control('action_expr', 'action');
        // Populate the user rule messages
        $this->set_user_rule_msgs(array(
            'validate_account_filter' => 'Invalid Account Filter Expression',
            'validate_user_agent_filter' => 'Invalid User Agent Filter Expression',
        ));
        return parent::configure();
    }

    public function description()
    {
        $desc = $this->get_data_value('comments', false);
        if($desc){
            return $desc;
        }else{
            return $this->name();
        }
    }

    private function sip_profiles()
    {
        //Pulls all sip profiles for rule dropdown
        $this->_the_app = $this->_node->software()->application();
        $this->_sip_profiles = $this->_the_app->sip_profiles();
    }
}
?>
