<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * NSC Product class
*/
require_once ('application/helpers/safe_helper.php');
safe_module_require_class('ntg', 'product');
safe_module_require_class('nsc', 'application');
safe_module_require_class('nsc', 'rtcpmon_service');
safe_module_require_class('nsc', 'sipsecmon_service');
safe_module_require_class('nsc', 'mediamon_service');
class Nsc_license extends Safe_license
{
    public function describe()
    {
        $describe = parent::describe();
        // Remove Max Sessions
        foreach($describe as $k => $v){
            if(!strcasecmp('max-sessions', $k)){
                $describe['Max-Calls'] = $v/2;
                unset($describe[$k]);
                break;
            }
        }
        return $describe;
    }
}
class Nsc_software_class extends Safe_software_class
{
    // Override create_license
    protected function create_license()
    {
        $this->_license = new Nsc_license($this);
        $this->_license->configure($this->node());
    }
}

class Nsc_product_class extends Ntg_product_class
{
    public function __construct()
    {
        parent::__construct("NSC");
    }
    public function &create_application()
    {
        return new Nsc_application_class($this->local_node()->software());
    }
    public function create_software_class($node)
    {
        return new Nsc_software_class($node);
    }
    public function configure($product_def = array())
    {
        parent::configure($product_def);
        //Create rtcpmon service instance
        $rtcpmon = new Nsc_rtcpmon_service_class($this->local_node() , $this->local_node()->software());
        $rtcpmon->configure();
        //Register that service
        $this->local_node()->software()->add_service($rtcpmon);
        //Create sipsecmon service instance
        $sipsecmon = new Nsc_sipsecmon_service_class($this->local_node() , $this->local_node()->software());
        $sipsecmon->configure();
        //Register that service
        $this->local_node()->software()->add_service($sipsecmon);
        //Create mediamon service instance
        $mediamon = new Nsc_mediamon_service_class($this->local_node() , $this->local_node()->software());
        $mediamon->configure();
        //Register that service
        $this->local_node()->software()->add_service($mediamon);
    }
}
/* End of file nsc_product_class.php */
