
<?php

///////////////////////////////////////////////////////////////////////////////
//
// Copyright 2011 Sangoma Technologies Corp.
//
///////////////////////////////////////////////////////////////////////////////
//
// Author: Jonathan Maurice
// Date: 22/07/2011
// Description: Create a div element to be refreshed with AJAX.
// To use this, call Enable() and DynamicDivBegin(). Insert code to be refreshed
// and close the div with DynamicDivEnd().
//
//
///////////////////////////////////////////////////////////////////////////////


class DynamicDiv
{

  public $divId;
  public $uri;
  public $queryArgs;
  public $refreshTimeMs;

  public function __construct($in_DivId, $in_ur, $in_queryArgs = "", $in_refreshTimeMs = 5000)
  {
    $this->divId = $in_DivId;
    $this->uri = $in_uri;
    $this->queryArgs = $in_queryArgs;
    $this->refreshTimeMs = $in_refreshTimeMs;
  }

  public function Enable() {
    // Div refresh
    ?>
    <script type="text/javascript">
      function RefreshDynamicDiv( szDivId, szURI, szQueryArgs, uiTimeoutMs )
      {
        var
          $http,
          $self = arguments.callee,
          $szHttpRequest;

        if (window.XMLHttpRequest) {
          $http = new XMLHttpRequest();
        } else if (window.ActiveXObject) {
          try {
            $http = new ActiveXObject('Msxml2.XMLHTTP');
          } catch(e) {
            $http = new ActiveXObject('Microsoft.XMLHTTP');
          }
        }

        if ($http) {
          $http.onreadystatechange = function()
          {
            if (/4|^complete$/.test($http.readyState)) {
              document.getElementById( szDivId ).innerHTML = $http.responseText;
              setTimeout(function(){$self( szDivId, szURI, szQueryArgs, uiTimeoutMs );}, uiTimeoutMs );
            }
          };
          // $http.open('GET', szUri + '?' + new Date().getTime(), true);
          $szHttpRequest = szURI + '?';
          if ( szQueryArgs.length ) 
            $szHttpRequest += '?' + szQueryArgs + '&';
          // Indicate which div should be refreshed
          $szHttpRequest += 'DynamicDiv=' + szDivId + '&';
          // randomize uri	
          $szHttpRequest += new Date().getTime();
          // Request the page
          $http.open('GET', $szHttpRequest, true);
          $http.send(null);
          
        }

      }

    </script>
    <?php
  }

  public function IsRenderingNonDynamicDiv()
  {
    return ( !isset( $_REQUEST['DynamicDiv'] ));
  }

  public function IsDynamicDivRefreshRequest()
  {
    return ( isset( $_REQUEST['DynamicDiv'] ) && $this->divId == $_REQUEST['DynamicDiv'] );
  }

  //Start the dynamic section.
  public function DynamicDivBegin( $in_divStyle = "" )
  {
    if ( $this->IsRenderingNonDynamicDiv() ){

      echo "<div id='" .$this->divId . "' style='" . $in_divStyle . "'>\n";
    }
    $this->RegisterRefresh( $this->divId );
  }

  //End the dynamic section.
  public function DynamicDivEnd( )
  {
    if ( $this->IsRenderingNonDynamicDiv() ){
      echo "</div>\n";
    }
  }

  private function RegisterRefresh()
  {
	  echo "	<script type='text/javascript'>\n";
		echo "		setTimeout(function() {RefreshDynamicDiv( '" .$this->divId . "', '" 
							. $this->uri . "' , '" 
              . $this->queryArgs . "' , '"
              . $this->refreshTimeMs . "' );} , '"
					    . $this->refreshTimeMs ."' );\n";
		echo "	</script>\n";
  }

}


?>
