#!/bin/bash
exec 0>&- # close stdin
exec 1>&- # close stdout
exec 2>&- # close stderr

PROG=${0##*/}

on_exit() {
  logger -t $PROG on_exit...
}


restart() {
  trap 'on_exit' SIGHUP SIGTERM 
  sleep 5
  logger -t $PROG Stopping webconfig
  /etc/init.d/webconfig stop > /dev/null 2>&1
  RETVAL=$?
  logger -t $PROG Stop Complete = $RETVAL
  sleep 2
  logger -t $PROG Starting webconfig
  /etc/init.d/webconfig start > /dev/null 2>&1
  RETVAL=$?
  logger -t $PROG Start Complete = $RETVAL
}

reload() {
  sleep 5
  logger -t $PROG Reloading webconfig
  /etc/init.d/webconfig graceful > /dev/null 2>&1
  RETVAL=$?
  logger -t $PROG Reload Complete = $RETVAL
}

fork() { 
  logger -t $PROG Forking $@
  ("$@" &) 
  #$@ &
  #disown $!
  RETVAL=$?
  logger -t $PROG Fork Complete = $RETVAL
}

fork restart
#graceful
#fork stop_start
