# !bin/sh
#
# Author: William Adam
# Date: 15/02/2013
# Description:
#
# This script extracts product brand from license
#
# Parameters:
# $1 - License file
#
# Return code:
# 0 - No error
# 1 - License file doesn't exist
#
# Copyright: Sangoma Technologies Corp. 2013

# Adjust product info to license settings (try finding Brand and fallback to
# Product)

if [ "${1}" ] && [ -f $1 ]; then
	product=`grep $1 -i -e 'brand' | cut -d= -f2`
	if [ -z "$product" ]; then
	  product=`grep $1 -i -e 'product' | cut -d= -f2`
	fi
else
  if [ -f /usr/local/sng/conf/brand.default ]; then
    product=`cat /usr/local/sng/conf/brand.default`
  else
    echo "Unknown product brand"
    exit 1
  fi
fi

echo $product
