<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * CodeMirror test page
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('table');
safe_require_class('crud_table');
safe_require_class('form');
class Sng_config_manager_param_class extends Safe_configurable_object_class
{
    private $_name;
    private $_obj_def;
    public function __construct($agg_obj_def)
    {
        parent::__construct('autofill', 'Sng_config_manager_param_class');
        $this->_obj_def = $agg_obj_def;
    }
    public function configure()
    {
        $label = 'New ' . $this->_obj_def['name'];
        if($this->_obj_def['controller']['config_manager']['new_label']){
            $label = $this->_obj_def['controller']['config_manager']['new_label'];
        }
        $this->add_field('profile-name', $label, 'string', '', 50);
        if($this->_obj_def['controller']['config_manager']['new_rule']) {
            $this->set_field_rules('profile-name', $this->_obj_def['controller']['config_manager']['new_rule']);
        } else {
            $this->set_field_rules('profile-name', 'required|alpha_dash');
        }
        parent::configure();
        // No synch
        //$this->synch();
    }
}
class Sng_config_manager extends Safe_CI_Controller
{
    // Inidicate if back is allowed when editing/modifying module
    // Can be override by extended class to prevent foing back to list of module 
    // using back
    protected $allow_back = true;

    //public $_the_product;
    public $_the_app;
    public $_services;
    public $_cfg_mgr;
    public function __construct()
    {
        parent::__construct();
        //$this->_the_product = Safe_get_product();
        $this->_the_app = $this->_the_product->local_node()->software()->application();
        $this->_services = $this->_the_product->local_node()->software()->services();
        $this->_cfg_mgr = $this->_the_product->local_node()->configuration_manager();
    }

    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Configuration Manager';
        $data['page_summary'] = 'This page allows managing System configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        
        $configuration_module = $this->_the_app;
        // Check if configuration need to be regenerated
        $modified_list = array();
        $output = array();
        $param['call_from'] = 'view_controller';
        $result = $configuration_module->api_status_configuration(null, $param, $output);
        if($result['modified'] == true){
            if (Safe_service_class::STATUS_RUNNING == $configuration_module->status()){
                //system running
                $data['notif_error'][] = safe_form_with_submit_button('<b>Configuration is out of date and System is Running.</b></br></br>' . 'You can apply new configuration and restart System using ', '/SAFe/sng_config_manager/generate/true', // TODO(wadam) - Need to get this url from application
                        'Apply & Restart');
                $modified_list = $result['reloadable'];
                if(is_array($modified_list)){
                    $data['table_size'] = '100%';
                    $table = new Safe_crud_table_class();
                    $data['table_title'] = $table->set_title('Reloadable objects');
                    // Prepare heading
                    $table->set_headings(array(
                            'Module',
                            'Type',
                            'Object(s)',
                    ));
                    $table->set_controller_url('/SAFe/' . $this->router->fetch_class());
                    foreach($modified_list as $mod_name => $value){
                        foreach($value as $type_name => $obj_list){
                            $objs = '';
                            foreach($obj_list as $obj_name => $obj_status){
                                if($objs != ''){
                                    $objs.='<br/>';
                                }
                                $objs .= '(' . $obj_status . ') ';
                                $objs .= $obj_name;
                            }
                            $table->add_row(array(
                                    $mod_name,
                                    $type_name,
                                    $objs,
                            ));
                        }
                    }
                    $table->allow_create(false);
                    $table->footer_button = array(
                            array(
                                    'url' => $this->router->fetch_class() . '/dynamic_reload',
                                    'name' => 'Apply & Reload'
                            )
                    );
                    // Generate table HTML code
                    $data['table'] = $table->generate_table();
                }
            }else{
                //system not running
                // Redirect to generate
                Safe_redirect('/SAFe/' . $this->router->fetch_class() . '/generate');
            }
            
        }else{
            // Configuration is up to date
            $data['notif_warn'][] = 'Configuration is up to date.';
        }
        $this->load->view("safe_header", $data);
        $this->load->view("safe_notifications", $data);
        if($data['table']) {
            $this->load->view("safe_table", $data);
        }
        $this->load->view("safe_footer", $data);
    }
    public function application()
    {
        // Set the basic data
        $data['page_title'] = 'Configuration Manager';
        $data['page_summary'] = 'This page allows managing Application configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        //Prepare table structure
        $data['table_size'] = '100%';
        $table = new Safe_crud_table_class();
        $data['table_title'] = $table->set_title('Application configuration');
        // Prepare heading
        $table->set_headings(array(
            'Name',
            'Configuration'
        ));
        // TODO(WADAM) - Figure out why adding safe prefix is required
        $table->set_controller_url('/SAFe/' . $this->router->fetch_class());
        // Check for application and services configurations
        $config = array();
        // Does application has a configuration
        if ($this->_the_app->config()) {
            $app_cfg = $this->_the_app->config();
            $config[$this->_the_app->name() ]['desc'] = $this->_the_app->description();
            $config[$this->_the_app->name() ]['cfg_desc'] = $this->_the_app->config()->description();
        }
        // Loop around services
        foreach ($this->_services as $service) {
            // Service configuration
            if ($service->config()) {
                $config[$service->name() ]['desc'] = $service->description();
                $config[$service->name() ]['cfg_desc'] = $service->config()->description();
            }
            // Check services modules
            foreach ($service->modules() as $k => $v) {
                // check if config present
                if ($v->config()) {
                    $config[$k]['desc'] = $v->description();
                    $config[$k]['cfg_desc'] = $v->config()->description();
                    if ($v->has_aggregate_objects()){
                        $config[$k]['aggregate'] = true;
                    } else {
                        $config[$k]['aggregate'] = false;
                    }
                }else if ($v->has_aggregate_objects()){
                    $config[$k]['desc'] = $v->description();
                    $config[$k]['cfg_desc'] = 'N/A';
                    $config[$k]['aggregate'] = true;
                }
            }
        }
        // Populate table with application confguration rows
        foreach ($config as $k => $v) {
            if (isset($v['aggregate'])) {
                if (!$v['aggregate']) $button_type = "edit";
                elseif ($v['aggregate']) $button_type = "modify";
            } else $button_type = "edit";
            $table->add_row(array(
                $v['desc'],
                $v['cfg_desc'],
            ) , $k, $button_type, '');
        }
        $table->allow_create(false);
        // Generate table HTML code
        $data['table'] = $table->generate_table();
        $this->load->view("safe_header", $data);
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Function which shows aggregated config module or service
     * @param string $cfg    
     *                        Product Name
     * @param string $sub_cfg
     *                        Service/Module Name
     */
    public function modify($module_name, $obj_type=null, $obj_name=null)
    {
        // verify if logged
        //safe_authenticate ();
        if (!isset($module_name)) exit('Service/Module and product name required');
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        // Get config object
        $cfg_obj = $module->config();
        // Prepare Description
        $description = $module->description();

        // Check if we want to work on an object instead of module
        if($obj_type && $obj_name){
            // Locate object
            $aggregated_object = $module->get_aggregate_objects($obj_type);
            if($aggregated_object[$obj_name]){
                $description = $module->description().' '.$module->aggregate_object_name($obj_type).' '.$obj_name;
                $module = $aggregated_object[$obj_name];
                $cfg_obj = $module;
            }
        }

        // Set the basic data
        $data['page_title'] = $description . ' Configuration';
        $data['page_summary'] = 'This page allows managing ' . $description. ' Configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // Display the views
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
        //Show first table
        if($cfg_obj) {
            $table = new Safe_crud_table_class();
            $data['table_size'] = '100%';
            $data['table_title'] = $table->set_title($description.' Configuration');
            $table->set_controller_url($this->router->fetch_class());
            if($obj_type && $obj_name){
                $table->primary_key = $module_name.'/'.$obj_type.'/'.$obj_name;
                $parent_key = $module_name;
            }else{
                $table->primary_key = $module_name;
            }
            if (!empty($cfg_obj)) {
                $prof_data = $cfg_obj->get_data_values_with_field_desc(true, false);
                foreach ($prof_data as $k => $v){
                    $table_line[$k] = $v;
                }
                $table_line[''] = $table->create_button(true, 'Edit', $button_css_class = '', $table->primary_key);
                if($parent_key){
                    $table_line[''] .= $table->create_button(true, 'Cancel', $button_css_class = '', $parent_key, 'modify', true);
                }
            }
            $data['table'] = $table->generate_vertical_line_table('', $table->primary_key, $table_line);
            $this->load->view("safe_table", $data);
            unset($table);
            unset($table_line);
        }
        // Aggregate object tables
        foreach ($module->has_aggregate_objects(false, true) as $_type => $_definition) {
            $table = new Safe_crud_table_class();
            $data['table_size'] = '100%';
            $data['table_title'] = $table->set_title($description . ' - ' . $_definition['name']);
            $table->set_controller_url($this->router->fetch_class());
            $custom = array();
            $custom = $_definition['controller']['config_manager'];
            if($custom['summary_headings']){
                $table->set_headings($custom['summary_headings']);
            }else{
                $table->set_headings(array(
                    'Name',
                    'Description'
                ));
            }
            // Retrieve the objects
            $aggregated_object = $module->get_aggregate_objects($_type);
            if (!empty($aggregated_object)) {
                foreach ($aggregated_object as $object) {
                    if (isset($object)) {
                        // Check for singleton
                        $has_sub = false;
                        if($_definition['singleton']){
                            $primary_key = $module_name. '/' . $_type;
                            $fields = array($_definition['name']);
                        }else{
                            if($obj_type && $obj_name){
                                $primary_key = $module_name. '/' . $obj_type.'/'.$obj_name.'/'. $_type . '/' . $object->name();
                            }else{
                                $primary_key = $module_name. '/' . $_type . '/' . $object->name();
                            }
                            $fields = array($object->name());

                            if($custom['summary_fields']){
                                foreach($custom['summary_fields'] as $field){
                                    $fields[] = $object->get_data_value($field);
                                }
                            }else{
                                $fields[] = $object->description();
                            }
                            $has_sub = $object->has_aggregate_objects();
                        }
                        // Has sub object ?
                        if($has_sub) {
                            $table_line = array(
                                $table->add_row(
                                $fields, 
                                $primary_key, 'Modify|Delete:confirm', '', true)
                            );
                        } else {
                            $table_line = array(
                                $table->add_row(
                                $fields, 
                                $primary_key, 'Edit|Delete:confirm', '', true)
                            );
                        }
                    }
                }
            }
            if($obj_type && $obj_name){
                // Adjust url suffix so will invoke add_form_child/..
                $table->set_url_suffix('child');
                $table->allow_create(true, $module_name . '/'  . $obj_type.'/'.$obj_name.'/'. $_type);
            }else{
                $table->allow_create(true, $module_name . '/' . $_type);
            }
            $data['table'] = $table->generate_table();
            $this->load->view("safe_table", $data);
        }
        $this->load->view("safe_footer", $data);
    }
    /**
     * Function create a json encoded form to Create an aggregated object
     *   using popup dialog in browser
     */
    public function add_form_child($module_name, $obj_type, $obj_name, $sub_type, $reload=false)
    {
        $this->add_form($module_name, $obj_type, $reload, $obj_name, $sub_type);
    }
    public function add_form($module_name, $obj_type,$reload=false, $obj_name=null, $sub_type)
    {
        $profile_exist = false;
        // Check post request
        $post = $this->input->post();
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        // Get config object
        $cfg_obj = $module->config();
        $_type = $obj_type;
        // Add a sub object ?
        if($obj_name && $sub_type){
            $aggregated_object = $module->get_aggregate_objects($obj_type);
            if($aggregated_object[$obj_name]){
                $module = $aggregated_object[$obj_name];
                $_type = $sub_type;
            }
        }

        $param = new Sng_config_manager_param_class($module->get_aggregate_object_definition($_type));
        $param->configure();
        
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);

        // Set the basic data
        $data['page_title'] = $module->description() . ' Configuration';
        //Display form with checkboxes
        $data['form_title'] = $module->description() . ' : Add ' . $module->aggregate_object_name($_type);
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['form_cfg'] = $this->safe_form_class->config;
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
                array(
                        'name' => 'add',
                        'value' => 'Add',
                        'type' => 'submit'
                ) ,
                array(
                        'name' => 'cancel',
                        'value' => 'Cancel',
                        'type' => 'submit'
                ) ,
        );
        //******
        //clear the content in page cache and get the view content
        ob_start();
        ob_clean();
        $this->load->view("safe_form_json", $data);
        $data['content'] = ob_get_contents();
        ob_clean();
        //******
        
        $data['page_title'] = $data['form_title'];
        $data['result'] = true;
        if($reload === true){
            $data['result'] = false; //user sumbit data did not pass the validation, return false and reload the form with error message
        }
        $data['reload'] = $reload;
        if($obj_name && $sub_type){
            $data['action_url'] = base_url($this->router->fetch_class().'/add/'. $module_name. '/' . $obj_type.'/'.$obj_name.'/'.$sub_type);
        }else{
            $data['action_url'] = base_url($this->router->fetch_class().'/add/'. $module_name. '/' . $obj_type);
        }
        $data['action_method'] = 'POST';
        echo json_encode($data);
    }
    /**
     * Create an aggregated object
     * @param unknown_type $cfg
     * @param unknown_type $sub_cfg
     */
    public function add($module_name, $obj_type, $obj_name=null, $sub_type=null)
    {
        $profile_exist = false;
        // Check post request
        $post = $this->input->post();
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        // Get config object
        $cfg_obj = $module->config();
        $_type = $obj_type;
        $aggregated_object = $module->get_aggregate_objects($obj_type);

        // Add a sub object ?
        if($obj_name && $sub_type){
            if($aggregated_object[$obj_name]){
                $module = $aggregated_object[$obj_name];
                $aggregated_object = $module->get_aggregate_objects($sub_type);
                $_type = $sub_type;
            }
        }

        $param = new Sng_config_manager_param_class($module->get_aggregate_object_definition($_type));
        $param->configure();
        
        $data['page_title'] = $module->description() . ' Configuration';
        
        $wizard_data = $param->get_data_values();
        $wizard_data['profile-name'] = $post['profile-name'];
        $param->set_data_values($wizard_data);
        // Validate the data
        $config = $param->get_data();
        $this->load->library("safe_form_class", $config);
        if ($this->safe_form_class->run_validation($validation_errors)) {
            $param->save();
            // Check that profile does not exist
            if (isset($aggregated_object[$post['profile-name']])) {
                //Profile exists, throw an error
                $data['message'] = "<b>" . $post['profile-name'] . "</b> exists. Please use a different " . $module->aggregate_object_name($_type) . " name";
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            } else {
                // Ask module to create aggregate object
                $new_obj = $module->create_aggregate_object($_type, $post['profile-name']);
                if ($new_obj) {
                    if($obj_name && $sub_type){
                        $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit/' . $module_name . '/' . $obj_type . '/' . $obj_name.'/'.$sub_type.'/'.$post['profile-name']);
                    }else{
                        $data['redirect_url'] = base_url('/' . $this->router->fetch_class() . '/edit/' . $module_name . '/' . $obj_type . '/' . $post['profile-name']);
                    }
                    $data['result'] = true;
                    echo json_encode($data);
                } else {
                    $data['message'] = "Fail to create <b>" . $post['profile-name'] . "</b> in " . $module->aggregate_object_name($_type);
                    $data['message_type'] = 'alert';
                    $data['result'] = false;
                    echo json_encode($data);
                }
            }
        }else{
            //return a json encode form with a error message
            if($obj_name && $sub_type){
                $this->add_form_child($module_name, $obj_type, $obj_name, $sub_type, true);
            }else{
                $this->add_form($module_name, $obj_type, true);
            }
        }
    }
    /*
     * Confirm to delete 
     * @param string $cfg
     * @param string $sub_cfg
     * @param string $obj_type
     * @param string $obj_name
     */
    public function delete_confirm($module_name, $obj_type, $obj_name, $sub_type=null, $sub_name=null)
    {
        $data['page_title'] = 'Configuration';
        $profile_exist = false;
        if (!isset($module_name)) {
            $data['message'] = 'Module name required!';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
            exit();
        }
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        $aggregated_object = $module->get_aggregate_objects($obj_type);
        $aggr_object = $aggregated_object[$obj_name];
        $description = $module->description();
        // Want to delete a child object ?
        if($sub_type && $sub_name){
            $module = $aggr_object;
            $aggregated_object = $aggr_object->get_aggregate_objects($sub_type);
            $aggr_object = $aggregated_object[$sub_name];

        }
        // Check post request
        $post = $this->input->post();
        // Set the basic data
        $data['page_title'] = $description . ' Configuration';
        if (isset($aggr_object)) {
            //Check to make sure you can delete, then delete the object
            $reason = array();
            if ($aggr_object->can_dispose($reason)) {
                $data['message'] = 'Are you sure you would like to delete <b>' . $description . ' - '.$aggr_object->name() . '</b>?';
                $data['message_type'] = 'notice';
                $data['result'] = true;
                if($sub_type && $sub_name){
                    $data['action_url'] = base_url($this->router->fetch_class()). '/delete/'. $module_name .'/' . $obj_type . '/' . $obj_name.'/'.$sub_type.'/'.$sub_name;
                }else{
                    $data['action_url'] = base_url($this->router->fetch_class()). '/delete/'. $module_name .'/' . $obj_type . '/' . $obj_name;
                }
                echo json_encode($data);
            }else{
                $reason_msg='';
                if($reason){
                    $reason_msg =(is_array($reason)) ? implode('<br>',$reason) : $reason;
                }
                $reason_msg = ($reason_msg=='')?'':'<br>'.$reason_msg;
                $data['message'] = 'Delete <b>' . $description.' - '.$aggr_object->name() . '</b> Failed.'.$reason_msg;
                $data['message_type'] = 'notice';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            $data['message'] = 'Obj not found!';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /*
     * delete
    * @param string $cfg
    * @param string $sub_cfg
    * @param string $obj_type
    * @param string $obj_name
    */
    public function delete($module_name, $obj_type, $obj_name, $sub_type=null, $sub_name=null)
    {
        $data['page_title'] = 'Configuration';
        $profile_exist = false;
        if (!isset($module_name)) {
            $data['message'] = 'Module name required!';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
            exit();
        }
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        $aggregated_object = $module->get_aggregate_objects($obj_type);
        $aggr_object = $aggregated_object[$obj_name];
        $description = $module->description();
        // Want to delete a child object ?
        if($sub_type && $sub_name){
            $module = $aggr_object;
            $aggregated_object = $aggr_object->get_aggregate_objects($sub_type);
            $aggr_object = $aggregated_object[$sub_name];

        }
        // Set the basic data
        $data['page_title'] = $description . ' Configuration';
        if (isset($aggr_object)) {
            //Dispose aggregated object config
            $aggr_object->dispose();
            //return redirect url
            $data['result'] = true;
            if($sub_type && $sub_name){
                $data['redirect_url'] =  base_url($this->router->fetch_class()). '/modify/' . $module_name.'/'.$obj_type.'/'.$obj_name;
            }else{
                $data['redirect_url'] =  base_url($this->router->fetch_class()). '/modify/' . $module_name;
            }
            echo json_encode($data);
        }else{
            //return error message
            $data['message'] = 'Obj not found!';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * @brief Dyanmic reload
     *           
     * @param[in out] $cfg
     * @param[in out] $sub_cfg
     *           
     * @return
     */
    public function dynamic_reload($module_name = null, $obj_type = null, $obj_name = null)
    {
        // From this point we will display something for sure, so display header
        $data['page_title'] = 'Apply & Reload';
        $data['page_summary'] = 'This page allows Applying & Reloading dynamic objects.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $this->load->view("safe_header", $data);
        // Process to adapter detection
        $data['wait_message'] = '</br><b>Applying & Reloading ...</b></br>&nbsp;';
        $this->load->view("safe_confirm_dialog", $data);
        $this->load->view("safe_wait", $data);
        safe_flush_ouput();

        // Default module is the app
        $module_root = $this->_the_app;
        if($module_name) {
            $module_root = $this->_the_app->find_module_by_name($module_name);
        }
        // TODO - Filter obj_type and obj_name
        
        $configuration_module = $this->_the_app;
        $param['call_from'] = 'view_controller';
        $output = array();
        $rc = $configuration_module->api_reload_configuration($module_name, $param, $output);
        if($rc) {
            safe_redirect('/SAFe/' . $this->router->fetch_class());
        }else{
            if(isset($output['cfg_mgr'])){
                // Populate generation result table
                $data['table_title'] = 'Configuration Generation';
                $table = new Safe_table_class();
                $table->data = $output['cfg_mgr_data'];
                $table->footer_button = array(
                        array(
                                'url' => '/SAFe/sng_control_panel',
                                'name' => 'Control Panel'
                        )
                );
                $data['table'] = $table->generate();
                $data['notif_error'][] = $output['cfg_mgr'];
            }else{
                $data['notif_error'] = $output;
            }
        }

        $this->load->view("safe_notifications", $data);
        if (isset($data['table'])) $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * @brief Reload the module configuration
     *           
     * @param[in out] $cfg
     * @param[in out] $sub_cfg
     *           
     * @return
     */
    public function reload($module_name)
    {
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        // From this point we will display something for sure, so display header
        $data['page_title'] = $module->description() . ' configuration';
        $data['page_summary'] = 'This page allows managing ' . $module->description() . ' configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $this->load->view("safe_header", $data);
        // Process to adapter detection
        $data['wait_message'] = '</br><b>Reloading ' . $module->description() . ' Configuration...</b></br>&nbsp;';
        $this->load->view("safe_confirm_dialog", $data);
        $this->load->view("safe_wait", $data);
        safe_flush_ouput();
        // Reload the module
        $rc = $module->reload();
        // Check success
        if ($rc) {
            // Go back to edit
            safe_redirect('/SAFe/' . $this->router->fetch_class() . '/edit/' . $module_name);
        } else {
            $data['notif_error'][] = safe_form_with_submit_button('Reload ' . $module->description() . ' Configuration Failed.', '/SAFe/' . $this->router->fetch_class() . '/edit/' . $module_name, 'Back');
        }
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * @brief Edit module configuration
     *           
     * @param[in out] $cfg
     * @param[in out] $sub_cfg
     * @param[in out] $obj_type
     * @param[in out] $aggr_edit
     *           
     * @return
     */
    public function edit($module_name, $obj_type = null, $obj_name = null, $sub_type = null, $sub_name = null)
    {
        // Retrieve module to work on
        $module = $this->_the_app->find_module_by_name($module_name);
        // Get config object
        $cfg_obj = $module->config();
        $description = $module->description();
        // Prepare redirect urls
        if($module->has_aggregate_objects()){
            $redirect_url = '/modify/'.$module_name;
        }
        
        //gets aggregated object based on the url. If editing aggregated object, set cfg_obj to the aggregated object configuration
        if ($obj_type && $obj_name) {
            $aggr_obj = $module->get_aggregate_objects($obj_type);
            $cfg_obj = $aggr_obj[$obj_name];
            $description = $module->aggregate_object_name($obj_type).' '.$obj_name;
            if($cfg_obj) {
                if($cfg_obj->has_aggregate_objects()){
                    $redirect_url = '/modify/'.$module_name.'/'.$obj_type.'/'.$obj_name;
                }
                $module = $cfg_obj;
                // Same mechanism if editing a sub object
                if($sub_type && $sub_name){
                    $description = $module->aggregate_object_name($sub_type).' '.$sub_name;
                    $aggr_obj = $module->get_aggregate_objects($sub_type);
                    $cfg_obj = $aggr_obj[$sub_name];
                }
            }
        }elseif($obj_type){
            // Check if this type of object is a singleton
            $obj_def = $module->get_aggregate_object_definition($obj_type);
            if($obj_def && $obj_def['singleton']){
                $description = $module->aggregate_object_name($obj_type);
                $cfg_obj = $module->get_aggregate_objects($obj_type);
            }
        }
        
        $new_obj = false;
        if(!$cfg_obj) {
            if($sub_type && $sub_name){
                $cfg_obj = $module->create_aggregate_object($sub_type, $sub_name);
            } else {
                $cfg_obj = $module->create_aggregate_object($obj_type, $obj_name);
            }
            if($cfg_obj->has_aggregate_objects()){
                $redirect_url = '/modify/'.$module_name.'/'.$obj_type.'/'.$obj_name;
            }
            $cfg_obj->configure();
            $new_obj = true;
        }
        // Check post request
        $post = $this->input->post();
        // Handle post
        if (isset($post['cancel'])) {
            if ($redirect_url) {
                redirect('/' . $this->router->fetch_class() . $redirect_url, 'refresh');
            }
        } elseif (isset($post['save'])) {
            // TODO(wadam) - Validate and save
            //print_r($post);
            unset($post['save']);
            // Prepare an array to retreive errors if any
            $validation_errors = array();
            // update the configurable object with posted values
            $cfg_obj->set_data_values($post);
            // Prepare the form for validation with posted data
            // Note that this is the form that will be used by edit code (after this if/else block)
            // if the validation fail
            $this->load->library('safe_form_class', $cfg_obj->get_data());
            // Check new data are valid
            if ($this->safe_form_class->run_validation($validation_errors)) {
                // Save
                if ($cfg_obj->save()) {
                    if ($redirect_url && $this->allow_back) {
                        redirect('/' . $this->router->fetch_class() . $redirect_url, 'refresh');
                    }
                    $data['notif_warn'][] = $module->description() . ' configuration saved.';
                    $data['auto_hide'] = 'notif_warn';
                }
            }
            // Data not validated correctly
            // Continue to display errors
            
        } else {
            $this->load->library('safe_form_class', $cfg_obj->get_data());
        }
        // Set the basic data
        $data['page_title'] = $description . ' Configuration';
        $data['page_summary'] = 'This page allows managing ' . $description . ' Configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // Display the views
        $this->load->view("safe_header", $data);
        $this->load->view("safe_notifications", $data);
        // Display form for configuration
        //$this->load->library('safe_form_class', $cfg_obj->get_data());
        $cfg_data = array();
        $cfg_data['form_title'] = $description.' Configuration';
        $cfg_data['form'] = $this->safe_form_class->form_input_array();
        $form_config = array();
        $form_config = $this->safe_form_class->config;
        $cfg_data['form_cfg'] = $form_config;
        // Get the fields group
        // send the group array in our form view
        $field_group = array();
        $field_group = $cfg_obj->get_group();
        $cfg_data['group'] = $field_group;
        $cfg_data['label'] = $this->safe_form_class->form_label_array();
        // set the form attributes
        $frm_attributes = array(
            'id' => 'cfg_manager'
        );
        $this->safe_form_class->set_form_attributes($frm_attributes);
        $cfg_data['form_open'] = $this->safe_form_class->form_open();
        //if ($module->has_aggregate_objects() || ($obj_type && $obj_name)) {
        if ($redirect_url && $this->allow_back) {
            $cfg_data['buttons'] = array(
                array(
                    'name' => 'save',
                    'value' => 'Save',
                    'type' => 'submit'
                ) ,
                array(
                    'name' => 'cancel',
                    'value' => 'Cancel',
                    'type' => 'submit'
                ) ,
            );
        } else {
            $cfg_data['buttons'] = array(
                array(
                    'name' => 'save',
                    'value' => 'Save',
                    'type' => 'submit'
                ) ,
            );
        }
        $this->load->view("safe_form", $cfg_data);
        $this->load->view("safe_footer", $data);
    }
    public function generate($restart = false, $force = false)
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Configuration Manager';
        $data['page_summary'] = 'This page allows managing System configuration.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // From this point we will display something for sure, so display header
        $this->load->view("safe_header", $data);
        // Process to adapter detection
        if ($restart) $data['wait_message'] = '<b>Generating Configuration and Restarting System...</b>';
        else $data['wait_message'] = '<b>Generating Configuration...</b>';
        $this->load->view("safe_confirm_dialog", $data);
        $this->load->view("safe_wait", $data);
        safe_flush_ouput();
        $app_status = $this->_the_app->status();
        $rc_restart = TRUE;
        
        $configuration_module = $this->_the_app;
        if(isset($restart)) $param['restart'] = $restart;
        if(isset($force)) $param['force'] = $force;
        $param['call_from'] = 'view_controller';
        $output = array();
        $result = $configuration_module->api_apply_configuration(null,$param,$output);
        if ($result === false ) {
            if(isset($output['sys_running'])){
                $data['notif_error'][] = $output['sys_running'];
            }elseif(isset($output['apply_failed'])){
                $data['notif_error'][] = $output['apply_failed'];
                // Populate generation result table
                $data['table_title'] = 'Configuration Generation';
                $table = new Safe_table_class();
                $table->data = $output['apply_failed_data'];
                $table->footer_button = array(
                        array(
                                'url' => '/SAFe/sng_control_panel',
                                'name' => 'Control Panel'
                        )
                );
                $data['table'] = $table->generate();
            }else{
                if($restart){
                    if(isset($output['restart_failed'])){
                        $data['notif_error'][] = 'System Apply Configuration and Restart Failed.</br>' . safe_form_with_submit_button('', '/SAFe/sng_control_panel', 'Control Panel', '', 'get', 'float:left;');
                    }    
                }
            }
        }else{
            if($restart){
                $data['notif_warn'][] = 'System Apply Configuration and Restart Succeeded.</br>' . safe_form_with_submit_button('', '/SAFe/sng_control_panel', 'Control Panel', '', 'get', 'float:left;');
            }else{
                $data['notif_warn'][] = 'Apply Configuration Succeeded.</br>' . safe_form_with_submit_button('', '/SAFe/sng_control_panel', 'Control Panel', '', 'get', 'float:left;');
            }
        }
        // Already done - $this->load->view ( "safe_header", $data );
        $this->load->view("safe_notifications", $data);
        if (isset($data['table'])) $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
}
/* End of file safe_edito.php */
