<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * Transcoding adapter configuration class
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
safe_require_class('product');
class Sng_transcoding_config_class extends Safe_configurable_object_class
{
    public function __construct($node)
    {
        parent::__construct($node->hardware()->object_name() . '/TRANSCODING', 'config', $node);
    }
    public function detect_interfaces()
    {
        $mgmt_if = $this->_node->hardware()->adapters();
        $if_enum = array();
        foreach ($mgmt_if as $if_name => $if) {
            if (strlen($if->ip_address())) {
                if (!strlen($def_if)) $def_if = $if->name();
                $if_enum[$if->name() ]['name'] = $if->name();
                $if_enum[$if->name() ]['type'] = $if->type();
            }
        }
        // We must have at least one entry or we're in trouble
        if (!strlen($if_enum)) {
            // TODO(wadam) - Do something
            
        }
        return $if_enum;
    }
    /**
     * Determines which mode the object is in, and returns which adapters to use for signalling
     * @return string interfaces
     */
    public function adapter_type()
    {
        $mode = $this->require_transcoding_interface();
        if ($mode == true) $interfaces = null;
        else $interfaces = Safe_hardware_adapter_class::ETHERNET_ADAPTER;
        return $interfaces;
    }
    /**
     * Checks if media interfaces are enabled
     * @return boolean
     */
    public function media_check()
    {
        $config = $this->configure();
        $transcoding_mode_data = $this->get_data_values(false);
        return $transcoding_mode_data['enable_media_interface'];
    }
    /**
     * Returns the IP Mode of the media interfaces (Hidden/Exposed)
     * @return string
     */
    public function ip_mode()
    {
        $config = $this->configure();
        $transcoding_mode_data = $this->get_data_values(false);
        //Some cases it might equal false
        if ($transcoding_mode_data['individual-ip'] == "false") $mode = "Hidden";
        elseif ($transcoding_mode_data['individual-ip'] == "true") $mode = "Exposed";
        return $mode;
    }
    /**
     * Determines whether a transcoding interface is required for signalling
     * @return boolean
     */
    public function require_transcoding_interface()
    {
        $config = $this->configure();
        $transcoding_mode_data = $this->get_data_values(false);
        //Put hidden in if statement just in case
        if ($transcoding_mode_data['enable_media_interface'] == 'false') $mode = false;
        if ($transcoding_mode_data['individual-ip'] == "false" || $transcoding_mode_data['individual-ip'] == "Hidden") $mode = false;
        else $mode = true;
        return $mode;
    }
    public function configure()
    {
        $if_names = $this->detect_interfaces();
        $internal_adapter = false;
        foreach ($if_names as $if => $value) {
            if (Safe_hardware_adapter_class::TRANSCODING_ADAPTER == $value['type']) {
                $def_if[] = $value['name'];
                //Found internal adpaters
                $internal_adapter = true;
            }
            $if_name[] = $value['name'];
        }
        if ($internal_adapter) {
            $mode = array(
                'true' => 'Exposed',
                'false' => 'Hidden',
            );
            $this->add_field('enable_media_interface', 'enable_media_interface', 'hidden', 'true');
            $this->add_enum_field('individual-ip', 'Media Server Interfaces IP Mode', 'dropdown', 'false', $mode);
            $this->set_field_help('individual-ip', '
				Sets whether the transcoding modules are exposed on the external network.<br /><br />
				Hidden -  All media interfaces will be hidden and protected from the external network. Signaling and media will flow together thru the primary network interfaces (ie, eth0 and eth1).
				Do NOT plug an ethernet cable to the media ethernet port (D500/D100).<br /><br />
				Exposed - All media interfaces will be exposed in the network. Media will flow thru the media ethernet port only.
				You must connect an ethernet cable to the media ethernet port (D500/D100)
				');
        } else {
            $this->add_enum_field('enable_media_interface', 'Enable/Disable Media Interfaces', 'dropdown', 'true', $this->enable_disable_enum());
            $this->set_field_help('enable_media_interface', 'Option to enable/disable media interfaces from being used with the system.');
            $this->add_field('individual-ip', 'Media Server Interfaces IP Mode', 'hidden', 'true');
            $this->add_multiple_field('interfaces[]', 'Detect Media Interfaces', 'inline_checkbox', $def_if, $if_name);
            $this->set_field_rules('interfaces[]', 'required');
            $this->set_field_help('interfaces[]', array(
                'Select from a list of interfaces to detect media modules.',
                'Media modules will only be detected on selected interfaces.',
                'All other media module information will be removed.'
            ));
        }
        $this->add_field('ip_address', 'Base IP address', 'text', '10.10.0.1');
        if ($internal_adapter) $this->set_field_rules('ip_address', 'required[individual-ip]|valid_ip');
        else $this->set_field_rules('ip_address', 'required|valid_ip');
        $this->set_field_help('ip_address', array(
            'Starting IP Address to be assigned to the media modules.',
            'For every module discovered, the IP address will be incremented by 1.'
        ));
        $this->add_field('vlan_id', 'VLAN Identifier', 'string', '', 10);
        $this->set_field_rules('vlan_id', 'greater_than[0]|less_than[4097]');
        $this->set_field_help('vlan_id', 'Specify the VLAN identifier that will be used on all media modules discovered.');
        $this->add_field('ext_ip_address', 'Base External IP address', 'text', '');
        $this->set_field_rules('ext_ip_address', 'valid_ip');
        $this->set_field_help('ext_ip_address', array(
            'This is the starting IP address that system will use in the SDP offer or answer. For every module discovered, the IP address will be incremented by 1.',
            'If not specified, system will use the assigned IP address to the media module(default behavior).',
            '',
            'When system is behind a firewall (ie: DMZ or port-forwarding) with RTP ports being forwarded to the media module,
    		it may be desirable to specify this parameter to an IP address that will be mapped by the firewall port-forwarding capabilities to the IP address of the media module.
    		If not set when working under a DMZ or port-forwarding scenario, calls may end up not having audio.
    		'
        ));
        $this->add_field('mask', 'Network Mask', 'text', '255.255.255.0');
        $this->set_field_rules('mask', 'required[individual-ip]|valid_ip');
        $this->set_field_help('mask', 'Subnet mask to be assigned to the media modules.');
        $this->add_field('gateway', 'Default Gateway', 'text', '10.10.0.100');
        $this->set_field_rules('gateway', 'valid_ip');
        $this->set_field_help('gateway', 'Default Gateway to be assigned to the media modules.');
        $this->add_field('udp_begin', 'First UDP port', 'text', '14000');
        $this->set_field_rules('udp_begin', 'required|is_numeric');
        $this->set_field_help('udp_begin', 'Starting UDP port to be assigned to the media modules.');
        $this->add_field('udp_end', 'Last UDP port', 'text', '17999');
        $this->set_field_rules('udp_end', 'required[individual-ip]|is_numeric');
        $this->set_field_help('udp_end', 'Ending UDP port to be assigned to the media modules.');
        // Create group for individual-ip control
        $this->create_group('media_int', array(
            'individual-ip',
            'ip_address',
            'ext_ip_address',
            'mask',
            'gateway',
            //'udp_begin',
            //'udp_end',
            'interfaces[]',
            'vlan_id'
        ));
        $this->conditional_control('enable_media_interface', 'media_int');
        $this->create_group('global', array(
            'ip_address',
            'ext_ip_address',
            'mask',
            'gateway',
            'udp_end',
            'vlan_id'
        ));
        $this->conditional_control('individual-ip', 'global');
        // Auto synch
        $this->synch();
    }
    public function is_enabled()
    {
        $enabled = $this->get_data_value('enable_media_interface', false);
        return ('true' == $enabled);
    }
    /**
     * Checks if the transcoder is enabled, and if it isn't, it will check to see the codec is a PCM Codec
     * @param string  $codec
     * @return boolean
     */
    public function transcoder_media_check($codec, $media_profile )
    {
        $config = $this->configure();
        if ($this->is_enabled()) {
            $codecs = array_keys($media_profile->hw_codec_enum());
        } else {
            $codecs = array_keys($media_profile->sw_codec_enum());
        }
        return in_array($codec, $codecs);
    }

    public function udp_ports(&$start, &$stop)
    {
        $data = $this->get_data_values(false);
        $start = $data['udp_begin'];
        $stop = $data['udp_end'];
    }
}
/* End of file sng_transcoding_config_class.php */
