<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * SNG SSH Linux service wrapper
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
safe_require_class('service');
class Sng_sshd_config_class extends Safe_configurable_object_class
{
    public function __construct($node, $parent_name, $name)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($parent_name, $name, $node);
    }
    public function configure()
    {
        // Default interface name
        $def_if = 'all';
        // Populate IP enumeration with all management interface IP
        $transcoding_mode = new Sng_transcoding_config_class($this->_node);
        $adapter_type = $transcoding_mode->adapter_type();

        $mgmt_if = $this->_node->hardware()->adapters($adapter_type);
        $if_enum = array();
        $if_enum['all'] = 'All interfaces';
        foreach($mgmt_if as $if_name=>$if) {
            if(strlen($if->ip_address()))
            {
                $if_enum[$if->ip_address()] = $if->name() . ' - ' . $if->ip_address();
            }
        }
        $this->add_enum_field('ip', 'Network Interface', 'dropdown', '', $if_enum);
        $this->set_field_help('ip', 'Select interface that sshd listens on.');

        $this->add_field('port', 'Port', 'text', '22',10);
        $this->set_field_help('port', 'Port number that sshd listens on.');
        $this->set_field_rules('port', 'required|integer|greater_than[0]|less_than[61000]');
        
        return parent::configure();
    }

    public function description()
    {
        return parent::description();
    }
}
class Sng_sshd_service_class extends Safe_service_class
{
    public function __construct($software)
    {
        parent::__construct($software, 'sshd');
    }
    /**
     * @brief
     *
     * @return
     */
    public function configure()
    {
        // Set the module description
        $this->set_description("Secure Shell");
    
        // Create the config object
        $cfg = new Sng_sshd_config_class($this->node(), parent::path(),$this->name());
        // Synch with DB
        $cfg->configure();
        $cfg->synch();
        // Attach config to module
        $this->set_config($cfg);
    
        return parent::configure();
    }
    public function can_restore(&$reason)
    {
        // Prevent calling parent as service status will be checked
        return true;
    }
    public function allow_user_ctl()
    {
        return true;
    }
    /**
     * @brief Check for IP_PORT conflicts
     *
     * @param[in out] $src_module_name
     * @param[in out] $resource_type
     * @param[in out] $resource_data
     **  'name'       => Module reporting conflict
     *  'obj_type'   => Object type 
     *  'obj_name'   => (opt) Object name (except for configuration) 
     *  'child_type' => (opt) Child type 
     *  'child_name' => (opt) Object name
     * @return 
     */
    public function check_resource_conflict($src_module_name, $resource_type, $resource_data)
    {
        // IP_PORT conflicts ?
        $conflicts = array();
        if('IP_PORT' == $resource_type){
            // get our configuration
            $data = $this->config()->get_data_values(false);
            $ports[] = array('name' =>$this->name(),'port'=>$data['port'], 'ip'=>$data['ip'], 'type' => 'TCP');
            // Loop around resource data
            foreach($resource_data as $resource){
                // TODO - Check
                foreach($ports as $port_item){
                    if(safe_check_port_conflict($port_item, $resource)){
                        $conflicts[] = array('name' => $this->name(), 'obj_type' =>'Configuration', 'desc' =>'port '.$port_item['port']);
                    }    
                }
            }
        }
        return $conflicts;
    }
    /**
     * @brief Generate sshd configuration
     *
     * @param[in out] $config_manager
     *
     * @return true on success
     */
    public function generate_config(&$config_manager)
    {
        //Generates service configuration files
        if (!$this->_generate_service_config($config_manager)) return false;
        // Invoke parent generate
        return parent::generate_config($config_manager);
    }
    public function _generate_service_config(&$config_manager)
    {
        $data= $this->config()->get_data_values(false);
        $ports[] = array('name' =>$this->name(),'port'=>$data['port'], 'ip'=>$data['ip'], 'type' => 'TCP');

        //check system port
        foreach($ports as $port_item){
            if(!$this->node()->os()->valid_ip_port($port_item['ip'], $port_item['port'], $port_item['type'], 'sshd')){
                $config_manager->add_error('Validating', "{$this->description()} port {$port_item['port']} is used by other program.");
            }
        }

        //check $conflicts
        $conflicts = $this->node()->software()->application()->check_resource_conflict($this->name(), 'IP_PORT', $ports);
        foreach($conflicts as $conflict){
            $mod = $this->node()->software()->application()->find_module_by_name($conflict['name']);
            $name = $mod->description();
            $config_manager->add_error('Validating', "{$this->description()} has IP_PORT conflict with {$name} at {$conflict['desc']}.");
        }
        
        // Get our configuration data (unresolved)
        $sshd_conf_file  = '/etc/ssh/sshd_config';
        $sshd_conf_port = 'Port '.$data['port'];

        if($data['ip'] == 'all'){
            $sshd_conf_ip = 'ListenAddress 0.0.0.0';
        }else{
            $sshd_conf_ip = 'ListenAddress '.$data['ip'];
        }
        $sed_data[] = "/^\s*ListenAddress.*/Id";
        
        $sed_data[] = "/^\s*Port.*/d";
        $sed_data[] = "1i\\$sshd_conf_ip\\";
        $sed_data[] = "1i\\$sshd_conf_port\\";

        $config_manager->add_config(new Safe_configuration_class($sshd_conf_file, 'webconfig', Safe_configuration_class::CFG_UPDATE,Safe_configuration_class::CFG_CHOWN));
        $config_manager->add_config(new Safe_configuration_class($sshd_conf_file, $sed_data, Safe_configuration_class::CFG_UPDATE,Safe_configuration_class::CFG_SED));
        $config_manager->add_config(new Safe_configuration_class($sshd_conf_file, 'root', Safe_configuration_class::CFG_UPDATE,Safe_configuration_class::CFG_CHOWN));

        return true;
    }
    /**
     * @brief Invoked after a successfull write_config
     *
     * @return
     */
    public function post_write_config($obj_type=null)
    {
        // restart service
        if($this->status() == Safe_service_class::STATUS_RUNNING){
            $this->restart();
        }
        return parent::post_write_config($obj_type);
    }
    public function support_reload(&$need_reload = null) {
        parent::support_reload($need_reload);
        return true;
    }
    public function reload_generate_config(&$config_manager, $obj_type=null)
    {
        return $this->generate_config($config_manager);
    }
    public function reload_clear_modified($obj_type=null)
    {
        return $this->clear_configuration_modified();
    }
}
/* End of file sng_sshd_service_class.php */
