<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * CodeMirror test page
 *
 * @author William Adam
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('table');
class Ntg_media_profiles extends Safe_CI_Controller
{
    //public $_the_product;
    public $_the_app;
    public $_media_profiles;
    public function __construct()
    {
        parent::__construct();
        //$this->_the_product = Safe_get_product();
        $this->_the_app = $this->_the_product->local_node()->software()->application();
        $this->_media_profiles = $this->_the_app->media_profiles();
    }
    public function index()
    {
        // verify if logged
        //safe_authenticate ();
        // Set the basic data
        $data['page_title'] = 'Media Profile';
        $data['page_summary'] = 'This page allows managing Media profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        // Prepare table structure
        $table = new Safe_table_class();
        $data['table_title'] = 'Media profiles';
        // Prepare heading
        $table->heading = array(
            'Name',
            'Codec List'
        );
        // Prepare rows
        $table->data = array();
        $table->line_button = array();
        foreach ($this->_media_profiles as $profile) {
            $prof_data = $profile->get_data_values();
            $codec_list = $prof_data['codec-1'] . "~" . $prof_data['codec-2'] . "~" . $prof_data['codec-3'] . "~" . $prof_data['codec-4'] . "~" . $prof_data['codec-5'];
            $codec_list_array = explode("~", $codec_list);
            // At least one codec is required
            $codec_list_format = '<ul>';
            foreach ($codec_list_array as $codec) {
                $codec_list_format.= '<li>' . $codec . '</li>';
            }
            $codec_list_format.= '</ul>';
            $table->data[] = array(
                $profile->name() ,
                $codec_list_format,
            );
            array_push($table->primary_key, $profile->name());
            array_push($table->line_button, array(
                array(
                    'url' => 'ntg_media_profiles/edit',
                    'name' => 'Edit',
                    'label' => ''
                )
            ));
        }
        // Generate table HTML code
        $data['table'] = $table->generate();
        // Display
        $this->load->view("safe_header", $data);
        $this->load->view("safe_table", $data);
        $this->load->view("safe_footer", $data);
    }
    public function edit($profile_type)
    {
        if (!isset($profile_type)) $profile_type = 'in';
        $media_profile = $this->_media_profiles[$profile_type];
        // verify if logged
        //safe_authenticate ();
        // Get the datas
        $config = $media_profile->get_data();
        // Check post request
        $post = $this->input->post();
        if (isset($post['cancel'])) {
            redirect('/ntg_media_profiles/', 'refresh');
        } elseif (isset($post['save'])) {
            // Validate and save
            unset($post['save']);
            // Update config with posted data
            $media_profile->set_data_values($post);
            // Prepare form for configuration
            $this->load->library("safe_form_class", $media_profile->get_data());
            // run validation
            $validation_errors = array();
            if ($this->safe_form_class->run_validation($validation_errors)) {
                if (TRUE == $media_profile->save()) redirect('/ntg_media_profiles/', 'refresh');
            }
            // Add validations errors to notification box
            // TODO(WADAM) - Modify form generation to add error tooltip on  faulty
            // field
            $data['notif_error'] = $validation_errors;
        } else {
            // Not a post
            // Prepare form with configuration and data
            $this->load->library('safe_form_class', $media_profile->get_data());
        }
        // Set the basic data
        $data['page_title'] = 'Media Profile';
        $data['page_summary'] = 'This page allows managing Media profile settings.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $data['form_title'] = 'Media profile : ' . $media_profile->name();
        $data['form'] = $this->safe_form_class->form_input_array();
        $data['label'] = $this->safe_form_class->form_label_array();
        $data['form_open'] = $this->safe_form_class->form_open();
        $data['buttons'] = array(
            array(
                'name' => 'save',
                'value' => 'Save',
                'type' => 'submit'
            ) ,
            array(
                'name' => 'cancel',
                'value' => 'Cancel',
                'type' => 'submit'
            ) ,
        );
        $this->load->view("safe_header", $data);
        $this->load->view("safe_notifications", $data);
        $this->load->view("safe_form", $data);
        $this->load->view("safe_footer", $data);
    }
}
/* End of file safe_edito.php */
