<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * FS SIP Profile Status Page
 *
 * @author Shaunt Libarian
 * @version
 */
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once ('application/helpers/safe_helper.php');
require_once ('application/controllers/Safe_CI_Controller.php');
safe_require_class('product');
safe_require_class('object');
safe_require_class('crud_table');
safe_require_class('form');
class Fs_sip_status extends Safe_CI_Controller
{
    public $_sip_profiles;
    public $_status;
    public $_sip_trunks;
    private $_sip_module = null;
    public function __construct()
    {
        parent::__construct();
        $this->_sip_profiles = $this->_the_app->sip_profiles(); //Holds all SIP Profiles
        $this->_sip_trunks = $this->_the_app->sip_trunks();
        $this->_status = $this->_the_product->local_node()->software()->application()->status();
        $this->_sip_module = $this->_the_app->module("sip");
    }
    public function index()
    {
        if (Safe_service_class::STATUS_RUNNING != $this->_status) {
            // Set the basic data
            $data['page_title'] = 'SIP Profiles';
            $data['page_summary'] = 'This page allows viewing the status SIP profiles.';
            $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
            $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
            $data['errors'] = array();
            $table = new Safe_table_class();
            $data['notif_error'][] = $this->_the_app->description() . ' is currently stopped.'; 
            $data['notif_error'][] = safe_form_with_submit_button('Click here to ', '/SAFe/sng_control_panel', 'Start the Service', '');
            //Loads the HTML Data
            $this->load->view("safe_header", $data);
            $this->load->view("safe_error");
            $this->load->view("safe_notifications", $data);
            $this->load->view("safe_footer", $data);
        } else {
            $output = "";
            $headings = array();
            // Set the basic data
            $data['page_title'] = 'SIP Profiles';
            $data['page_summary'] = 'This page allows viewing the status SIP profiles.';
            $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
            $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
            $this->load->view("safe_header", $data);
            $this->load->view("safe_confirm_dialog", $data);//load dialog js and css
            //Prepare table structure
            $data['table_size'] = '100%';
            try {
                $xml_output = $this->_sip_module->api_status_profile();
                $table = new Safe_crud_table_class();
                $data['table_title'] = $table->set_title('SIP Profile Status');
                $table->set_headings(array(
                    'Name',
                    'Type',
                    'Data',
                    'State'
                ));
                $table->set_controller_url($this->router->fetch_class());
                $table->set_form_method('get');
                $tmp_sip_profile_runing_status = array();
                if (count($xml_output['profile']) == 4 && is_associative_array($xml_output['profile'])) {
                    $status = explode(' ', trim($xml_output['profile']['state']));
                    if (preg_match("'\bRUNNING\b'", $xml_output['profile']['state'])) {
                        $state = '<font color="green"><b>' . $status[0] . '</b></font>';
                        $running = true;
                    }else{
                        $state = '<font color="red"><b>' . $status[0] . '</b></font>';
                        $running = false;
                    }
                    $tmp_sip_profile_runing_status[trim($xml_output['profile']['name'])]=array(
                        "name" => $xml_output['profile']['name'],
                        "type" => $xml_output['profile']['type'],
                        "data" => $xml_output['profile']['data'],
                        "state" => $state,
                        "running" => $running
                    );
                } else {
                    foreach ($xml_output['profile'] as $key => $value) {
                        $status = explode(' ', trim($value['state']));
                        if (preg_match("'\bRUNNING\b'", $value['state'])){
                            $state = '<font color="green"><b>' . $status[0] . '</b></font>';
                            $running = true;
                        }else{
                            $state = '<font color="red"><b>' . $status[0] . '</b></font>';
                            $running = false;
                        }
                        $tmp_sip_profile_runing_status[trim($value['name'])]=array(
                                "name" => $value['name'],
                                "type" => $value['type'],
                                "data" => $value['data'],
                                "state" => $state,
                                "running" => $running
                        );
                    }
                }
                foreach ($this->_sip_profiles as $profile) {
                    if (isset($profile)) {
                        $prof_data = $profile->get_data_values();
                        if(isset($tmp_sip_profile_runing_status[$profile->name()])){
                            $state = $tmp_sip_profile_runing_status[$profile->name()]["state"];
                            $running = $tmp_sip_profile_runing_status[$profile->name()]["running"];
                        }else{
                            $state = '<font color="red"><b>STOPPED</b></font>';
                            $running = false;
                        }
                        if($running){
                            $button = "View|Stop:confirm";
                            $tmp_data = $tmp_sip_profile_runing_status[$profile->name()]["data"];
                        }else{
                            $button = "Start:confirm";
                            $tmp_data = 'sip:NetBorder@'.trim(substr($prof_data['sip-ip'],strpos ($prof_data['sip-ip'], '-')+1) ).':'.$prof_data['sip-port'];
                        }
                        
                        $table->add_row(array(
                                $profile->name() ,
                                'profile',
                                $tmp_data,
                                $state,
                        ) , $profile->name() , $button, '');
                    }
                }
                $table->footer_button = array(
                    array(
                        'url' => base_url('fs_sip_status') ,
                        'name' => 'Refresh'
                    )
                );
                $data['table'] = $table->generate_table();
                $this->load->view("safe_table", $data);
            }
            catch(exception $e) {
                unset($data['notif_error']);
                $data['notif_error'][] = 'Unable to retrieve SIP Profile Information.';
                $this->load->view("safe_notifications", $data);
                unset($data['notif_error']);
            }
            $this->load->view("safe_footer", $data);
        }
    }
    /**
     * Confirm to stop  a sip profile file
     *
     */
    public function stop_confirm($profile_name)
    {
        // Set the basic data
        $data['page_title'] = 'Stop SIP Profile';
        if (isset($this->_sip_profiles[$profile_name])) {
            $data['message'] = ' Calls in this profile will be dropped! <br>Are you sure you would like to stop <b>' . $profile_name . '</b>?';
            $data['message_type'] = 'notice';
            $data['result'] = true;
            $data['action_url'] = base_url($this->router->fetch_class()). '/' . 'stop'.'/'. $profile_name;
            echo json_encode($data);
        }else{
            $data['message'] = 'No SIP Profile found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * stop a  SIP Profile
     * @param string $profile_name
     *                             SIP profile to be stop
     */
    public function stop($profile_name)
    {
        // Set the basic data
        $data['page_title'] = 'Stop SIP Profile';
        if (isset($this->_sip_profiles[$profile_name])) {
            $this->_sip_module->api_stop_profile($profile_name,null,$output);
            if(count($output)){
                $out_message ='';
                foreach($output as $msg){
                    if($out_message==''){
                        $out_message = $msg;
                    }else{
                        $out_message = $out_message .'<br>'.$msg;
                    }
                }
            }else{
                $out_message ='';
            }
            if (preg_match("/\bstopping\b/i", $out_message)){
                //Reload XML [Success]
                //stopping: NSC_SIP_Profile1
                $result = true;
            }else{
                //Invalid Profile [NSC_SIP_Profile2]
                $error_message = $out_message;
                $result = false;
            }
            if ($result) {
                $data['result'] = true;
                $data['redirect_url'] = base_url( $this->router->fetch_class());
                echo json_encode($data);
            }else{
                $data['message'] = $error_message;
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            $data['message'] = 'No sip profile found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Confirm to start a sip profile file
     *
     */
    public function start_confirm($profile_name)
    {
        // Set the basic data
        $data['page_title'] = 'Start SIP Profile';
        if (isset($this->_sip_profiles[$profile_name])) {
            $data['message'] = 'Are you sure you would like to Start <b>' . $profile_name . '</b>?';
            $data['message_type'] = 'notice';
            $data['result'] = true;
            $data['action_url'] = base_url($this->router->fetch_class()). '/' . 'start'.'/'. $profile_name;
            echo json_encode($data);
        }else{
            $data['message'] = 'No SIP Profile found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * start a  SIP Profile
     * @param string $profile_name
     *                             SIP profile to be start
     */
    public function start($profile_name)
    {
        // Set the basic data
        $data['page_title'] = 'Start SIP Profile';
        if (isset($this->_sip_profiles[$profile_name])) {
            $this->_sip_module->api_start_profile($profile_name,null,$output);
            if(count($output)){
                $out_message ='';
                foreach($output as $msg){
                    if($out_message==''){
                        $out_message = $msg;
                    }else{
                        $out_message = $out_message .'<br>'.$msg;
                    }
                }
            }else{
                $out_message ='';
            }
            if (preg_match("/\bsuccessfully\b/i", $out_message)){
                //Reload XML [Success]
                //stopping: NSC_SIP_Profile1
                $result = true;
            }else{
                //Invalid Profile [NSC_SIP_Profile2]
                $error_message = $out_message;
                $result = false;
            }
            if ($result) {
                $data['result'] = true;
                $data['redirect_url'] = base_url( $this->router->fetch_class());
                echo json_encode($data);
            }else{
                $data['message'] = $error_message;
                $data['message_type'] = 'alert';
                $data['result'] = false;
                echo json_encode($data);
            }
        }else{
            $data['message'] = 'No sip profile found.';
            $data['message_type'] = 'alert';
            $data['result'] = false;
            echo json_encode($data);
        }
    }
    /**
     * Returns the SIP Channel Status
     */
    public function channels($offset = '')
    {
        // Set the basic data
        $data['page_title'] = 'SIP Session Status';
        $data['page_summary'] = 'This page allows viewing the SIP Session Status.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $data['errors'] = array();
        $table = new Safe_crud_table_class();
        //$data['table_size'] = '100%';
        $table->set_controller_url($this->router->fetch_class());
        $table->set_form_method('get');
        if (Safe_service_class::STATUS_RUNNING != $this->_status) {
            $data['notif_error'][] = $this->_the_app->description() . ' is currently stopped.'; 
            $data['notif_error'][] = safe_form_with_submit_button('Click here to ', '/SAFe/sng_control_panel', 'Start the Service', '');
            $show_table = false;
        } else {
            $show_table = true;
            $output = NULL;
            $total_calls = 0;
            try {
                
                $params_total = array( 'select' => 'count(*) as total', 'limit' => 1, 'offset' => 0 );
                $rs_total  = $this->_sip_module->api_channels_profile('',$params_total);
                $record_count =  $rs_total[0]->total;
                
                $max_per_page = 20;
                $data_offset = isset($offset) ? $offset : 0;
                
                if ($max_per_page < $record_count) {
                    $this->load->library('pagination');
                    $pagination_config['base_url'] = '/SAFe/' . $this->router->fetch_class() . '/' . $this->router->fetch_method() . '/';
                    $pagination_config['total_rows'] = $record_count;
                    
                    $pagination_config['per_page'] = $max_per_page;
                    $pagination_config['uri_segment'] = 3;
                    $pieces = explode("/", $_SERVER['REQUEST_URI']);
                    if(count($pieces) > 5 ){
                        $pagination_config['uri_segment'] = count($pieces) - 2;
                    }
                    $this->pagination->initialize($pagination_config);
                }
                
                $params = array( 'limit' => $max_per_page, 'offset' => $data_offset );
                $output = $this->_sip_module->api_channels_profile('',$params);
                if($output!=false){
                    foreach ($output as $chan_info) {
                        //direction,name,state,cid_name,read_codec,write_codec,callstate,callee_name
                        if (trim($chan_info->callstate) == "ACTIVE") $state = '<font color="green"><b>' . $chan_info->callstate . '</b></font>';
                        elseif (trim($chan_info->callstate) == "DOWN") $state = '<font color="red"><b>' . $chan_info->callstate . '</b></font>';
                        elseif (trim($chan_info->callstate) == "DIALING") $state = '<font color="D6C537"><b>' . $chan_info->callstate . '</b></font>';
                        elseif (trim($chan_info->callstate) == "RINGING") $state = '<font color="D6C537"><b>' . $chan_info->callstate . '</b></font>';
                        elseif (trim($chan_info->callstate) == "EARLY") $state = '<font color="99CC99"><b>' . $chan_info->callstate . '</b></font>';
                        elseif (trim($chan_info->callstate) == "HELD") $state = '<font color="orange"><b>' . $chan_info->callstate . '</b></font>';
                        elseif (trim($chan_info->callstate) == "HANGUP") $state = '<font color="red"><b>' . $chan_info->callstate . '</b></font>';
                        $table->add_row(array(
                                ucfirst($chan_info->direction) ,
                                $chan_info->name,
                                //$chan_info->state,
                                $chan_info->cid_name,
                                $chan_info->callee_name,
                                $chan_info->write_codec,
                                //$chan_info->callstate,
                                $state,
                        ) , $chan_info->uuid, 'Details', '', true);
                        $total_calls++;
                    }
                }
            }catch(exception $e) {
                $data['notif_error'][] = "Unable to retreive Session Information.";
                $data['notif_warn'][] = safe_form_with_submit_button('', '/SAFe/fs_sip_status/channels/', 'Click to Refresh', '');
                $show_table = false;
            }
            $data['table_title'] = $table->set_title('Session Status (' . $rs_total[0]->total . ')');
            $table->set_headings(array(
            'Direction',
            'Channel Name',
            'Caller Name',
            'Callee Name',
                    'Codec',
                    'Call State'
            ));
                    
            if (isset($pagination_config)) $table->set_footer($this->pagination->create_links());
                    $data['table'] = $table->generate_table();
        }
        $data['notif_warn'][] = '<div style="float:left;height:22px;line-height:22px;">&nbsp;&nbsp;</div>'.
                '<div style="float:left"> Click to Refresh '.safe_button_click("refresh", ucfirst('Refresh') , '/SAFe/' . $this->router->fetch_class() . '/' . $this->router->fetch_method() . '/' .$offset, array(
                        'float:right;'
                )).'</div>';
        
        //Loads the HTML Data
        $this->load->view("safe_header", $data);
        $this->load->view("safe_error");
        $this->load->view("safe_notifications", $data);
        if ($show_table) $this->load->view('safe_table', $data);
        $this->load->view("safe_footer", $data);
    }
    public function details($uuid)
    {
        // Set the basic data
        $data['page_title'] = 'SIP Channel Status';
        $data['page_summary'] = 'This page allows viewing the SIP Session Status.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $data['errors'] = array();
        $table = new Safe_crud_table_class();
        //$data['table_size'] = '100%';
        $data['table_title'] = $table->set_title('Session Details');
        $table->set_controller_url($this->router->fetch_class());
        $table->set_form_method('get');
        if (Safe_service_class::STATUS_RUNNING != $this->_status) {
            $data['notif_error'][] = safe_form_with_submit_button($this->_the_product->name() . ' is currently stopped. To start the ' . $this->_the_product->name() . ' Service, please proceed to the ', '/SAFe/sng_control_panel', 'Control Panel', '');
            $show_table = false;
        } else {
            $data['notif_warn'][] = safe_form_with_submit_button('', '/SAFe/fs_sip_status/channels', 'View all Sessions', '');
            $show_table = true;
            $output = NULL;
            $a = 0;
            try {
                $params = array( 'uuid' => $uuid, 'limit' => 1, 'offset' => 0 );
                $output = $this->_sip_module->api_channels_profile('',$params);
                if($output == false){
                    $data['notif_warn'][] = "UUID " . $uuid . ' is no longer a valid session.';
                    $show_table = false;
                }else{
                    foreach ($output as $chan_info) {
                        if ($uuid == $chan_info->uuid) {
                            if (trim($chan_info->callstate) == "ACTIVE") $state = '<font color="green"><b>' . $chan_info->callstate . '</b></font>';
                            elseif (trim($chan_info->callstate) == "DOWN") $state = '<font color="red"><b>' . $chan_info->callstate . '</b></font>';
                            elseif (trim($chan_info->callstate) == "DIALING") $state = '<font color="D6C537"><b>' . $chan_info->callstate . '</b></font>';
                            elseif (trim($chan_info->callstate) == "RINGING") $state = '<font color="D6C537"><b>' . $chan_info->callstate . '</b></font>';
                            elseif (trim($chan_info->callstate) == "EARLY") $state = '<font color="99CC99"><b>' . $chan_info->callstate . '</b></font>';
                            elseif (trim($chan_info->callstate) == "HELD") $state = '<font color="orange"><b>' . $chan_info->callstate . '</b></font>';
                            elseif (trim($chan_info->callstate) == "HANGUP") $state = '<font color="red"><b>' . $chan_info->callstate . '</b></font>';
                            //Display all session info in a vertical table
                            $table_line = array(
                                    'UUID' => $chan_info->uuid,
                                    'Direction' => $chan_info->direction,
                                    'Creation Date' => $chan_info->created,
                                    'Creation Epoch' => $chan_info->created_epoch,
                                    'Channel Name' => $chan_info->name,
                                    'Channel State' => $chan_info->state,
                                    'Caller ID Name' => $chan_info->cid_name,
                                    'Caller ID Number' => $chan_info->cid_num,
                                    'IP Address' => $chan_info->ip_addr,
                                    'Destination' => $chan_info->dest,
                                    //'Application' => $chan_info->application,
                                    //'Application Data' => $chan_info->application_data,
                                    //'Dialplan' => $chan_info->dialplan,
                                    //'Context' => $chan_info->context,
                                    'Inbound Codec' => $chan_info->read_codec,
                                    'Inbound Codec Rate' => $chan_info->read_rate,
                                    'Inbound Codec Bit Rate' => $chan_info->read_bit_rate,
                                    'Outbound Codec' => $chan_info->write_codec,
                                    'Outbound Codec Rate' => $chan_info->write_rate,
                                    'Outbound Codec Bit Rate' => $chan_info->write_bit_rate,
                                    'Secure' => $chan_info->secure,
                                    //'Hostname' => $chan_info->hostname,
                            //'Presence ID' => $chan_info->presence_id,
                            //'Presence Data' => $chan_info->presence_data,
                            'Call State' => $state,
                            'Callee Name' => $chan_info->callee_name,
                            'Callee Number' => $chan_info->callee_num,
                            //'Callee Direction' => $call_info->callee_direction,
                            'Call UUID' => $chan_info->call_uuid,
                            //'Sent Callee Name' => $call_info->callee_name[28],
                            //'Sent Callee Number' => $call_info->sent_callee_num[29]
                    
                            );
                            $table->footer_button = array(
                                    array(
                                            'url' => base_url('fs_sip_status/details/' . $uuid) ,
                                            'name' => 'Refresh'
                                    )
                            );
                            break;
                        } else {
                            $data['notif_warn'][] = "UUID " . $uuid . ' is no longer a valid session.';
                            $show_table = false;
                        }
                    }
                }
            }
            catch(exception $e) {
                $data['notif_error'][] = "Unable to retreive Session Information.";
                $show_table = false;
            }
            $data['table'] = $table->generate_vertical_line_table('', $uuid, $table_line);
        }
        //Loads the HTML Data
        $this->load->view("safe_header", $data);
        $this->load->view("safe_error");
        $this->load->view("safe_notifications", $data);
        if ($show_table) $this->load->view('safe_table', $data);
        $this->load->view("safe_footer", $data);
    }
    /**
     * Displays information about the particular SIP Profile
     * @param string $sip_profile
     */
    public function view($sip_profile,$page)
    {
        // Set the basic data
        $data['page_title'] = 'SIP Profiles';
        $data['page_summary'] = 'This page allows viewing the status SIP profiles.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load confirm dialog js and css
        $data['notif_warn'][] = safe_form_with_submit_button('', '/SAFe/fs_sip_status', 'View all SIP Profiles', '');
        $this->load->view("safe_notifications", $data);
        $sip_profile_data = "";
        $trunk_data = "";
        $output = "";
        try {
            $sip_profile_obj = $this->_sip_profiles[$sip_profile];
            $sip = $sip_profile_obj->get_data_values(false);
            $xml_output = $this->_sip_module->api_status_profile();
            $sip_profile_xml_output = $this->_sip_module->api_status_profile($sip_profile);
            if (is_associative_array($xml_output['profile'])) $state = $xml_output['profile']['state'];
            else {
                foreach ($xml_output['profile'] as $key => $value) {
                    if ($value['name'] == $sip_profile) $state = $value['state'];
                }
            }
            $status = explode(' ', trim($state));
            //Print SIP Profile Information
            //Vertical table
            $table = new Safe_crud_table_class();
            $data['table_size'] = '100%';
            $data['table_title'] = $table->set_title('SIP Profile Status');
            $table->set_controller_url($this->router->fetch_class());
            $table->set_form_method('get');
            $table_line = array(
                'Profile Name' => $sip_profile_xml_output['profile-info']['name'],
                'State' => '<font color="green"><b>' . $status[0] . '</b></font>',
                //'Domain Name' => $sip_profile_xml_output['profile-info']['domain-name'] ,
                //'Auto NAT' =>  $sip_profile_xml_output['profile-info']['auto-nat'],
                //'Database name' => $sip_profile_xml_output['profile-info']['db-name'],
                //'Dialplan' => $sip_profile_xml_output['profile-info']['dialplan'],
                'Dialplan' => str_replace('profile-', '', $sip_profile_xml_output['profile-info']['context']) ,
                //'Challange Realm' => $sip_profile_xml_output['profile-info']['challenge-realm'],
                'RTP IP Address' => $sip_profile_xml_output['profile-info']['rtp-ip'],
                'External RTP IP Address' => $sip_profile_xml_output['profile-info']['ext-rtp-ip'],
                'SIP IP Address' => $sip_profile_xml_output['profile-info']['sip-ip'],
                'External SIP IP Address' => $sip_profile_xml_output['profile-info']['ext-sip-ip'],
                'URL' => $sip_profile_xml_output['profile-info']['url'],
                'Bind URL' => $sip_profile_xml_output['profile-info']['bind-url'],
                'TLS URL' => $sip_profile_xml_output['profile-info']['tls-url'],
                'TLS Bind URL' => $sip_profile_xml_output['profile-info']['tls-bind-url'],
                //'Hold Music' => $sip_profile_xml_output['profile-info']['hold-music'],
                //'Outbound Proxy' => $sip_profile_xml_output['profile-info']['outbound-proxy'],
                'Inbound Codecs' => $sip_profile_xml_output['profile-info']['inbound-codecs'],
                'Outbound Codecs' => $sip_profile_xml_output['profile-info']['outbound-codecs'],
                //'Tel Event' => $sip_profile_xml_output['profile-info']['tel-event'],
                'DTMF Mode' => $sip_profile_xml_output['profile-info']['dtmf-mode'][0],
                /*'CNG' => $sip_profile_xml_output['profile-info']['cng'],
                'Session to' => $sip_profile_xml_output['profile-info']['session-to'],
                'Max Dialog' => $sip_profile_xml_output['profile-info']['max-dialog'],
                'No Media' => $sip_profile_xml_output['profile-info']['nomedia'],
                'Late Neg' => $sip_profile_xml_output['profile-info']['late-neg'],
                'Proxy Media' => $sip_profile_xml_output['profile-info']['proxy-media'],
                'Aggressive NAT' => $sip_profile_xml_output['profile-info']['aggressive-nat'],
                'STUN Server Enabled' => $sip_profile_xml_output['profile-info']['stun-enabled'],
                'STUN Server Auto Disable' => $sip_profile_xml_output['profile-info']['stun-auto-disable'],
                'MAX Registrations per Extension' => $sip_profile_xml_output['profile-info']['max-registrations-per-extension'],*/
                'Incoming Calls' => $sip_profile_xml_output['profile-info']['calls-in'],
                'Outgoing Calls' => $sip_profile_xml_output['profile-info']['calls-out'],
                'Failed Incoming Calls' => $sip_profile_xml_output['profile-info']['failed-calls-in'],
                'Failed Outgoing Calls' => $sip_profile_xml_output['profile-info']['failed-calls-out'],
                'Total Active Sessions' => trim(trim($status[1], '(') , ')')
            );
            // Generate table HTML code
            $table->footer_button = array(
                array(
                    'url' => base_url('fs_sip_status/view/' . $sip_profile) ,
                    'name' => 'Refresh'
                )
            );
            $data['table'] = $table->generate_vertical_line_table('', $sip_profile, $table_line);
            unset($table);
            $this->load->view("safe_table", $data);
            //Print SIP Registration Information
            //$sip_profile_xml_output['profile-info']
            $table = new Safe_crud_table_class();
            $data['table_size'] = '100%';
            
            $table->set_controller_url(base_url($this->router->fetch_class()));
            $table->set_form_method('get');
            $table->set_headings(array(
                'User',
                'IP Address',
                'IP Port'
            ));
            
            $max_display_record = 50;
            $init_offset = 0;
            $params_total = array( 'select' => 'count(*) as total', 'limit' => 1, 'offset' => 0 );
            $rs_total = $this->_sip_module->api_registration_profile($sip_profile,$params_total);
            $page_total = ceil($rs_total[0]->total/$max_display_record);
            if($page < 1){
                $page = 1;
            }elseif($page > $page_total){
                if($page_total > 0){
                    $page = $page_total;
                }else{
                    $page = 1;
                }
            }
            $init_offset = ($page - 1) * $max_display_record;
            $previous_page = $page -1;
            $next_page = $page + 1;
            
            $params = array( 'limit' => $max_display_record, 'offset' => $init_offset );
            $reg_output = $this->_sip_module->api_registration_profile($sip_profile,$params);
              
            if (!empty($reg_output)) {
                foreach ($reg_output as $key => $value) {
                    $table->add_row(array(
                        $value['user'],
                        $value['network-ip'],
                        $value['network-port'],
                    ) , $sip_profile . '/' . urlencode($value['user']). '/' . urlencode($value['call-id']) , 'More|Flush:confirm', '');
                }
            }
            $data['table_title'] = $table->set_title('SIP Profile Registrations(' . $rs_total[0]->total . ')');
            $table->footer_button = array(
                array(
                        'url' => base_url('fs_sip_status/registrations_flush_confirm/' . $sip_profile) ,
                        'name' => 'Flush',
                        'type' => 'confirm'
                ),
                array(
                    'url' => base_url('fs_sip_status/view/' . $sip_profile .'/'.$page) ,
                    'name' => 'Refresh'
                ) 
            );
            if($previous_page >= 1 ){
                array_push($table->footer_button, array(
                'url' => base_url('fs_sip_status/view/'. $sip_profile .'/'.$previous_page) ,
                'name' => 'Prev Page'
                        ));
            }
            if($next_page > $page && $next_page <= $page_total){
                array_push($table->footer_button, array(
                'url' => base_url('fs_sip_status/view/'. $sip_profile .'/'.$next_page) ,
                'name' => 'Next Page'
                        ));
            }
            $data['table'] = $table->generate_table();
            unset($table);
            $this->load->view("safe_table", $data);
            //Print SIP Trunk Status
            $table = new Safe_crud_table_class();
            $data['table_size'] = '100%';
            $data['table_title'] = $table->set_title('SIP Trunk Status');
            $table->set_controller_url(base_url($this->router->fetch_class()));
            $table->set_form_method('get');
            $table->set_headings(array(
                'SIP Trunk',
                'State',
                'Status'
            ));
            if (!empty($this->_sip_trunks)) {
                foreach ($this->_sip_trunks as $profile) {
                    if (isset($profile)) {
                        $prof_data = $profile->get_data_values();
                        if ($prof_data['sip_profile'] == $sip_profile) {
                            $xml_trunk = $this->_sip_module->api_gateway_status_profile($profile->name());
                            if($xml_trunk){
                                if ($xml_trunk['state'] == "REGISTER" || $xml_trunk['state'] == "REGED") $state = '<font color="green"><b>' . $xml_trunk['state'] . '</b></font>';
                                elseif ($xml_trunk['state'] == "FAILED" || $xml_trunk['state'] == "FAIL_WAIT") $state = '<font color="red"><b>' . $xml_trunk['state'] . '</b></font>';
                                else $state = '<font color="orange"><b>' . $xml_trunk['state'] . '</b></font>';
                                if ($xml_trunk['status'] == "UP") $status = '<font color="green"><b>' . $xml_trunk['status'] . '</b></font>';
                                else $status = '<font color="red"><b>' . $xml_trunk['status'] . '</b></font>';
                            }else{
                                $state = '<font color="orange"><b>Not Applied</b></font>';
                                $status = '<font color="red"><b>Not Activated</b></font>';
                            }
                            $table->add_row(array(
                                $profile->name() ,
                                $state,
                                $status
                            ) , '', '', '');
                        }
                    }
                }
            }
            $table->footer_button = array(
                array(
                    'url' => base_url('fs_sip_status/view/' . $sip_profile) ,
                    'name' => 'Refresh'
                )
            );
            $data['table'] = $table->generate_table();
            $this->load->view("safe_table", $data);
        }
        catch(exception $e) {
            $data['notif_warn'] = array();
            $data['notif_error'][] = "Unable to retrieve information on the SIP Profile " . $sip_profile;
            $this->load->view("safe_notifications", $data);
        }
        $this->load->view("safe_footer", $data);
    }
    public function flush_confirm($sip_profile,$reg_name,$call_id)
    {
        $data['page_title'] = 'Flush Registrations';
        $data['message'] = 'Are you sure you would like to Flush Registrations <b>'.urldecode($reg_name). '<br>(CALLID:'.urldecode($call_id).')</b>?';
        $data['message_type'] = 'notice';
        $data['result'] = true;
        $data['action_url'] = base_url('fs_sip_status/registrations_flush/' . $sip_profile.'/'.$call_id);
        echo json_encode($data);
    }
    public function registrations_flush_confirm($sip_profile)
    {
        $data['page_title'] = 'Flush Registrations';
        $data['message'] = 'Are you sure you would like to Flush Registrations?';
        $data['message_type'] = 'notice';
        $data['result'] = true;
        $data['action_url'] = base_url('fs_sip_status/registrations_flush/' . $sip_profile);
        echo json_encode($data);
    }
    public function registrations_flush($sip_profile,$call_id='')
    {
        $output = array();
        if ($call_id != '') $call_id = urldecode($call_id);
        $params = array( 'call_id' => $call_id );
        $this->_sip_module->api_flush_registration_profile($sip_profile,$params);
        $data['result'] = true;
        $data['redirect_url'] =  base_url('fs_sip_status/view/' . $sip_profile);
        echo json_encode($data);
    }
    public function more($sip_profile, $reg_name)
    {
        // Set the basic data
        $data['page_title'] = 'SIP Profiles';
        $data['page_summary'] = 'This page allows viewing the status SIP profiles.';
        $data['page_large_icon'] = '/images/icons/32x32/icon-network.png';
        $data['page_small_icon'] = '/images/icons/16x16/icon-network.png';
        $this->load->view("safe_header", $data);
        $this->load->view("safe_confirm_dialog", $data);//load dialog js and css
        $sip_profile_data = "";
        $trunk_list_up = "";
        $trunk_list_down = "";
        $register_name = urldecode($reg_name);
        try {
            $table = new Safe_crud_table_class();
            $data['table_size'] = '100%';
            $data['table_title'] = $table->set_title($register_name);
            $table->set_controller_url($this->router->fetch_class());
            $table->set_form_method('get');
            $params = array( 'reg_name' => $register_name, 'limit' => 1, 'offset' => 0 ); 
            $sip_regitster = $this->_sip_module->api_registration_profile($sip_profile,$params);
            if ($sip_regitster!=false) {
                foreach ($sip_regitster as $key => $value) {
                    if ($value['user'] == $register_name) {
                        $table_line = array(
                                'User' => $value['user'],
                                'Call-ID' => $value['call-id'],
                                'Contact' => $value['contact'],
                                'Thru-Contact' => $value['thru-contact'],
                                'Agent' => $value['agent'],
                                'Status' => $value['status'],
                                'Host' => $value['host'],
                                'IP Address' => $value['network-ip'],
                                'IP Port' => $value['network-port'],
                                'SIP Authentication Realm' => $value['sip-auth-realm'],
                                'SIP Authentication User' => $value['sip-auth-user']
                        );
                        $call_id = $value['call-id'];
                        break;
                    }
                }
            }else{
                $table_line = array();
                $error = "Unable to retrieve information on the user " . $register_name;
                throw new Exception($error);
            }
            $table->footer_button = array(
                array(
                    'url' => base_url('fs_sip_status/more/' . $sip_profile . '/' . $reg_name) ,
                    'name' => 'Refresh'
                ),
                array(
                    'url' => base_url('fs_sip_status/flush_confirm/' . $sip_profile. '/' . $reg_name . '/' . urlencode($call_id)) ,
                    'name' => 'Flush',
                    'type' => 'confirm'
                )
            );
            $data['table'] = $table->generate_vertical_line_table('', $sip_profile, $table_line);
            unset($table);
            $data['notif_warn'][] = safe_form_with_submit_button('', '/SAFe/fs_sip_status/view/' . $sip_profile, 'Click to view ' . $sip_profile . ' Status', '');
            $this->load->view("safe_notifications", $data);
            $this->load->view("safe_table", $data);
        }
        catch(exception $e) {
            $data['notif_warn'][] = safe_form_with_submit_button('', '/SAFe/fs_sip_status/view/' . $sip_profile, 'Click to view ' . $sip_profile . ' Status', '');
            $data['notif_error'][] = "Unable to retrieve information on the user " . $register_name;
            $this->load->view("safe_notifications", $data);
        }
        $this->load->view("safe_footer", $data);
    }
}
?>
