<?php
/*
 * FS Sangoma Media Server module class
 */
require_once('application/helpers/safe_helper.php');
safe_require_class('safe_service_class');
safe_module_require_class('fs','application');
safe_module_require_class('sng','transcoding_config');

class Fs_sngms_module_class extends Fs_module_class  {

  /**
    * @brief
    *
    * @param[in out] $fs_app
    *
    * @return
   */
  public function __construct($fs_app) {
    parent::__construct($fs_app, "sngms");

  }

  /**
    * @brief
    *
    * @return
   */
  public function configure(){
    // Set the module description
    $this->set_description("Media Server");
    $cfg = new Sng_transcoding_config_class($this->fs_app()->node());
    $cfg->configure();
    $cfg->synch();

    // Attach config to module
    $this->set_config($cfg);

    return parent::configure();
  }
  
  /**
    * @brief Is module enabled
    *
    * @param[in out] $mod_name
    *
    * @return 
   */
  public function is_enabled($mod_name = "") {
    // Check if transcoding enabled ?
    $cfg = $this->config();
    if($cfg->is_enabled()){
      // force load module sngms
      // force noload for TDM
      return ($mod_name=="mod_sangoma_media_server.so")?'load':'skip';
    }
    return ($mod_name=="mod_sangoma_media_server.so")?false:'load';
  }
  /**
   * Returns whether the module is a critical module
   * @return boolean
   */
  public function is_critical($mod_name="") {
  	return ($mod_name=="mod_sangoma_media_server.so")?TRUE:FALSE;
  }
  /**
   * @brief Return FS module name
    *
    * @return string
   */
  public function get_fs_module_name() {
		//two module for Media server
    $mod = array(
      'mod_sangoma_media_server.so',
      'CORE_PCM_MODULE', 
      'mod_spandsp.so',
      'mod_ilbc.so',
      'mod_g729.so',
      'mod_g723_1.so',
      'mod_siren.so',
      'mod_h26x.so',
    );	
		return $mod;
  }

  /**
    * @brief
    *
    * @param[in out] $config_manager
    *
    * @return
   */
  public function generate_config(&$config_manager){
    return parent::generate_config($config_manager);
  }

  /*
   * Return usage statistics
   */
  public function term_sessions(&$result)
  {
  	$output = array();
  	if ($this->eslapi_execute('hupall','',$output))
  	{
  		return true;
  	}
  	return false;
  }
  
  //Drops all active sessions
  public function service_request(&$result, $mac, $service_type)
  {
  	$cmd = 'sngms_control service ' . $service_type . ' mac ' . $mac;
  	if ($this->eslapi_execute($cmd,'',$result))
  	{
  		return true;
  	}
  	return false;
  } 
  
  //Returns usage statistics
  public function stats_usage(&$stats, $summary=false){
    $output = array();
    $cmd = 'sngms_stats_xml usage';
    if (!$summary)
      $cmd = $cmd.' all';
       
    if($this->eslapi_execute($cmd, "", $output) ) 
    {
      $stats = Safe_xml_to_array($output);
      if (!$summary) {
        // Check if module array is created correctly
        // When only 1 module is returned, conversion from XML to array
        // can't figure out this is and arry. Ending up in:
        // [modules]
        //   [module]
        //     [stats]
        //
        // Instead of
        // [modules]
        //   [module]
        //     [0] <-- Missing info
        //       [stats]
        //
        if (isset($stats['usage'])
          && isset($stats['usage']['modules'])
          && isset($stats['usage']['modules']['module'])
          && !is_indexed_array($stats['usage']['modules']['module']))
        {
          $tmp = $stats['usage']['modules']['module'];
          unset($stats['usage']['modules']['module']);
          $stats['usage']['modules']['module'] = array(
            '0' => $tmp);
        }
      }
      return true;
    }
    return false;
  }

  //Returns duration statistics
  public function stats_duration(&$stats,$summary=false){
    $output = array();
    $cmd = 'sngms_stats_xml duration';
    if (!$summary)
    	$cmd = $cmd.' all';
    
    
    if($this->eslapi_execute($cmd,"",$output) ) 
    {
      $stats = Safe_xml_to_array($output);
      if (!$summary) {
        // Check if module array is created correctly
        // When only 1 module is returned, conversion from XML to array
        // can't figure out this is and arry. Ending up in:
        // [modules]
        //   [module]
        //     [stats]
        //
        // Instead of
        // [modules]
        //   [module]
        //     [0] <-- Missing info
        //       [stats]
        //
        if (isset($stats['duration'])
          && isset($stats['duration']['modules'])
          && isset($stats['duration']['modules']['module'])
          && !is_indexed_array($stats['duration']['modules']['module']))
        {
          $tmp = $stats['duration']['modules']['module'];
          unset($stats['duration']['modules']['module']);
          $stats['duration']['modules']['module'] = array(
            '0' => $tmp);
        }
      }
      return true;
    }
    return false;
  }
}

/* End of file fs_sngms_module_class.php */
