<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
View parameters (to pass as $data['xxx']):
- min_line => Minimum number of line in each container
- tabs => array of tabs
   - id      => Id of content container (optional)
   - title   => Tab title
   - mode    => display mode: table(default), paragraph, pre
   - content => Tab content
*/
if (isset($tabs)) {
?>

<style>
.ui-tabs .ui-widget-header{
  border: none !important;
}
.ui-tabs-nav .ui-widget-header a { 
  color: #222222/*{fcHeader}*/;
}
.safe_tabs_table {
  margin-left: -1px;
  height:700px;
  overflow:auto;
  white-space: nowrap;
}

.safe_tab_content {
  width: 100%;
  border-spacing: 0px;
  margin-top: 3px;
  margin-bottom: 3px;
}

.ui-tabs-nav .ui-state-active a {
  color: #004581;
}

.ui-widget-content div.ui-tabs-panel {
  width: 100% !important;
  max-width: 100% !important;
}

.ui-widget .ui-tabs-panel {
  width: 100% !important;
  max-width: 100% !important;
}

}
</style>

<script type="text/javascript">
  // Create tab view
  $(document).ready(function(){
    $('#safe_tabs').tabs();
  });
</script>
<br/>
<div id="safe_tabs">
<?php
    if (!isset($min_line)) $min_line = 50;
    // Create Tab layout
    echo '<ul>';
    $tab_id = 0;
    foreach ($tabs as $tab) {
        if (isset($tab['id'])) $tab_ref = $tab['id'];
        else $tab_ref = 'safe_tab_' . $tab_id;
        echo '<li><a href="#' . $tab_ref . '">' . $tab['title'] . '</a></li>';
        $tab_id++;
    }
    echo '</ul>';
    // Create tab content
    $tab_id = 0;
    foreach ($tabs as $tab) {
        if (isset($tab['id'])) $tab_ref = $tab['id'];
        else $tab_ref = 'safe_tab_' . $tab_id;
        echo '<div id="' . $tab_ref . '" >';
        if (!is_array($tab['content'])) {
            $tmp = $tab['content'];
            unset($tab['content']);
            $tab['content'] = array(
                $tmp
            );
        }
        echo '<div class="mytable safe_tabs_table widget-content-body ui-state-active">';
        $mode = (isset($tab['mode'])) ? $tab['mode'] : 'table';
        switch ($mode) {
        case 'paragraph':
            $open = '';
            $close = '';
            $open_line = '<p class="safe_tab_content %s">';
            $close_line = '</p>';
            break;

        case 'pre':
            $open = '<pre>';
            $close = '</pre>';
            unset($open_line);
            $close_line = '</br>';
            break;

        case 'table':
        default:
            $open = '<table class="safe_tab_content">';
            $close = '</table>';
            $open_line = '<tr class="%s"><td>';
            $close_line = '</td></tr>';
            break;
        }
        $i = 0;
        //$tab['content'] = array_merge($tab['content'],array_fill(0, 50,"&nbsp;"));
        // Open the tab container according to mode
        echo $open;
        foreach ($tab['content'] as $content) {
            $class = ($i % 2) ? 'mytablealt' : '';
            // Open the line
            if (isset($open_line)) echo sprintf($open_line, $class);
            // Display content
            echo $content;
            // close the line
            if (isset($close_line)) echo $close_line;
            $i++;
        }
        echo $close;
        echo '</div>';
        echo '</div>';
        $tab_id++;
    }
?>
</div>


<?php
}
?>
