<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/*
 * Application class
*/
require_once ('application/helpers/safe_helper.php');
require_once ('safe_service_class.php');
require_once ('safe_application_settings_class.php');
class Safe_application_class extends Safe_service_class
{
    protected $_preferences = NULL;
    public function __construct($node, $name, $process_name = null)
    {
        parent::__construct($node, $name, $process_name);
    }
    /**
     * @brief Default category getter for application
     *           
     * @param[in out] $name
     *           
     * @return
     */
    public function category()
    {
        return 'Application';
    }
    public function allow_rest(){
        return true;
    }
    public function configure()
    {
        // Preferences
        $this->_preferences = new Safe_application_settings_class($this->node()->software());
        $this->_preferences->configure();
        $this->_preferences->synch();
        $license = $this->node()->software()->license();
        if ($license->status()) {
            // Check for product name change in license
            // - Brand
            // - Product
            // - or user defined object description
            $prod_name = trim($license->info('Brand'));
            if (!$prod_name) $prod_name = trim($license->info('Product'));
            if ($prod_name) $this->set_description($prod_name);
        }
        $this->set_documentation( array(
            'The Application module manages the system startup mode, configuration and licensing.',
            )
        );
        // expose configuratio as aggregate object to allow methods: apply, 
        // reload...
        $this->register_aggregate_object( 'configuration',
            array(
                'name' => 'Configuration',
                'description' => array(
                    'Manages overall Application configuration.',
                    ),
                'singleton' => true,
                'dynamic' => true,
                'controller_url' => '/SAFe/sng_config_manager',
                'methods' => array(
                    'reload' => array(
                        'name' => 'Reload',
                        'description' => array( 'Apply and reload all dynamic configuration.' ),
                        'request' => 'POST',
                    ),
                    'apply' => array(
                        'name' => 'Apply',
                        'description' => array( 'Apply Application configuration.' ),
                        'request' => 'POST',
                    ),
                    'status' => array(
                        'name' => 'Get Status',
                        'description' => array( 'Get Application configuration status.' ),
                        'request' => 'GET',
                    ),
                )
            )
        );
        $this->register_aggregate_object( 'license',
            array(
                'name' => 'License',
                'singleton' => true,
                'description' => array(
                    'Manages Application licensed Features.',
                    ),
                'controller_url' => '/SAFe/sng_license',
                'methods' => array(
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => array( 'Returns Application currently installed license and status.' ),
                        'request' => 'GET',
                    ),
                    'info' => array(
                        'name' => 'Info',
                        'description' => array( 
                            'Returns System information required to produce a new License.' 
                        ),
                        'request' => 'GET',
                    ),
                ),
            )
        );
        $this->register_aggregate_object( 'version',
            array(
                'name' => 'Version',
                'description' => array(
                    'Manages Application components version.',
                    ),
                'singleton' => true,
                'methods' => array(
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => array( 'Returns Application version information.' ),
                        'request' => 'GET',
                    ),
                ),
            )
        );
        $this->register_aggregate_object( 'preferences',
            array(
                'name' => 'Preferences',
                'description' => array(
                    'Manages Application preferences.',
                    ),
                'singleton' => true,
                'methods' => array(
                    'retrieve' => array(
                        'name' => 'Retrieve',
                        'description' => array( 'Returns Application preferences.' ),
                        'request' => '',
                    ),
                    'update' => array(
                        'name' => 'Update',
                        'description' => array( 'Modifies Application preferences.' ),
                        'request' => '',
                    ),
                ),
            )
        );
        return parent::configure();
    }
    /**
     * @brief Find module by name (either in modules or services)
     *
     * @param[in out] $name
     *
     * @return 
     */
    public function find_module_by_name($name)
    {
        if($name == $this->name() || 'application' == $name) {
            return $this;
        }
        if($name == 'hardware') {
            return $this->node()->hardware();
        }
        $mod = null;
        foreach($this->node()->software()->services() as $k => $v) {
            // skip ourself :)
            if($k != $this->name()) {
                if($name == $k) {
                    return $v;
                }else{
                    $mod = $v->find_module_by_name($name);
                    if($mod)
                        return $mod;
                }
            }
        }
        return parent::find_module_by_name($name);

    }
    /**
     * @brief
     *         
     * @return
     */
    public function get_data_settings()
    {
        $cfg_manager = $this->node()->configuration_manager();
        $archive_manager = $cfg_manager->archive_manager();
        $data = array(
            'log' => array(
                'description' => 'Log File',
                'filesystem' => TRUE,
                'pattern' => $cfg_manager->directory('log') . '/' . $this->name() . '.log*',
                'global_capabilities' => array(
                    'download',
                    'rotate'
                ) ,
                'capabilities' => array(
                    'download',
                    'view'
                )
            ) ,
            'core' => array(
                'description' => 'Core Dump',
                'filesystem' => TRUE,
                'pattern' => $cfg_manager->directory('core-dump') . '/core.' . $this->name() . '*',
                'global_capabilities' => array(
                    'delete'
                ) ,
                'capabilities' => array(
                    'download',
                    'delete'
                )
            ) ,
            'corebt' => array(
                'description' => 'Core Dump Back Trace',
                'filesystem' => TRUE,
                'pattern' => $cfg_manager->directory('core-dump') . '/core.' . $this->name() . '*.bt',
                'global_capabilities' => array(
                    'download',
                    'delete'
                ) ,
                'capabilities' => array(
                    'download',
                    'delete',
                    'view'
                )
            ) ,
        );
        // Get license info
        $license = $cfg_manager->license();
        if($license){
            // Ensure we're having a 
            $this->node()->os()->mkdir($cfg_manager->directory('base') . '/upload');
            $data['license'] = array(
                        'description' => 'License',
                        'filesystem' => true,
                        'singleton' => true,
                        'pattern' =>  $cfg_manager->directory('base') . '/upload/license.tgz',
                        'global_capabilities_no_data' => array(
                                'upload'
                        ) ,
                        'capabilities' => array(
                                'view'
                                )
                );
        }
        if (isset($archive_manager)) $data['archive'] = array(
            'description' => 'Backup',
            'filesystem' => TRUE,
            'pattern' => $archive_manager->directory(TRUE) ,
            'global_capabilities_no_data' => array(
                'backup',
                'upload'
            ) ,
            'capabilities' => array(
                'download',
                'delete',
                'restore'
            )
        );
        return $data;
    }
    public function get_data_file_content_by_key($data_name, $key, $line_count = NULL)
    {
        // Do not return core content too large
        if ('core' == $data_name) return '';
        return parent::get_data_file_content_by_key($data_name, $key, $line_count);
    }
    public function get_data_count($data_name)
    {
        if ('license' == $data_name){
            $license = $this->node()->software()->license();
            return (true == $license->status())?1:0;
        }
        return parent::get_data_count($data_name);
    }
    public function get_data_files($data_name)
    {
        if ('license' == $data_name){
            $license = $this->node()->software()->license();
            if(true == $license->status()){
                $info = $this->node()->configuration_manager()->license();
                return array(basename($info['file']) => $info['file']);
            }
        }
        return parent::get_data_files($data_name);
    }
    /**
     * @brief Return data description
     * Special hook for license
     *
     * @param[in out] $data_name
     * @param[in out] $data_key
     * @param[in out] $output
     *
     * @return 
     */
    public function describe_data($data_name = null, $data_key = null, &$output = null)
    {
        if('license' == $data_name){
            $license = $this->node()->software()->license();
            $output = $license->describe();
            return true;
        }
        return parent::describe_data($data_name, $data_key, $output);
    }
    public function initialize_data($data_name = null, $data_key = null, &$output = null)
    {
        if('license' == $data_name){
            $info = $this->node()->configuration_manager()->license();
            $data_cfg = $this->get_data_settings();
            $data_cfg = $data_cfg[$data_name];
            $file = $data_cfg['pattern'];
            $ext = pathinfo($file);
            $file = $ext['dirname'].'/'.$data_key;

            $rc = $this->node()->os()->execute('/usr/local/sng/scripts/update-license.sh '.$file.' '.$info['file'].' '.$info['pubkey'], $output, true, true);
            // In any case remove the file
            $this->node()->os()->delete_file($file); 
            return $rc;
        }
        return parent::initialize_data($data_name, $data_key, $output);
    }

    public function modified_object_list(&$obj_list, $reloadable_only=true)
    {
        // Parent function
        parent::modified_object_list($obj_list, $reloadable_only);
        // Take care of services
        foreach($this->node()->software()->services() as $service) {
            if($service->name() != $this->name()) {
                $service->modified_object_list($obj_list, $reloadable_only);
            }
        }
    }
    /**
     * @brief Application conflict check - Add services in the loop
     *
     * @param[in out] $src_module_name
     * @param[in out] $resource_type
     * @param[in out] $resource_data
     *
     * @return 
     */
    public function check_resource_conflict($src_module_name, $resource_type, $resource_data) 
    {
        // Parent function
        $conflicts = parent::check_resource_conflict($src_module_name, $resource_type, $resource_data) ;
        // Take care of services
        foreach($this->node()->software()->services() as $service) {
            if($service->name() != $this->name() && $src_module_name != $service->name()) {
                $sub_conflicts = array();
                $sub_conflicts = $service->check_resource_conflict($src_module_name, $resource_type, $resource_data) ;
                if($sub_conflicts){
                    $conflicts = array_merge($conflicts, $sub_conflicts);
                }
            }
        }
        return $conflicts;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_status_configuration($name, $data = null, &$output = null){
        if(isset($data['call_from']) && $data['call_from']=='view_controller' ){
            $call_from = 'view_controller';
        }else{
            $call_from = 'rest';
        }
        $result = array();
        $modified_list = array();
        if ($this->node()->is_configuration_modified()) {
            $modified_obj_list = array();
            $this->modified_object_list($modified_obj_list);
            if($modified_obj_list) {
                foreach($modified_obj_list as $mod_name => $obj_list) {
                    $mod = $this->find_module_by_name($mod_name);
                    foreach($obj_list as $obj_type => $obj_type_list){
                        // Check if configuration or object
                        if('configuration' == $obj_type){
                            if ($call_from == 'rest'){
                                $modified_list[$mod_name]['configuration'] = 'M';
                            }else{
                                $modified_list[$mod->description()]['Configuration'] = '';
                            }
                        } else {
                            // Check if it's subobjects
                            $obj_type_split = explode('/', $obj_type);
                            $obj_type_name = $mod->aggregate_object_name($obj_type_split[0]);
                            foreach($obj_type_list as $obj_name => $obj){
                                if ($call_from == 'rest'){
                                    $modified_list[$mod_name][$obj_type][$obj_name] = $obj->status();
                                }else{
                                    if(sizeof($obj_type_split) > 1) {
                                        $sub_obj_type_name = $obj_type_split[1];
                                        $obj_name_split = explode('/', $obj_name);
                                        if(sizeof($obj_name_split) > 1){
                                            $sub_obj = call_user_func(array($mod, 'api_retrieve_'.$obj_type_split[0]), $obj_name_split[0]);
                                            if($sub_obj){
                                                $sub_obj_type_name = $sub_obj->aggregate_object_name($obj_type_split[1]);
                                            }
                                        }
                                        $tmp_obj_type_name = $obj_type_name . ' / ' . $sub_obj_type_name;
                                    }else{
                                        $tmp_obj_type_name = $obj_type_name;
                                    }
                                    $modified_list[$mod->description()][$tmp_obj_type_name][$obj_name] = $obj->status();
                                }
                                
                            }
                        }
                    }
                }
            }
            if (Safe_service_class::STATUS_RUNNING == $this->status()){
                //modified and running  (and no reload avail)
                $result['modified'] = true;
                $result['can_apply'] = false;
                //no reload avail
                if($modified_list) {
                    $result['can_reload'] = true;
                }else {
                    $result['can_reload'] = false;
                }
            }else{
                //modified and not running 
                $result['modified'] = true;
                $result['can_apply'] = true;
                $result['can_reload'] = false;
            }
            if($modified_list) {
                $result['reloadable'] = $modified_list;
            }else {
               $result['reloadable'] = false;
            }
        }else{
            $result['modified'] = false; 
        }
        return $result;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_apply_configuration($name, $data = null, &$output = null){
        $rc = true;
        if(isset($data['restart']) && $data['restart']==true ){
            $restart = true;
        }
        if(isset($data['force']) && $data['force']==true ){
            $this->node()->configuration_manager()->forget_error(TRUE);
            $force = true;
        }
        if(isset($data['call_from']) && $data['call_from']=='view_controller' ){
            $call_from = 'view_controller';
        }else{
            $call_from = 'rest';
        }
        if ($force || $this->node()->is_configuration_modified()) {
            if ($call_from == 'rest' && Safe_service_class::STATUS_RUNNING == $this->status()){
                //if call from rest api, and system is running return error
                $output['sys_running'] ='System is Running';
                $rc = false;
            }else{
                $this->modified_object_list($reload_list);
                Safe_enter_critical_section();
                if (!$this->node()->generate_config()) {
                    $output['apply_failed'] = 'Apply Configuration Failed';
                    $output['apply_failed_data'] = $this->node()->configuration_manager()->progress();
                    $rc = false;
                } else {
                    if ($restart) {
                        $rc_restart = $this->restart();
                        if (0 == $rc_restart) {
                            $output['restart_succeeded'] = 'System Apply Configuration and Restart Succeeded';
                            $rc = true;
                        } else {
                            $output['restart_failed'] = 'System Apply Configuration and Restart Failed';
                            $rc = false;
                        }
                    }
                    // Check if some service with modified config and 
                    // supporting reload and running -> post_write
                    foreach($reload_list as $module_name => $module_obj_list) {
                        $module = $this->find_module_by_name($module_name);
                        // TODO - need to loop around obj_type
                        if(is_subclass_of($module, "Safe_service_class")
                            &&
                            $module->status == Safe_service_class::STATUS_RUNNING ) {
                            if(!$module->post_write_config()) {
                                $output[] = 'Post Write Failed for '.$module->name() . '.';
                            }
                        }
                    }
                }
                Safe_leave_critical_section();
            }
        }
        return $rc;
    }
    /**
     * @brief
     *
     * @param[in out] $name
     * @param[in out] $data
     * @param[in out] $output
     *
     * @return
     */
    public function api_reload_configuration($name, $data = null, &$output = null){
        if(isset($data['call_from']) && $data['call_from'] == 'view_controller' ){
            $call_from = 'view_controller';
        }else{
            $call_from = 'rest';
        }
        Safe_enter_critical_section();
        $reload_list = array();
        $this->modified_object_list($reload_list);
        $cfg_mgr = $this->node()->configuration_manager();
        $rc = true;
        if ($call_from == 'rest' && Safe_service_class::STATUS_RUNNING != $this->status()){
            //if call from rest api, and system is not running return error
            $output['sys_running'] ='System is not Running';
            $rc = false;
        }
        if($rc) {
            foreach($reload_list as $module_name => $module_obj_list) {
                $module = $this->find_module_by_name($module_name);
                // TODO - need to loop around obj_type
                if(!$module->reload_generate_config($cfg_mgr)) {
                    $output[] = 'Generate Configuration Failed for ' . $module->name() . '.';
                    $rc = false;
                }
            }    
        }
        if($rc) {
            // Step 2
            if($cfg_mgr->errors()) {
                $output['cfg_mgr'] = 'Apply Configuration Failed.';
                $output['cfg_mgr_data'] = $cfg_mgr->progress();
                $rc = false;
            }
            if($rc) {
                // Step 3
                if(!$cfg_mgr->write_config($this->node())) {
                    $output[] = 'Write Configuration Failed.';
                    $rc = false;
                }
                // Step 4
                foreach($reload_list as $module_name => $module_obj_list) {
                    $module = $this->find_module_by_name($module_name);
                    // TODO - need to loop around obj_type
                    if(!$module->post_write_config()) {
                        $output[] = 'Post Write Failed for '.$module->name() . '.';
                    }
                }
                // Step 5
                foreach($reload_list as $module_name => $module_obj_list) {
                    $module = $this->find_module_by_name($module_name);
                    // TODO - need to loop around obj_type
                    $module->reload_clear_modified(true);
                }
            }
        }
        Safe_leave_critical_section();
        return $rc;
    }

    public function api_create_preferences($name=null, $data = null, &$output = null){
        // Cannot create one
        return $this->api_retrieve_preferences();
    }
    public function api_retrieve_preferences($name=null, $data = null, &$output = null){
        return $this->_preferences;
    }

    public function api_create_license($name=null, $data = null, &$output = null){
        // Cannot create one
        return $this->api_retrieve_license();
    }
    public function api_retrieve_license($name=null, $data = null, &$output = null){
        return $this->node()->software()->license();
    }
    public function api_info_license($name=null, $data = null, &$output = null){
        return $this->api_retrieve_system_info();
    }

    public function api_create_version($name=null, $data = null, &$output = null){
        // Cannot create one
        return $this->api_retrieve_version();
    }
    public function api_retrieve_version($name=null, $data = null, &$output = null){
        return $this->node()->software()->version();
    }

    public function api_retrieve_system_info($name=null, $data = null, &$output = null){
        $sys_info = $this->system_info();

        $obj = new Safe_configurable_object_class('/tmp','sys_info');
        foreach($sys_info as $k => $v){
            $obj->add_field($k, $k, 'text', $v);
        }
        return $obj;
    }
    /**
     * @brief Return System information used to generate license
     *
     * @return array of key value pairs
     */
    public function system_info()
    {
        $info = array();
        $adapters = $this->node()->hardware()->adapters();
        foreach($adapters as $adapter){
            $info[$adapter->name().' MAC'] = $adapter->mac();
        }
        // Check for hw serial numbers
        $result = array();
        $this->node()->os()->execute('/usr/local/sng/bin/sng-system-info', $result, true, true);
            foreach($result as $res){
                $item = explode('=',$res);
                $info[$item[0]] = $item[1];
            }

        return $info;
    }
}
/* End of file safe_product_class.php */
