<?php
/** vim: set tabstop=4 softtabstop=4 shiftwidth=4 textwidth=80 smarttab expandtab: **/
/** coding: utf-8: **/
/*
 * Copyright (C) 2012  Sangoma Technologies Corp.
 * All Rights Reserved.
 *
 * Author(s)
 * your name <your_name@sangoma.com>
 *
 * This code is Sangoma Technologies Confidential Property.
 * Use of and access to this code is covered by a previously executed
 * non-disclosure agreement between Sangoma Technologies and the Recipient.
 * This code is being supplied for evaluation purposes only and is not to be
 * used for any other purpose.
*/
/**
 * NSC Media Monitor Class
 * @author William Adam
 */
require_once ('application/helpers/safe_helper.php');
safe_require_class('safe_object_class');
safe_require_class('safe_hardware_class');
safe_module_require_class('nsc', 'application');
safe_module_require_class('sng', 'transcoding_config');
// MEDIAMON Configurable class
class Nsc_mediamon_config_class extends Safe_configurable_object_class
{
    /**
     * Constructor for sipsecmon config class
     * @param $node       
     * @param $parent_name
     * @param $name       
     */
    public function __construct($service)
    {
        // Parent constructor to invoke unserialize if needed
        parent::__construct($service->path() , $service->name(), $service->node());
    }
    /**
     * @brief Return configuration description
     *         
     * @return Description string or array
     */
    public function description()
    {
        $cfg = $this->get_data_values();
        if (isset($cfg['global/NSC_MEDIAMON_ENABLE'])) return $cfg['global/NSC_MEDIAMON_ENABLE'];
        else return parent::description();
    }
    /**
     * Configures MEDIAMON configurable object
     */
    public function configure()
    {
        //CI DATABASE CONFIGURABLE OBJECTS
        //=============================
        //hostname    - The hostname of your database server. Often this is "localhost".
        //username    - The username used to connect to the database.
        //password    - The password used to connect to the database.
        //database    - The name of the database you want to connect to.
        //dbdriver    - The database type. ie: mysql, postgres, odbc, etc. Must be specified in lower case.
        //dbprefix    - An optional table prefix which will added to the table name when running Active Record queries. This permits multiple CodeIgniter installations to share one database.
        //pconnect    - TRUE/FALSE (boolean) - Whether to use a persistent connection.
        //db_debug    - TRUE/FALSE (boolean) - Whether database errors should be displayed.
        //cache_on    - TRUE/FALSE (boolean) - Whether database query caching is enabled, see also Database Caching Class.
        //cachedir    - The absolute server path to your database query cache directory.
        //char_set    - The character set used in communicating with the database.
        //dbcollat    - The character collation used in communicating with the database.
        //port        - The database port number. To use this value you have to add a line to the database config array
        //active-record - Allows to run custom CI queries
        $log_level_enum = array(
            'debug' => 'debug',
            'info' => 'info'
        );
        // Create object fields
        // Configurable objects
        $this->add_enum_field('global/NSC_MEDIAMON_ENABLE', 'Media Firewall', 'dropdown', 'false', $this->enable_disable_enum()); //SIPSECMON enable/disable
        $this->set_field_help('global/NSC_MEDIAMON_ENABLE', 'This option is read only. The media firewall is enabled when the media interfaces are in \'hidden\' mode');
        $this->set_field_disabled('global/NSC_MEDIAMON_ENABLE');
        $this->add_enum_field('mediamon/dynamic-rules', 'Enhanced Security', 'dropdown', 'false', $this->enable_disable_enum());
        $this->set_field_help('mediamon/dynamic-rules',
        array('This option configures the media firewall to open individual firewall rules for each call ',
            'This improves security, as the media interfaces are not exposed to the outside network, but reduces ',
            'performance due to the number of firewall rules added which each network packet must now traverse'));
        $this->add_enum_field('logging/level', 'Log Level', 'dropdown', 'info', $log_level_enum); //sipsecmon log level enumeration
        $this->set_field_help('logging/level', 'Type of information that will be printed within the Media Monitor logs.');
        $this->add_enum_field('logging/syslog', 'Log in Syslog', 'dropdown', 'true', $this->enable_disable_enum()); //sipsecmon log within syslog
        $this->set_field_help('logging/syslog', 'Enable/Disable logging of the Media Monitor logs within syslog.');
        // Add Conditional Control
        // 1. create the group control 'global'
        $this->create_group('global', array(
            'mediamon/dynamic-rules',
            'logging/level',
            'logging/syslog'
        ));
        // 2. tell the field 'global/NSC_SIPSECMON_ENABLE' which existing group it can control (global)
        $this->conditional_control('global/NSC_MEDIAMON_ENABLE', 'global');
        //Hidden objects
        $this->add_field('database/table-prefix', 'Table Prefix', 'hidden', 'mediamon_'); //sipsecmon table prefix
        $this->add_field('logging/file', 'Logfile Location', 'hidden', '/var/log/mediamon.log'); //sipsecmon log file location
        $this->add_field('db-cfg/hostname', 'Database Hostname', 'hidden', 'localhost', 50); //HOSTNAME set to localhost
        $this->add_field('db-cfg/username', 'Database Username', 'hidden', 'root', 25); //USERNAME set to root
        $this->add_field('db-cfg/password', 'Database Password', 'hidden', '', 50); //PASSWORD set to ""
        $this->add_field('db-cfg/port', 'Database Port', 'hidden', '3306', 10); //PORT set to 3306
        $this->add_field('db-cfg/database', 'Database', 'hidden', 'nsc'); //DATABASE set to NSC. Hidden Field
        $this->add_field('db-cfg/dbdriver', 'dbdriver', 'hidden', 'mysql'); //DBDRIVER set to mysql. Hidden field
        $this->add_field('db-cfg/dbprefix', 'dbprefix', 'hidden', 'mediamon_'); //DBPREFIX set to "". Hidden field
        $this->add_field('db-cfg/pconnect', 'pconnect', 'hidden', 'false'); //PCONNECT set to false. Hidden field
        $this->add_field('db-cfg/db_debug', 'db_debug', 'hidden', 'true'); //DB_DEBUG set to true. Hidden field
        $this->add_field('db-cfg/cache_on', 'cache_on', 'hidden', 'false'); //CACHE_ON set to false. Hidden field
        $this->add_field('db-cfg/cachedir', 'cachedir', 'hidden', ''); //CACHEDIR set to "". Hidden field
        $this->add_field('db-cfg/char_set', 'char_set', 'hidden', 'utf8'); //CHAR_SET set to UTF8. Hidden field
        $this->add_field('db-cfg/dbcollat', 'dbcollat', 'hidden', 'utf8_general_ci'); //DBCOLLAT set to utf8_general_ci. Hidden field
        $this->add_field('db-cfg/active-record', 'active-record', 'hidden', 'true'); //ACTIVE-RECORD set to true. Hidden field
        $this->add_field('switch/connection-string', 'connection-string', 'hidden', 'esl://ClueCon@localhost:8021', 50); //ESL API Connection String
        $this->add_field('mediamon/num-subchains', 'num-subchains', 'hidden', '16', 50); //Default number of sub-chains
        return parent::configure();
    }
    /**
     * @brief Resolve mediamon enabled/disabled based on transcoding 
     * configuration
     *
     * @return 
     */
    private function _resolve_enable($resolve_enum=false)
    {
        $transcoding = new Sng_transcoding_config_class($this->_node);
        $transcoding->configure();
        $mode = $transcoding->get_data_value('individual-ip', false);
        if ($transcoding->is_enabled() && 'false' == $mode) {
            return ($resolve_enum)?'Enable':'true';
        } else {
            return ($resolve_enum)?'Disable':'false';
        }
    }

    // Overide serialize/unserialize because enable/disable come from
    // hardware/TRANSCODING/config object
    protected function _set_unserialized_data($data)
    {
        $data['global/NSC_MEDIAMON_ENABLE'] = $this->_resolve_enable();
        parent::_set_unserialized_data($data);
    }
    protected function _get_serialized_data()
    {
        $data = parent::_get_serialized_data();
        $data['global/NSC_MEDIAMON_ENABLE'] = $this->_resolve_enable();
        return $data;
    }
    public public function get_data_value($name, $resolve_enum = true)
    {
        if('global/NSC_MEDIAMON_ENABLE' == $name) {
            return $this->_resolve_enable($resolve_enum);
        }
        return parent::get_data_value($name, $resolve_enum);
    }
    public function get_data_values($resolve_enum = true, $include_hidden = true)
    {
        $data = parent::get_data_values($resolve_enum, $include_hidden);
        $data['global/NSC_MEDIAMON_ENABLE'] = $this->_resolve_enable($resolve_enum);
        return $data;
    }
}
?>
